# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAuditTrailsTrailResult',
    'AwaitableGetAuditTrailsTrailResult',
    'get_audit_trails_trail',
    'get_audit_trails_trail_output',
]

@pulumi.output_type
class GetAuditTrailsTrailResult:
    """
    A collection of values returned by getAuditTrailsTrail.
    """
    def __init__(__self__, data_stream_destinations=None, description=None, filtering_policies=None, filters=None, folder_id=None, id=None, labels=None, logging_destinations=None, name=None, service_account_id=None, status=None, storage_destinations=None, trail_id=None):
        if data_stream_destinations and not isinstance(data_stream_destinations, list):
            raise TypeError("Expected argument 'data_stream_destinations' to be a list")
        pulumi.set(__self__, "data_stream_destinations", data_stream_destinations)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filtering_policies and not isinstance(filtering_policies, list):
            raise TypeError("Expected argument 'filtering_policies' to be a list")
        pulumi.set(__self__, "filtering_policies", filtering_policies)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if logging_destinations and not isinstance(logging_destinations, list):
            raise TypeError("Expected argument 'logging_destinations' to be a list")
        pulumi.set(__self__, "logging_destinations", logging_destinations)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_account_id and not isinstance(service_account_id, str):
            raise TypeError("Expected argument 'service_account_id' to be a str")
        pulumi.set(__self__, "service_account_id", service_account_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_destinations and not isinstance(storage_destinations, list):
            raise TypeError("Expected argument 'storage_destinations' to be a list")
        pulumi.set(__self__, "storage_destinations", storage_destinations)
        if trail_id and not isinstance(trail_id, str):
            raise TypeError("Expected argument 'trail_id' to be a str")
        pulumi.set(__self__, "trail_id", trail_id)

    @_builtins.property
    @pulumi.getter(name="dataStreamDestinations")
    def data_stream_destinations(self) -> Sequence['outputs.GetAuditTrailsTrailDataStreamDestinationResult']:
        """
        Structure describing destination data stream of the trail. Mutually exclusive with `logging_destination` and `storage_destination`.
        """
        return pulumi.get(self, "data_stream_destinations")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="filteringPolicies")
    def filtering_policies(self) -> Sequence['outputs.GetAuditTrailsTrailFilteringPolicyResult']:
        """
        Structure describing event filtering process for the trail. Mutually exclusive with `filter`. At least one of the `management_events_filter` or `data_events_filter` fields will be filled.
        """
        return pulumi.get(self, "filtering_policies")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use filtering_policy instead. This attribute will be removed""")
    def filters(self) -> Sequence['outputs.GetAuditTrailsTrailFilterResult']:
        """
        Structure is deprecated. Use `filtering_policy` instead.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="loggingDestinations")
    def logging_destinations(self) -> Sequence['outputs.GetAuditTrailsTrailLoggingDestinationResult']:
        """
        Structure describing destination log group of the trail. Mutually exclusive with `storage_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "logging_destinations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> _builtins.str:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of this trail.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageDestinations")
    def storage_destinations(self) -> Sequence['outputs.GetAuditTrailsTrailStorageDestinationResult']:
        """
        Structure describing destination bucket of the trail. Mutually exclusive with `logging_destination` and `data_stream_destination`.
        """
        return pulumi.get(self, "storage_destinations")

    @_builtins.property
    @pulumi.getter(name="trailId")
    def trail_id(self) -> _builtins.str:
        """
        Trail ID.
        """
        return pulumi.get(self, "trail_id")


class AwaitableGetAuditTrailsTrailResult(GetAuditTrailsTrailResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditTrailsTrailResult(
            data_stream_destinations=self.data_stream_destinations,
            description=self.description,
            filtering_policies=self.filtering_policies,
            filters=self.filters,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            logging_destinations=self.logging_destinations,
            name=self.name,
            service_account_id=self.service_account_id,
            status=self.status,
            storage_destinations=self.storage_destinations,
            trail_id=self.trail_id)


def get_audit_trails_trail(trail_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditTrailsTrailResult:
    """
    Get information about a trail. For information about the trail concept, see [official documentation](https://yandex.cloud/docs/audit-trails/concepts/trail).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Audit Trails Trail
    #
    basic_trail = yandex.get_audit_trails_trail(trail_id="cnpqe**********sh835")
    ```


    :param _builtins.str trail_id: Trail ID.
    """
    __args__ = dict()
    __args__['trailId'] = trail_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getAuditTrailsTrail:getAuditTrailsTrail', __args__, opts=opts, typ=GetAuditTrailsTrailResult).value

    return AwaitableGetAuditTrailsTrailResult(
        data_stream_destinations=pulumi.get(__ret__, 'data_stream_destinations'),
        description=pulumi.get(__ret__, 'description'),
        filtering_policies=pulumi.get(__ret__, 'filtering_policies'),
        filters=pulumi.get(__ret__, 'filters'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        logging_destinations=pulumi.get(__ret__, 'logging_destinations'),
        name=pulumi.get(__ret__, 'name'),
        service_account_id=pulumi.get(__ret__, 'service_account_id'),
        status=pulumi.get(__ret__, 'status'),
        storage_destinations=pulumi.get(__ret__, 'storage_destinations'),
        trail_id=pulumi.get(__ret__, 'trail_id'))
def get_audit_trails_trail_output(trail_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuditTrailsTrailResult]:
    """
    Get information about a trail. For information about the trail concept, see [official documentation](https://yandex.cloud/docs/audit-trails/concepts/trail).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Audit Trails Trail
    #
    basic_trail = yandex.get_audit_trails_trail(trail_id="cnpqe**********sh835")
    ```


    :param _builtins.str trail_id: Trail ID.
    """
    __args__ = dict()
    __args__['trailId'] = trail_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getAuditTrailsTrail:getAuditTrailsTrail', __args__, opts=opts, typ=GetAuditTrailsTrailResult)
    return __ret__.apply(lambda __response__: GetAuditTrailsTrailResult(
        data_stream_destinations=pulumi.get(__response__, 'data_stream_destinations'),
        description=pulumi.get(__response__, 'description'),
        filtering_policies=pulumi.get(__response__, 'filtering_policies'),
        filters=pulumi.get(__response__, 'filters'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        logging_destinations=pulumi.get(__response__, 'logging_destinations'),
        name=pulumi.get(__response__, 'name'),
        service_account_id=pulumi.get(__response__, 'service_account_id'),
        status=pulumi.get(__response__, 'status'),
        storage_destinations=pulumi.get(__response__, 'storage_destinations'),
        trail_id=pulumi.get(__response__, 'trail_id')))
