# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetBackupPolicyResult',
    'AwaitableGetBackupPolicyResult',
    'get_backup_policy',
    'get_backup_policy_output',
]

@pulumi.output_type
class GetBackupPolicyResult:
    """
    A collection of values returned by getBackupPolicy.
    """
    def __init__(__self__, archive_name=None, cbt=None, compression=None, created_at=None, enabled=None, fast_backup_enabled=None, file_filters=None, folder_id=None, format=None, id=None, lvm_snapshotting_enabled=None, multi_volume_snapshotting_enabled=None, name=None, performance_window_enabled=None, policy_id=None, reattempts=None, retentions=None, schedulings=None, sector_by_sector=None, silent_mode_enabled=None, splitting_bytes=None, updated_at=None, validation_enabled=None, vm_snapshot_reattempts=None, vss_provider=None):
        if archive_name and not isinstance(archive_name, str):
            raise TypeError("Expected argument 'archive_name' to be a str")
        pulumi.set(__self__, "archive_name", archive_name)
        if cbt and not isinstance(cbt, str):
            raise TypeError("Expected argument 'cbt' to be a str")
        pulumi.set(__self__, "cbt", cbt)
        if compression and not isinstance(compression, str):
            raise TypeError("Expected argument 'compression' to be a str")
        pulumi.set(__self__, "compression", compression)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if fast_backup_enabled and not isinstance(fast_backup_enabled, bool):
            raise TypeError("Expected argument 'fast_backup_enabled' to be a bool")
        pulumi.set(__self__, "fast_backup_enabled", fast_backup_enabled)
        if file_filters and not isinstance(file_filters, list):
            raise TypeError("Expected argument 'file_filters' to be a list")
        pulumi.set(__self__, "file_filters", file_filters)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lvm_snapshotting_enabled and not isinstance(lvm_snapshotting_enabled, bool):
            raise TypeError("Expected argument 'lvm_snapshotting_enabled' to be a bool")
        pulumi.set(__self__, "lvm_snapshotting_enabled", lvm_snapshotting_enabled)
        if multi_volume_snapshotting_enabled and not isinstance(multi_volume_snapshotting_enabled, bool):
            raise TypeError("Expected argument 'multi_volume_snapshotting_enabled' to be a bool")
        pulumi.set(__self__, "multi_volume_snapshotting_enabled", multi_volume_snapshotting_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if performance_window_enabled and not isinstance(performance_window_enabled, bool):
            raise TypeError("Expected argument 'performance_window_enabled' to be a bool")
        pulumi.set(__self__, "performance_window_enabled", performance_window_enabled)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if reattempts and not isinstance(reattempts, list):
            raise TypeError("Expected argument 'reattempts' to be a list")
        pulumi.set(__self__, "reattempts", reattempts)
        if retentions and not isinstance(retentions, list):
            raise TypeError("Expected argument 'retentions' to be a list")
        pulumi.set(__self__, "retentions", retentions)
        if schedulings and not isinstance(schedulings, list):
            raise TypeError("Expected argument 'schedulings' to be a list")
        pulumi.set(__self__, "schedulings", schedulings)
        if sector_by_sector and not isinstance(sector_by_sector, bool):
            raise TypeError("Expected argument 'sector_by_sector' to be a bool")
        pulumi.set(__self__, "sector_by_sector", sector_by_sector)
        if silent_mode_enabled and not isinstance(silent_mode_enabled, bool):
            raise TypeError("Expected argument 'silent_mode_enabled' to be a bool")
        pulumi.set(__self__, "silent_mode_enabled", silent_mode_enabled)
        if splitting_bytes and not isinstance(splitting_bytes, str):
            raise TypeError("Expected argument 'splitting_bytes' to be a str")
        pulumi.set(__self__, "splitting_bytes", splitting_bytes)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if validation_enabled and not isinstance(validation_enabled, bool):
            raise TypeError("Expected argument 'validation_enabled' to be a bool")
        pulumi.set(__self__, "validation_enabled", validation_enabled)
        if vm_snapshot_reattempts and not isinstance(vm_snapshot_reattempts, list):
            raise TypeError("Expected argument 'vm_snapshot_reattempts' to be a list")
        pulumi.set(__self__, "vm_snapshot_reattempts", vm_snapshot_reattempts)
        if vss_provider and not isinstance(vss_provider, str):
            raise TypeError("Expected argument 'vss_provider' to be a str")
        pulumi.set(__self__, "vss_provider", vss_provider)

    @_builtins.property
    @pulumi.getter(name="archiveName")
    def archive_name(self) -> _builtins.str:
        """
        The name of generated archives. Default `[Machine Name]-[Plan ID]-[Unique ID]a`.
        """
        return pulumi.get(self, "archive_name")

    @_builtins.property
    @pulumi.getter
    def cbt(self) -> _builtins.str:
        """
        Configuration of Changed Block Tracking. Available values are: `USE_IF_ENABLED`, `ENABLED_AND_USE`, `DO_NOT_USE`. Default `DO_NOT_USE`.
        """
        return pulumi.get(self, "cbt")

    @_builtins.property
    @pulumi.getter
    def compression(self) -> _builtins.str:
        """
        Archive compression level. Affects CPU. Available values: `NORMAL`, `HIGH`, `MAX`, `OFF`. Default: `NORMAL`.
        """
        return pulumi.get(self, "compression")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        If this field is true, it means that the policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fastBackupEnabled")
    def fast_backup_enabled(self) -> _builtins.bool:
        """
        If true, determines whether a file has changed by the file size and timestamp. Otherwise, the entire file contents are compared to those stored in the backup.
        """
        return pulumi.get(self, "fast_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="fileFilters")
    def file_filters(self) -> Sequence['outputs.GetBackupPolicyFileFilterResult']:
        """
        File filters to specify masks of files to backup or to exclude of backuping.
        """
        return pulumi.get(self, "file_filters")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        Format of the backup. It's strongly recommend to leave this option empty or `AUTO`. Available values: `AUTO`, `VERSION_11`, `VERSION_12`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lvmSnapshottingEnabled")
    def lvm_snapshotting_enabled(self) -> _builtins.bool:
        """
        LVM will be used to create the volume snapshot. If LVM fails to create a snapshot (for example, because there is not enough free space), the software will create the snapshot itself.
        """
        return pulumi.get(self, "lvm_snapshotting_enabled")

    @_builtins.property
    @pulumi.getter(name="multiVolumeSnapshottingEnabled")
    def multi_volume_snapshotting_enabled(self) -> _builtins.bool:
        """
        If true, snapshots of multiple volumes will be taken simultaneously. Default `true`.
        """
        return pulumi.get(self, "multi_volume_snapshotting_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="performanceWindowEnabled")
    def performance_window_enabled(self) -> _builtins.bool:
        """
        Time windows for performance limitations of backup. Default `false`.
        """
        return pulumi.get(self, "performance_window_enabled")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> _builtins.str:
        """
        ID of the policy.
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def reattempts(self) -> Sequence['outputs.GetBackupPolicyReattemptResult']:
        """
        Amount of reattempts that should be performed while trying to make backup at the host.
        """
        return pulumi.get(self, "reattempts")

    @_builtins.property
    @pulumi.getter
    def retentions(self) -> Sequence['outputs.GetBackupPolicyRetentionResult']:
        """
        Retention policy for backups. Allows to setup backups lifecycle.
        """
        return pulumi.get(self, "retentions")

    @_builtins.property
    @pulumi.getter
    def schedulings(self) -> Sequence['outputs.GetBackupPolicySchedulingResult']:
        """
        Schedule settings for creating backups on the host.
        """
        return pulumi.get(self, "schedulings")

    @_builtins.property
    @pulumi.getter(name="sectorBySector")
    def sector_by_sector(self) -> _builtins.bool:
        """
        A sector-by-sector backup of a disk or volume creates a backup copy of all sectors of the disk or volume, including those that do not contain data. Therefore, the size of such a backup copy will be equal to the size of the original disk or volume.
        """
        return pulumi.get(self, "sector_by_sector")

    @_builtins.property
    @pulumi.getter(name="silentModeEnabled")
    def silent_mode_enabled(self) -> _builtins.bool:
        """
        If true, a user interaction will be avoided when possible. Default `true`.
        """
        return pulumi.get(self, "silent_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="splittingBytes")
    def splitting_bytes(self) -> _builtins.str:
        """
        Determines the size to split backups. It's better to leave this option unchanged. Default `9223372036854775807`.
        """
        return pulumi.get(self, "splitting_bytes")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The update timestamp of the resource.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="validationEnabled")
    def validation_enabled(self) -> _builtins.bool:
        """
        Validation is a time-consuming process, even with incremental or differential backups of small amounts of data. This is because not only the data physically contained in the backup copy is verified, but all data restored when it is selected. This option requires access to previously created backup copies.
        """
        return pulumi.get(self, "validation_enabled")

    @_builtins.property
    @pulumi.getter(name="vmSnapshotReattempts")
    def vm_snapshot_reattempts(self) -> Sequence['outputs.GetBackupPolicyVmSnapshotReattemptResult']:
        """
        Amount of reattempts that should be performed while trying to make snapshot.
        """
        return pulumi.get(self, "vm_snapshot_reattempts")

    @_builtins.property
    @pulumi.getter(name="vssProvider")
    def vss_provider(self) -> _builtins.str:
        """
        Settings for the volume shadow copy service. Available values are: `NATIVE`, `TARGET_SYSTEM_DEFINED`. Default `NATIVE`.
        """
        return pulumi.get(self, "vss_provider")


class AwaitableGetBackupPolicyResult(GetBackupPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupPolicyResult(
            archive_name=self.archive_name,
            cbt=self.cbt,
            compression=self.compression,
            created_at=self.created_at,
            enabled=self.enabled,
            fast_backup_enabled=self.fast_backup_enabled,
            file_filters=self.file_filters,
            folder_id=self.folder_id,
            format=self.format,
            id=self.id,
            lvm_snapshotting_enabled=self.lvm_snapshotting_enabled,
            multi_volume_snapshotting_enabled=self.multi_volume_snapshotting_enabled,
            name=self.name,
            performance_window_enabled=self.performance_window_enabled,
            policy_id=self.policy_id,
            reattempts=self.reattempts,
            retentions=self.retentions,
            schedulings=self.schedulings,
            sector_by_sector=self.sector_by_sector,
            silent_mode_enabled=self.silent_mode_enabled,
            splitting_bytes=self.splitting_bytes,
            updated_at=self.updated_at,
            validation_enabled=self.validation_enabled,
            vm_snapshot_reattempts=self.vm_snapshot_reattempts,
            vss_provider=self.vss_provider)


def get_backup_policy(name: Optional[_builtins.str] = None,
                      policy_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupPolicyResult:
    """
    Get information about a Yandex Backup Policy. For more information, see [the official documentation](https://yandex.cloud/docs/backup/concepts/policy).

    > One of `policy_id` or `name` should be specified.

    > In case you use `name`, an error will occur if two policies with the same name exist. In this case, rename the policy or use the `policy_id`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Cloud Backup Policy
    #
    my_policy = yandex.get_backup_policy(name="some_policy_name")
    pulumi.export("myPolicyName", my_policy.name)
    ```


    :param _builtins.str name: The resource name.
    :param _builtins.str policy_id: ID of the policy.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getBackupPolicy:getBackupPolicy', __args__, opts=opts, typ=GetBackupPolicyResult).value

    return AwaitableGetBackupPolicyResult(
        archive_name=pulumi.get(__ret__, 'archive_name'),
        cbt=pulumi.get(__ret__, 'cbt'),
        compression=pulumi.get(__ret__, 'compression'),
        created_at=pulumi.get(__ret__, 'created_at'),
        enabled=pulumi.get(__ret__, 'enabled'),
        fast_backup_enabled=pulumi.get(__ret__, 'fast_backup_enabled'),
        file_filters=pulumi.get(__ret__, 'file_filters'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        format=pulumi.get(__ret__, 'format'),
        id=pulumi.get(__ret__, 'id'),
        lvm_snapshotting_enabled=pulumi.get(__ret__, 'lvm_snapshotting_enabled'),
        multi_volume_snapshotting_enabled=pulumi.get(__ret__, 'multi_volume_snapshotting_enabled'),
        name=pulumi.get(__ret__, 'name'),
        performance_window_enabled=pulumi.get(__ret__, 'performance_window_enabled'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        reattempts=pulumi.get(__ret__, 'reattempts'),
        retentions=pulumi.get(__ret__, 'retentions'),
        schedulings=pulumi.get(__ret__, 'schedulings'),
        sector_by_sector=pulumi.get(__ret__, 'sector_by_sector'),
        silent_mode_enabled=pulumi.get(__ret__, 'silent_mode_enabled'),
        splitting_bytes=pulumi.get(__ret__, 'splitting_bytes'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        validation_enabled=pulumi.get(__ret__, 'validation_enabled'),
        vm_snapshot_reattempts=pulumi.get(__ret__, 'vm_snapshot_reattempts'),
        vss_provider=pulumi.get(__ret__, 'vss_provider'))
def get_backup_policy_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupPolicyResult]:
    """
    Get information about a Yandex Backup Policy. For more information, see [the official documentation](https://yandex.cloud/docs/backup/concepts/policy).

    > One of `policy_id` or `name` should be specified.

    > In case you use `name`, an error will occur if two policies with the same name exist. In this case, rename the policy or use the `policy_id`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Cloud Backup Policy
    #
    my_policy = yandex.get_backup_policy(name="some_policy_name")
    pulumi.export("myPolicyName", my_policy.name)
    ```


    :param _builtins.str name: The resource name.
    :param _builtins.str policy_id: ID of the policy.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getBackupPolicy:getBackupPolicy', __args__, opts=opts, typ=GetBackupPolicyResult)
    return __ret__.apply(lambda __response__: GetBackupPolicyResult(
        archive_name=pulumi.get(__response__, 'archive_name'),
        cbt=pulumi.get(__response__, 'cbt'),
        compression=pulumi.get(__response__, 'compression'),
        created_at=pulumi.get(__response__, 'created_at'),
        enabled=pulumi.get(__response__, 'enabled'),
        fast_backup_enabled=pulumi.get(__response__, 'fast_backup_enabled'),
        file_filters=pulumi.get(__response__, 'file_filters'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        format=pulumi.get(__response__, 'format'),
        id=pulumi.get(__response__, 'id'),
        lvm_snapshotting_enabled=pulumi.get(__response__, 'lvm_snapshotting_enabled'),
        multi_volume_snapshotting_enabled=pulumi.get(__response__, 'multi_volume_snapshotting_enabled'),
        name=pulumi.get(__response__, 'name'),
        performance_window_enabled=pulumi.get(__response__, 'performance_window_enabled'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        reattempts=pulumi.get(__response__, 'reattempts'),
        retentions=pulumi.get(__response__, 'retentions'),
        schedulings=pulumi.get(__response__, 'schedulings'),
        sector_by_sector=pulumi.get(__response__, 'sector_by_sector'),
        silent_mode_enabled=pulumi.get(__response__, 'silent_mode_enabled'),
        splitting_bytes=pulumi.get(__response__, 'splitting_bytes'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        validation_enabled=pulumi.get(__response__, 'validation_enabled'),
        vm_snapshot_reattempts=pulumi.get(__response__, 'vm_snapshot_reattempts'),
        vss_provider=pulumi.get(__response__, 'vss_provider')))
