# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCdnOriginGroupResult',
    'AwaitableGetCdnOriginGroupResult',
    'get_cdn_origin_group',
    'get_cdn_origin_group_output',
]

@pulumi.output_type
class GetCdnOriginGroupResult:
    """
    A collection of values returned by getCdnOriginGroup.
    """
    def __init__(__self__, folder_id=None, id=None, name=None, origin_group_id=None, origins=None, use_next=None):
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if origin_group_id and not isinstance(origin_group_id, int):
            raise TypeError("Expected argument 'origin_group_id' to be a int")
        pulumi.set(__self__, "origin_group_id", origin_group_id)
        if origins and not isinstance(origins, list):
            raise TypeError("Expected argument 'origins' to be a list")
        pulumi.set(__self__, "origins", origins)
        if use_next and not isinstance(use_next, bool):
            raise TypeError("Expected argument 'use_next' to be a bool")
        pulumi.set(__self__, "use_next", use_next)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="originGroupId")
    def origin_group_id(self) -> _builtins.int:
        """
        The ID of a specific origin group.
        """
        return pulumi.get(self, "origin_group_id")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Sequence['outputs.GetCdnOriginGroupOriginResult']:
        return pulumi.get(self, "origins")

    @_builtins.property
    @pulumi.getter(name="useNext")
    def use_next(self) -> _builtins.bool:
        """
        If the option is active (has true value), in case the origin responds with 4XX or 5XX codes, use the next origin from the list.
        """
        return pulumi.get(self, "use_next")


class AwaitableGetCdnOriginGroupResult(GetCdnOriginGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCdnOriginGroupResult(
            folder_id=self.folder_id,
            id=self.id,
            name=self.name,
            origin_group_id=self.origin_group_id,
            origins=self.origins,
            use_next=self.use_next)


def get_cdn_origin_group(folder_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         origin_group_id: Optional[_builtins.int] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCdnOriginGroupResult:
    """
    Get information about a Yandex CDN Origin Group. For more information, see [the official documentation](https://yandex.cloud/docs/cdn/concepts/origins).

    > One of `origin_group_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing CDN Origin Group
    #
    my_group = yandex.get_cdn_origin_group(origin_group_id="some_instance_id")
    pulumi.export("originGroupName", my_group.name)
    ```


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.int origin_group_id: The ID of a specific origin group.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['originGroupId'] = origin_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getCdnOriginGroup:getCdnOriginGroup', __args__, opts=opts, typ=GetCdnOriginGroupResult).value

    return AwaitableGetCdnOriginGroupResult(
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        origin_group_id=pulumi.get(__ret__, 'origin_group_id'),
        origins=pulumi.get(__ret__, 'origins'),
        use_next=pulumi.get(__ret__, 'use_next'))
def get_cdn_origin_group_output(folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                origin_group_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCdnOriginGroupResult]:
    """
    Get information about a Yandex CDN Origin Group. For more information, see [the official documentation](https://yandex.cloud/docs/cdn/concepts/origins).

    > One of `origin_group_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing CDN Origin Group
    #
    my_group = yandex.get_cdn_origin_group(origin_group_id="some_instance_id")
    pulumi.export("originGroupName", my_group.name)
    ```


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.int origin_group_id: The ID of a specific origin group.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['originGroupId'] = origin_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getCdnOriginGroup:getCdnOriginGroup', __args__, opts=opts, typ=GetCdnOriginGroupResult)
    return __ret__.apply(lambda __response__: GetCdnOriginGroupResult(
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        origin_group_id=pulumi.get(__response__, 'origin_group_id'),
        origins=pulumi.get(__response__, 'origins'),
        use_next=pulumi.get(__response__, 'use_next')))
