# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCdnResourceResult',
    'AwaitableGetCdnResourceResult',
    'get_cdn_resource',
    'get_cdn_resource_output',
]

@pulumi.output_type
class GetCdnResourceResult:
    """
    A collection of values returned by getCdnResource.
    """
    def __init__(__self__, active=None, cname=None, created_at=None, folder_id=None, id=None, labels=None, options=None, origin_group_id=None, origin_group_name=None, origin_protocol=None, provider_cname=None, provider_type=None, resource_id=None, secondary_hostnames=None, ssl_certificate=None, updated_at=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if cname and not isinstance(cname, str):
            raise TypeError("Expected argument 'cname' to be a str")
        pulumi.set(__self__, "cname", cname)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if options and not isinstance(options, dict):
            raise TypeError("Expected argument 'options' to be a dict")
        pulumi.set(__self__, "options", options)
        if origin_group_id and not isinstance(origin_group_id, int):
            raise TypeError("Expected argument 'origin_group_id' to be a int")
        pulumi.set(__self__, "origin_group_id", origin_group_id)
        if origin_group_name and not isinstance(origin_group_name, str):
            raise TypeError("Expected argument 'origin_group_name' to be a str")
        pulumi.set(__self__, "origin_group_name", origin_group_name)
        if origin_protocol and not isinstance(origin_protocol, str):
            raise TypeError("Expected argument 'origin_protocol' to be a str")
        pulumi.set(__self__, "origin_protocol", origin_protocol)
        if provider_cname and not isinstance(provider_cname, str):
            raise TypeError("Expected argument 'provider_cname' to be a str")
        pulumi.set(__self__, "provider_cname", provider_cname)
        if provider_type and not isinstance(provider_type, str):
            raise TypeError("Expected argument 'provider_type' to be a str")
        pulumi.set(__self__, "provider_type", provider_type)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if secondary_hostnames and not isinstance(secondary_hostnames, list):
            raise TypeError("Expected argument 'secondary_hostnames' to be a list")
        pulumi.set(__self__, "secondary_hostnames", secondary_hostnames)
        if ssl_certificate and not isinstance(ssl_certificate, dict):
            raise TypeError("Expected argument 'ssl_certificate' to be a dict")
        pulumi.set(__self__, "ssl_certificate", ssl_certificate)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[_builtins.bool]:
        """
        Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter
    def cname(self) -> _builtins.str:
        """
        CDN endpoint CNAME, must be unique among resources.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def options(self) -> 'outputs.GetCdnResourceOptionsResult':
        """
        CDN Resource settings and options to tune CDN edge behavior.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="originGroupId")
    def origin_group_id(self) -> Optional[_builtins.int]:
        """
        The ID of a specific origin group.
        """
        return pulumi.get(self, "origin_group_id")

    @_builtins.property
    @pulumi.getter(name="originGroupName")
    def origin_group_name(self) -> Optional[_builtins.str]:
        """
        The name of a specific origin group.
        """
        return pulumi.get(self, "origin_group_name")

    @_builtins.property
    @pulumi.getter(name="originProtocol")
    def origin_protocol(self) -> Optional[_builtins.str]:
        """
        Protocol of origin resource. `http` or `https`.
        """
        return pulumi.get(self, "origin_protocol")

    @_builtins.property
    @pulumi.getter(name="providerCname")
    def provider_cname(self) -> _builtins.str:
        """
        Provider CNAME of CDN resource, computed value for read and update operations.
        """
        return pulumi.get(self, "provider_cname")

    @_builtins.property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> _builtins.str:
        return pulumi.get(self, "provider_type")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="secondaryHostnames")
    def secondary_hostnames(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of secondary hostname strings.
        """
        return pulumi.get(self, "secondary_hostnames")

    @_builtins.property
    @pulumi.getter(name="sslCertificate")
    def ssl_certificate(self) -> 'outputs.GetCdnResourceSslCertificateResult':
        """
        SSL certificate of CDN resource.
        """
        return pulumi.get(self, "ssl_certificate")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Last update timestamp. Computed value for read and update operations.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetCdnResourceResult(GetCdnResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCdnResourceResult(
            active=self.active,
            cname=self.cname,
            created_at=self.created_at,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            options=self.options,
            origin_group_id=self.origin_group_id,
            origin_group_name=self.origin_group_name,
            origin_protocol=self.origin_protocol,
            provider_cname=self.provider_cname,
            provider_type=self.provider_type,
            resource_id=self.resource_id,
            secondary_hostnames=self.secondary_hostnames,
            ssl_certificate=self.ssl_certificate,
            updated_at=self.updated_at)


def get_cdn_resource(active: Optional[_builtins.bool] = None,
                     cname: Optional[_builtins.str] = None,
                     folder_id: Optional[_builtins.str] = None,
                     labels: Optional[Mapping[str, _builtins.str]] = None,
                     options: Optional[Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict']] = None,
                     origin_group_id: Optional[_builtins.int] = None,
                     origin_group_name: Optional[_builtins.str] = None,
                     origin_protocol: Optional[_builtins.str] = None,
                     resource_id: Optional[_builtins.str] = None,
                     secondary_hostnames: Optional[Sequence[_builtins.str]] = None,
                     ssl_certificate: Optional[Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict']] = None,
                     updated_at: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCdnResourceResult:
    """
    Allows management of [Yandex Cloud CDN Resource](https://yandex.cloud/docs/cdn/concepts/resource).

    > CDN provider must be activated prior usage of CDN resources, either via UI console or via yc cli command: `yc cdn provider activate --folder-id <folder-id> --type gcore`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing CDN Resource
    #
    my_resource = yandex.get_cdn_resource(resource_id="some resource id")
    pulumi.export("resourceCname", my_resource.cname)
    ```


    :param _builtins.bool active: Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
    :param _builtins.str cname: CDN endpoint CNAME, must be unique among resources.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict'] options: CDN Resource settings and options to tune CDN edge behavior.
    :param _builtins.int origin_group_id: The ID of a specific origin group.
    :param _builtins.str origin_group_name: The name of a specific origin group.
    :param _builtins.str origin_protocol: Protocol of origin resource. `http` or `https`.
    :param Sequence[_builtins.str] secondary_hostnames: List of secondary hostname strings.
    :param Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict'] ssl_certificate: SSL certificate of CDN resource.
    :param _builtins.str updated_at: Last update timestamp. Computed value for read and update operations.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['cname'] = cname
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['options'] = options
    __args__['originGroupId'] = origin_group_id
    __args__['originGroupName'] = origin_group_name
    __args__['originProtocol'] = origin_protocol
    __args__['resourceId'] = resource_id
    __args__['secondaryHostnames'] = secondary_hostnames
    __args__['sslCertificate'] = ssl_certificate
    __args__['updatedAt'] = updated_at
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getCdnResource:getCdnResource', __args__, opts=opts, typ=GetCdnResourceResult).value

    return AwaitableGetCdnResourceResult(
        active=pulumi.get(__ret__, 'active'),
        cname=pulumi.get(__ret__, 'cname'),
        created_at=pulumi.get(__ret__, 'created_at'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        options=pulumi.get(__ret__, 'options'),
        origin_group_id=pulumi.get(__ret__, 'origin_group_id'),
        origin_group_name=pulumi.get(__ret__, 'origin_group_name'),
        origin_protocol=pulumi.get(__ret__, 'origin_protocol'),
        provider_cname=pulumi.get(__ret__, 'provider_cname'),
        provider_type=pulumi.get(__ret__, 'provider_type'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        secondary_hostnames=pulumi.get(__ret__, 'secondary_hostnames'),
        ssl_certificate=pulumi.get(__ret__, 'ssl_certificate'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_cdn_resource_output(active: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                            cname: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            labels: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            options: Optional[pulumi.Input[Optional[Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict']]]] = None,
                            origin_group_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                            origin_group_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            origin_protocol: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            secondary_hostnames: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            ssl_certificate: Optional[pulumi.Input[Optional[Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict']]]] = None,
                            updated_at: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCdnResourceResult]:
    """
    Allows management of [Yandex Cloud CDN Resource](https://yandex.cloud/docs/cdn/concepts/resource).

    > CDN provider must be activated prior usage of CDN resources, either via UI console or via yc cli command: `yc cdn provider activate --folder-id <folder-id> --type gcore`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing CDN Resource
    #
    my_resource = yandex.get_cdn_resource(resource_id="some resource id")
    pulumi.export("resourceCname", my_resource.cname)
    ```


    :param _builtins.bool active: Flag to create Resource either in active or disabled state. `True` - the content from CDN is available to clients.
    :param _builtins.str cname: CDN endpoint CNAME, must be unique among resources.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param Union['GetCdnResourceOptionsArgs', 'GetCdnResourceOptionsArgsDict'] options: CDN Resource settings and options to tune CDN edge behavior.
    :param _builtins.int origin_group_id: The ID of a specific origin group.
    :param _builtins.str origin_group_name: The name of a specific origin group.
    :param _builtins.str origin_protocol: Protocol of origin resource. `http` or `https`.
    :param Sequence[_builtins.str] secondary_hostnames: List of secondary hostname strings.
    :param Union['GetCdnResourceSslCertificateArgs', 'GetCdnResourceSslCertificateArgsDict'] ssl_certificate: SSL certificate of CDN resource.
    :param _builtins.str updated_at: Last update timestamp. Computed value for read and update operations.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['cname'] = cname
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['options'] = options
    __args__['originGroupId'] = origin_group_id
    __args__['originGroupName'] = origin_group_name
    __args__['originProtocol'] = origin_protocol
    __args__['resourceId'] = resource_id
    __args__['secondaryHostnames'] = secondary_hostnames
    __args__['sslCertificate'] = ssl_certificate
    __args__['updatedAt'] = updated_at
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getCdnResource:getCdnResource', __args__, opts=opts, typ=GetCdnResourceResult)
    return __ret__.apply(lambda __response__: GetCdnResourceResult(
        active=pulumi.get(__response__, 'active'),
        cname=pulumi.get(__response__, 'cname'),
        created_at=pulumi.get(__response__, 'created_at'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        options=pulumi.get(__response__, 'options'),
        origin_group_id=pulumi.get(__response__, 'origin_group_id'),
        origin_group_name=pulumi.get(__response__, 'origin_group_name'),
        origin_protocol=pulumi.get(__response__, 'origin_protocol'),
        provider_cname=pulumi.get(__response__, 'provider_cname'),
        provider_type=pulumi.get(__response__, 'provider_type'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        secondary_hostnames=pulumi.get(__response__, 'secondary_hostnames'),
        ssl_certificate=pulumi.get(__response__, 'ssl_certificate'),
        updated_at=pulumi.get(__response__, 'updated_at')))
