# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCmCertificateResult',
    'AwaitableGetCmCertificateResult',
    'get_cm_certificate',
    'get_cm_certificate_output',
]

@pulumi.output_type
class GetCmCertificateResult:
    """
    A collection of values returned by getCmCertificate.
    """
    def __init__(__self__, certificate_id=None, challenges=None, created_at=None, deletion_protection=None, description=None, domains=None, folder_id=None, id=None, issued_at=None, issuer=None, labels=None, name=None, not_after=None, not_before=None, serial=None, status=None, subject=None, type=None, updated_at=None, wait_validation=None):
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if challenges and not isinstance(challenges, list):
            raise TypeError("Expected argument 'challenges' to be a list")
        pulumi.set(__self__, "challenges", challenges)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issued_at and not isinstance(issued_at, str):
            raise TypeError("Expected argument 'issued_at' to be a str")
        pulumi.set(__self__, "issued_at", issued_at)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if not_after and not isinstance(not_after, str):
            raise TypeError("Expected argument 'not_after' to be a str")
        pulumi.set(__self__, "not_after", not_after)
        if not_before and not isinstance(not_before, str):
            raise TypeError("Expected argument 'not_before' to be a str")
        pulumi.set(__self__, "not_before", not_before)
        if serial and not isinstance(serial, str):
            raise TypeError("Expected argument 'serial' to be a str")
        pulumi.set(__self__, "serial", serial)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subject and not isinstance(subject, str):
            raise TypeError("Expected argument 'subject' to be a str")
        pulumi.set(__self__, "subject", subject)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if wait_validation and not isinstance(wait_validation, bool):
            raise TypeError("Expected argument 'wait_validation' to be a bool")
        pulumi.set(__self__, "wait_validation", wait_validation)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        Certificate Id.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def challenges(self) -> Sequence['outputs.GetCmCertificateChallengeResult']:
        return pulumi.get(self, "challenges")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Sequence[_builtins.str]:
        """
        Domains for this certificate. Should be specified for managed certificates.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="issuedAt")
    def issued_at(self) -> _builtins.str:
        """
        Certificate issue timestamp.
        """
        return pulumi.get(self, "issued_at")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        Certificate Issuer.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> _builtins.str:
        """
        Certificate end valid period.
        """
        return pulumi.get(self, "not_after")

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> _builtins.str:
        """
        Certificate start valid period.
        """
        return pulumi.get(self, "not_before")

    @_builtins.property
    @pulumi.getter
    def serial(self) -> _builtins.str:
        """
        Certificate Serial Number.
        """
        return pulumi.get(self, "serial")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Certificate status: `VALIDATING`, `INVALID`, `ISSUED`, `REVOKED`, `RENEWING` or `RENEWAL_FAILED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        Certificate Subject.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Certificate type: `MANAGED` or `IMPORTED`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Certificate update timestamp.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="waitValidation")
    def wait_validation(self) -> Optional[_builtins.bool]:
        """
        If `true`, the operation won't be completed while the certificate is in `VALIDATING`.
        """
        return pulumi.get(self, "wait_validation")


class AwaitableGetCmCertificateResult(GetCmCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCmCertificateResult(
            certificate_id=self.certificate_id,
            challenges=self.challenges,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            domains=self.domains,
            folder_id=self.folder_id,
            id=self.id,
            issued_at=self.issued_at,
            issuer=self.issuer,
            labels=self.labels,
            name=self.name,
            not_after=self.not_after,
            not_before=self.not_before,
            serial=self.serial,
            status=self.status,
            subject=self.subject,
            type=self.type,
            updated_at=self.updated_at,
            wait_validation=self.wait_validation)


def get_cm_certificate(certificate_id: Optional[_builtins.str] = None,
                       description: Optional[_builtins.str] = None,
                       folder_id: Optional[_builtins.str] = None,
                       labels: Optional[Mapping[str, _builtins.str]] = None,
                       name: Optional[_builtins.str] = None,
                       wait_validation: Optional[_builtins.bool] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCmCertificateResult:
    """
    Get information about a Yandex Certificate Manager Certificate. For more information, see [the official documentation](https://yandex.cloud/docs/certificate-manager/concepts/).

    > One of `certificate_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing CM Certificate
    #
    example_by_id = yandex.get_cm_certificate(certificate_id="certificate-id")
    example_by_name = yandex.get_cm_certificate(folder_id="folder-id",
        name="example")
    ```

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Example of Certificate Validation. 
    # Use "data.yandex_cm_certificate.example.id" to get validated certificate.
    #
    example_cm_certificate = yandex.CmCertificate("example",
        name="example",
        domains=[
            "example.com",
            "*.example.com",
        ],
        managed={
            "challenge_type": "DNS_CNAME",
            "challenge_count": 1,
        })
    example_dns_recordset = []
    def create_example(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            example_dns_recordset.append(yandex.DnsRecordset(f"example-{range['value']}",
                zone_id="example-zone-id",
                name=example_cm_certificate.challenges.apply(lambda challenges: challenges.apply(lambda challenges: challenges[range["value"]].dns_name)),
                type=example_cm_certificate.challenges.apply(lambda challenges: challenges.apply(lambda challenges: challenges[range["value"]].dns_type)),
                datas=[example_cm_certificate.challenges.apply(lambda challenges: challenges.apply(lambda challenges: challenges[range["value"]].dns_value))],
                ttl=60))

    example_cm_certificate.managed.challenge_count.apply(create_example)
    example = yandex.get_cm_certificate_output(certificate_id=example_cm_certificate.id,
        wait_validation=True)
    ```


    :param _builtins.str certificate_id: Certificate Id.
    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    :param _builtins.bool wait_validation: If `true`, the operation won't be completed while the certificate is in `VALIDATING`.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['waitValidation'] = wait_validation
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getCmCertificate:getCmCertificate', __args__, opts=opts, typ=GetCmCertificateResult).value

    return AwaitableGetCmCertificateResult(
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        challenges=pulumi.get(__ret__, 'challenges'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        domains=pulumi.get(__ret__, 'domains'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        issued_at=pulumi.get(__ret__, 'issued_at'),
        issuer=pulumi.get(__ret__, 'issuer'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        not_after=pulumi.get(__ret__, 'not_after'),
        not_before=pulumi.get(__ret__, 'not_before'),
        serial=pulumi.get(__ret__, 'serial'),
        status=pulumi.get(__ret__, 'status'),
        subject=pulumi.get(__ret__, 'subject'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        wait_validation=pulumi.get(__ret__, 'wait_validation'))
def get_cm_certificate_output(certificate_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              labels: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              wait_validation: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCmCertificateResult]:
    """
    Get information about a Yandex Certificate Manager Certificate. For more information, see [the official documentation](https://yandex.cloud/docs/certificate-manager/concepts/).

    > One of `certificate_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing CM Certificate
    #
    example_by_id = yandex.get_cm_certificate(certificate_id="certificate-id")
    example_by_name = yandex.get_cm_certificate(folder_id="folder-id",
        name="example")
    ```

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Example of Certificate Validation. 
    # Use "data.yandex_cm_certificate.example.id" to get validated certificate.
    #
    example_cm_certificate = yandex.CmCertificate("example",
        name="example",
        domains=[
            "example.com",
            "*.example.com",
        ],
        managed={
            "challenge_type": "DNS_CNAME",
            "challenge_count": 1,
        })
    example_dns_recordset = []
    def create_example(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            example_dns_recordset.append(yandex.DnsRecordset(f"example-{range['value']}",
                zone_id="example-zone-id",
                name=example_cm_certificate.challenges.apply(lambda challenges: challenges.apply(lambda challenges: challenges[range["value"]].dns_name)),
                type=example_cm_certificate.challenges.apply(lambda challenges: challenges.apply(lambda challenges: challenges[range["value"]].dns_type)),
                datas=[example_cm_certificate.challenges.apply(lambda challenges: challenges.apply(lambda challenges: challenges[range["value"]].dns_value))],
                ttl=60))

    example_cm_certificate.managed.challenge_count.apply(create_example)
    example = yandex.get_cm_certificate_output(certificate_id=example_cm_certificate.id,
        wait_validation=True)
    ```


    :param _builtins.str certificate_id: Certificate Id.
    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param Mapping[str, _builtins.str] labels: A set of key/value label pairs which assigned to resource.
    :param _builtins.str name: The resource name.
    :param _builtins.bool wait_validation: If `true`, the operation won't be completed while the certificate is in `VALIDATING`.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['labels'] = labels
    __args__['name'] = name
    __args__['waitValidation'] = wait_validation
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getCmCertificate:getCmCertificate', __args__, opts=opts, typ=GetCmCertificateResult)
    return __ret__.apply(lambda __response__: GetCmCertificateResult(
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        challenges=pulumi.get(__response__, 'challenges'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        domains=pulumi.get(__response__, 'domains'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        issued_at=pulumi.get(__response__, 'issued_at'),
        issuer=pulumi.get(__response__, 'issuer'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        not_after=pulumi.get(__response__, 'not_after'),
        not_before=pulumi.get(__response__, 'not_before'),
        serial=pulumi.get(__response__, 'serial'),
        status=pulumi.get(__response__, 'status'),
        subject=pulumi.get(__response__, 'subject'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        wait_validation=pulumi.get(__response__, 'wait_validation')))
