# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetComputeFilesystemResult',
    'AwaitableGetComputeFilesystemResult',
    'get_compute_filesystem',
    'get_compute_filesystem_output',
]

@pulumi.output_type
class GetComputeFilesystemResult:
    """
    A collection of values returned by getComputeFilesystem.
    """
    def __init__(__self__, block_size=None, created_at=None, description=None, filesystem_id=None, folder_id=None, id=None, labels=None, name=None, size=None, status=None, type=None, zone=None):
        if block_size and not isinstance(block_size, int):
            raise TypeError("Expected argument 'block_size' to be a int")
        pulumi.set(__self__, "block_size", block_size)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filesystem_id and not isinstance(filesystem_id, str):
            raise TypeError("Expected argument 'filesystem_id' to be a str")
        pulumi.set(__self__, "filesystem_id", filesystem_id)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> _builtins.int:
        """
        Block size of the filesystem, specified in bytes.
        """
        return pulumi.get(self, "block_size")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> _builtins.str:
        """
        ID of the filesystem.
        """
        return pulumi.get(self, "filesystem_id")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Size of the filesystem, specified in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the filesystem.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of filesystem to create. Type `network-hdd` is set by default.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone")


class AwaitableGetComputeFilesystemResult(GetComputeFilesystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeFilesystemResult(
            block_size=self.block_size,
            created_at=self.created_at,
            description=self.description,
            filesystem_id=self.filesystem_id,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            size=self.size,
            status=self.status,
            type=self.type,
            zone=self.zone)


def get_compute_filesystem(filesystem_id: Optional[_builtins.str] = None,
                           folder_id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeFilesystemResult:
    """
    Get information about a Yandex Compute filesystem. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/filesystem).

    > One of `filesystem_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Get information about existing Compute Filesystem.
    #
    my_fs = yandex.get_compute_filesystem(filesystem_id="some_fs_id")
    # You can use "data.yandex_compute_filesystem.my_fs.id" identifier 
    # as reference to the existing resource.
    default = yandex.ComputeInstance("default", filesystems=[{
        "filesystem_id": my_fs.id,
    }])
    ```


    :param _builtins.str filesystem_id: ID of the filesystem.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['filesystemId'] = filesystem_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getComputeFilesystem:getComputeFilesystem', __args__, opts=opts, typ=GetComputeFilesystemResult).value

    return AwaitableGetComputeFilesystemResult(
        block_size=pulumi.get(__ret__, 'block_size'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        filesystem_id=pulumi.get(__ret__, 'filesystem_id'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        size=pulumi.get(__ret__, 'size'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        zone=pulumi.get(__ret__, 'zone'))
def get_compute_filesystem_output(filesystem_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeFilesystemResult]:
    """
    Get information about a Yandex Compute filesystem. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/filesystem).

    > One of `filesystem_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Get information about existing Compute Filesystem.
    #
    my_fs = yandex.get_compute_filesystem(filesystem_id="some_fs_id")
    # You can use "data.yandex_compute_filesystem.my_fs.id" identifier 
    # as reference to the existing resource.
    default = yandex.ComputeInstance("default", filesystems=[{
        "filesystem_id": my_fs.id,
    }])
    ```


    :param _builtins.str filesystem_id: ID of the filesystem.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['filesystemId'] = filesystem_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getComputeFilesystem:getComputeFilesystem', __args__, opts=opts, typ=GetComputeFilesystemResult)
    return __ret__.apply(lambda __response__: GetComputeFilesystemResult(
        block_size=pulumi.get(__response__, 'block_size'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        filesystem_id=pulumi.get(__response__, 'filesystem_id'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        size=pulumi.get(__response__, 'size'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        zone=pulumi.get(__response__, 'zone')))
