# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetComputeImageResult',
    'AwaitableGetComputeImageResult',
    'get_compute_image',
    'get_compute_image_output',
]

@pulumi.output_type
class GetComputeImageResult:
    """
    A collection of values returned by getComputeImage.
    """
    def __init__(__self__, created_at=None, description=None, family=None, folder_id=None, hardware_generations=None, id=None, image_id=None, kms_key_id=None, labels=None, min_disk_size=None, name=None, os_type=None, pooled=None, product_ids=None, size=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if family and not isinstance(family, str):
            raise TypeError("Expected argument 'family' to be a str")
        pulumi.set(__self__, "family", family)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if hardware_generations and not isinstance(hardware_generations, list):
            raise TypeError("Expected argument 'hardware_generations' to be a list")
        pulumi.set(__self__, "hardware_generations", hardware_generations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if min_disk_size and not isinstance(min_disk_size, int):
            raise TypeError("Expected argument 'min_disk_size' to be a int")
        pulumi.set(__self__, "min_disk_size", min_disk_size)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if pooled and not isinstance(pooled, bool):
            raise TypeError("Expected argument 'pooled' to be a bool")
        pulumi.set(__self__, "pooled", pooled)
        if product_ids and not isinstance(product_ids, list):
            raise TypeError("Expected argument 'product_ids' to be a list")
        pulumi.set(__self__, "product_ids", product_ids)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        The name of the image family to which this image belongs.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="hardwareGenerations")
    def hardware_generations(self) -> Sequence['outputs.GetComputeImageHardwareGenerationResult']:
        return pulumi.get(self, "hardware_generations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The ID of a specific image.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        ID of KMS symmetric key used to encrypt image.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> _builtins.int:
        """
        Minimum size in GB of the disk that will be created from this image.
        """
        return pulumi.get(self, "min_disk_size")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        Operating system type that is contained in the image. Possible values: `LINUX`, `WINDOWS`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def pooled(self) -> _builtins.bool:
        """
        Optimize the image to create a disk.
        """
        return pulumi.get(self, "pooled")

    @_builtins.property
    @pulumi.getter(name="productIds")
    def product_ids(self) -> Sequence[_builtins.str]:
        """
        License IDs that indicate which licenses are attached to this image.
        """
        return pulumi.get(self, "product_ids")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size of the image, specified in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")


class AwaitableGetComputeImageResult(GetComputeImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeImageResult(
            created_at=self.created_at,
            description=self.description,
            family=self.family,
            folder_id=self.folder_id,
            hardware_generations=self.hardware_generations,
            id=self.id,
            image_id=self.image_id,
            kms_key_id=self.kms_key_id,
            labels=self.labels,
            min_disk_size=self.min_disk_size,
            name=self.name,
            os_type=self.os_type,
            pooled=self.pooled,
            product_ids=self.product_ids,
            size=self.size,
            status=self.status)


def get_compute_image(family: Optional[_builtins.str] = None,
                      folder_id: Optional[_builtins.str] = None,
                      image_id: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeImageResult:
    """
    Get information about a Yandex Compute image. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/image).

    > Either `image_id`, `family` or `name` must be specified.

    > If you specify `family` without `folder_id` then lookup takes place in the 'standard-images' folder.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Get information about existing Compute Image
    #
    my_image = yandex.get_compute_image(family="ubuntu-1804-lts")
    # You can use "data.yandex_compute_image.my_image.id" identifier 
    # as reference to existing resource.
    default = yandex.ComputeInstance("default", boot_disk={
        "initialize_params": {
            "image_id": my_image.id,
        },
    })
    ```


    :param _builtins.str family: The name of the image family to which this image belongs.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str image_id: The ID of a specific image.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['family'] = family
    __args__['folderId'] = folder_id
    __args__['imageId'] = image_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getComputeImage:getComputeImage', __args__, opts=opts, typ=GetComputeImageResult).value

    return AwaitableGetComputeImageResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        family=pulumi.get(__ret__, 'family'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        hardware_generations=pulumi.get(__ret__, 'hardware_generations'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        labels=pulumi.get(__ret__, 'labels'),
        min_disk_size=pulumi.get(__ret__, 'min_disk_size'),
        name=pulumi.get(__ret__, 'name'),
        os_type=pulumi.get(__ret__, 'os_type'),
        pooled=pulumi.get(__ret__, 'pooled'),
        product_ids=pulumi.get(__ret__, 'product_ids'),
        size=pulumi.get(__ret__, 'size'),
        status=pulumi.get(__ret__, 'status'))
def get_compute_image_output(family: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             image_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeImageResult]:
    """
    Get information about a Yandex Compute image. For more information, see [the official documentation](https://yandex.cloud/docs/compute/concepts/image).

    > Either `image_id`, `family` or `name` must be specified.

    > If you specify `family` without `folder_id` then lookup takes place in the 'standard-images' folder.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex
    import pulumi_yandex_marketmaker as yandex

    #
    # Get information about existing Compute Image
    #
    my_image = yandex.get_compute_image(family="ubuntu-1804-lts")
    # You can use "data.yandex_compute_image.my_image.id" identifier 
    # as reference to existing resource.
    default = yandex.ComputeInstance("default", boot_disk={
        "initialize_params": {
            "image_id": my_image.id,
        },
    })
    ```


    :param _builtins.str family: The name of the image family to which this image belongs.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str image_id: The ID of a specific image.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['family'] = family
    __args__['folderId'] = folder_id
    __args__['imageId'] = image_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getComputeImage:getComputeImage', __args__, opts=opts, typ=GetComputeImageResult)
    return __ret__.apply(lambda __response__: GetComputeImageResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        family=pulumi.get(__response__, 'family'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        hardware_generations=pulumi.get(__response__, 'hardware_generations'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        labels=pulumi.get(__response__, 'labels'),
        min_disk_size=pulumi.get(__response__, 'min_disk_size'),
        name=pulumi.get(__response__, 'name'),
        os_type=pulumi.get(__response__, 'os_type'),
        pooled=pulumi.get(__response__, 'pooled'),
        product_ids=pulumi.get(__response__, 'product_ids'),
        size=pulumi.get(__response__, 'size'),
        status=pulumi.get(__response__, 'status')))
