# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDataprocClusterResult',
    'AwaitableGetDataprocClusterResult',
    'get_dataproc_cluster',
    'get_dataproc_cluster_output',
]

@pulumi.output_type
class GetDataprocClusterResult:
    """
    A collection of values returned by getDataprocCluster.
    """
    def __init__(__self__, autoscaling_service_account_id=None, bucket=None, cluster_configs=None, cluster_id=None, created_at=None, deletion_protection=None, description=None, environment=None, folder_id=None, host_group_ids=None, id=None, labels=None, log_group_id=None, name=None, security_group_ids=None, service_account_id=None, ui_proxy=None, zone_id=None):
        if autoscaling_service_account_id and not isinstance(autoscaling_service_account_id, str):
            raise TypeError("Expected argument 'autoscaling_service_account_id' to be a str")
        pulumi.set(__self__, "autoscaling_service_account_id", autoscaling_service_account_id)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if cluster_configs and not isinstance(cluster_configs, list):
            raise TypeError("Expected argument 'cluster_configs' to be a list")
        pulumi.set(__self__, "cluster_configs", cluster_configs)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids and not isinstance(host_group_ids, list):
            raise TypeError("Expected argument 'host_group_ids' to be a list")
        pulumi.set(__self__, "host_group_ids", host_group_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if log_group_id and not isinstance(log_group_id, str):
            raise TypeError("Expected argument 'log_group_id' to be a str")
        pulumi.set(__self__, "log_group_id", log_group_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_account_id and not isinstance(service_account_id, str):
            raise TypeError("Expected argument 'service_account_id' to be a str")
        pulumi.set(__self__, "service_account_id", service_account_id)
        if ui_proxy and not isinstance(ui_proxy, bool):
            raise TypeError("Expected argument 'ui_proxy' to be a bool")
        pulumi.set(__self__, "ui_proxy", ui_proxy)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="autoscalingServiceAccountId")
    def autoscaling_service_account_id(self) -> _builtins.str:
        """
        Service account to be used for managing hosts in an autoscaled subcluster.
        """
        return pulumi.get(self, "autoscaling_service_account_id")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Name of the Object Storage bucket to use for Yandex Data Processing jobs. Yandex Data Processing Agent saves output of job driver's process to specified bucket. In order for this to work service account (specified by the `service_account_id` argument) should be given permission to create objects within this bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="clusterConfigs")
    def cluster_configs(self) -> Sequence['outputs.GetDataprocClusterClusterConfigResult']:
        """
        Configuration and resources for hosts that should be created with the cluster.
        """
        return pulumi.get(self, "cluster_configs")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Yandex Data Processing cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> _builtins.str:
        """
        Deployment environment of the cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRESTABLE`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Sequence[_builtins.str]:
        """
        A list of host group IDs to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        ID of the cloud logging group for cluster logs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> _builtins.str:
        """
        Service account to be used by the Yandex Data Processing agent to access resources of Yandex Cloud. Selected service account should have `mdb.dataproc.agent` role on the folder where the Yandex Data Processing cluster will be located.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="uiProxy")
    def ui_proxy(self) -> _builtins.bool:
        """
        Whether to enable UI Proxy feature.
        """
        return pulumi.get(self, "ui_proxy")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) where resource is located. If it is not provided, the default provider zone will be used.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetDataprocClusterResult(GetDataprocClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataprocClusterResult(
            autoscaling_service_account_id=self.autoscaling_service_account_id,
            bucket=self.bucket,
            cluster_configs=self.cluster_configs,
            cluster_id=self.cluster_id,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            environment=self.environment,
            folder_id=self.folder_id,
            host_group_ids=self.host_group_ids,
            id=self.id,
            labels=self.labels,
            log_group_id=self.log_group_id,
            name=self.name,
            security_group_ids=self.security_group_ids,
            service_account_id=self.service_account_id,
            ui_proxy=self.ui_proxy,
            zone_id=self.zone_id)


def get_dataproc_cluster(cluster_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataprocClusterResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Data Processing Cluster.
    #
    foo = yandex.get_dataproc_cluster(name="test")
    pulumi.export("serviceAccountId", foo.service_account_id)
    ```


    :param _builtins.str cluster_id: The ID of the Yandex Data Processing cluster.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getDataprocCluster:getDataprocCluster', __args__, opts=opts, typ=GetDataprocClusterResult).value

    return AwaitableGetDataprocClusterResult(
        autoscaling_service_account_id=pulumi.get(__ret__, 'autoscaling_service_account_id'),
        bucket=pulumi.get(__ret__, 'bucket'),
        cluster_configs=pulumi.get(__ret__, 'cluster_configs'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        environment=pulumi.get(__ret__, 'environment'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        host_group_ids=pulumi.get(__ret__, 'host_group_ids'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        log_group_id=pulumi.get(__ret__, 'log_group_id'),
        name=pulumi.get(__ret__, 'name'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        service_account_id=pulumi.get(__ret__, 'service_account_id'),
        ui_proxy=pulumi.get(__ret__, 'ui_proxy'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_dataproc_cluster_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataprocClusterResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Data Processing Cluster.
    #
    foo = yandex.get_dataproc_cluster(name="test")
    pulumi.export("serviceAccountId", foo.service_account_id)
    ```


    :param _builtins.str cluster_id: The ID of the Yandex Data Processing cluster.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getDataprocCluster:getDataprocCluster', __args__, opts=opts, typ=GetDataprocClusterResult)
    return __ret__.apply(lambda __response__: GetDataprocClusterResult(
        autoscaling_service_account_id=pulumi.get(__response__, 'autoscaling_service_account_id'),
        bucket=pulumi.get(__response__, 'bucket'),
        cluster_configs=pulumi.get(__response__, 'cluster_configs'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        environment=pulumi.get(__response__, 'environment'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        host_group_ids=pulumi.get(__response__, 'host_group_ids'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        log_group_id=pulumi.get(__response__, 'log_group_id'),
        name=pulumi.get(__response__, 'name'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        service_account_id=pulumi.get(__response__, 'service_account_id'),
        ui_proxy=pulumi.get(__response__, 'ui_proxy'),
        zone_id=pulumi.get(__response__, 'zone_id')))
