# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIamPolicyResult',
    'AwaitableGetIamPolicyResult',
    'get_iam_policy',
    'get_iam_policy_output',
]

@pulumi.output_type
class GetIamPolicyResult:
    """
    A collection of values returned by getIamPolicy.
    """
    def __init__(__self__, bindings=None, id=None, policy_data=None):
        if bindings and not isinstance(bindings, list):
            raise TypeError("Expected argument 'bindings' to be a list")
        pulumi.set(__self__, "bindings", bindings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> Sequence['outputs.GetIamPolicyBindingResult']:
        """
        Defines a binding to be included in the policy document. Multiple `binding` arguments are supported.
        """
        return pulumi.get(self, "bindings")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        The above bindings serialized in a format suitable for referencing from a resource that supports IAM.
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetIamPolicyResult(GetIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamPolicyResult(
            bindings=self.bindings,
            id=self.id,
            policy_data=self.policy_data)


def get_iam_policy(bindings: Optional[Sequence[Union['GetIamPolicyBindingArgs', 'GetIamPolicyBindingArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamPolicyResult:
    """
    Generates an [IAM](https://yandex.cloud/docs/iam/) policy document that may be referenced by and applied to other Yandex Cloud Platform resources, such as the `get_resourcemanager_folder` resource.

    This data source is used to define [IAM](https://yandex.cloud/docs/iam/) policies to apply to other resources. Currently, defining a policy through a data source and referencing that policy from another resource is the only way to apply an IAM policy to a resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IAM Policy.
    #
    admin = yandex.get_iam_policy(bindings=[
        {
            "role": "admin",
            "members": ["userAccount:user_id_1"],
        },
        {
            "role": "viewer",
            "members": ["userAccount:user_id_2"],
        },
    ])
    ```


    :param Sequence[Union['GetIamPolicyBindingArgs', 'GetIamPolicyBindingArgsDict']] bindings: Defines a binding to be included in the policy document. Multiple `binding` arguments are supported.
    """
    __args__ = dict()
    __args__['bindings'] = bindings
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getIamPolicy:getIamPolicy', __args__, opts=opts, typ=GetIamPolicyResult).value

    return AwaitableGetIamPolicyResult(
        bindings=pulumi.get(__ret__, 'bindings'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'))
def get_iam_policy_output(bindings: Optional[pulumi.Input[Sequence[Union['GetIamPolicyBindingArgs', 'GetIamPolicyBindingArgsDict']]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIamPolicyResult]:
    """
    Generates an [IAM](https://yandex.cloud/docs/iam/) policy document that may be referenced by and applied to other Yandex Cloud Platform resources, such as the `get_resourcemanager_folder` resource.

    This data source is used to define [IAM](https://yandex.cloud/docs/iam/) policies to apply to other resources. Currently, defining a policy through a data source and referencing that policy from another resource is the only way to apply an IAM policy to a resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing IAM Policy.
    #
    admin = yandex.get_iam_policy(bindings=[
        {
            "role": "admin",
            "members": ["userAccount:user_id_1"],
        },
        {
            "role": "viewer",
            "members": ["userAccount:user_id_2"],
        },
    ])
    ```


    :param Sequence[Union['GetIamPolicyBindingArgs', 'GetIamPolicyBindingArgsDict']] bindings: Defines a binding to be included in the policy document. Multiple `binding` arguments are supported.
    """
    __args__ = dict()
    __args__['bindings'] = bindings
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getIamPolicy:getIamPolicy', __args__, opts=opts, typ=GetIamPolicyResult)
    return __ret__.apply(lambda __response__: GetIamPolicyResult(
        bindings=pulumi.get(__response__, 'bindings'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data')))
