# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetKubernetesClusterResult',
    'AwaitableGetKubernetesClusterResult',
    'get_kubernetes_cluster',
    'get_kubernetes_cluster_output',
]

@pulumi.output_type
class GetKubernetesClusterResult:
    """
    A collection of values returned by getKubernetesCluster.
    """
    def __init__(__self__, cluster_id=None, cluster_ipv4_range=None, cluster_ipv6_range=None, created_at=None, description=None, folder_id=None, health=None, id=None, kms_providers=None, labels=None, log_group_id=None, masters=None, name=None, network_id=None, network_implementations=None, network_policy_provider=None, node_ipv4_cidr_mask_size=None, node_service_account_id=None, release_channel=None, service_account_id=None, service_ipv4_range=None, service_ipv6_range=None, status=None, workload_identity_federations=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_ipv4_range and not isinstance(cluster_ipv4_range, str):
            raise TypeError("Expected argument 'cluster_ipv4_range' to be a str")
        pulumi.set(__self__, "cluster_ipv4_range", cluster_ipv4_range)
        if cluster_ipv6_range and not isinstance(cluster_ipv6_range, str):
            raise TypeError("Expected argument 'cluster_ipv6_range' to be a str")
        pulumi.set(__self__, "cluster_ipv6_range", cluster_ipv6_range)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if health and not isinstance(health, str):
            raise TypeError("Expected argument 'health' to be a str")
        pulumi.set(__self__, "health", health)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_providers and not isinstance(kms_providers, list):
            raise TypeError("Expected argument 'kms_providers' to be a list")
        pulumi.set(__self__, "kms_providers", kms_providers)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if log_group_id and not isinstance(log_group_id, str):
            raise TypeError("Expected argument 'log_group_id' to be a str")
        pulumi.set(__self__, "log_group_id", log_group_id)
        if masters and not isinstance(masters, list):
            raise TypeError("Expected argument 'masters' to be a list")
        pulumi.set(__self__, "masters", masters)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if network_implementations and not isinstance(network_implementations, list):
            raise TypeError("Expected argument 'network_implementations' to be a list")
        pulumi.set(__self__, "network_implementations", network_implementations)
        if network_policy_provider and not isinstance(network_policy_provider, str):
            raise TypeError("Expected argument 'network_policy_provider' to be a str")
        pulumi.set(__self__, "network_policy_provider", network_policy_provider)
        if node_ipv4_cidr_mask_size and not isinstance(node_ipv4_cidr_mask_size, int):
            raise TypeError("Expected argument 'node_ipv4_cidr_mask_size' to be a int")
        pulumi.set(__self__, "node_ipv4_cidr_mask_size", node_ipv4_cidr_mask_size)
        if node_service_account_id and not isinstance(node_service_account_id, str):
            raise TypeError("Expected argument 'node_service_account_id' to be a str")
        pulumi.set(__self__, "node_service_account_id", node_service_account_id)
        if release_channel and not isinstance(release_channel, str):
            raise TypeError("Expected argument 'release_channel' to be a str")
        pulumi.set(__self__, "release_channel", release_channel)
        if service_account_id and not isinstance(service_account_id, str):
            raise TypeError("Expected argument 'service_account_id' to be a str")
        pulumi.set(__self__, "service_account_id", service_account_id)
        if service_ipv4_range and not isinstance(service_ipv4_range, str):
            raise TypeError("Expected argument 'service_ipv4_range' to be a str")
        pulumi.set(__self__, "service_ipv4_range", service_ipv4_range)
        if service_ipv6_range and not isinstance(service_ipv6_range, str):
            raise TypeError("Expected argument 'service_ipv6_range' to be a str")
        pulumi.set(__self__, "service_ipv6_range", service_ipv6_range)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if workload_identity_federations and not isinstance(workload_identity_federations, list):
            raise TypeError("Expected argument 'workload_identity_federations' to be a list")
        pulumi.set(__self__, "workload_identity_federations", workload_identity_federations)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        ID of a specific Kubernetes cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterIpv4Range")
    def cluster_ipv4_range(self) -> _builtins.str:
        """
        CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        """
        return pulumi.get(self, "cluster_ipv4_range")

    @_builtins.property
    @pulumi.getter(name="clusterIpv6Range")
    def cluster_ipv6_range(self) -> _builtins.str:
        """
        Identical to `cluster_ipv4_range` but for IPv6 protocol.
        """
        return pulumi.get(self, "cluster_ipv6_range")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> _builtins.str:
        """
        Health of the Kubernetes cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsProviders")
    def kms_providers(self) -> Sequence['outputs.GetKubernetesClusterKmsProviderResult']:
        """
        Cluster KMS provider parameters.
        """
        return pulumi.get(self, "kms_providers")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> _builtins.str:
        """
        Log group where cluster stores cluster system logs, like audit, events, or control plane logs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter
    def masters(self) -> Sequence['outputs.GetKubernetesClusterMasterResult']:
        """
        Kubernetes master configuration options.
        """
        return pulumi.get(self, "masters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The ID of the cluster network.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="networkImplementations")
    def network_implementations(self) -> Sequence['outputs.GetKubernetesClusterNetworkImplementationResult']:
        """
        Network Implementation options.
        """
        return pulumi.get(self, "network_implementations")

    @_builtins.property
    @pulumi.getter(name="networkPolicyProvider")
    def network_policy_provider(self) -> _builtins.str:
        """
        Network policy provider for the cluster. Possible values: `CALICO`.
        """
        return pulumi.get(self, "network_policy_provider")

    @_builtins.property
    @pulumi.getter(name="nodeIpv4CidrMaskSize")
    def node_ipv4_cidr_mask_size(self) -> _builtins.int:
        """
        Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        """
        return pulumi.get(self, "node_ipv4_cidr_mask_size")

    @_builtins.property
    @pulumi.getter(name="nodeServiceAccountId")
    def node_service_account_id(self) -> _builtins.str:
        """
        Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        """
        return pulumi.get(self, "node_service_account_id")

    @_builtins.property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> _builtins.str:
        """
        Cluster release channel.
        """
        return pulumi.get(self, "release_channel")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> _builtins.str:
        """
        Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="serviceIpv4Range")
    def service_ipv4_range(self) -> _builtins.str:
        """
        CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        """
        return pulumi.get(self, "service_ipv4_range")

    @_builtins.property
    @pulumi.getter(name="serviceIpv6Range")
    def service_ipv6_range(self) -> _builtins.str:
        """
        Identical to service*ipv4*range but for IPv6 protocol.
        """
        return pulumi.get(self, "service_ipv6_range")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederations")
    def workload_identity_federations(self) -> Sequence['outputs.GetKubernetesClusterWorkloadIdentityFederationResult']:
        """
        Workload Identity Federation configuration.
        """
        return pulumi.get(self, "workload_identity_federations")


class AwaitableGetKubernetesClusterResult(GetKubernetesClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesClusterResult(
            cluster_id=self.cluster_id,
            cluster_ipv4_range=self.cluster_ipv4_range,
            cluster_ipv6_range=self.cluster_ipv6_range,
            created_at=self.created_at,
            description=self.description,
            folder_id=self.folder_id,
            health=self.health,
            id=self.id,
            kms_providers=self.kms_providers,
            labels=self.labels,
            log_group_id=self.log_group_id,
            masters=self.masters,
            name=self.name,
            network_id=self.network_id,
            network_implementations=self.network_implementations,
            network_policy_provider=self.network_policy_provider,
            node_ipv4_cidr_mask_size=self.node_ipv4_cidr_mask_size,
            node_service_account_id=self.node_service_account_id,
            release_channel=self.release_channel,
            service_account_id=self.service_account_id,
            service_ipv4_range=self.service_ipv4_range,
            service_ipv6_range=self.service_ipv6_range,
            status=self.status,
            workload_identity_federations=self.workload_identity_federations)


def get_kubernetes_cluster(cluster_id: Optional[_builtins.str] = None,
                           folder_id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesClusterResult:
    """
    Get information about a Yandex Cloud Managed Kubernetes Cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kubernetes/concepts/#kubernetes-cluster).

    > One of `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Managed Kubernetes Cluster (MK8S).
    #
    my_cluster = yandex.get_kubernetes_cluster(cluster_id="some_k8s_cluster_id")
    pulumi.export("clusterExternalV4Endpoint", my_cluster.masters[0].external_v4_endpoint)
    ```


    :param _builtins.str cluster_id: ID of a specific Kubernetes cluster.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts, typ=GetKubernetesClusterResult).value

    return AwaitableGetKubernetesClusterResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_ipv4_range=pulumi.get(__ret__, 'cluster_ipv4_range'),
        cluster_ipv6_range=pulumi.get(__ret__, 'cluster_ipv6_range'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        health=pulumi.get(__ret__, 'health'),
        id=pulumi.get(__ret__, 'id'),
        kms_providers=pulumi.get(__ret__, 'kms_providers'),
        labels=pulumi.get(__ret__, 'labels'),
        log_group_id=pulumi.get(__ret__, 'log_group_id'),
        masters=pulumi.get(__ret__, 'masters'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        network_implementations=pulumi.get(__ret__, 'network_implementations'),
        network_policy_provider=pulumi.get(__ret__, 'network_policy_provider'),
        node_ipv4_cidr_mask_size=pulumi.get(__ret__, 'node_ipv4_cidr_mask_size'),
        node_service_account_id=pulumi.get(__ret__, 'node_service_account_id'),
        release_channel=pulumi.get(__ret__, 'release_channel'),
        service_account_id=pulumi.get(__ret__, 'service_account_id'),
        service_ipv4_range=pulumi.get(__ret__, 'service_ipv4_range'),
        service_ipv6_range=pulumi.get(__ret__, 'service_ipv6_range'),
        status=pulumi.get(__ret__, 'status'),
        workload_identity_federations=pulumi.get(__ret__, 'workload_identity_federations'))
def get_kubernetes_cluster_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesClusterResult]:
    """
    Get information about a Yandex Cloud Managed Kubernetes Cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kubernetes/concepts/#kubernetes-cluster).

    > One of `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Managed Kubernetes Cluster (MK8S).
    #
    my_cluster = yandex.get_kubernetes_cluster(cluster_id="some_k8s_cluster_id")
    pulumi.export("clusterExternalV4Endpoint", my_cluster.masters[0].external_v4_endpoint)
    ```


    :param _builtins.str cluster_id: ID of a specific Kubernetes cluster.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getKubernetesCluster:getKubernetesCluster', __args__, opts=opts, typ=GetKubernetesClusterResult)
    return __ret__.apply(lambda __response__: GetKubernetesClusterResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_ipv4_range=pulumi.get(__response__, 'cluster_ipv4_range'),
        cluster_ipv6_range=pulumi.get(__response__, 'cluster_ipv6_range'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        health=pulumi.get(__response__, 'health'),
        id=pulumi.get(__response__, 'id'),
        kms_providers=pulumi.get(__response__, 'kms_providers'),
        labels=pulumi.get(__response__, 'labels'),
        log_group_id=pulumi.get(__response__, 'log_group_id'),
        masters=pulumi.get(__response__, 'masters'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        network_implementations=pulumi.get(__response__, 'network_implementations'),
        network_policy_provider=pulumi.get(__response__, 'network_policy_provider'),
        node_ipv4_cidr_mask_size=pulumi.get(__response__, 'node_ipv4_cidr_mask_size'),
        node_service_account_id=pulumi.get(__response__, 'node_service_account_id'),
        release_channel=pulumi.get(__response__, 'release_channel'),
        service_account_id=pulumi.get(__response__, 'service_account_id'),
        service_ipv4_range=pulumi.get(__response__, 'service_ipv4_range'),
        service_ipv6_range=pulumi.get(__response__, 'service_ipv6_range'),
        status=pulumi.get(__response__, 'status'),
        workload_identity_federations=pulumi.get(__response__, 'workload_identity_federations')))
