# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetKubernetesNodeGroupResult',
    'AwaitableGetKubernetesNodeGroupResult',
    'get_kubernetes_node_group',
    'get_kubernetes_node_group_output',
]

@pulumi.output_type
class GetKubernetesNodeGroupResult:
    """
    A collection of values returned by getKubernetesNodeGroup.
    """
    def __init__(__self__, allocation_policies=None, allowed_unsafe_sysctls=None, cluster_id=None, created_at=None, deploy_policies=None, description=None, folder_id=None, id=None, instance_group_id=None, instance_templates=None, labels=None, maintenance_policies=None, name=None, node_group_id=None, node_labels=None, node_taints=None, scale_policies=None, status=None, version_infos=None):
        if allocation_policies and not isinstance(allocation_policies, list):
            raise TypeError("Expected argument 'allocation_policies' to be a list")
        pulumi.set(__self__, "allocation_policies", allocation_policies)
        if allowed_unsafe_sysctls and not isinstance(allowed_unsafe_sysctls, list):
            raise TypeError("Expected argument 'allowed_unsafe_sysctls' to be a list")
        pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deploy_policies and not isinstance(deploy_policies, list):
            raise TypeError("Expected argument 'deploy_policies' to be a list")
        pulumi.set(__self__, "deploy_policies", deploy_policies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_group_id and not isinstance(instance_group_id, str):
            raise TypeError("Expected argument 'instance_group_id' to be a str")
        pulumi.set(__self__, "instance_group_id", instance_group_id)
        if instance_templates and not isinstance(instance_templates, list):
            raise TypeError("Expected argument 'instance_templates' to be a list")
        pulumi.set(__self__, "instance_templates", instance_templates)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if maintenance_policies and not isinstance(maintenance_policies, list):
            raise TypeError("Expected argument 'maintenance_policies' to be a list")
        pulumi.set(__self__, "maintenance_policies", maintenance_policies)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_group_id and not isinstance(node_group_id, str):
            raise TypeError("Expected argument 'node_group_id' to be a str")
        pulumi.set(__self__, "node_group_id", node_group_id)
        if node_labels and not isinstance(node_labels, dict):
            raise TypeError("Expected argument 'node_labels' to be a dict")
        pulumi.set(__self__, "node_labels", node_labels)
        if node_taints and not isinstance(node_taints, list):
            raise TypeError("Expected argument 'node_taints' to be a list")
        pulumi.set(__self__, "node_taints", node_taints)
        if scale_policies and not isinstance(scale_policies, list):
            raise TypeError("Expected argument 'scale_policies' to be a list")
        pulumi.set(__self__, "scale_policies", scale_policies)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if version_infos and not isinstance(version_infos, list):
            raise TypeError("Expected argument 'version_infos' to be a list")
        pulumi.set(__self__, "version_infos", version_infos)

    @_builtins.property
    @pulumi.getter(name="allocationPolicies")
    def allocation_policies(self) -> Sequence['outputs.GetKubernetesNodeGroupAllocationPolicyResult']:
        return pulumi.get(self, "allocation_policies")

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Sequence[_builtins.str]:
        """
        A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Kubernetes cluster that this node group belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deployPolicies")
    def deploy_policies(self) -> Sequence['outputs.GetKubernetesNodeGroupDeployPolicyResult']:
        return pulumi.get(self, "deploy_policies")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceGroupId")
    def instance_group_id(self) -> _builtins.str:
        """
        ID of instance group that is used to manage this Kubernetes node group.
        """
        return pulumi.get(self, "instance_group_id")

    @_builtins.property
    @pulumi.getter(name="instanceTemplates")
    def instance_templates(self) -> Sequence['outputs.GetKubernetesNodeGroupInstanceTemplateResult']:
        return pulumi.get(self, "instance_templates")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicies")
    def maintenance_policies(self) -> Sequence['outputs.GetKubernetesNodeGroupMaintenancePolicyResult']:
        return pulumi.get(self, "maintenance_policies")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> _builtins.str:
        """
        ID of a specific Kubernetes node group.
        """
        return pulumi.get(self, "node_group_id")

    @_builtins.property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_labels")

    @_builtins.property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Sequence[_builtins.str]:
        """
        A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_taints")

    @_builtins.property
    @pulumi.getter(name="scalePolicies")
    def scale_policies(self) -> Sequence['outputs.GetKubernetesNodeGroupScalePolicyResult']:
        return pulumi.get(self, "scale_policies")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the Kubernetes node group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="versionInfos")
    def version_infos(self) -> Sequence['outputs.GetKubernetesNodeGroupVersionInfoResult']:
        return pulumi.get(self, "version_infos")


class AwaitableGetKubernetesNodeGroupResult(GetKubernetesNodeGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesNodeGroupResult(
            allocation_policies=self.allocation_policies,
            allowed_unsafe_sysctls=self.allowed_unsafe_sysctls,
            cluster_id=self.cluster_id,
            created_at=self.created_at,
            deploy_policies=self.deploy_policies,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            instance_group_id=self.instance_group_id,
            instance_templates=self.instance_templates,
            labels=self.labels,
            maintenance_policies=self.maintenance_policies,
            name=self.name,
            node_group_id=self.node_group_id,
            node_labels=self.node_labels,
            node_taints=self.node_taints,
            scale_policies=self.scale_policies,
            status=self.status,
            version_infos=self.version_infos)


def get_kubernetes_node_group(folder_id: Optional[_builtins.str] = None,
                              name: Optional[_builtins.str] = None,
                              node_group_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesNodeGroupResult:
    """
    Get information about a Yandex Kubernetes Node Group. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kubernetes/concepts/#node-group).

    > One of `node_group_id` or `name` should be specified.


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str node_group_id: ID of a specific Kubernetes node group.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['nodeGroupId'] = node_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getKubernetesNodeGroup:getKubernetesNodeGroup', __args__, opts=opts, typ=GetKubernetesNodeGroupResult).value

    return AwaitableGetKubernetesNodeGroupResult(
        allocation_policies=pulumi.get(__ret__, 'allocation_policies'),
        allowed_unsafe_sysctls=pulumi.get(__ret__, 'allowed_unsafe_sysctls'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deploy_policies=pulumi.get(__ret__, 'deploy_policies'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_group_id=pulumi.get(__ret__, 'instance_group_id'),
        instance_templates=pulumi.get(__ret__, 'instance_templates'),
        labels=pulumi.get(__ret__, 'labels'),
        maintenance_policies=pulumi.get(__ret__, 'maintenance_policies'),
        name=pulumi.get(__ret__, 'name'),
        node_group_id=pulumi.get(__ret__, 'node_group_id'),
        node_labels=pulumi.get(__ret__, 'node_labels'),
        node_taints=pulumi.get(__ret__, 'node_taints'),
        scale_policies=pulumi.get(__ret__, 'scale_policies'),
        status=pulumi.get(__ret__, 'status'),
        version_infos=pulumi.get(__ret__, 'version_infos'))
def get_kubernetes_node_group_output(folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     node_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesNodeGroupResult]:
    """
    Get information about a Yandex Kubernetes Node Group. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kubernetes/concepts/#node-group).

    > One of `node_group_id` or `name` should be specified.


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str node_group_id: ID of a specific Kubernetes node group.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['nodeGroupId'] = node_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getKubernetesNodeGroup:getKubernetesNodeGroup', __args__, opts=opts, typ=GetKubernetesNodeGroupResult)
    return __ret__.apply(lambda __response__: GetKubernetesNodeGroupResult(
        allocation_policies=pulumi.get(__response__, 'allocation_policies'),
        allowed_unsafe_sysctls=pulumi.get(__response__, 'allowed_unsafe_sysctls'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        deploy_policies=pulumi.get(__response__, 'deploy_policies'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        instance_group_id=pulumi.get(__response__, 'instance_group_id'),
        instance_templates=pulumi.get(__response__, 'instance_templates'),
        labels=pulumi.get(__response__, 'labels'),
        maintenance_policies=pulumi.get(__response__, 'maintenance_policies'),
        name=pulumi.get(__response__, 'name'),
        node_group_id=pulumi.get(__response__, 'node_group_id'),
        node_labels=pulumi.get(__response__, 'node_labels'),
        node_taints=pulumi.get(__response__, 'node_taints'),
        scale_policies=pulumi.get(__response__, 'scale_policies'),
        status=pulumi.get(__response__, 'status'),
        version_infos=pulumi.get(__response__, 'version_infos')))
