# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLbNetworkLoadBalancerResult',
    'AwaitableGetLbNetworkLoadBalancerResult',
    'get_lb_network_load_balancer',
    'get_lb_network_load_balancer_output',
]

@pulumi.output_type
class GetLbNetworkLoadBalancerResult:
    """
    A collection of values returned by getLbNetworkLoadBalancer.
    """
    def __init__(__self__, allow_zonal_shift=None, attached_target_groups=None, created_at=None, deletion_protection=None, description=None, folder_id=None, id=None, labels=None, listeners=None, name=None, network_load_balancer_id=None, region_id=None, type=None):
        if allow_zonal_shift and not isinstance(allow_zonal_shift, bool):
            raise TypeError("Expected argument 'allow_zonal_shift' to be a bool")
        pulumi.set(__self__, "allow_zonal_shift", allow_zonal_shift)
        if attached_target_groups and not isinstance(attached_target_groups, list):
            raise TypeError("Expected argument 'attached_target_groups' to be a list")
        pulumi.set(__self__, "attached_target_groups", attached_target_groups)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_load_balancer_id and not isinstance(network_load_balancer_id, str):
            raise TypeError("Expected argument 'network_load_balancer_id' to be a str")
        pulumi.set(__self__, "network_load_balancer_id", network_load_balancer_id)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="allowZonalShift")
    def allow_zonal_shift(self) -> _builtins.bool:
        """
        Flag that marks the network load balancer as available to zonal shift.
        """
        return pulumi.get(self, "allow_zonal_shift")

    @_builtins.property
    @pulumi.getter(name="attachedTargetGroups")
    def attached_target_groups(self) -> Sequence['outputs.GetLbNetworkLoadBalancerAttachedTargetGroupResult']:
        return pulumi.get(self, "attached_target_groups")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetLbNetworkLoadBalancerListenerResult']:
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkLoadBalancerId")
    def network_load_balancer_id(self) -> _builtins.str:
        """
        Network load balancer ID.
        """
        return pulumi.get(self, "network_load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> _builtins.str:
        """
        ID of the availability zone where the network load balancer resides. If omitted, default region is being used.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the network load balancer. Must be one of 'external' or 'internal'. The default is 'external'.
        """
        return pulumi.get(self, "type")


class AwaitableGetLbNetworkLoadBalancerResult(GetLbNetworkLoadBalancerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbNetworkLoadBalancerResult(
            allow_zonal_shift=self.allow_zonal_shift,
            attached_target_groups=self.attached_target_groups,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            listeners=self.listeners,
            name=self.name,
            network_load_balancer_id=self.network_load_balancer_id,
            region_id=self.region_id,
            type=self.type)


def get_lb_network_load_balancer(folder_id: Optional[_builtins.str] = None,
                                 name: Optional[_builtins.str] = None,
                                 network_load_balancer_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbNetworkLoadBalancerResult:
    """
    Get information about a Yandex Load Balancer network load balancer. For more information, see [the official documentation](https://yandex.cloud/docs/load-balancer/concepts/).

    This data source is used to define [Load Balancer Network Load Balancers](https://yandex.cloud/docs/load-balancer/concepts/) that can be used by other resources.

    > One of `network_load_balancer_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Network Load Balancer (NLB).
    #
    my_nlb = yandex.get_lb_network_load_balancer(network_load_balancer_id="my-network-load-balancer")
    ```


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str network_load_balancer_id: Network load balancer ID.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getLbNetworkLoadBalancer:getLbNetworkLoadBalancer', __args__, opts=opts, typ=GetLbNetworkLoadBalancerResult).value

    return AwaitableGetLbNetworkLoadBalancerResult(
        allow_zonal_shift=pulumi.get(__ret__, 'allow_zonal_shift'),
        attached_target_groups=pulumi.get(__ret__, 'attached_target_groups'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        listeners=pulumi.get(__ret__, 'listeners'),
        name=pulumi.get(__ret__, 'name'),
        network_load_balancer_id=pulumi.get(__ret__, 'network_load_balancer_id'),
        region_id=pulumi.get(__ret__, 'region_id'),
        type=pulumi.get(__ret__, 'type'))
def get_lb_network_load_balancer_output(folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        network_load_balancer_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLbNetworkLoadBalancerResult]:
    """
    Get information about a Yandex Load Balancer network load balancer. For more information, see [the official documentation](https://yandex.cloud/docs/load-balancer/concepts/).

    This data source is used to define [Load Balancer Network Load Balancers](https://yandex.cloud/docs/load-balancer/concepts/) that can be used by other resources.

    > One of `network_load_balancer_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Network Load Balancer (NLB).
    #
    my_nlb = yandex.get_lb_network_load_balancer(network_load_balancer_id="my-network-load-balancer")
    ```


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str network_load_balancer_id: Network load balancer ID.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['networkLoadBalancerId'] = network_load_balancer_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getLbNetworkLoadBalancer:getLbNetworkLoadBalancer', __args__, opts=opts, typ=GetLbNetworkLoadBalancerResult)
    return __ret__.apply(lambda __response__: GetLbNetworkLoadBalancerResult(
        allow_zonal_shift=pulumi.get(__response__, 'allow_zonal_shift'),
        attached_target_groups=pulumi.get(__response__, 'attached_target_groups'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        listeners=pulumi.get(__response__, 'listeners'),
        name=pulumi.get(__response__, 'name'),
        network_load_balancer_id=pulumi.get(__response__, 'network_load_balancer_id'),
        region_id=pulumi.get(__response__, 'region_id'),
        type=pulumi.get(__response__, 'type')))
