# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMdbKafkaClusterResult',
    'AwaitableGetMdbKafkaClusterResult',
    'get_mdb_kafka_cluster',
    'get_mdb_kafka_cluster_output',
]

@pulumi.output_type
class GetMdbKafkaClusterResult:
    """
    A collection of values returned by getMdbKafkaCluster.
    """
    def __init__(__self__, cluster_id=None, config=None, created_at=None, deletion_protection=None, description=None, environment=None, folder_id=None, health=None, host_group_ids=None, hosts=None, id=None, labels=None, maintenance_windows=None, name=None, network_id=None, security_group_ids=None, status=None, subnet_ids=None, topics=None, users=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if health and not isinstance(health, str):
            raise TypeError("Expected argument 'health' to be a str")
        pulumi.set(__self__, "health", health)
        if host_group_ids and not isinstance(host_group_ids, list):
            raise TypeError("Expected argument 'host_group_ids' to be a list")
        pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional['outputs.GetMdbKafkaClusterConfigResult']:
        """
        Configuration of the Kafka cluster.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> _builtins.str:
        """
        Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> _builtins.str:
        """
        Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-kafka/api-ref/Cluster/).
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Sequence[_builtins.str]:
        """
        A list of IDs of the host groups to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.GetMdbKafkaClusterHostResult']:
        """
        A host of the Kafka cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetMdbKafkaClusterMaintenanceWindowResult']:
        """
        Maintenance policy of the Kafka cluster.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-kafka/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of VPC subnets identifiers which resource is attached.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""")
    def topics(self) -> Optional[Sequence['outputs.GetMdbKafkaClusterTopicResult']]:
        """
        List of kafka topics.
        """
        return pulumi.get(self, "topics")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""")
    def users(self) -> Optional[Sequence['outputs.GetMdbKafkaClusterUserResult']]:
        """
        List of kafka users.
        """
        return pulumi.get(self, "users")


class AwaitableGetMdbKafkaClusterResult(GetMdbKafkaClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbKafkaClusterResult(
            cluster_id=self.cluster_id,
            config=self.config,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            description=self.description,
            environment=self.environment,
            folder_id=self.folder_id,
            health=self.health,
            host_group_ids=self.host_group_ids,
            hosts=self.hosts,
            id=self.id,
            labels=self.labels,
            maintenance_windows=self.maintenance_windows,
            name=self.name,
            network_id=self.network_id,
            security_group_ids=self.security_group_ids,
            status=self.status,
            subnet_ids=self.subnet_ids,
            topics=self.topics,
            users=self.users)


def get_mdb_kafka_cluster(cluster_id: Optional[_builtins.str] = None,
                          config: Optional[Union['GetMdbKafkaClusterConfigArgs', 'GetMdbKafkaClusterConfigArgsDict']] = None,
                          deletion_protection: Optional[_builtins.bool] = None,
                          folder_id: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          subnet_ids: Optional[Sequence[_builtins.str]] = None,
                          topics: Optional[Sequence[Union['GetMdbKafkaClusterTopicArgs', 'GetMdbKafkaClusterTopicArgsDict']]] = None,
                          users: Optional[Sequence[Union['GetMdbKafkaClusterUserArgs', 'GetMdbKafkaClusterUserArgsDict']]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbKafkaClusterResult:
    """
    Get information about a Yandex Managed Kafka cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Kafka Cluster.
    #
    my_cluster = yandex.get_mdb_kafka_cluster(name="test")
    pulumi.export("networkId", my_cluster.network_id)
    ```


    :param _builtins.str cluster_id: The ID of the Kafka cluster.
    :param Union['GetMdbKafkaClusterConfigArgs', 'GetMdbKafkaClusterConfigArgsDict'] config: Configuration of the Kafka cluster.
    :param _builtins.bool deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param Sequence[_builtins.str] subnet_ids: The list of VPC subnets identifiers which resource is attached.
    :param Sequence[Union['GetMdbKafkaClusterTopicArgs', 'GetMdbKafkaClusterTopicArgsDict']] topics: List of kafka topics.
    :param Sequence[Union['GetMdbKafkaClusterUserArgs', 'GetMdbKafkaClusterUserArgsDict']] users: List of kafka users.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['config'] = config
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['subnetIds'] = subnet_ids
    __args__['topics'] = topics
    __args__['users'] = users
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbKafkaCluster:getMdbKafkaCluster', __args__, opts=opts, typ=GetMdbKafkaClusterResult).value

    return AwaitableGetMdbKafkaClusterResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        config=pulumi.get(__ret__, 'config'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        environment=pulumi.get(__ret__, 'environment'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        health=pulumi.get(__ret__, 'health'),
        host_group_ids=pulumi.get(__ret__, 'host_group_ids'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        status=pulumi.get(__ret__, 'status'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        topics=pulumi.get(__ret__, 'topics'),
        users=pulumi.get(__ret__, 'users'))
def get_mdb_kafka_cluster_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 config: Optional[pulumi.Input[Optional[Union['GetMdbKafkaClusterConfigArgs', 'GetMdbKafkaClusterConfigArgsDict']]]] = None,
                                 deletion_protection: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                 folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 subnet_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 topics: Optional[pulumi.Input[Optional[Sequence[Union['GetMdbKafkaClusterTopicArgs', 'GetMdbKafkaClusterTopicArgsDict']]]]] = None,
                                 users: Optional[pulumi.Input[Optional[Sequence[Union['GetMdbKafkaClusterUserArgs', 'GetMdbKafkaClusterUserArgsDict']]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbKafkaClusterResult]:
    """
    Get information about a Yandex Managed Kafka cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB Kafka Cluster.
    #
    my_cluster = yandex.get_mdb_kafka_cluster(name="test")
    pulumi.export("networkId", my_cluster.network_id)
    ```


    :param _builtins.str cluster_id: The ID of the Kafka cluster.
    :param Union['GetMdbKafkaClusterConfigArgs', 'GetMdbKafkaClusterConfigArgsDict'] config: Configuration of the Kafka cluster.
    :param _builtins.bool deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param Sequence[_builtins.str] subnet_ids: The list of VPC subnets identifiers which resource is attached.
    :param Sequence[Union['GetMdbKafkaClusterTopicArgs', 'GetMdbKafkaClusterTopicArgsDict']] topics: List of kafka topics.
    :param Sequence[Union['GetMdbKafkaClusterUserArgs', 'GetMdbKafkaClusterUserArgsDict']] users: List of kafka users.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['config'] = config
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['subnetIds'] = subnet_ids
    __args__['topics'] = topics
    __args__['users'] = users
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbKafkaCluster:getMdbKafkaCluster', __args__, opts=opts, typ=GetMdbKafkaClusterResult)
    return __ret__.apply(lambda __response__: GetMdbKafkaClusterResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        config=pulumi.get(__response__, 'config'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        environment=pulumi.get(__response__, 'environment'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        health=pulumi.get(__response__, 'health'),
        host_group_ids=pulumi.get(__response__, 'host_group_ids'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        status=pulumi.get(__response__, 'status'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        topics=pulumi.get(__response__, 'topics'),
        users=pulumi.get(__response__, 'users')))
