# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMdbSqlserverClusterResult',
    'AwaitableGetMdbSqlserverClusterResult',
    'get_mdb_sqlserver_cluster',
    'get_mdb_sqlserver_cluster_output',
]

@pulumi.output_type
class GetMdbSqlserverClusterResult:
    """
    A collection of values returned by getMdbSqlserverCluster.
    """
    def __init__(__self__, backup_window_starts=None, cluster_id=None, created_at=None, databases=None, deletion_protection=None, description=None, environment=None, folder_id=None, health=None, host_group_ids=None, hosts=None, id=None, labels=None, name=None, network_id=None, resources=None, security_group_ids=None, sqlcollation=None, sqlserver_config=None, status=None, users=None, version=None):
        if backup_window_starts and not isinstance(backup_window_starts, list):
            raise TypeError("Expected argument 'backup_window_starts' to be a list")
        pulumi.set(__self__, "backup_window_starts", backup_window_starts)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if health and not isinstance(health, str):
            raise TypeError("Expected argument 'health' to be a str")
        pulumi.set(__self__, "health", health)
        if host_group_ids and not isinstance(host_group_ids, list):
            raise TypeError("Expected argument 'host_group_ids' to be a list")
        pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sqlcollation and not isinstance(sqlcollation, str):
            raise TypeError("Expected argument 'sqlcollation' to be a str")
        pulumi.set(__self__, "sqlcollation", sqlcollation)
        if sqlserver_config and not isinstance(sqlserver_config, dict):
            raise TypeError("Expected argument 'sqlserver_config' to be a dict")
        pulumi.set(__self__, "sqlserver_config", sqlserver_config)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="backupWindowStarts")
    def backup_window_starts(self) -> Sequence['outputs.GetMdbSqlserverClusterBackupWindowStartResult']:
        return pulumi.get(self, "backup_window_starts")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the SQLServer cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetMdbSqlserverClusterDatabaseResult']:
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> _builtins.str:
        """
        Deployment environment of the SQLServer cluster. (PRODUCTION, PRESTABLE).
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> _builtins.str:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Sequence[_builtins.str]:
        """
        A list of IDs of the host groups hosting VMs of the cluster.
        """
        return pulumi.get(self, "host_group_ids")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.GetMdbSqlserverClusterHostResult']:
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the SQLServer cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetMdbSqlserverClusterResourceResult']:
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def sqlcollation(self) -> _builtins.str:
        """
        SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
        """
        return pulumi.get(self, "sqlcollation")

    @_builtins.property
    @pulumi.getter(name="sqlserverConfig")
    def sqlserver_config(self) -> Mapping[str, _builtins.str]:
        """
        SQLServer cluster config. Detail info in `SQLServer config` section.
        """
        return pulumi.get(self, "sqlserver_config")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetMdbSqlserverClusterUserResult']:
        return pulumi.get(self, "users")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetMdbSqlserverClusterResult(GetMdbSqlserverClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMdbSqlserverClusterResult(
            backup_window_starts=self.backup_window_starts,
            cluster_id=self.cluster_id,
            created_at=self.created_at,
            databases=self.databases,
            deletion_protection=self.deletion_protection,
            description=self.description,
            environment=self.environment,
            folder_id=self.folder_id,
            health=self.health,
            host_group_ids=self.host_group_ids,
            hosts=self.hosts,
            id=self.id,
            labels=self.labels,
            name=self.name,
            network_id=self.network_id,
            resources=self.resources,
            security_group_ids=self.security_group_ids,
            sqlcollation=self.sqlcollation,
            sqlserver_config=self.sqlserver_config,
            status=self.status,
            users=self.users,
            version=self.version)


def get_mdb_sqlserver_cluster(cluster_id: Optional[_builtins.str] = None,
                              deletion_protection: Optional[_builtins.bool] = None,
                              folder_id: Optional[_builtins.str] = None,
                              name: Optional[_builtins.str] = None,
                              sqlcollation: Optional[_builtins.str] = None,
                              sqlserver_config: Optional[Mapping[str, _builtins.str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMdbSqlserverClusterResult:
    """
    Get information about a Yandex Managed SQLServer cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-sqlserver/).

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB SQL Server Cluster.
    #
    foo = yandex.get_mdb_sqlserver_cluster(name="test")
    pulumi.export("networkId", foo.network_id)
    ```


    :param _builtins.str cluster_id: The ID of the SQLServer cluster.
    :param _builtins.bool deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The name of the SQLServer cluster.
    :param _builtins.str sqlcollation: SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
    :param Mapping[str, _builtins.str] sqlserver_config: SQLServer cluster config. Detail info in `SQLServer config` section.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['sqlcollation'] = sqlcollation
    __args__['sqlserverConfig'] = sqlserver_config
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMdbSqlserverCluster:getMdbSqlserverCluster', __args__, opts=opts, typ=GetMdbSqlserverClusterResult).value

    return AwaitableGetMdbSqlserverClusterResult(
        backup_window_starts=pulumi.get(__ret__, 'backup_window_starts'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        databases=pulumi.get(__ret__, 'databases'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        environment=pulumi.get(__ret__, 'environment'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        health=pulumi.get(__ret__, 'health'),
        host_group_ids=pulumi.get(__ret__, 'host_group_ids'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        resources=pulumi.get(__ret__, 'resources'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        sqlcollation=pulumi.get(__ret__, 'sqlcollation'),
        sqlserver_config=pulumi.get(__ret__, 'sqlserver_config'),
        status=pulumi.get(__ret__, 'status'),
        users=pulumi.get(__ret__, 'users'),
        version=pulumi.get(__ret__, 'version'))
def get_mdb_sqlserver_cluster_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     deletion_protection: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                     folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     sqlcollation: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     sqlserver_config: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMdbSqlserverClusterResult]:
    """
    Get information about a Yandex Managed SQLServer cluster. For more information, see [the official documentation](https://yandex.cloud/docs/managed-sqlserver/).

    > Either `cluster_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing MDB SQL Server Cluster.
    #
    foo = yandex.get_mdb_sqlserver_cluster(name="test")
    pulumi.export("networkId", foo.network_id)
    ```


    :param _builtins.str cluster_id: The ID of the SQLServer cluster.
    :param _builtins.bool deletion_protection: The `true` value means that resource is protected from accidental deletion.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The name of the SQLServer cluster.
    :param _builtins.str sqlcollation: SQL Collation cluster will be created with. This attribute cannot be changed when cluster is created!
    :param Mapping[str, _builtins.str] sqlserver_config: SQLServer cluster config. Detail info in `SQLServer config` section.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['sqlcollation'] = sqlcollation
    __args__['sqlserverConfig'] = sqlserver_config
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMdbSqlserverCluster:getMdbSqlserverCluster', __args__, opts=opts, typ=GetMdbSqlserverClusterResult)
    return __ret__.apply(lambda __response__: GetMdbSqlserverClusterResult(
        backup_window_starts=pulumi.get(__response__, 'backup_window_starts'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        databases=pulumi.get(__response__, 'databases'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        environment=pulumi.get(__response__, 'environment'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        health=pulumi.get(__response__, 'health'),
        host_group_ids=pulumi.get(__response__, 'host_group_ids'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        resources=pulumi.get(__response__, 'resources'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        sqlcollation=pulumi.get(__response__, 'sqlcollation'),
        sqlserver_config=pulumi.get(__response__, 'sqlserver_config'),
        status=pulumi.get(__response__, 'status'),
        users=pulumi.get(__response__, 'users'),
        version=pulumi.get(__response__, 'version')))
