# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetMonitoringDashboardResult',
    'AwaitableGetMonitoringDashboardResult',
    'get_monitoring_dashboard',
    'get_monitoring_dashboard_output',
]

@pulumi.output_type
class GetMonitoringDashboardResult:
    """
    A collection of values returned by getMonitoringDashboard.
    """
    def __init__(__self__, dashboard_id=None, description=None, folder_id=None, id=None, labels=None, name=None, parametrizations=None, title=None, widgets=None):
        if dashboard_id and not isinstance(dashboard_id, str):
            raise TypeError("Expected argument 'dashboard_id' to be a str")
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parametrizations and not isinstance(parametrizations, list):
            raise TypeError("Expected argument 'parametrizations' to be a list")
        pulumi.set(__self__, "parametrizations", parametrizations)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if widgets and not isinstance(widgets, list):
            raise TypeError("Expected argument 'widgets' to be a list")
        pulumi.set(__self__, "widgets", widgets)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[_builtins.str]:
        """
        Dashboard ID.
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parametrizations(self) -> Sequence['outputs.GetMonitoringDashboardParametrizationResult']:
        """
        Dashboard parametrization
        """
        return pulumi.get(self, "parametrizations")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        Dashboard title.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def widgets(self) -> Sequence['outputs.GetMonitoringDashboardWidgetResult']:
        """
        Widgets
        """
        return pulumi.get(self, "widgets")


class AwaitableGetMonitoringDashboardResult(GetMonitoringDashboardResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoringDashboardResult(
            dashboard_id=self.dashboard_id,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            parametrizations=self.parametrizations,
            title=self.title,
            widgets=self.widgets)


def get_monitoring_dashboard(dashboard_id: Optional[_builtins.str] = None,
                             description: Optional[_builtins.str] = None,
                             folder_id: Optional[_builtins.str] = None,
                             name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoringDashboardResult:
    """
    Get information about a Yandex Monitoring dashboard.

    > One of `dashboard_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Monitoring Dashboard.
    #
    my_dashboard = yandex.get_monitoring_dashboard(dashboard_id="some_instance_dashboard_id")
    ```


    :param _builtins.str dashboard_id: Dashboard ID.
    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['dashboardId'] = dashboard_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getMonitoringDashboard:getMonitoringDashboard', __args__, opts=opts, typ=GetMonitoringDashboardResult).value

    return AwaitableGetMonitoringDashboardResult(
        dashboard_id=pulumi.get(__ret__, 'dashboard_id'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        parametrizations=pulumi.get(__ret__, 'parametrizations'),
        title=pulumi.get(__ret__, 'title'),
        widgets=pulumi.get(__ret__, 'widgets'))
def get_monitoring_dashboard_output(dashboard_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitoringDashboardResult]:
    """
    Get information about a Yandex Monitoring dashboard.

    > One of `dashboard_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing Monitoring Dashboard.
    #
    my_dashboard = yandex.get_monitoring_dashboard(dashboard_id="some_instance_dashboard_id")
    ```


    :param _builtins.str dashboard_id: Dashboard ID.
    :param _builtins.str description: The resource description.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['dashboardId'] = dashboard_id
    __args__['description'] = description
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getMonitoringDashboard:getMonitoringDashboard', __args__, opts=opts, typ=GetMonitoringDashboardResult)
    return __ret__.apply(lambda __response__: GetMonitoringDashboardResult(
        dashboard_id=pulumi.get(__response__, 'dashboard_id'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        parametrizations=pulumi.get(__response__, 'parametrizations'),
        title=pulumi.get(__response__, 'title'),
        widgets=pulumi.get(__response__, 'widgets')))
