# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSwsAdvancedRateLimiterProfileResult',
    'AwaitableGetSwsAdvancedRateLimiterProfileResult',
    'get_sws_advanced_rate_limiter_profile',
    'get_sws_advanced_rate_limiter_profile_output',
]

@pulumi.output_type
class GetSwsAdvancedRateLimiterProfileResult:
    """
    A collection of values returned by getSwsAdvancedRateLimiterProfile.
    """
    def __init__(__self__, advanced_rate_limiter_profile_id=None, advanced_rate_limiter_rules=None, cloud_id=None, created_at=None, description=None, folder_id=None, id=None, labels=None, name=None):
        if advanced_rate_limiter_profile_id and not isinstance(advanced_rate_limiter_profile_id, str):
            raise TypeError("Expected argument 'advanced_rate_limiter_profile_id' to be a str")
        pulumi.set(__self__, "advanced_rate_limiter_profile_id", advanced_rate_limiter_profile_id)
        if advanced_rate_limiter_rules and not isinstance(advanced_rate_limiter_rules, list):
            raise TypeError("Expected argument 'advanced_rate_limiter_rules' to be a list")
        pulumi.set(__self__, "advanced_rate_limiter_rules", advanced_rate_limiter_rules)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> Optional[_builtins.str]:
        """
        ID of the ARL profile.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterRules")
    def advanced_rate_limiter_rules(self) -> Sequence['outputs.GetSwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleResult']:
        return pulumi.get(self, "advanced_rate_limiter_rules")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> _builtins.str:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")


class AwaitableGetSwsAdvancedRateLimiterProfileResult(GetSwsAdvancedRateLimiterProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwsAdvancedRateLimiterProfileResult(
            advanced_rate_limiter_profile_id=self.advanced_rate_limiter_profile_id,
            advanced_rate_limiter_rules=self.advanced_rate_limiter_rules,
            cloud_id=self.cloud_id,
            created_at=self.created_at,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name)


def get_sws_advanced_rate_limiter_profile(advanced_rate_limiter_profile_id: Optional[_builtins.str] = None,
                                          cloud_id: Optional[_builtins.str] = None,
                                          folder_id: Optional[_builtins.str] = None,
                                          name: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwsAdvancedRateLimiterProfileResult:
    """
    Get information about ARL Profile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#arl).This data source is used to define [ARL Profile](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles) that can be used by other resources.

    > One of `advanced_rate_limiter_profile_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing SWS Advanced Rate Limiter Profile.
    #
    by_id = yandex.get_sws_advanced_rate_limiter_profile(advanced_rate_limiter_profile_id=my_profile["id"])
    by_name = yandex.get_sws_advanced_rate_limiter_profile(name=my_profile["name"])
    ```


    :param _builtins.str advanced_rate_limiter_profile_id: ID of the ARL profile.
    :param _builtins.str cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['advancedRateLimiterProfileId'] = advanced_rate_limiter_profile_id
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getSwsAdvancedRateLimiterProfile:getSwsAdvancedRateLimiterProfile', __args__, opts=opts, typ=GetSwsAdvancedRateLimiterProfileResult).value

    return AwaitableGetSwsAdvancedRateLimiterProfileResult(
        advanced_rate_limiter_profile_id=pulumi.get(__ret__, 'advanced_rate_limiter_profile_id'),
        advanced_rate_limiter_rules=pulumi.get(__ret__, 'advanced_rate_limiter_rules'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'))
def get_sws_advanced_rate_limiter_profile_output(advanced_rate_limiter_profile_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 cloud_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSwsAdvancedRateLimiterProfileResult]:
    """
    Get information about ARL Profile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#arl).This data source is used to define [ARL Profile](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles) that can be used by other resources.

    > One of `advanced_rate_limiter_profile_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing SWS Advanced Rate Limiter Profile.
    #
    by_id = yandex.get_sws_advanced_rate_limiter_profile(advanced_rate_limiter_profile_id=my_profile["id"])
    by_name = yandex.get_sws_advanced_rate_limiter_profile(name=my_profile["name"])
    ```


    :param _builtins.str advanced_rate_limiter_profile_id: ID of the ARL profile.
    :param _builtins.str cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    """
    __args__ = dict()
    __args__['advancedRateLimiterProfileId'] = advanced_rate_limiter_profile_id
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getSwsAdvancedRateLimiterProfile:getSwsAdvancedRateLimiterProfile', __args__, opts=opts, typ=GetSwsAdvancedRateLimiterProfileResult)
    return __ret__.apply(lambda __response__: GetSwsAdvancedRateLimiterProfileResult(
        advanced_rate_limiter_profile_id=pulumi.get(__response__, 'advanced_rate_limiter_profile_id'),
        advanced_rate_limiter_rules=pulumi.get(__response__, 'advanced_rate_limiter_rules'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name')))
