# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSwsWafProfileResult',
    'AwaitableGetSwsWafProfileResult',
    'get_sws_waf_profile',
    'get_sws_waf_profile_output',
]

@pulumi.output_type
class GetSwsWafProfileResult:
    """
    A collection of values returned by getSwsWafProfile.
    """
    def __init__(__self__, analyze_request_bodies=None, cloud_id=None, core_rule_sets=None, created_at=None, description=None, exclusion_rules=None, folder_id=None, id=None, labels=None, match_all_rule_sets=None, name=None, rule_sets=None, rules=None, waf_profile_id=None):
        if analyze_request_bodies and not isinstance(analyze_request_bodies, list):
            raise TypeError("Expected argument 'analyze_request_bodies' to be a list")
        pulumi.set(__self__, "analyze_request_bodies", analyze_request_bodies)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if core_rule_sets and not isinstance(core_rule_sets, list):
            raise TypeError("Expected argument 'core_rule_sets' to be a list")
        pulumi.set(__self__, "core_rule_sets", core_rule_sets)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if exclusion_rules and not isinstance(exclusion_rules, list):
            raise TypeError("Expected argument 'exclusion_rules' to be a list")
        pulumi.set(__self__, "exclusion_rules", exclusion_rules)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if match_all_rule_sets and not isinstance(match_all_rule_sets, bool):
            raise TypeError("Expected argument 'match_all_rule_sets' to be a bool")
        pulumi.set(__self__, "match_all_rule_sets", match_all_rule_sets)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rule_sets and not isinstance(rule_sets, list):
            raise TypeError("Expected argument 'rule_sets' to be a list")
        pulumi.set(__self__, "rule_sets", rule_sets)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if waf_profile_id and not isinstance(waf_profile_id, str):
            raise TypeError("Expected argument 'waf_profile_id' to be a str")
        pulumi.set(__self__, "waf_profile_id", waf_profile_id)

    @_builtins.property
    @pulumi.getter(name="analyzeRequestBodies")
    def analyze_request_bodies(self) -> Sequence['outputs.GetSwsWafProfileAnalyzeRequestBodyResult']:
        """
        Analyze request body.
        """
        return pulumi.get(self, "analyze_request_bodies")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> _builtins.str:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="coreRuleSets")
    def core_rule_sets(self) -> Sequence['outputs.GetSwsWafProfileCoreRuleSetResult']:
        """
        Core rule set.
        """
        return pulumi.get(self, "core_rule_sets")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> Sequence['outputs.GetSwsWafProfileExclusionRuleResult']:
        return pulumi.get(self, "exclusion_rules")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="matchAllRuleSets")
    def match_all_rule_sets(self) -> _builtins.bool:
        """
        Match all rule sets.
        """
        return pulumi.get(self, "match_all_rule_sets")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of waf profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ruleSets")
    def rule_sets(self) -> Sequence['outputs.GetSwsWafProfileRuleSetResult']:
        return pulumi.get(self, "rule_sets")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetSwsWafProfileRuleResult']:
        """
        List of rules.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="wafProfileId")
    def waf_profile_id(self) -> Optional[_builtins.str]:
        """
        ID of the WAF profile.
        """
        return pulumi.get(self, "waf_profile_id")


class AwaitableGetSwsWafProfileResult(GetSwsWafProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwsWafProfileResult(
            analyze_request_bodies=self.analyze_request_bodies,
            cloud_id=self.cloud_id,
            core_rule_sets=self.core_rule_sets,
            created_at=self.created_at,
            description=self.description,
            exclusion_rules=self.exclusion_rules,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            match_all_rule_sets=self.match_all_rule_sets,
            name=self.name,
            rule_sets=self.rule_sets,
            rules=self.rules,
            waf_profile_id=self.waf_profile_id)


def get_sws_waf_profile(cloud_id: Optional[_builtins.str] = None,
                        folder_id: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        waf_profile_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwsWafProfileResult:
    """
    Get information about WAF Profile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).
    This data source is used to define WAF Profile that can be used by other resources.

    > One of `waf_profile_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing SWS WAF Profile.
    #
    by_id = yandex.get_sws_waf_profile(waf_profile_id=my_profile["id"])
    by_name = yandex.get_sws_waf_profile(name=my_profile["name"])
    ```


    :param _builtins.str cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: Name of waf profile.
    :param _builtins.str waf_profile_id: ID of the WAF profile.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['wafProfileId'] = waf_profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getSwsWafProfile:getSwsWafProfile', __args__, opts=opts, typ=GetSwsWafProfileResult).value

    return AwaitableGetSwsWafProfileResult(
        analyze_request_bodies=pulumi.get(__ret__, 'analyze_request_bodies'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        core_rule_sets=pulumi.get(__ret__, 'core_rule_sets'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        exclusion_rules=pulumi.get(__ret__, 'exclusion_rules'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        match_all_rule_sets=pulumi.get(__ret__, 'match_all_rule_sets'),
        name=pulumi.get(__ret__, 'name'),
        rule_sets=pulumi.get(__ret__, 'rule_sets'),
        rules=pulumi.get(__ret__, 'rules'),
        waf_profile_id=pulumi.get(__ret__, 'waf_profile_id'))
def get_sws_waf_profile_output(cloud_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               waf_profile_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSwsWafProfileResult]:
    """
    Get information about WAF Profile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).
    This data source is used to define WAF Profile that can be used by other resources.

    > One of `waf_profile_id` or `name` should be specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_yandex as yandex

    #
    # Get information about existing SWS WAF Profile.
    #
    by_id = yandex.get_sws_waf_profile(waf_profile_id=my_profile["id"])
    by_name = yandex.get_sws_waf_profile(name=my_profile["name"])
    ```


    :param _builtins.str cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: Name of waf profile.
    :param _builtins.str waf_profile_id: ID of the WAF profile.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['wafProfileId'] = waf_profile_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getSwsWafProfile:getSwsWafProfile', __args__, opts=opts, typ=GetSwsWafProfileResult)
    return __ret__.apply(lambda __response__: GetSwsWafProfileResult(
        analyze_request_bodies=pulumi.get(__response__, 'analyze_request_bodies'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        core_rule_sets=pulumi.get(__response__, 'core_rule_sets'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        exclusion_rules=pulumi.get(__response__, 'exclusion_rules'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        match_all_rule_sets=pulumi.get(__response__, 'match_all_rule_sets'),
        name=pulumi.get(__response__, 'name'),
        rule_sets=pulumi.get(__response__, 'rule_sets'),
        rules=pulumi.get(__response__, 'rules'),
        waf_profile_id=pulumi.get(__response__, 'waf_profile_id')))
