# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVpcSecurityGroupResult',
    'AwaitableGetVpcSecurityGroupResult',
    'get_vpc_security_group',
    'get_vpc_security_group_output',
]

@pulumi.output_type
class GetVpcSecurityGroupResult:
    """
    A collection of values returned by getVpcSecurityGroup.
    """
    def __init__(__self__, created_at=None, description=None, egresses=None, folder_id=None, id=None, ingresses=None, labels=None, name=None, network_id=None, security_group_id=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if egresses and not isinstance(egresses, list):
            raise TypeError("Expected argument 'egresses' to be a list")
        pulumi.set(__self__, "egresses", egresses)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingresses and not isinstance(ingresses, list):
            raise TypeError("Expected argument 'ingresses' to be a list")
        pulumi.set(__self__, "ingresses", ingresses)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def egresses(self) -> Sequence['outputs.GetVpcSecurityGroupEgressResult']:
        """
        A list of egress rules.
        """
        return pulumi.get(self, "egresses")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> _builtins.str:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ingresses(self) -> Sequence['outputs.GetVpcSecurityGroupIngressResult']:
        """
        A list of ingress rules.
        """
        return pulumi.get(self, "ingresses")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        ID of the network this security group belongs to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        ID of Security Group that owns the rule.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of this security group.
        """
        return pulumi.get(self, "status")


class AwaitableGetVpcSecurityGroupResult(GetVpcSecurityGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcSecurityGroupResult(
            created_at=self.created_at,
            description=self.description,
            egresses=self.egresses,
            folder_id=self.folder_id,
            id=self.id,
            ingresses=self.ingresses,
            labels=self.labels,
            name=self.name,
            network_id=self.network_id,
            security_group_id=self.security_group_id,
            status=self.status)


def get_vpc_security_group(folder_id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           security_group_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcSecurityGroupResult:
    """
    Get information about a Yandex VPC Security Group Rule. For more information, see [the official documentation](https://yandex.cloud/docs/vpc/concepts/security-groups).

    This data source used to define Security Group Rule that can be used by other resources.


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str security_group_id: ID of Security Group that owns the rule.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['securityGroupId'] = security_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getVpcSecurityGroup:getVpcSecurityGroup', __args__, opts=opts, typ=GetVpcSecurityGroupResult).value

    return AwaitableGetVpcSecurityGroupResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        egresses=pulumi.get(__ret__, 'egresses'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        ingresses=pulumi.get(__ret__, 'ingresses'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        status=pulumi.get(__ret__, 'status'))
def get_vpc_security_group_output(folder_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  security_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcSecurityGroupResult]:
    """
    Get information about a Yandex VPC Security Group Rule. For more information, see [the official documentation](https://yandex.cloud/docs/vpc/concepts/security-groups).

    This data source used to define Security Group Rule that can be used by other resources.


    :param _builtins.str folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
    :param _builtins.str name: The resource name.
    :param _builtins.str security_group_id: ID of Security Group that owns the rule.
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['securityGroupId'] = security_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getVpcSecurityGroup:getVpcSecurityGroup', __args__, opts=opts, typ=GetVpcSecurityGroupResult)
    return __ret__.apply(lambda __response__: GetVpcSecurityGroupResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        egresses=pulumi.get(__response__, 'egresses'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        ingresses=pulumi.get(__response__, 'ingresses'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        status=pulumi.get(__response__, 'status')))
