# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IamWorkloadIdentityFederatedCredentialArgs', 'IamWorkloadIdentityFederatedCredential']

@pulumi.input_type
class IamWorkloadIdentityFederatedCredentialArgs:
    def __init__(__self__, *,
                 external_subject_id: pulumi.Input[_builtins.str],
                 federation_id: pulumi.Input[_builtins.str],
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IamWorkloadIdentityFederatedCredential resource.
        :param pulumi.Input[_builtins.str] external_subject_id: Id of the workload identity federation which is used for authentication.
        :param pulumi.Input[_builtins.str] federation_id: Id of the federated credential.
        :param pulumi.Input[_builtins.str] service_account_id: Id of the service account that the federated credential belongs to.
        """
        pulumi.set(__self__, "external_subject_id", external_subject_id)
        pulumi.set(__self__, "federation_id", federation_id)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="externalSubjectId")
    def external_subject_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the workload identity federation which is used for authentication.
        """
        return pulumi.get(self, "external_subject_id")

    @external_subject_id.setter
    def external_subject_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "external_subject_id", value)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the federated credential.
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "federation_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the service account that the federated credential belongs to.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)


@pulumi.input_type
class _IamWorkloadIdentityFederatedCredentialState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 external_subject_id: Optional[pulumi.Input[_builtins.str]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IamWorkloadIdentityFederatedCredential resources.
        :param pulumi.Input[_builtins.str] created_at: Id of the external subject.
        :param pulumi.Input[_builtins.str] external_subject_id: Id of the workload identity federation which is used for authentication.
        :param pulumi.Input[_builtins.str] federation_id: Id of the federated credential.
        :param pulumi.Input[_builtins.str] service_account_id: Id of the service account that the federated credential belongs to.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if external_subject_id is not None:
            pulumi.set(__self__, "external_subject_id", external_subject_id)
        if federation_id is not None:
            pulumi.set(__self__, "federation_id", federation_id)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the external subject.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="externalSubjectId")
    def external_subject_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the workload identity federation which is used for authentication.
        """
        return pulumi.get(self, "external_subject_id")

    @external_subject_id.setter
    def external_subject_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_subject_id", value)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the federated credential.
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federation_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the service account that the federated credential belongs to.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)


@pulumi.type_token("yandex:index/iamWorkloadIdentityFederatedCredential:IamWorkloadIdentityFederatedCredential")
class IamWorkloadIdentityFederatedCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_subject_id: Optional[pulumi.Input[_builtins.str]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud IAM federated credentials](https://yandex.cloud/docs/iam/concepts/workload-identity#federated-credentials).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new IAM Workload Identity Federated Credential.
        #
        fed_cred = yandex.IamWorkloadIdentityFederatedCredential("fed_cred",
            service_account_id="some_sa_id",
            federation_id="some_wli_federation_id",
            external_subject_id="some_external_subject_id")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityFederatedCredential:IamWorkloadIdentityFederatedCredential <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityFederatedCredential:IamWorkloadIdentityFederatedCredential fed_cred ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_subject_id: Id of the workload identity federation which is used for authentication.
        :param pulumi.Input[_builtins.str] federation_id: Id of the federated credential.
        :param pulumi.Input[_builtins.str] service_account_id: Id of the service account that the federated credential belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamWorkloadIdentityFederatedCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud IAM federated credentials](https://yandex.cloud/docs/iam/concepts/workload-identity#federated-credentials).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new IAM Workload Identity Federated Credential.
        #
        fed_cred = yandex.IamWorkloadIdentityFederatedCredential("fed_cred",
            service_account_id="some_sa_id",
            federation_id="some_wli_federation_id",
            external_subject_id="some_external_subject_id")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityFederatedCredential:IamWorkloadIdentityFederatedCredential <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityFederatedCredential:IamWorkloadIdentityFederatedCredential fed_cred ...
        ```

        :param str resource_name: The name of the resource.
        :param IamWorkloadIdentityFederatedCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamWorkloadIdentityFederatedCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_subject_id: Optional[pulumi.Input[_builtins.str]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamWorkloadIdentityFederatedCredentialArgs.__new__(IamWorkloadIdentityFederatedCredentialArgs)

            if external_subject_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_subject_id'")
            __props__.__dict__["external_subject_id"] = external_subject_id
            if federation_id is None and not opts.urn:
                raise TypeError("Missing required property 'federation_id'")
            __props__.__dict__["federation_id"] = federation_id
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["created_at"] = None
        super(IamWorkloadIdentityFederatedCredential, __self__).__init__(
            'yandex:index/iamWorkloadIdentityFederatedCredential:IamWorkloadIdentityFederatedCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            external_subject_id: Optional[pulumi.Input[_builtins.str]] = None,
            federation_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'IamWorkloadIdentityFederatedCredential':
        """
        Get an existing IamWorkloadIdentityFederatedCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Id of the external subject.
        :param pulumi.Input[_builtins.str] external_subject_id: Id of the workload identity federation which is used for authentication.
        :param pulumi.Input[_builtins.str] federation_id: Id of the federated credential.
        :param pulumi.Input[_builtins.str] service_account_id: Id of the service account that the federated credential belongs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamWorkloadIdentityFederatedCredentialState.__new__(_IamWorkloadIdentityFederatedCredentialState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["external_subject_id"] = external_subject_id
        __props__.__dict__["federation_id"] = federation_id
        __props__.__dict__["service_account_id"] = service_account_id
        return IamWorkloadIdentityFederatedCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the external subject.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="externalSubjectId")
    def external_subject_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the workload identity federation which is used for authentication.
        """
        return pulumi.get(self, "external_subject_id")

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the federated credential.
        """
        return pulumi.get(self, "federation_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the service account that the federated credential belongs to.
        """
        return pulumi.get(self, "service_account_id")

