# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IamWorkloadIdentityOidcFederationArgs', 'IamWorkloadIdentityOidcFederation']

@pulumi.input_type
class IamWorkloadIdentityOidcFederationArgs:
    def __init__(__self__, *,
                 issuer: pulumi.Input[_builtins.str],
                 jwks_url: pulumi.Input[_builtins.str],
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IamWorkloadIdentityOidcFederation resource.
        :param pulumi.Input[_builtins.str] issuer: Issuer identifier of the external IdP server to be used for authentication.
        :param pulumi.Input[_builtins.str] jwks_url: URL reference to trusted keys in format of JSON Web Key Set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audiences: List of trusted values for aud claim.
        :param pulumi.Input[_builtins.str] description: Description of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.bool] disabled: Disabled flag.
        :param pulumi.Input[_builtins.str] federation_id: Id of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.str] folder_id: Id of the folder that the OIDC workload identity federation belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels as key-value pairs.
        :param pulumi.Input[_builtins.str] name: Name of the OIDC workload identity federation. The name is unique within the folder.
        """
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "jwks_url", jwks_url)
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if federation_id is not None:
            pulumi.set(__self__, "federation_id", federation_id)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[_builtins.str]:
        """
        Issuer identifier of the external IdP server to be used for authentication.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> pulumi.Input[_builtins.str]:
        """
        URL reference to trusted keys in format of JSON Web Key Set.
        """
        return pulumi.get(self, "jwks_url")

    @jwks_url.setter
    def jwks_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "jwks_url", value)

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of trusted values for aud claim.
        """
        return pulumi.get(self, "audiences")

    @audiences.setter
    def audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audiences", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the OIDC workload identity federation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disabled flag.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the OIDC workload identity federation.
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federation_id", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the folder that the OIDC workload identity federation belongs to.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels as key-value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the OIDC workload identity federation. The name is unique within the folder.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IamWorkloadIdentityOidcFederationState:
    def __init__(__self__, *,
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 jwks_url: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IamWorkloadIdentityOidcFederation resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audiences: List of trusted values for aud claim.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp.
        :param pulumi.Input[_builtins.str] description: Description of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.bool] disabled: Disabled flag.
        :param pulumi.Input[_builtins.bool] enabled: Enabled flag.
        :param pulumi.Input[_builtins.str] federation_id: Id of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.str] folder_id: Id of the folder that the OIDC workload identity federation belongs to.
        :param pulumi.Input[_builtins.str] issuer: Issuer identifier of the external IdP server to be used for authentication.
        :param pulumi.Input[_builtins.str] jwks_url: URL reference to trusted keys in format of JSON Web Key Set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels as key-value pairs.
        :param pulumi.Input[_builtins.str] name: Name of the OIDC workload identity federation. The name is unique within the folder.
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if federation_id is not None:
            pulumi.set(__self__, "federation_id", federation_id)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_url is not None:
            pulumi.set(__self__, "jwks_url", jwks_url)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of trusted values for aud claim.
        """
        return pulumi.get(self, "audiences")

    @audiences.setter
    def audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audiences", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the OIDC workload identity federation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disabled flag.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabled flag.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the OIDC workload identity federation.
        """
        return pulumi.get(self, "federation_id")

    @federation_id.setter
    def federation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federation_id", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the folder that the OIDC workload identity federation belongs to.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Issuer identifier of the external IdP server to be used for authentication.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL reference to trusted keys in format of JSON Web Key Set.
        """
        return pulumi.get(self, "jwks_url")

    @jwks_url.setter
    def jwks_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jwks_url", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels as key-value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the OIDC workload identity federation. The name is unique within the folder.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("yandex:index/iamWorkloadIdentityOidcFederation:IamWorkloadIdentityOidcFederation")
class IamWorkloadIdentityOidcFederation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 jwks_url: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud IAM workload identity OIDC federations](https://yandex.cloud/docs/iam/concepts/workload-identity).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new IAM Workload Identity OIDC Federation.
        #
        wlif = yandex.IamWorkloadIdentityOidcFederation("wlif",
            name="some_wlif_name",
            folder_id="some_folder_id",
            description="some description",
            disabled=False,
            audiences=[
                "aud1",
                "aud2",
            ],
            issuer="https://example-issuer.com",
            jwks_url="https://example-issuer.com/jwks",
            labels={
                "key1": "value1",
                "key2": "value2",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityOidcFederation:IamWorkloadIdentityOidcFederation <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityOidcFederation:IamWorkloadIdentityOidcFederation wlif ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audiences: List of trusted values for aud claim.
        :param pulumi.Input[_builtins.str] description: Description of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.bool] disabled: Disabled flag.
        :param pulumi.Input[_builtins.str] federation_id: Id of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.str] folder_id: Id of the folder that the OIDC workload identity federation belongs to.
        :param pulumi.Input[_builtins.str] issuer: Issuer identifier of the external IdP server to be used for authentication.
        :param pulumi.Input[_builtins.str] jwks_url: URL reference to trusted keys in format of JSON Web Key Set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels as key-value pairs.
        :param pulumi.Input[_builtins.str] name: Name of the OIDC workload identity federation. The name is unique within the folder.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamWorkloadIdentityOidcFederationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud IAM workload identity OIDC federations](https://yandex.cloud/docs/iam/concepts/workload-identity).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new IAM Workload Identity OIDC Federation.
        #
        wlif = yandex.IamWorkloadIdentityOidcFederation("wlif",
            name="some_wlif_name",
            folder_id="some_folder_id",
            description="some description",
            disabled=False,
            audiences=[
                "aud1",
                "aud2",
            ],
            issuer="https://example-issuer.com",
            jwks_url="https://example-issuer.com/jwks",
            labels={
                "key1": "value1",
                "key2": "value2",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityOidcFederation:IamWorkloadIdentityOidcFederation <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/iamWorkloadIdentityOidcFederation:IamWorkloadIdentityOidcFederation wlif ...
        ```

        :param str resource_name: The name of the resource.
        :param IamWorkloadIdentityOidcFederationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamWorkloadIdentityOidcFederationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 federation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 jwks_url: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamWorkloadIdentityOidcFederationArgs.__new__(IamWorkloadIdentityOidcFederationArgs)

            __props__.__dict__["audiences"] = audiences
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["federation_id"] = federation_id
            __props__.__dict__["folder_id"] = folder_id
            if issuer is None and not opts.urn:
                raise TypeError("Missing required property 'issuer'")
            __props__.__dict__["issuer"] = issuer
            if jwks_url is None and not opts.urn:
                raise TypeError("Missing required property 'jwks_url'")
            __props__.__dict__["jwks_url"] = jwks_url
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enabled"] = None
        super(IamWorkloadIdentityOidcFederation, __self__).__init__(
            'yandex:index/iamWorkloadIdentityOidcFederation:IamWorkloadIdentityOidcFederation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            federation_id: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            jwks_url: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'IamWorkloadIdentityOidcFederation':
        """
        Get an existing IamWorkloadIdentityOidcFederation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audiences: List of trusted values for aud claim.
        :param pulumi.Input[_builtins.str] created_at: Creation timestamp.
        :param pulumi.Input[_builtins.str] description: Description of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.bool] disabled: Disabled flag.
        :param pulumi.Input[_builtins.bool] enabled: Enabled flag.
        :param pulumi.Input[_builtins.str] federation_id: Id of the OIDC workload identity federation.
        :param pulumi.Input[_builtins.str] folder_id: Id of the folder that the OIDC workload identity federation belongs to.
        :param pulumi.Input[_builtins.str] issuer: Issuer identifier of the external IdP server to be used for authentication.
        :param pulumi.Input[_builtins.str] jwks_url: URL reference to trusted keys in format of JSON Web Key Set.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels as key-value pairs.
        :param pulumi.Input[_builtins.str] name: Name of the OIDC workload identity federation. The name is unique within the folder.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamWorkloadIdentityOidcFederationState.__new__(_IamWorkloadIdentityOidcFederationState)

        __props__.__dict__["audiences"] = audiences
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["federation_id"] = federation_id
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["jwks_url"] = jwks_url
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        return IamWorkloadIdentityOidcFederation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def audiences(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of trusted values for aud claim.
        """
        return pulumi.get(self, "audiences")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the OIDC workload identity federation.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disabled flag.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enabled flag.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="federationId")
    def federation_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the OIDC workload identity federation.
        """
        return pulumi.get(self, "federation_id")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the folder that the OIDC workload identity federation belongs to.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[_builtins.str]:
        """
        Issuer identifier of the external IdP server to be used for authentication.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL reference to trusted keys in format of JSON Web Key Set.
        """
        return pulumi.get(self, "jwks_url")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Resource labels as key-value pairs.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the OIDC workload identity federation. The name is unique within the folder.
        """
        return pulumi.get(self, "name")

