# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesClusterArgs', 'KubernetesCluster']

@pulumi.input_type
class KubernetesClusterArgs:
    def __init__(__self__, *,
                 master: pulumi.Input['KubernetesClusterMasterArgs'],
                 network_id: pulumi.Input[_builtins.str],
                 node_service_account_id: pulumi.Input[_builtins.str],
                 service_account_id: pulumi.Input[_builtins.str],
                 cluster_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_provider: Optional[pulumi.Input['KubernetesClusterKmsProviderArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_implementation: Optional[pulumi.Input['KubernetesClusterNetworkImplementationArgs']] = None,
                 network_policy_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 node_ipv4_cidr_mask_size: Optional[pulumi.Input[_builtins.int]] = None,
                 release_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_federation: Optional[pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs']] = None):
        """
        The set of arguments for constructing a KubernetesCluster resource.
        :param pulumi.Input['KubernetesClusterMasterArgs'] master: Kubernetes master configuration options.
        :param pulumi.Input[_builtins.str] network_id: The ID of the cluster network.
        :param pulumi.Input[_builtins.str] node_service_account_id: Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        :param pulumi.Input[_builtins.str] cluster_ipv4_range: CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        :param pulumi.Input[_builtins.str] cluster_ipv6_range: Identical to `cluster_ipv4_range` but for IPv6 protocol.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['KubernetesClusterKmsProviderArgs'] kms_provider: Cluster KMS provider parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['KubernetesClusterNetworkImplementationArgs'] network_implementation: Network Implementation options.
        :param pulumi.Input[_builtins.str] network_policy_provider: Network policy provider for the cluster. Possible values: `CALICO`.
        :param pulumi.Input[_builtins.int] node_ipv4_cidr_mask_size: Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        :param pulumi.Input[_builtins.str] release_channel: Cluster release channel.
        :param pulumi.Input[_builtins.str] service_ipv4_range: CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        :param pulumi.Input[_builtins.str] service_ipv6_range: Identical to service*ipv4*range but for IPv6 protocol.
        :param pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs'] workload_identity_federation: Workload Identity Federation configuration.
        """
        pulumi.set(__self__, "master", master)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "node_service_account_id", node_service_account_id)
        pulumi.set(__self__, "service_account_id", service_account_id)
        if cluster_ipv4_range is not None:
            pulumi.set(__self__, "cluster_ipv4_range", cluster_ipv4_range)
        if cluster_ipv6_range is not None:
            pulumi.set(__self__, "cluster_ipv6_range", cluster_ipv6_range)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if kms_provider is not None:
            pulumi.set(__self__, "kms_provider", kms_provider)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_implementation is not None:
            pulumi.set(__self__, "network_implementation", network_implementation)
        if network_policy_provider is not None:
            pulumi.set(__self__, "network_policy_provider", network_policy_provider)
        if node_ipv4_cidr_mask_size is not None:
            pulumi.set(__self__, "node_ipv4_cidr_mask_size", node_ipv4_cidr_mask_size)
        if release_channel is not None:
            pulumi.set(__self__, "release_channel", release_channel)
        if service_ipv4_range is not None:
            pulumi.set(__self__, "service_ipv4_range", service_ipv4_range)
        if service_ipv6_range is not None:
            pulumi.set(__self__, "service_ipv6_range", service_ipv6_range)
        if workload_identity_federation is not None:
            pulumi.set(__self__, "workload_identity_federation", workload_identity_federation)

    @_builtins.property
    @pulumi.getter
    def master(self) -> pulumi.Input['KubernetesClusterMasterArgs']:
        """
        Kubernetes master configuration options.
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: pulumi.Input['KubernetesClusterMasterArgs']):
        pulumi.set(self, "master", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the cluster network.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeServiceAccountId")
    def node_service_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        """
        return pulumi.get(self, "node_service_account_id")

    @node_service_account_id.setter
    def node_service_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterIpv4Range")
    def cluster_ipv4_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        """
        return pulumi.get(self, "cluster_ipv4_range")

    @cluster_ipv4_range.setter
    def cluster_ipv4_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ipv4_range", value)

    @_builtins.property
    @pulumi.getter(name="clusterIpv6Range")
    def cluster_ipv6_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identical to `cluster_ipv4_range` but for IPv6 protocol.
        """
        return pulumi.get(self, "cluster_ipv6_range")

    @cluster_ipv6_range.setter
    def cluster_ipv6_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ipv6_range", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsProvider")
    def kms_provider(self) -> Optional[pulumi.Input['KubernetesClusterKmsProviderArgs']]:
        """
        Cluster KMS provider parameters.
        """
        return pulumi.get(self, "kms_provider")

    @kms_provider.setter
    def kms_provider(self, value: Optional[pulumi.Input['KubernetesClusterKmsProviderArgs']]):
        pulumi.set(self, "kms_provider", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkImplementation")
    def network_implementation(self) -> Optional[pulumi.Input['KubernetesClusterNetworkImplementationArgs']]:
        """
        Network Implementation options.
        """
        return pulumi.get(self, "network_implementation")

    @network_implementation.setter
    def network_implementation(self, value: Optional[pulumi.Input['KubernetesClusterNetworkImplementationArgs']]):
        pulumi.set(self, "network_implementation", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicyProvider")
    def network_policy_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network policy provider for the cluster. Possible values: `CALICO`.
        """
        return pulumi.get(self, "network_policy_provider")

    @network_policy_provider.setter
    def network_policy_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy_provider", value)

    @_builtins.property
    @pulumi.getter(name="nodeIpv4CidrMaskSize")
    def node_ipv4_cidr_mask_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        """
        return pulumi.get(self, "node_ipv4_cidr_mask_size")

    @node_ipv4_cidr_mask_size.setter
    def node_ipv4_cidr_mask_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_ipv4_cidr_mask_size", value)

    @_builtins.property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster release channel.
        """
        return pulumi.get(self, "release_channel")

    @release_channel.setter
    def release_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_channel", value)

    @_builtins.property
    @pulumi.getter(name="serviceIpv4Range")
    def service_ipv4_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        """
        return pulumi.get(self, "service_ipv4_range")

    @service_ipv4_range.setter
    def service_ipv4_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_ipv4_range", value)

    @_builtins.property
    @pulumi.getter(name="serviceIpv6Range")
    def service_ipv6_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identical to service*ipv4*range but for IPv6 protocol.
        """
        return pulumi.get(self, "service_ipv6_range")

    @service_ipv6_range.setter
    def service_ipv6_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_ipv6_range", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederation")
    def workload_identity_federation(self) -> Optional[pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs']]:
        """
        Workload Identity Federation configuration.
        """
        return pulumi.get(self, "workload_identity_federation")

    @workload_identity_federation.setter
    def workload_identity_federation(self, value: Optional[pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs']]):
        pulumi.set(self, "workload_identity_federation", value)


@pulumi.input_type
class _KubernetesClusterState:
    def __init__(__self__, *,
                 cluster_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_provider: Optional[pulumi.Input['KubernetesClusterKmsProviderArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 master: Optional[pulumi.Input['KubernetesClusterMasterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_implementation: Optional[pulumi.Input['KubernetesClusterNetworkImplementationArgs']] = None,
                 network_policy_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 node_ipv4_cidr_mask_size: Optional[pulumi.Input[_builtins.int]] = None,
                 node_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_federation: Optional[pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs']] = None):
        """
        Input properties used for looking up and filtering KubernetesCluster resources.
        :param pulumi.Input[_builtins.str] cluster_ipv4_range: CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        :param pulumi.Input[_builtins.str] cluster_ipv6_range: Identical to `cluster_ipv4_range` but for IPv6 protocol.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Health of the Kubernetes cluster.
        :param pulumi.Input['KubernetesClusterKmsProviderArgs'] kms_provider: Cluster KMS provider parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] log_group_id: Log group where cluster stores cluster system logs, like audit, events, or control plane logs.
        :param pulumi.Input['KubernetesClusterMasterArgs'] master: Kubernetes master configuration options.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The ID of the cluster network.
        :param pulumi.Input['KubernetesClusterNetworkImplementationArgs'] network_implementation: Network Implementation options.
        :param pulumi.Input[_builtins.str] network_policy_provider: Network policy provider for the cluster. Possible values: `CALICO`.
        :param pulumi.Input[_builtins.int] node_ipv4_cidr_mask_size: Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        :param pulumi.Input[_builtins.str] node_service_account_id: Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        :param pulumi.Input[_builtins.str] release_channel: Cluster release channel.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        :param pulumi.Input[_builtins.str] service_ipv4_range: CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        :param pulumi.Input[_builtins.str] service_ipv6_range: Identical to service*ipv4*range but for IPv6 protocol.
        :param pulumi.Input[_builtins.str] status: Status of the Kubernetes cluster.
        :param pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs'] workload_identity_federation: Workload Identity Federation configuration.
        """
        if cluster_ipv4_range is not None:
            pulumi.set(__self__, "cluster_ipv4_range", cluster_ipv4_range)
        if cluster_ipv6_range is not None:
            pulumi.set(__self__, "cluster_ipv6_range", cluster_ipv6_range)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if kms_provider is not None:
            pulumi.set(__self__, "kms_provider", kms_provider)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_group_id is not None:
            pulumi.set(__self__, "log_group_id", log_group_id)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if network_implementation is not None:
            pulumi.set(__self__, "network_implementation", network_implementation)
        if network_policy_provider is not None:
            pulumi.set(__self__, "network_policy_provider", network_policy_provider)
        if node_ipv4_cidr_mask_size is not None:
            pulumi.set(__self__, "node_ipv4_cidr_mask_size", node_ipv4_cidr_mask_size)
        if node_service_account_id is not None:
            pulumi.set(__self__, "node_service_account_id", node_service_account_id)
        if release_channel is not None:
            pulumi.set(__self__, "release_channel", release_channel)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if service_ipv4_range is not None:
            pulumi.set(__self__, "service_ipv4_range", service_ipv4_range)
        if service_ipv6_range is not None:
            pulumi.set(__self__, "service_ipv6_range", service_ipv6_range)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if workload_identity_federation is not None:
            pulumi.set(__self__, "workload_identity_federation", workload_identity_federation)

    @_builtins.property
    @pulumi.getter(name="clusterIpv4Range")
    def cluster_ipv4_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        """
        return pulumi.get(self, "cluster_ipv4_range")

    @cluster_ipv4_range.setter
    def cluster_ipv4_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ipv4_range", value)

    @_builtins.property
    @pulumi.getter(name="clusterIpv6Range")
    def cluster_ipv6_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identical to `cluster_ipv4_range` but for IPv6 protocol.
        """
        return pulumi.get(self, "cluster_ipv6_range")

    @cluster_ipv6_range.setter
    def cluster_ipv6_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ipv6_range", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Health of the Kubernetes cluster.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter(name="kmsProvider")
    def kms_provider(self) -> Optional[pulumi.Input['KubernetesClusterKmsProviderArgs']]:
        """
        Cluster KMS provider parameters.
        """
        return pulumi.get(self, "kms_provider")

    @kms_provider.setter
    def kms_provider(self, value: Optional[pulumi.Input['KubernetesClusterKmsProviderArgs']]):
        pulumi.set(self, "kms_provider", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Log group where cluster stores cluster system logs, like audit, events, or control plane logs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_group_id", value)

    @_builtins.property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input['KubernetesClusterMasterArgs']]:
        """
        Kubernetes master configuration options.
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input['KubernetesClusterMasterArgs']]):
        pulumi.set(self, "master", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cluster network.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="networkImplementation")
    def network_implementation(self) -> Optional[pulumi.Input['KubernetesClusterNetworkImplementationArgs']]:
        """
        Network Implementation options.
        """
        return pulumi.get(self, "network_implementation")

    @network_implementation.setter
    def network_implementation(self, value: Optional[pulumi.Input['KubernetesClusterNetworkImplementationArgs']]):
        pulumi.set(self, "network_implementation", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicyProvider")
    def network_policy_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network policy provider for the cluster. Possible values: `CALICO`.
        """
        return pulumi.get(self, "network_policy_provider")

    @network_policy_provider.setter
    def network_policy_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy_provider", value)

    @_builtins.property
    @pulumi.getter(name="nodeIpv4CidrMaskSize")
    def node_ipv4_cidr_mask_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        """
        return pulumi.get(self, "node_ipv4_cidr_mask_size")

    @node_ipv4_cidr_mask_size.setter
    def node_ipv4_cidr_mask_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_ipv4_cidr_mask_size", value)

    @_builtins.property
    @pulumi.getter(name="nodeServiceAccountId")
    def node_service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        """
        return pulumi.get(self, "node_service_account_id")

    @node_service_account_id.setter
    def node_service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster release channel.
        """
        return pulumi.get(self, "release_channel")

    @release_channel.setter
    def release_channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_channel", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceIpv4Range")
    def service_ipv4_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        """
        return pulumi.get(self, "service_ipv4_range")

    @service_ipv4_range.setter
    def service_ipv4_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_ipv4_range", value)

    @_builtins.property
    @pulumi.getter(name="serviceIpv6Range")
    def service_ipv6_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identical to service*ipv4*range but for IPv6 protocol.
        """
        return pulumi.get(self, "service_ipv6_range")

    @service_ipv6_range.setter
    def service_ipv6_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_ipv6_range", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederation")
    def workload_identity_federation(self) -> Optional[pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs']]:
        """
        Workload Identity Federation configuration.
        """
        return pulumi.get(self, "workload_identity_federation")

    @workload_identity_federation.setter
    def workload_identity_federation(self, value: Optional[pulumi.Input['KubernetesClusterWorkloadIdentityFederationArgs']]):
        pulumi.set(self, "workload_identity_federation", value)


@pulumi.type_token("yandex:index/kubernetesCluster:KubernetesCluster")
class KubernetesCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_provider: Optional[pulumi.Input[Union['KubernetesClusterKmsProviderArgs', 'KubernetesClusterKmsProviderArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 master: Optional[pulumi.Input[Union['KubernetesClusterMasterArgs', 'KubernetesClusterMasterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_implementation: Optional[pulumi.Input[Union['KubernetesClusterNetworkImplementationArgs', 'KubernetesClusterNetworkImplementationArgsDict']]] = None,
                 network_policy_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 node_ipv4_cidr_mask_size: Optional[pulumi.Input[_builtins.int]] = None,
                 node_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_federation: Optional[pulumi.Input[Union['KubernetesClusterWorkloadIdentityFederationArgs', 'KubernetesClusterWorkloadIdentityFederationArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Managed Kubernetes zonal Cluster.
        #
        zonal_cluster = yandex.KubernetesCluster("zonal_cluster",
            name="name",
            description="description",
            network_id=network_resource_name["id"],
            master={
                "version": "1.30",
                "zonal": {
                    "zone": subnet_resource_name["zone"],
                    "subnet_id": subnet_resource_name["id"],
                },
                "public_ip": True,
                "security_group_ids": [security_group_name["id"]],
                "maintenance_policy": {
                    "auto_upgrade": True,
                    "maintenance_windows": [{
                        "start_time": "15:00",
                        "duration": "3h",
                    }],
                },
                "master_logging": {
                    "enabled": True,
                    "log_group_id": log_group_resoruce_name["id"],
                    "kube_apiserver_enabled": True,
                    "cluster_autoscaler_enabled": True,
                    "events_enabled": True,
                    "audit_enabled": True,
                },
                "scale_policy": {
                    "auto_scale": {
                        "min_resource_preset_id": "s-c4-m16",
                    },
                },
            },
            service_account_id=service_account_resource_name["id"],
            node_service_account_id=node_service_account_resource_name["id"],
            labels={
                "my_key": "my_value",
                "my_other_key": "my_other_value",
            },
            release_channel="RAPID",
            network_policy_provider="CALICO",
            kms_provider={
                "key_id": kms_key_resource_name["id"],
            },
            workload_identity_federation={
                "enabled": True,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Managed Kubernetes regional Cluster.
        #
        regional_cluster = yandex.KubernetesCluster("regional_cluster",
            name="name",
            description="description",
            network_id=network_resource_name["id"],
            master={
                "regional": {
                    "region": "ru-central1",
                    "locations": [
                        {
                            "zone": subnet_a_resource_name["zone"],
                            "subnet_id": subnet_a_resource_name["id"],
                        },
                        {
                            "zone": subnet_b_resource_name["zone"],
                            "subnet_id": subnet_b_resource_name["id"],
                        },
                        {
                            "zone": subnet_d_resource_name["zone"],
                            "subnet_id": subnet_d_resource_name["id"],
                        },
                    ],
                },
                "version": "1.30",
                "public_ip": True,
                "maintenance_policy": {
                    "auto_upgrade": True,
                    "maintenance_windows": [
                        {
                            "day": "monday",
                            "start_time": "15:00",
                            "duration": "3h",
                        },
                        {
                            "day": "friday",
                            "start_time": "10:00",
                            "duration": "4h30m",
                        },
                    ],
                },
                "master_logging": {
                    "enabled": True,
                    "folder_id": folder_resource_name["id"],
                    "kube_apiserver_enabled": True,
                    "cluster_autoscaler_enabled": True,
                    "events_enabled": True,
                    "audit_enabled": True,
                },
                "scale_policy": {
                    "auto_scale": {
                        "min_resource_preset_id": "s-c4-m16",
                    },
                },
            },
            service_account_id=service_account_resource_name["id"],
            node_service_account_id=node_service_account_resource_name["id"],
            labels={
                "my_key": "my_value",
                "my_other_key": "my_other_value",
            },
            release_channel="STABLE",
            workload_identity_federation={
                "enabled": True,
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/kubernetesCluster:KubernetesCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/kubernetesCluster:KubernetesCluster regional_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ipv4_range: CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        :param pulumi.Input[_builtins.str] cluster_ipv6_range: Identical to `cluster_ipv4_range` but for IPv6 protocol.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['KubernetesClusterKmsProviderArgs', 'KubernetesClusterKmsProviderArgsDict']] kms_provider: Cluster KMS provider parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['KubernetesClusterMasterArgs', 'KubernetesClusterMasterArgsDict']] master: Kubernetes master configuration options.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The ID of the cluster network.
        :param pulumi.Input[Union['KubernetesClusterNetworkImplementationArgs', 'KubernetesClusterNetworkImplementationArgsDict']] network_implementation: Network Implementation options.
        :param pulumi.Input[_builtins.str] network_policy_provider: Network policy provider for the cluster. Possible values: `CALICO`.
        :param pulumi.Input[_builtins.int] node_ipv4_cidr_mask_size: Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        :param pulumi.Input[_builtins.str] node_service_account_id: Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        :param pulumi.Input[_builtins.str] release_channel: Cluster release channel.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        :param pulumi.Input[_builtins.str] service_ipv4_range: CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        :param pulumi.Input[_builtins.str] service_ipv6_range: Identical to service*ipv4*range but for IPv6 protocol.
        :param pulumi.Input[Union['KubernetesClusterWorkloadIdentityFederationArgs', 'KubernetesClusterWorkloadIdentityFederationArgsDict']] workload_identity_federation: Workload Identity Federation configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Managed Kubernetes zonal Cluster.
        #
        zonal_cluster = yandex.KubernetesCluster("zonal_cluster",
            name="name",
            description="description",
            network_id=network_resource_name["id"],
            master={
                "version": "1.30",
                "zonal": {
                    "zone": subnet_resource_name["zone"],
                    "subnet_id": subnet_resource_name["id"],
                },
                "public_ip": True,
                "security_group_ids": [security_group_name["id"]],
                "maintenance_policy": {
                    "auto_upgrade": True,
                    "maintenance_windows": [{
                        "start_time": "15:00",
                        "duration": "3h",
                    }],
                },
                "master_logging": {
                    "enabled": True,
                    "log_group_id": log_group_resoruce_name["id"],
                    "kube_apiserver_enabled": True,
                    "cluster_autoscaler_enabled": True,
                    "events_enabled": True,
                    "audit_enabled": True,
                },
                "scale_policy": {
                    "auto_scale": {
                        "min_resource_preset_id": "s-c4-m16",
                    },
                },
            },
            service_account_id=service_account_resource_name["id"],
            node_service_account_id=node_service_account_resource_name["id"],
            labels={
                "my_key": "my_value",
                "my_other_key": "my_other_value",
            },
            release_channel="RAPID",
            network_policy_provider="CALICO",
            kms_provider={
                "key_id": kms_key_resource_name["id"],
            },
            workload_identity_federation={
                "enabled": True,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Managed Kubernetes regional Cluster.
        #
        regional_cluster = yandex.KubernetesCluster("regional_cluster",
            name="name",
            description="description",
            network_id=network_resource_name["id"],
            master={
                "regional": {
                    "region": "ru-central1",
                    "locations": [
                        {
                            "zone": subnet_a_resource_name["zone"],
                            "subnet_id": subnet_a_resource_name["id"],
                        },
                        {
                            "zone": subnet_b_resource_name["zone"],
                            "subnet_id": subnet_b_resource_name["id"],
                        },
                        {
                            "zone": subnet_d_resource_name["zone"],
                            "subnet_id": subnet_d_resource_name["id"],
                        },
                    ],
                },
                "version": "1.30",
                "public_ip": True,
                "maintenance_policy": {
                    "auto_upgrade": True,
                    "maintenance_windows": [
                        {
                            "day": "monday",
                            "start_time": "15:00",
                            "duration": "3h",
                        },
                        {
                            "day": "friday",
                            "start_time": "10:00",
                            "duration": "4h30m",
                        },
                    ],
                },
                "master_logging": {
                    "enabled": True,
                    "folder_id": folder_resource_name["id"],
                    "kube_apiserver_enabled": True,
                    "cluster_autoscaler_enabled": True,
                    "events_enabled": True,
                    "audit_enabled": True,
                },
                "scale_policy": {
                    "auto_scale": {
                        "min_resource_preset_id": "s-c4-m16",
                    },
                },
            },
            service_account_id=service_account_resource_name["id"],
            node_service_account_id=node_service_account_resource_name["id"],
            labels={
                "my_key": "my_value",
                "my_other_key": "my_other_value",
            },
            release_channel="STABLE",
            workload_identity_federation={
                "enabled": True,
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/kubernetesCluster:KubernetesCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/kubernetesCluster:KubernetesCluster regional_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_provider: Optional[pulumi.Input[Union['KubernetesClusterKmsProviderArgs', 'KubernetesClusterKmsProviderArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 master: Optional[pulumi.Input[Union['KubernetesClusterMasterArgs', 'KubernetesClusterMasterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_implementation: Optional[pulumi.Input[Union['KubernetesClusterNetworkImplementationArgs', 'KubernetesClusterNetworkImplementationArgsDict']]] = None,
                 network_policy_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 node_ipv4_cidr_mask_size: Optional[pulumi.Input[_builtins.int]] = None,
                 node_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 release_channel: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
                 service_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_federation: Optional[pulumi.Input[Union['KubernetesClusterWorkloadIdentityFederationArgs', 'KubernetesClusterWorkloadIdentityFederationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesClusterArgs.__new__(KubernetesClusterArgs)

            __props__.__dict__["cluster_ipv4_range"] = cluster_ipv4_range
            __props__.__dict__["cluster_ipv6_range"] = cluster_ipv6_range
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["kms_provider"] = kms_provider
            __props__.__dict__["labels"] = labels
            if master is None and not opts.urn:
                raise TypeError("Missing required property 'master'")
            __props__.__dict__["master"] = master
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["network_implementation"] = network_implementation
            __props__.__dict__["network_policy_provider"] = network_policy_provider
            __props__.__dict__["node_ipv4_cidr_mask_size"] = node_ipv4_cidr_mask_size
            if node_service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'node_service_account_id'")
            __props__.__dict__["node_service_account_id"] = node_service_account_id
            __props__.__dict__["release_channel"] = release_channel
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["service_ipv4_range"] = service_ipv4_range
            __props__.__dict__["service_ipv6_range"] = service_ipv6_range
            __props__.__dict__["workload_identity_federation"] = workload_identity_federation
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["log_group_id"] = None
            __props__.__dict__["status"] = None
        super(KubernetesCluster, __self__).__init__(
            'yandex:index/kubernetesCluster:KubernetesCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            kms_provider: Optional[pulumi.Input[Union['KubernetesClusterKmsProviderArgs', 'KubernetesClusterKmsProviderArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            log_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            master: Optional[pulumi.Input[Union['KubernetesClusterMasterArgs', 'KubernetesClusterMasterArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_implementation: Optional[pulumi.Input[Union['KubernetesClusterNetworkImplementationArgs', 'KubernetesClusterNetworkImplementationArgsDict']]] = None,
            network_policy_provider: Optional[pulumi.Input[_builtins.str]] = None,
            node_ipv4_cidr_mask_size: Optional[pulumi.Input[_builtins.int]] = None,
            node_service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            release_channel: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_ipv4_range: Optional[pulumi.Input[_builtins.str]] = None,
            service_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            workload_identity_federation: Optional[pulumi.Input[Union['KubernetesClusterWorkloadIdentityFederationArgs', 'KubernetesClusterWorkloadIdentityFederationArgsDict']]] = None) -> 'KubernetesCluster':
        """
        Get an existing KubernetesCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_ipv4_range: CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        :param pulumi.Input[_builtins.str] cluster_ipv6_range: Identical to `cluster_ipv4_range` but for IPv6 protocol.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Health of the Kubernetes cluster.
        :param pulumi.Input[Union['KubernetesClusterKmsProviderArgs', 'KubernetesClusterKmsProviderArgsDict']] kms_provider: Cluster KMS provider parameters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] log_group_id: Log group where cluster stores cluster system logs, like audit, events, or control plane logs.
        :param pulumi.Input[Union['KubernetesClusterMasterArgs', 'KubernetesClusterMasterArgsDict']] master: Kubernetes master configuration options.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The ID of the cluster network.
        :param pulumi.Input[Union['KubernetesClusterNetworkImplementationArgs', 'KubernetesClusterNetworkImplementationArgsDict']] network_implementation: Network Implementation options.
        :param pulumi.Input[_builtins.str] network_policy_provider: Network policy provider for the cluster. Possible values: `CALICO`.
        :param pulumi.Input[_builtins.int] node_ipv4_cidr_mask_size: Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        :param pulumi.Input[_builtins.str] node_service_account_id: Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        :param pulumi.Input[_builtins.str] release_channel: Cluster release channel.
        :param pulumi.Input[_builtins.str] service_account_id: Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        :param pulumi.Input[_builtins.str] service_ipv4_range: CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        :param pulumi.Input[_builtins.str] service_ipv6_range: Identical to service*ipv4*range but for IPv6 protocol.
        :param pulumi.Input[_builtins.str] status: Status of the Kubernetes cluster.
        :param pulumi.Input[Union['KubernetesClusterWorkloadIdentityFederationArgs', 'KubernetesClusterWorkloadIdentityFederationArgsDict']] workload_identity_federation: Workload Identity Federation configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesClusterState.__new__(_KubernetesClusterState)

        __props__.__dict__["cluster_ipv4_range"] = cluster_ipv4_range
        __props__.__dict__["cluster_ipv6_range"] = cluster_ipv6_range
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["kms_provider"] = kms_provider
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_group_id"] = log_group_id
        __props__.__dict__["master"] = master
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["network_implementation"] = network_implementation
        __props__.__dict__["network_policy_provider"] = network_policy_provider
        __props__.__dict__["node_ipv4_cidr_mask_size"] = node_ipv4_cidr_mask_size
        __props__.__dict__["node_service_account_id"] = node_service_account_id
        __props__.__dict__["release_channel"] = release_channel
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["service_ipv4_range"] = service_ipv4_range
        __props__.__dict__["service_ipv6_range"] = service_ipv6_range
        __props__.__dict__["status"] = status
        __props__.__dict__["workload_identity_federation"] = workload_identity_federation
        return KubernetesCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterIpv4Range")
    def cluster_ipv4_range(self) -> pulumi.Output[_builtins.str]:
        """
        CIDR block. IP range for allocating pod addresses. It should not overlap with any subnet in the network the Kubernetes cluster located in. Static routes will be set up for this CIDR blocks in node subnets.
        """
        return pulumi.get(self, "cluster_ipv4_range")

    @_builtins.property
    @pulumi.getter(name="clusterIpv6Range")
    def cluster_ipv6_range(self) -> pulumi.Output[_builtins.str]:
        """
        Identical to `cluster_ipv4_range` but for IPv6 protocol.
        """
        return pulumi.get(self, "cluster_ipv6_range")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Health of the Kubernetes cluster.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="kmsProvider")
    def kms_provider(self) -> pulumi.Output[Optional['outputs.KubernetesClusterKmsProvider']]:
        """
        Cluster KMS provider parameters.
        """
        return pulumi.get(self, "kms_provider")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Log group where cluster stores cluster system logs, like audit, events, or control plane logs.
        """
        return pulumi.get(self, "log_group_id")

    @_builtins.property
    @pulumi.getter
    def master(self) -> pulumi.Output['outputs.KubernetesClusterMaster']:
        """
        Kubernetes master configuration options.
        """
        return pulumi.get(self, "master")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cluster network.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="networkImplementation")
    def network_implementation(self) -> pulumi.Output[Optional['outputs.KubernetesClusterNetworkImplementation']]:
        """
        Network Implementation options.
        """
        return pulumi.get(self, "network_implementation")

    @_builtins.property
    @pulumi.getter(name="networkPolicyProvider")
    def network_policy_provider(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Network policy provider for the cluster. Possible values: `CALICO`.
        """
        return pulumi.get(self, "network_policy_provider")

    @_builtins.property
    @pulumi.getter(name="nodeIpv4CidrMaskSize")
    def node_ipv4_cidr_mask_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Size of the masks that are assigned to each node in the cluster. Effectively limits maximum number of pods for each node.
        """
        return pulumi.get(self, "node_ipv4_cidr_mask_size")

    @_builtins.property
    @pulumi.getter(name="nodeServiceAccountId")
    def node_service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Service account to be used by the worker nodes of the Kubernetes cluster to access Container Registry or to push node logs and metrics.
        """
        return pulumi.get(self, "node_service_account_id")

    @_builtins.property
    @pulumi.getter(name="releaseChannel")
    def release_channel(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster release channel.
        """
        return pulumi.get(self, "release_channel")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Service account to be used for provisioning Compute Cloud and VPC resources for Kubernetes cluster. Selected service account should have `edit` role on the folder where the Kubernetes cluster will be located and on the folder where selected network resides.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="serviceIpv4Range")
    def service_ipv4_range(self) -> pulumi.Output[_builtins.str]:
        """
        CIDR block. IP range Kubernetes service Kubernetes cluster IP addresses will be allocated from. It should not overlap with any subnet in the network the Kubernetes cluster located in.
        """
        return pulumi.get(self, "service_ipv4_range")

    @_builtins.property
    @pulumi.getter(name="serviceIpv6Range")
    def service_ipv6_range(self) -> pulumi.Output[_builtins.str]:
        """
        Identical to service*ipv4*range but for IPv6 protocol.
        """
        return pulumi.get(self, "service_ipv6_range")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederation")
    def workload_identity_federation(self) -> pulumi.Output[Optional['outputs.KubernetesClusterWorkloadIdentityFederation']]:
        """
        Workload Identity Federation configuration.
        """
        return pulumi.get(self, "workload_identity_federation")

