# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KubernetesNodeGroupArgs', 'KubernetesNodeGroup']

@pulumi.input_type
class KubernetesNodeGroupArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 instance_template: pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs'],
                 scale_policy: pulumi.Input['KubernetesNodeGroupScalePolicyArgs'],
                 allocation_policy: Optional[pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs']] = None,
                 allowed_unsafe_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deploy_policy: Optional[pulumi.Input['KubernetesNodeGroupDeployPolicyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KubernetesNodeGroup resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kubernetes cluster that this node group belongs to.
        :param pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs'] instance_template: Template used to create compute instances in this Kubernetes node group.
        :param pulumi.Input['KubernetesNodeGroupScalePolicyArgs'] scale_policy: Scale policy of the node group.
        :param pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs'] allocation_policy: This argument specify subnets (zones), that will be used by node group compute instances.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_unsafe_sysctls: A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        :param pulumi.Input['KubernetesNodeGroupDeployPolicyArgs'] deploy_policy: Deploy policy of the node group.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for this Kubernetes node group. If policy is omitted, automatic revision upgrades are enabled and could happen at any time. Revision upgrades are performed only within the same minor version, e.g. `1.29`. Minor version upgrades (e.g. `1.29`->`1.30`) should be performed manually.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        :param pulumi.Input[_builtins.str] version: Version of Kubernetes that will be used for Kubernetes node group.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "instance_template", instance_template)
        pulumi.set(__self__, "scale_policy", scale_policy)
        if allocation_policy is not None:
            pulumi.set(__self__, "allocation_policy", allocation_policy)
        if allowed_unsafe_sysctls is not None:
            pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if deploy_policy is not None:
            pulumi.set(__self__, "deploy_policy", deploy_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Kubernetes cluster that this node group belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs']:
        """
        Template used to create compute instances in this Kubernetes node group.
        """
        return pulumi.get(self, "instance_template")

    @instance_template.setter
    def instance_template(self, value: pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs']):
        pulumi.set(self, "instance_template", value)

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Input['KubernetesNodeGroupScalePolicyArgs']:
        """
        Scale policy of the node group.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: pulumi.Input['KubernetesNodeGroupScalePolicyArgs']):
        pulumi.set(self, "scale_policy", value)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> Optional[pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs']]:
        """
        This argument specify subnets (zones), that will be used by node group compute instances.
        """
        return pulumi.get(self, "allocation_policy")

    @allocation_policy.setter
    def allocation_policy(self, value: Optional[pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs']]):
        pulumi.set(self, "allocation_policy", value)

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @allowed_unsafe_sysctls.setter
    def allowed_unsafe_sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_unsafe_sysctls", value)

    @_builtins.property
    @pulumi.getter(name="deployPolicy")
    def deploy_policy(self) -> Optional[pulumi.Input['KubernetesNodeGroupDeployPolicyArgs']]:
        """
        Deploy policy of the node group.
        """
        return pulumi.get(self, "deploy_policy")

    @deploy_policy.setter
    def deploy_policy(self, value: Optional[pulumi.Input['KubernetesNodeGroupDeployPolicyArgs']]):
        pulumi.set(self, "deploy_policy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs']]:
        """
        Maintenance policy for this Kubernetes node group. If policy is omitted, automatic revision upgrades are enabled and could happen at any time. Revision upgrades are performed only within the same minor version, e.g. `1.29`. Minor version upgrades (e.g. `1.29`->`1.30`) should be performed manually.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_labels", value)

    @_builtins.property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_taints", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Kubernetes that will be used for Kubernetes node group.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _KubernetesNodeGroupState:
    def __init__(__self__, *,
                 allocation_policy: Optional[pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs']] = None,
                 allowed_unsafe_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_policy: Optional[pulumi.Input['KubernetesNodeGroupDeployPolicyArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_template: Optional[pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scale_policy: Optional[pulumi.Input['KubernetesNodeGroupScalePolicyArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_infos: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupVersionInfoArgs']]]] = None):
        """
        Input properties used for looking up and filtering KubernetesNodeGroup resources.
        :param pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs'] allocation_policy: This argument specify subnets (zones), that will be used by node group compute instances.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_unsafe_sysctls: A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kubernetes cluster that this node group belongs to.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input['KubernetesNodeGroupDeployPolicyArgs'] deploy_policy: Deploy policy of the node group.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] instance_group_id: ID of instance group that is used to manage this Kubernetes node group.
        :param pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs'] instance_template: Template used to create compute instances in this Kubernetes node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for this Kubernetes node group. If policy is omitted, automatic revision upgrades are enabled and could happen at any time. Revision upgrades are performed only within the same minor version, e.g. `1.29`. Minor version upgrades (e.g. `1.29`->`1.30`) should be performed manually.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        :param pulumi.Input['KubernetesNodeGroupScalePolicyArgs'] scale_policy: Scale policy of the node group.
        :param pulumi.Input[_builtins.str] status: Status of the Kubernetes node group.
        :param pulumi.Input[_builtins.str] version: Version of Kubernetes that will be used for Kubernetes node group.
        :param pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupVersionInfoArgs']]] version_infos: Information about Kubernetes node group version.
        """
        if allocation_policy is not None:
            pulumi.set(__self__, "allocation_policy", allocation_policy)
        if allowed_unsafe_sysctls is not None:
            pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deploy_policy is not None:
            pulumi.set(__self__, "deploy_policy", deploy_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_group_id is not None:
            pulumi.set(__self__, "instance_group_id", instance_group_id)
        if instance_template is not None:
            pulumi.set(__self__, "instance_template", instance_template)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if scale_policy is not None:
            pulumi.set(__self__, "scale_policy", scale_policy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_infos is not None:
            pulumi.set(__self__, "version_infos", version_infos)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> Optional[pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs']]:
        """
        This argument specify subnets (zones), that will be used by node group compute instances.
        """
        return pulumi.get(self, "allocation_policy")

    @allocation_policy.setter
    def allocation_policy(self, value: Optional[pulumi.Input['KubernetesNodeGroupAllocationPolicyArgs']]):
        pulumi.set(self, "allocation_policy", value)

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @allowed_unsafe_sysctls.setter
    def allowed_unsafe_sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_unsafe_sysctls", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Kubernetes cluster that this node group belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deployPolicy")
    def deploy_policy(self) -> Optional[pulumi.Input['KubernetesNodeGroupDeployPolicyArgs']]:
        """
        Deploy policy of the node group.
        """
        return pulumi.get(self, "deploy_policy")

    @deploy_policy.setter
    def deploy_policy(self, value: Optional[pulumi.Input['KubernetesNodeGroupDeployPolicyArgs']]):
        pulumi.set(self, "deploy_policy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroupId")
    def instance_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of instance group that is used to manage this Kubernetes node group.
        """
        return pulumi.get(self, "instance_group_id")

    @instance_group_id.setter
    def instance_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_group_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> Optional[pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs']]:
        """
        Template used to create compute instances in this Kubernetes node group.
        """
        return pulumi.get(self, "instance_template")

    @instance_template.setter
    def instance_template(self, value: Optional[pulumi.Input['KubernetesNodeGroupInstanceTemplateArgs']]):
        pulumi.set(self, "instance_template", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs']]:
        """
        Maintenance policy for this Kubernetes node group. If policy is omitted, automatic revision upgrades are enabled and could happen at any time. Revision upgrades are performed only within the same minor version, e.g. `1.29`. Minor version upgrades (e.g. `1.29`->`1.30`) should be performed manually.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['KubernetesNodeGroupMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_labels", value)

    @_builtins.property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_taints", value)

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> Optional[pulumi.Input['KubernetesNodeGroupScalePolicyArgs']]:
        """
        Scale policy of the node group.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: Optional[pulumi.Input['KubernetesNodeGroupScalePolicyArgs']]):
        pulumi.set(self, "scale_policy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the Kubernetes node group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Kubernetes that will be used for Kubernetes node group.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionInfos")
    def version_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupVersionInfoArgs']]]]:
        """
        Information about Kubernetes node group version.
        """
        return pulumi.get(self, "version_infos")

    @version_infos.setter
    def version_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KubernetesNodeGroupVersionInfoArgs']]]]):
        pulumi.set(self, "version_infos", value)


@pulumi.type_token("yandex:index/kubernetesNodeGroup:KubernetesNodeGroup")
class KubernetesNodeGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupAllocationPolicyArgs', 'KubernetesNodeGroupAllocationPolicyArgsDict']]] = None,
                 allowed_unsafe_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupDeployPolicyArgs', 'KubernetesNodeGroupDeployPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_template: Optional[pulumi.Input[Union['KubernetesNodeGroupInstanceTemplateArgs', 'KubernetesNodeGroupInstanceTemplateArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupMaintenancePolicyArgs', 'KubernetesNodeGroupMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scale_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupScalePolicyArgs', 'KubernetesNodeGroupScalePolicyArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Yandex Managed Kubernetes Cluster Node Group. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kubernetes/concepts/#node-group).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Managed Kubernetes Node Group.
        #
        my_node_group = yandex.KubernetesNodeGroup("my_node_group",
            cluster_id=my_cluster["id"],
            name="name",
            description="description",
            version="1.30",
            labels={
                "key": "value",
            },
            instance_template={
                "platform_id": "standard-v2",
                "network_interfaces": [{
                    "nat": True,
                    "subnet_ids": [my_subnet["id"]],
                }],
                "resources": {
                    "memory": 2,
                    "cores": 2,
                },
                "boot_disk": {
                    "type": "network-hdd",
                    "size": 64,
                },
                "scheduling_policy": {
                    "preemptible": False,
                },
                "container_runtime": {
                    "type": "containerd",
                },
            },
            scale_policy={
                "fixed_scale": {
                    "size": 1,
                },
            },
            allocation_policy={
                "locations": [{
                    "zone": "ru-central1-a",
                }],
            },
            maintenance_policy={
                "auto_upgrade": True,
                "auto_repair": True,
                "maintenance_windows": [
                    {
                        "day": "monday",
                        "start_time": "15:00",
                        "duration": "3h",
                    },
                    {
                        "day": "friday",
                        "start_time": "10:00",
                        "duration": "4h30m",
                    },
                ],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/kubernetesNodeGroup:KubernetesNodeGroup <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/kubernetesNodeGroup:KubernetesNodeGroup my_node_group ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesNodeGroupAllocationPolicyArgs', 'KubernetesNodeGroupAllocationPolicyArgsDict']] allocation_policy: This argument specify subnets (zones), that will be used by node group compute instances.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_unsafe_sysctls: A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kubernetes cluster that this node group belongs to.
        :param pulumi.Input[Union['KubernetesNodeGroupDeployPolicyArgs', 'KubernetesNodeGroupDeployPolicyArgsDict']] deploy_policy: Deploy policy of the node group.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Union['KubernetesNodeGroupInstanceTemplateArgs', 'KubernetesNodeGroupInstanceTemplateArgsDict']] instance_template: Template used to create compute instances in this Kubernetes node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['KubernetesNodeGroupMaintenancePolicyArgs', 'KubernetesNodeGroupMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for this Kubernetes node group. If policy is omitted, automatic revision upgrades are enabled and could happen at any time. Revision upgrades are performed only within the same minor version, e.g. `1.29`. Minor version upgrades (e.g. `1.29`->`1.30`) should be performed manually.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        :param pulumi.Input[Union['KubernetesNodeGroupScalePolicyArgs', 'KubernetesNodeGroupScalePolicyArgsDict']] scale_policy: Scale policy of the node group.
        :param pulumi.Input[_builtins.str] version: Version of Kubernetes that will be used for Kubernetes node group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesNodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Yandex Managed Kubernetes Cluster Node Group. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kubernetes/concepts/#node-group).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Managed Kubernetes Node Group.
        #
        my_node_group = yandex.KubernetesNodeGroup("my_node_group",
            cluster_id=my_cluster["id"],
            name="name",
            description="description",
            version="1.30",
            labels={
                "key": "value",
            },
            instance_template={
                "platform_id": "standard-v2",
                "network_interfaces": [{
                    "nat": True,
                    "subnet_ids": [my_subnet["id"]],
                }],
                "resources": {
                    "memory": 2,
                    "cores": 2,
                },
                "boot_disk": {
                    "type": "network-hdd",
                    "size": 64,
                },
                "scheduling_policy": {
                    "preemptible": False,
                },
                "container_runtime": {
                    "type": "containerd",
                },
            },
            scale_policy={
                "fixed_scale": {
                    "size": 1,
                },
            },
            allocation_policy={
                "locations": [{
                    "zone": "ru-central1-a",
                }],
            },
            maintenance_policy={
                "auto_upgrade": True,
                "auto_repair": True,
                "maintenance_windows": [
                    {
                        "day": "monday",
                        "start_time": "15:00",
                        "duration": "3h",
                    },
                    {
                        "day": "friday",
                        "start_time": "10:00",
                        "duration": "4h30m",
                    },
                ],
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/kubernetesNodeGroup:KubernetesNodeGroup <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/kubernetesNodeGroup:KubernetesNodeGroup my_node_group ...
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesNodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesNodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupAllocationPolicyArgs', 'KubernetesNodeGroupAllocationPolicyArgsDict']]] = None,
                 allowed_unsafe_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 deploy_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupDeployPolicyArgs', 'KubernetesNodeGroupDeployPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_template: Optional[pulumi.Input[Union['KubernetesNodeGroupInstanceTemplateArgs', 'KubernetesNodeGroupInstanceTemplateArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupMaintenancePolicyArgs', 'KubernetesNodeGroupMaintenancePolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scale_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupScalePolicyArgs', 'KubernetesNodeGroupScalePolicyArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesNodeGroupArgs.__new__(KubernetesNodeGroupArgs)

            __props__.__dict__["allocation_policy"] = allocation_policy
            __props__.__dict__["allowed_unsafe_sysctls"] = allowed_unsafe_sysctls
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["deploy_policy"] = deploy_policy
            __props__.__dict__["description"] = description
            if instance_template is None and not opts.urn:
                raise TypeError("Missing required property 'instance_template'")
            __props__.__dict__["instance_template"] = instance_template
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["node_labels"] = node_labels
            __props__.__dict__["node_taints"] = node_taints
            if scale_policy is None and not opts.urn:
                raise TypeError("Missing required property 'scale_policy'")
            __props__.__dict__["scale_policy"] = scale_policy
            __props__.__dict__["version"] = version
            __props__.__dict__["created_at"] = None
            __props__.__dict__["instance_group_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version_infos"] = None
        super(KubernetesNodeGroup, __self__).__init__(
            'yandex:index/kubernetesNodeGroup:KubernetesNodeGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupAllocationPolicyArgs', 'KubernetesNodeGroupAllocationPolicyArgsDict']]] = None,
            allowed_unsafe_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deploy_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupDeployPolicyArgs', 'KubernetesNodeGroupDeployPolicyArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_template: Optional[pulumi.Input[Union['KubernetesNodeGroupInstanceTemplateArgs', 'KubernetesNodeGroupInstanceTemplateArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupMaintenancePolicyArgs', 'KubernetesNodeGroupMaintenancePolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            scale_policy: Optional[pulumi.Input[Union['KubernetesNodeGroupScalePolicyArgs', 'KubernetesNodeGroupScalePolicyArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            version_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupVersionInfoArgs', 'KubernetesNodeGroupVersionInfoArgsDict']]]]] = None) -> 'KubernetesNodeGroup':
        """
        Get an existing KubernetesNodeGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KubernetesNodeGroupAllocationPolicyArgs', 'KubernetesNodeGroupAllocationPolicyArgsDict']] allocation_policy: This argument specify subnets (zones), that will be used by node group compute instances.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_unsafe_sysctls: A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kubernetes cluster that this node group belongs to.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Union['KubernetesNodeGroupDeployPolicyArgs', 'KubernetesNodeGroupDeployPolicyArgsDict']] deploy_policy: Deploy policy of the node group.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] instance_group_id: ID of instance group that is used to manage this Kubernetes node group.
        :param pulumi.Input[Union['KubernetesNodeGroupInstanceTemplateArgs', 'KubernetesNodeGroupInstanceTemplateArgsDict']] instance_template: Template used to create compute instances in this Kubernetes node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['KubernetesNodeGroupMaintenancePolicyArgs', 'KubernetesNodeGroupMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for this Kubernetes node group. If policy is omitted, automatic revision upgrades are enabled and could happen at any time. Revision upgrades are performed only within the same minor version, e.g. `1.29`. Minor version upgrades (e.g. `1.29`->`1.30`) should be performed manually.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] node_labels: A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_taints: A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        :param pulumi.Input[Union['KubernetesNodeGroupScalePolicyArgs', 'KubernetesNodeGroupScalePolicyArgsDict']] scale_policy: Scale policy of the node group.
        :param pulumi.Input[_builtins.str] status: Status of the Kubernetes node group.
        :param pulumi.Input[_builtins.str] version: Version of Kubernetes that will be used for Kubernetes node group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KubernetesNodeGroupVersionInfoArgs', 'KubernetesNodeGroupVersionInfoArgsDict']]]] version_infos: Information about Kubernetes node group version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesNodeGroupState.__new__(_KubernetesNodeGroupState)

        __props__.__dict__["allocation_policy"] = allocation_policy
        __props__.__dict__["allowed_unsafe_sysctls"] = allowed_unsafe_sysctls
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deploy_policy"] = deploy_policy
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_group_id"] = instance_group_id
        __props__.__dict__["instance_template"] = instance_template
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["node_labels"] = node_labels
        __props__.__dict__["node_taints"] = node_taints
        __props__.__dict__["scale_policy"] = scale_policy
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        __props__.__dict__["version_infos"] = version_infos
        return KubernetesNodeGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> pulumi.Output['outputs.KubernetesNodeGroupAllocationPolicy']:
        """
        This argument specify subnets (zones), that will be used by node group compute instances.
        """
        return pulumi.get(self, "allocation_policy")

    @_builtins.property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of allowed unsafe `sysctl` parameters for this node group. For more details see [documentation](https://kubernetes.io/docs/tasks/administer-cluster/sysctl-cluster).
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Kubernetes cluster that this node group belongs to.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deployPolicy")
    def deploy_policy(self) -> pulumi.Output['outputs.KubernetesNodeGroupDeployPolicy']:
        """
        Deploy policy of the node group.
        """
        return pulumi.get(self, "deploy_policy")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceGroupId")
    def instance_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of instance group that is used to manage this Kubernetes node group.
        """
        return pulumi.get(self, "instance_group_id")

    @_builtins.property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> pulumi.Output['outputs.KubernetesNodeGroupInstanceTemplate']:
        """
        Template used to create compute instances in this Kubernetes node group.
        """
        return pulumi.get(self, "instance_template")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output['outputs.KubernetesNodeGroupMaintenancePolicy']:
        """
        Maintenance policy for this Kubernetes node group. If policy is omitted, automatic revision upgrades are enabled and could happen at any time. Revision upgrades are performed only within the same minor version, e.g. `1.29`. Minor version upgrades (e.g. `1.29`->`1.30`) should be performed manually.
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs, that are assigned to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_labels")

    @_builtins.property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Kubernetes taints, that are applied to all the nodes of this Kubernetes node group.
        """
        return pulumi.get(self, "node_taints")

    @_builtins.property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Output['outputs.KubernetesNodeGroupScalePolicy']:
        """
        Scale policy of the node group.
        """
        return pulumi.get(self, "scale_policy")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the Kubernetes node group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of Kubernetes that will be used for Kubernetes node group.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionInfos")
    def version_infos(self) -> pulumi.Output[Sequence['outputs.KubernetesNodeGroupVersionInfo']]:
        """
        Information about Kubernetes node group version.
        """
        return pulumi.get(self, "version_infos")

