# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadtestingAgentArgs', 'LoadtestingAgent']

@pulumi.input_type
class LoadtestingAgentArgs:
    def __init__(__self__, *,
                 compute_instance: pulumi.Input['LoadtestingAgentComputeInstanceArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_settings: Optional[pulumi.Input['LoadtestingAgentLogSettingsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadtestingAgent resource.
        :param pulumi.Input['LoadtestingAgentComputeInstanceArgs'] compute_instance: The template for creating new compute instance running load testing agent.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['LoadtestingAgentLogSettingsArgs'] log_settings: The logging settings of the load testing agent.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        pulumi.set(__self__, "compute_instance", compute_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_settings is not None:
            pulumi.set(__self__, "log_settings", log_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="computeInstance")
    def compute_instance(self) -> pulumi.Input['LoadtestingAgentComputeInstanceArgs']:
        """
        The template for creating new compute instance running load testing agent.
        """
        return pulumi.get(self, "compute_instance")

    @compute_instance.setter
    def compute_instance(self, value: pulumi.Input['LoadtestingAgentComputeInstanceArgs']):
        pulumi.set(self, "compute_instance", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> Optional[pulumi.Input['LoadtestingAgentLogSettingsArgs']]:
        """
        The logging settings of the load testing agent.
        """
        return pulumi.get(self, "log_settings")

    @log_settings.setter
    def log_settings(self, value: Optional[pulumi.Input['LoadtestingAgentLogSettingsArgs']]):
        pulumi.set(self, "log_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LoadtestingAgentState:
    def __init__(__self__, *,
                 compute_instance: Optional[pulumi.Input['LoadtestingAgentComputeInstanceArgs']] = None,
                 compute_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_settings: Optional[pulumi.Input['LoadtestingAgentLogSettingsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadtestingAgent resources.
        :param pulumi.Input['LoadtestingAgentComputeInstanceArgs'] compute_instance: The template for creating new compute instance running load testing agent.
        :param pulumi.Input[_builtins.str] compute_instance_id: Compute Instance ID.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['LoadtestingAgentLogSettingsArgs'] log_settings: The logging settings of the load testing agent.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        if compute_instance is not None:
            pulumi.set(__self__, "compute_instance", compute_instance)
        if compute_instance_id is not None:
            pulumi.set(__self__, "compute_instance_id", compute_instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_settings is not None:
            pulumi.set(__self__, "log_settings", log_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="computeInstance")
    def compute_instance(self) -> Optional[pulumi.Input['LoadtestingAgentComputeInstanceArgs']]:
        """
        The template for creating new compute instance running load testing agent.
        """
        return pulumi.get(self, "compute_instance")

    @compute_instance.setter
    def compute_instance(self, value: Optional[pulumi.Input['LoadtestingAgentComputeInstanceArgs']]):
        pulumi.set(self, "compute_instance", value)

    @_builtins.property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Compute Instance ID.
        """
        return pulumi.get(self, "compute_instance_id")

    @compute_instance_id.setter
    def compute_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> Optional[pulumi.Input['LoadtestingAgentLogSettingsArgs']]:
        """
        The logging settings of the load testing agent.
        """
        return pulumi.get(self, "log_settings")

    @log_settings.setter
    def log_settings(self, value: Optional[pulumi.Input['LoadtestingAgentLogSettingsArgs']]):
        pulumi.set(self, "log_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("yandex:index/loadtestingAgent:LoadtestingAgent")
class LoadtestingAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_instance: Optional[pulumi.Input[Union['LoadtestingAgentComputeInstanceArgs', 'LoadtestingAgentComputeInstanceArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_settings: Optional[pulumi.Input[Union['LoadtestingAgentLogSettingsArgs', 'LoadtestingAgentLogSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Load Testing Agent resource. For more information, see [the official documentation](https://yandex.cloud/docs/load-testing/concepts/agent).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new LoadTesting Agent.
        #
        my_agent = yandex.LoadtestingAgent("my-agent",
            name="my-agent",
            description="2 core 4 GB RAM agent",
            folder_id=test_folder["id"],
            labels={
                "jmeter": "5",
            },
            compute_instance={
                "zone_id": "ru-central1-b",
                "service_account_id": test_account["id"],
                "resources": {
                    "memory": 4,
                    "cores": 2,
                },
                "boot_disk": {
                    "initialize_params": {
                        "size": 15,
                    },
                    "auto_delete": True,
                },
                "network_interfaces": [{
                    "subnet_id": my_subnet_a["id"],
                }],
            })
        ```

        ## ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadtestingAgentComputeInstanceArgs', 'LoadtestingAgentComputeInstanceArgsDict']] compute_instance: The template for creating new compute instance running load testing agent.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['LoadtestingAgentLogSettingsArgs', 'LoadtestingAgentLogSettingsArgsDict']] log_settings: The logging settings of the load testing agent.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadtestingAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Load Testing Agent resource. For more information, see [the official documentation](https://yandex.cloud/docs/load-testing/concepts/agent).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new LoadTesting Agent.
        #
        my_agent = yandex.LoadtestingAgent("my-agent",
            name="my-agent",
            description="2 core 4 GB RAM agent",
            folder_id=test_folder["id"],
            labels={
                "jmeter": "5",
            },
            compute_instance={
                "zone_id": "ru-central1-b",
                "service_account_id": test_account["id"],
                "resources": {
                    "memory": 4,
                    "cores": 2,
                },
                "boot_disk": {
                    "initialize_params": {
                        "size": 15,
                    },
                    "auto_delete": True,
                },
                "network_interfaces": [{
                    "subnet_id": my_subnet_a["id"],
                }],
            })
        ```

        ## ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        :param str resource_name: The name of the resource.
        :param LoadtestingAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadtestingAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_instance: Optional[pulumi.Input[Union['LoadtestingAgentComputeInstanceArgs', 'LoadtestingAgentComputeInstanceArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_settings: Optional[pulumi.Input[Union['LoadtestingAgentLogSettingsArgs', 'LoadtestingAgentLogSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadtestingAgentArgs.__new__(LoadtestingAgentArgs)

            if compute_instance is None and not opts.urn:
                raise TypeError("Missing required property 'compute_instance'")
            __props__.__dict__["compute_instance"] = compute_instance
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_settings"] = log_settings
            __props__.__dict__["name"] = name
            __props__.__dict__["compute_instance_id"] = None
        super(LoadtestingAgent, __self__).__init__(
            'yandex:index/loadtestingAgent:LoadtestingAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_instance: Optional[pulumi.Input[Union['LoadtestingAgentComputeInstanceArgs', 'LoadtestingAgentComputeInstanceArgsDict']]] = None,
            compute_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            log_settings: Optional[pulumi.Input[Union['LoadtestingAgentLogSettingsArgs', 'LoadtestingAgentLogSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadtestingAgent':
        """
        Get an existing LoadtestingAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadtestingAgentComputeInstanceArgs', 'LoadtestingAgentComputeInstanceArgsDict']] compute_instance: The template for creating new compute instance running load testing agent.
        :param pulumi.Input[_builtins.str] compute_instance_id: Compute Instance ID.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['LoadtestingAgentLogSettingsArgs', 'LoadtestingAgentLogSettingsArgsDict']] log_settings: The logging settings of the load testing agent.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadtestingAgentState.__new__(_LoadtestingAgentState)

        __props__.__dict__["compute_instance"] = compute_instance
        __props__.__dict__["compute_instance_id"] = compute_instance_id
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_settings"] = log_settings
        __props__.__dict__["name"] = name
        return LoadtestingAgent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="computeInstance")
    def compute_instance(self) -> pulumi.Output['outputs.LoadtestingAgentComputeInstance']:
        """
        The template for creating new compute instance running load testing agent.
        """
        return pulumi.get(self, "compute_instance")

    @_builtins.property
    @pulumi.getter(name="computeInstanceId")
    def compute_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Compute Instance ID.
        """
        return pulumi.get(self, "compute_instance_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logSettings")
    def log_settings(self) -> pulumi.Output[Optional['outputs.LoadtestingAgentLogSettings']]:
        """
        The logging settings of the load testing agent.
        """
        return pulumi.get(self, "log_settings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

