# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LockboxSecretVersionArgs', 'LockboxSecretVersion']

@pulumi.input_type
class LockboxSecretVersionArgs:
    def __init__(__self__, *,
                 secret_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]]] = None):
        """
        The set of arguments for constructing a LockboxSecretVersion resource.
        :param pulumi.Input[_builtins.str] secret_id: The Yandex Cloud Lockbox secret ID where to add the version.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]] entries: List of entries in the Yandex Cloud Lockbox secret version. Must be omitted for secrets with a payload specification.
        """
        pulumi.set(__self__, "secret_id", secret_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Yandex Cloud Lockbox secret ID where to add the version.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]]]:
        """
        List of entries in the Yandex Cloud Lockbox secret version. Must be omitted for secrets with a payload specification.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]]]):
        pulumi.set(self, "entries", value)


@pulumi.input_type
class _LockboxSecretVersionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LockboxSecretVersion resources.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]] entries: List of entries in the Yandex Cloud Lockbox secret version. Must be omitted for secrets with a payload specification.
        :param pulumi.Input[_builtins.str] secret_id: The Yandex Cloud Lockbox secret ID where to add the version.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]]]:
        """
        List of entries in the Yandex Cloud Lockbox secret version. Must be omitted for secrets with a payload specification.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LockboxSecretVersionEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Yandex Cloud Lockbox secret ID where to add the version.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)


@pulumi.type_token("yandex:index/lockboxSecretVersion:LockboxSecretVersion")
class LockboxSecretVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LockboxSecretVersionEntryArgs', 'LockboxSecretVersionEntryArgsDict']]]]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Yandex Cloud Lockbox secret version resource. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Lockbox Secret Version.
        #
        my_secret = yandex.LockboxSecret("my_secret", name="test secret")
        my_version = yandex.LockboxSecretVersion("my_version",
            secret_id=my_secret.id,
            entries=[
                {
                    "key": "key1",
                    "text_value": "value1",
                },
                {
                    "key": "k2",
                    "command": {
                        "path": "my_secret_generator.sh",
                    },
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Lockbox Secret Version.
        #
        my_secret = yandex.LockboxSecret("my_secret", name="test secret")
        my_version = yandex.LockboxSecretVersion("my_version",
            secret_id=my_secret.id,
            entries=[
                {
                    "key": "key1",
                    "text_value": "value1",
                },
                {
                    "key": "k2",
                    "command": {
                        "path": "my_secret_generator.sh",
                    },
                },
            ])
        ```

        ## Import

        ~> Import for this resource is not implemented yet.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LockboxSecretVersionEntryArgs', 'LockboxSecretVersionEntryArgsDict']]]] entries: List of entries in the Yandex Cloud Lockbox secret version. Must be omitted for secrets with a payload specification.
        :param pulumi.Input[_builtins.str] secret_id: The Yandex Cloud Lockbox secret ID where to add the version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LockboxSecretVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Yandex Cloud Lockbox secret version resource. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Lockbox Secret Version.
        #
        my_secret = yandex.LockboxSecret("my_secret", name="test secret")
        my_version = yandex.LockboxSecretVersion("my_version",
            secret_id=my_secret.id,
            entries=[
                {
                    "key": "key1",
                    "text_value": "value1",
                },
                {
                    "key": "k2",
                    "command": {
                        "path": "my_secret_generator.sh",
                    },
                },
            ])
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Lockbox Secret Version.
        #
        my_secret = yandex.LockboxSecret("my_secret", name="test secret")
        my_version = yandex.LockboxSecretVersion("my_version",
            secret_id=my_secret.id,
            entries=[
                {
                    "key": "key1",
                    "text_value": "value1",
                },
                {
                    "key": "k2",
                    "command": {
                        "path": "my_secret_generator.sh",
                    },
                },
            ])
        ```

        ## Import

        ~> Import for this resource is not implemented yet.

        :param str resource_name: The name of the resource.
        :param LockboxSecretVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LockboxSecretVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LockboxSecretVersionEntryArgs', 'LockboxSecretVersionEntryArgsDict']]]]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LockboxSecretVersionArgs.__new__(LockboxSecretVersionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["entries"] = entries
            if secret_id is None and not opts.urn:
                raise TypeError("Missing required property 'secret_id'")
            __props__.__dict__["secret_id"] = secret_id
        super(LockboxSecretVersion, __self__).__init__(
            'yandex:index/lockboxSecretVersion:LockboxSecretVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LockboxSecretVersionEntryArgs', 'LockboxSecretVersionEntryArgsDict']]]]] = None,
            secret_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LockboxSecretVersion':
        """
        Get an existing LockboxSecretVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LockboxSecretVersionEntryArgs', 'LockboxSecretVersionEntryArgsDict']]]] entries: List of entries in the Yandex Cloud Lockbox secret version. Must be omitted for secrets with a payload specification.
        :param pulumi.Input[_builtins.str] secret_id: The Yandex Cloud Lockbox secret ID where to add the version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LockboxSecretVersionState.__new__(_LockboxSecretVersionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["secret_id"] = secret_id
        return LockboxSecretVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Optional[Sequence['outputs.LockboxSecretVersionEntry']]]:
        """
        List of entries in the Yandex Cloud Lockbox secret version. Must be omitted for secrets with a payload specification.
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Yandex Cloud Lockbox secret ID where to add the version.
        """
        return pulumi.get(self, "secret_id")

