# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbClickhouseClusterArgs', 'MdbClickhouseCluster']

@pulumi.input_type
class MdbClickhouseClusterArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[_builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]],
                 network_id: pulumi.Input[_builtins.str],
                 access: Optional[pulumi.Input['MdbClickhouseClusterAccessArgs']] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs']] = None,
                 clickhouse: Optional[pulumi.Input['MdbClickhouseClusterClickhouseArgs']] = None,
                 cloud_storage: Optional[pulumi.Input['MdbClickhouseClusterCloudStorageArgs']] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_schema_on_new_hosts: Optional[pulumi.Input[_builtins.bool]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 embedded_keeper: Optional[pulumi.Input[_builtins.bool]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format_schemas: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbClickhouseClusterMaintenanceWindowArgs']] = None,
                 ml_models: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_groups: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]]] = None,
                 shards: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]]] = None,
                 sql_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_user_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zookeeper: Optional[pulumi.Input['MdbClickhouseClusterZookeeperArgs']] = None):
        """
        The set of arguments for constructing a MdbClickhouseCluster resource.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the ClickHouse cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]] hosts: A host of the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbClickhouseClusterAccessArgs'] access: Access policy to the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] admin_password: A password used to authorize as user `admin` when `sql_user_management` enabled.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input['MdbClickhouseClusterClickhouseArgs'] clickhouse: Configuration of the ClickHouse subcluster.
        :param pulumi.Input['MdbClickhouseClusterCloudStorageArgs'] cloud_storage: Cloud Storage settings.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster identifier.
        :param pulumi.Input[_builtins.bool] copy_schema_on_new_hosts: Whether to copy schema on new ClickHouse hosts.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]] databases: A database of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[_builtins.bool] embedded_keeper: Whether to use ClickHouse Keeper as a coordination system and place it on the same hosts with ClickHouse. If not, it's used ZooKeeper with placement on separate hosts.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]] format_schemas: A set of `protobuf` or `capnproto` format schemas.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]] ml_models: A group of machine learning models.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]] shard_groups: A group of clickhouse shards.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]] shards: A shard of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] sql_database_management: Grants `admin` user database management permission.
        :param pulumi.Input[_builtins.bool] sql_user_management: Enables `admin` user with user management permission.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]] users: A user of the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] version: Version of the ClickHouse server software.
        :param pulumi.Input['MdbClickhouseClusterZookeeperArgs'] zookeeper: Configuration of the ZooKeeper subcluster.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if backup_retain_period_days is not None:
            pulumi.set(__self__, "backup_retain_period_days", backup_retain_period_days)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if clickhouse is not None:
            pulumi.set(__self__, "clickhouse", clickhouse)
        if cloud_storage is not None:
            pulumi.set(__self__, "cloud_storage", cloud_storage)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if copy_schema_on_new_hosts is not None:
            pulumi.set(__self__, "copy_schema_on_new_hosts", copy_schema_on_new_hosts)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_clickhouse_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_clickhouse_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if embedded_keeper is not None:
            pulumi.set(__self__, "embedded_keeper", embedded_keeper)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if format_schemas is not None:
            pulumi.set(__self__, "format_schemas", format_schemas)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if ml_models is not None:
            pulumi.set(__self__, "ml_models", ml_models)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if shard_groups is not None:
            pulumi.set(__self__, "shard_groups", shard_groups)
        if shards is not None:
            pulumi.set(__self__, "shards", shards)
        if sql_database_management is not None:
            pulumi.set(__self__, "sql_database_management", sql_database_management)
        if sql_user_management is not None:
            pulumi.set(__self__, "sql_user_management", sql_user_management)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_clickhouse_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_clickhouse_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zookeeper is not None:
            pulumi.set(__self__, "zookeeper", zookeeper)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment environment of the ClickHouse cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]]:
        """
        A host of the ClickHouse cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbClickhouseClusterAccessArgs']]:
        """
        Access policy to the ClickHouse cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbClickhouseClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A password used to authorize as user `admin` when `sql_user_management` enabled.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @backup_retain_period_days.setter
    def backup_retain_period_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retain_period_days", value)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC timezone.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter
    def clickhouse(self) -> Optional[pulumi.Input['MdbClickhouseClusterClickhouseArgs']]:
        """
        Configuration of the ClickHouse subcluster.
        """
        return pulumi.get(self, "clickhouse")

    @clickhouse.setter
    def clickhouse(self, value: Optional[pulumi.Input['MdbClickhouseClusterClickhouseArgs']]):
        pulumi.set(self, "clickhouse", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorage")
    def cloud_storage(self) -> Optional[pulumi.Input['MdbClickhouseClusterCloudStorageArgs']]:
        """
        Cloud Storage settings.
        """
        return pulumi.get(self, "cloud_storage")

    @cloud_storage.setter
    def cloud_storage(self, value: Optional[pulumi.Input['MdbClickhouseClusterCloudStorageArgs']]):
        pulumi.set(self, "cloud_storage", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster identifier.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="copySchemaOnNewHosts")
    def copy_schema_on_new_hosts(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to copy schema on new ClickHouse hosts.
        """
        return pulumi.get(self, "copy_schema_on_new_hosts")

    @copy_schema_on_new_hosts.setter
    def copy_schema_on_new_hosts(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_schema_on_new_hosts", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_clickhouse_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]]]:
        """
        A database of the ClickHouse cluster.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="embeddedKeeper")
    def embedded_keeper(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use ClickHouse Keeper as a coordination system and place it on the same hosts with ClickHouse. If not, it's used ZooKeeper with placement on separate hosts.
        """
        return pulumi.get(self, "embedded_keeper")

    @embedded_keeper.setter
    def embedded_keeper(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "embedded_keeper", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="formatSchemas")
    def format_schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]]]:
        """
        A set of `protobuf` or `capnproto` format schemas.
        """
        return pulumi.get(self, "format_schemas")

    @format_schemas.setter
    def format_schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]]]):
        pulumi.set(self, "format_schemas", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbClickhouseClusterMaintenanceWindowArgs']]:
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbClickhouseClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="mlModels")
    def ml_models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]]]:
        """
        A group of machine learning models.
        """
        return pulumi.get(self, "ml_models")

    @ml_models.setter
    def ml_models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]]]):
        pulumi.set(self, "ml_models", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="shardGroups")
    def shard_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]]]:
        """
        A group of clickhouse shards.
        """
        return pulumi.get(self, "shard_groups")

    @shard_groups.setter
    def shard_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]]]):
        pulumi.set(self, "shard_groups", value)

    @_builtins.property
    @pulumi.getter
    def shards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]]]:
        """
        A shard of the ClickHouse cluster.
        """
        return pulumi.get(self, "shards")

    @shards.setter
    def shards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]]]):
        pulumi.set(self, "shards", value)

    @_builtins.property
    @pulumi.getter(name="sqlDatabaseManagement")
    def sql_database_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants `admin` user database management permission.
        """
        return pulumi.get(self, "sql_database_management")

    @sql_database_management.setter
    def sql_database_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_database_management", value)

    @_builtins.property
    @pulumi.getter(name="sqlUserManagement")
    def sql_user_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables `admin` user with user management permission.
        """
        return pulumi.get(self, "sql_user_management")

    @sql_user_management.setter
    def sql_user_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_user_management", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_clickhouse_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]]]:
        """
        A user of the ClickHouse cluster.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the ClickHouse server software.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def zookeeper(self) -> Optional[pulumi.Input['MdbClickhouseClusterZookeeperArgs']]:
        """
        Configuration of the ZooKeeper subcluster.
        """
        return pulumi.get(self, "zookeeper")

    @zookeeper.setter
    def zookeeper(self, value: Optional[pulumi.Input['MdbClickhouseClusterZookeeperArgs']]):
        pulumi.set(self, "zookeeper", value)


@pulumi.input_type
class _MdbClickhouseClusterState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input['MdbClickhouseClusterAccessArgs']] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs']] = None,
                 clickhouse: Optional[pulumi.Input['MdbClickhouseClusterClickhouseArgs']] = None,
                 cloud_storage: Optional[pulumi.Input['MdbClickhouseClusterCloudStorageArgs']] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_schema_on_new_hosts: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 embedded_keeper: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format_schemas: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbClickhouseClusterMaintenanceWindowArgs']] = None,
                 ml_models: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_groups: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]]] = None,
                 shards: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]]] = None,
                 sql_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_user_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zookeeper: Optional[pulumi.Input['MdbClickhouseClusterZookeeperArgs']] = None):
        """
        Input properties used for looking up and filtering MdbClickhouseCluster resources.
        :param pulumi.Input['MdbClickhouseClusterAccessArgs'] access: Access policy to the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] admin_password: A password used to authorize as user `admin` when `sql_user_management` enabled.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input['MdbClickhouseClusterClickhouseArgs'] clickhouse: Configuration of the ClickHouse subcluster.
        :param pulumi.Input['MdbClickhouseClusterCloudStorageArgs'] cloud_storage: Cloud Storage settings.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster identifier.
        :param pulumi.Input[_builtins.bool] copy_schema_on_new_hosts: Whether to copy schema on new ClickHouse hosts.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]] databases: A database of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[_builtins.bool] embedded_keeper: Whether to use ClickHouse Keeper as a coordination system and place it on the same hosts with ClickHouse. If not, it's used ZooKeeper with placement on separate hosts.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the ClickHouse cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]] format_schemas: A set of `protobuf` or `capnproto` format schemas.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster. Can be `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]] hosts: A host of the ClickHouse cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]] ml_models: A group of machine learning models.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]] shard_groups: A group of clickhouse shards.
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]] shards: A shard of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] sql_database_management: Grants `admin` user database management permission.
        :param pulumi.Input[_builtins.bool] sql_user_management: Enables `admin` user with user management permission.
        :param pulumi.Input[_builtins.str] status: Status of the cluster. Can be `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]] users: A user of the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] version: Version of the ClickHouse server software.
        :param pulumi.Input['MdbClickhouseClusterZookeeperArgs'] zookeeper: Configuration of the ZooKeeper subcluster.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if backup_retain_period_days is not None:
            pulumi.set(__self__, "backup_retain_period_days", backup_retain_period_days)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if clickhouse is not None:
            pulumi.set(__self__, "clickhouse", clickhouse)
        if cloud_storage is not None:
            pulumi.set(__self__, "cloud_storage", cloud_storage)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if copy_schema_on_new_hosts is not None:
            pulumi.set(__self__, "copy_schema_on_new_hosts", copy_schema_on_new_hosts)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_clickhouse_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_clickhouse_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if embedded_keeper is not None:
            pulumi.set(__self__, "embedded_keeper", embedded_keeper)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if format_schemas is not None:
            pulumi.set(__self__, "format_schemas", format_schemas)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if ml_models is not None:
            pulumi.set(__self__, "ml_models", ml_models)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if shard_groups is not None:
            pulumi.set(__self__, "shard_groups", shard_groups)
        if shards is not None:
            pulumi.set(__self__, "shards", shards)
        if sql_database_management is not None:
            pulumi.set(__self__, "sql_database_management", sql_database_management)
        if sql_user_management is not None:
            pulumi.set(__self__, "sql_user_management", sql_user_management)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_clickhouse_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_clickhouse_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zookeeper is not None:
            pulumi.set(__self__, "zookeeper", zookeeper)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbClickhouseClusterAccessArgs']]:
        """
        Access policy to the ClickHouse cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbClickhouseClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A password used to authorize as user `admin` when `sql_user_management` enabled.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @backup_retain_period_days.setter
    def backup_retain_period_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retain_period_days", value)

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC timezone.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbClickhouseClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @_builtins.property
    @pulumi.getter
    def clickhouse(self) -> Optional[pulumi.Input['MdbClickhouseClusterClickhouseArgs']]:
        """
        Configuration of the ClickHouse subcluster.
        """
        return pulumi.get(self, "clickhouse")

    @clickhouse.setter
    def clickhouse(self, value: Optional[pulumi.Input['MdbClickhouseClusterClickhouseArgs']]):
        pulumi.set(self, "clickhouse", value)

    @_builtins.property
    @pulumi.getter(name="cloudStorage")
    def cloud_storage(self) -> Optional[pulumi.Input['MdbClickhouseClusterCloudStorageArgs']]:
        """
        Cloud Storage settings.
        """
        return pulumi.get(self, "cloud_storage")

    @cloud_storage.setter
    def cloud_storage(self, value: Optional[pulumi.Input['MdbClickhouseClusterCloudStorageArgs']]):
        pulumi.set(self, "cloud_storage", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster identifier.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="copySchemaOnNewHosts")
    def copy_schema_on_new_hosts(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to copy schema on new ClickHouse hosts.
        """
        return pulumi.get(self, "copy_schema_on_new_hosts")

    @copy_schema_on_new_hosts.setter
    def copy_schema_on_new_hosts(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_schema_on_new_hosts", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_clickhouse_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]]]:
        """
        A database of the ClickHouse cluster.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="embeddedKeeper")
    def embedded_keeper(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use ClickHouse Keeper as a coordination system and place it on the same hosts with ClickHouse. If not, it's used ZooKeeper with placement on separate hosts.
        """
        return pulumi.get(self, "embedded_keeper")

    @embedded_keeper.setter
    def embedded_keeper(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "embedded_keeper", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the ClickHouse cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="formatSchemas")
    def format_schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]]]:
        """
        A set of `protobuf` or `capnproto` format schemas.
        """
        return pulumi.get(self, "format_schemas")

    @format_schemas.setter
    def format_schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterFormatSchemaArgs']]]]):
        pulumi.set(self, "format_schemas", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregated health of the cluster. Can be `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]]]:
        """
        A host of the ClickHouse cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbClickhouseClusterMaintenanceWindowArgs']]:
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbClickhouseClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="mlModels")
    def ml_models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]]]:
        """
        A group of machine learning models.
        """
        return pulumi.get(self, "ml_models")

    @ml_models.setter
    def ml_models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterMlModelArgs']]]]):
        pulumi.set(self, "ml_models", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="shardGroups")
    def shard_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]]]:
        """
        A group of clickhouse shards.
        """
        return pulumi.get(self, "shard_groups")

    @shard_groups.setter
    def shard_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardGroupArgs']]]]):
        pulumi.set(self, "shard_groups", value)

    @_builtins.property
    @pulumi.getter
    def shards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]]]:
        """
        A shard of the ClickHouse cluster.
        """
        return pulumi.get(self, "shards")

    @shards.setter
    def shards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterShardArgs']]]]):
        pulumi.set(self, "shards", value)

    @_builtins.property
    @pulumi.getter(name="sqlDatabaseManagement")
    def sql_database_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Grants `admin` user database management permission.
        """
        return pulumi.get(self, "sql_database_management")

    @sql_database_management.setter
    def sql_database_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_database_management", value)

    @_builtins.property
    @pulumi.getter(name="sqlUserManagement")
    def sql_user_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables `admin` user with user management permission.
        """
        return pulumi.get(self, "sql_user_management")

    @sql_user_management.setter
    def sql_user_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sql_user_management", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the cluster. Can be `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_clickhouse_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]]]:
        """
        A user of the ClickHouse cluster.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbClickhouseClusterUserArgs']]]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the ClickHouse server software.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def zookeeper(self) -> Optional[pulumi.Input['MdbClickhouseClusterZookeeperArgs']]:
        """
        Configuration of the ZooKeeper subcluster.
        """
        return pulumi.get(self, "zookeeper")

    @zookeeper.setter
    def zookeeper(self, value: Optional[pulumi.Input['MdbClickhouseClusterZookeeperArgs']]):
        pulumi.set(self, "zookeeper", value)


@pulumi.type_token("yandex:index/mdbClickhouseCluster:MdbClickhouseCluster")
class MdbClickhouseCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbClickhouseClusterAccessArgs', 'MdbClickhouseClusterAccessArgsDict']]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbClickhouseClusterBackupWindowStartArgs', 'MdbClickhouseClusterBackupWindowStartArgsDict']]] = None,
                 clickhouse: Optional[pulumi.Input[Union['MdbClickhouseClusterClickhouseArgs', 'MdbClickhouseClusterClickhouseArgsDict']]] = None,
                 cloud_storage: Optional[pulumi.Input[Union['MdbClickhouseClusterCloudStorageArgs', 'MdbClickhouseClusterCloudStorageArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_schema_on_new_hosts: Optional[pulumi.Input[_builtins.bool]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterDatabaseArgs', 'MdbClickhouseClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 embedded_keeper: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format_schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterFormatSchemaArgs', 'MdbClickhouseClusterFormatSchemaArgsDict']]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterHostArgs', 'MdbClickhouseClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbClickhouseClusterMaintenanceWindowArgs', 'MdbClickhouseClusterMaintenanceWindowArgsDict']]] = None,
                 ml_models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterMlModelArgs', 'MdbClickhouseClusterMlModelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardGroupArgs', 'MdbClickhouseClusterShardGroupArgsDict']]]]] = None,
                 shards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardArgs', 'MdbClickhouseClusterShardArgsDict']]]]] = None,
                 sql_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_user_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterUserArgs', 'MdbClickhouseClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zookeeper: Optional[pulumi.Input[Union['MdbClickhouseClusterZookeeperArgs', 'MdbClickhouseClusterZookeeperArgsDict']]] = None,
                 __props__=None):
        """
        Manages a ClickHouse cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-clickhouse/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB Clickhouse Cluster.
        #
        my_cluster = yandex.MdbClickhouseCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            clickhouse={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 32,
                },
                "config": {
                    "log_level": "TRACE",
                    "max_connections": 100,
                    "max_concurrent_queries": 50,
                    "keep_alive_timeout": 3000,
                    "uncompressed_cache_size": 8589934592,
                    "mark_cache_size": 5368709120,
                    "max_table_size_to_drop": 53687091200,
                    "max_partition_size_to_drop": 53687091200,
                    "timezone": "UTC",
                    "geobase_uri": "",
                    "query_log_retention_size": 1073741824,
                    "query_log_retention_time": 2592000,
                    "query_thread_log_enabled": True,
                    "query_thread_log_retention_size": 536870912,
                    "query_thread_log_retention_time": 2592000,
                    "part_log_retention_size": 536870912,
                    "part_log_retention_time": 2592000,
                    "metric_log_enabled": True,
                    "metric_log_retention_size": 536870912,
                    "metric_log_retention_time": 2592000,
                    "trace_log_enabled": True,
                    "trace_log_retention_size": 536870912,
                    "trace_log_retention_time": 2592000,
                    "text_log_enabled": True,
                    "text_log_retention_size": 536870912,
                    "text_log_retention_time": 2592000,
                    "text_log_level": "TRACE",
                    "background_pool_size": 16,
                    "background_schedule_pool_size": 16,
                    "merge_tree": {
                        "replicated_deduplication_window": 100,
                        "replicated_deduplication_window_seconds": 604800,
                        "parts_to_delay_insert": 150,
                        "parts_to_throw_insert": 300,
                        "max_replicated_merges_in_queue": 16,
                        "number_of_free_entries_in_pool_to_lower_max_size_of_merge": 8,
                        "max_bytes_to_merge_at_min_space_in_pool": 1048576,
                        "max_bytes_to_merge_at_max_space_in_pool": 161061273600,
                    },
                    "kafka": {
                        "security_protocol": "SECURITY_PROTOCOL_PLAINTEXT",
                        "sasl_mechanism": "SASL_MECHANISM_GSSAPI",
                        "sasl_username": "user1",
                        "sasl_password": "pass1",
                    },
                    "kafka_topics": [
                        {
                            "name": "topic1",
                            "settings": {
                                "security_protocol": "SECURITY_PROTOCOL_SSL",
                                "sasl_mechanism": "SASL_MECHANISM_SCRAM_SHA_256",
                                "sasl_username": "user2",
                                "sasl_password": "pass2",
                            },
                        },
                        {
                            "name": "topic2",
                            "settings": {
                                "security_protocol": "SECURITY_PROTOCOL_SASL_PLAINTEXT",
                                "sasl_mechanism": "SASL_MECHANISM_PLAIN",
                            },
                        },
                    ],
                    "rabbitmq": {
                        "username": "rabbit_user",
                        "password": "rabbit_pass",
                    },
                    "compressions": [
                        {
                            "method": "LZ4",
                            "min_part_size": 1024,
                            "min_part_size_ratio": 0.5,
                        },
                        {
                            "method": "ZSTD",
                            "min_part_size": 2048,
                            "min_part_size_ratio": 0.7,
                        },
                    ],
                    "graphite_rollups": [
                        {
                            "name": "rollup1",
                            "patterns": [{
                                "regexp": "abc",
                                "function": "func1",
                                "retentions": [{
                                    "age": 1000,
                                    "precision": 3,
                                }],
                            }],
                        },
                        {
                            "name": "rollup2",
                            "patterns": [{
                                "function": "func2",
                                "retentions": [{
                                    "age": 2000,
                                    "precision": 5,
                                }],
                            }],
                        },
                    ],
                },
            },
            databases=[{
                "name": "db_name",
            }],
            users=[{
                "name": "user",
                "password": "your_password",
                "permissions": [{
                    "database_name": "db_name",
                }],
                "settings": {
                    "max_memory_usage_for_user": 1000000000,
                    "read_overflow_mode": "throw",
                    "output_format_json_quote64bit_integers": True,
                },
                "quotas": [
                    {
                        "interval_duration": 3600000,
                        "queries": 10000,
                        "errors": 1000,
                    },
                    {
                        "interval_duration": 79800000,
                        "queries": 50000,
                        "errors": 5000,
                    },
                ],
            }],
            hosts=[{
                "type": "CLICKHOUSE",
                "zone": "ru-central1-a",
                "subnet_id": foo_vpc_subnet.id,
            }],
            format_schemas=[{
                "name": "test_schema",
                "type": "FORMAT_SCHEMA_TYPE_CAPNPROTO",
                "uri": "https://storage.yandexcloud.net/ch-data/schema.proto",
            }],
            ml_models=[{
                "name": "test_model",
                "type": "ML_MODEL_TYPE_CATBOOST",
                "uri": "https://storage.yandexcloud.net/ch-data/train.csv",
            }],
            service_account_id="your_service_account_id",
            cloud_storage={
                "enabled": False,
            },
            maintenance_window={
                "type": "ANYTIME",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        baz = yandex.VpcSubnet("baz",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB High Availability Clickhouse Cluster.
        #
        my_cluster = yandex.MdbClickhouseCluster("my_cluster",
            name="ha",
            environment="PRESTABLE",
            network_id=foo.id,
            clickhouse={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            zookeeper={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 10,
                },
            },
            databases=[{
                "name": "db_name",
            }],
            users=[{
                "name": "user",
                "password": "password",
                "permissions": [{
                    "database_name": "db_name",
                }],
                "settings": {
                    "max_memory_usage_for_user": 1000000000,
                    "read_overflow_mode": "throw",
                    "output_format_json_quote64bit_integers": True,
                },
                "quotas": [
                    {
                        "interval_duration": 3600000,
                        "queries": 10000,
                        "errors": 1000,
                    },
                    {
                        "interval_duration": 79800000,
                        "queries": 50000,
                        "errors": 5000,
                    },
                ],
            }],
            hosts=[
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                },
                {
                    "type": "ZOOKEEPER",
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "type": "ZOOKEEPER",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                },
                {
                    "type": "ZOOKEEPER",
                    "zone": "ru-central1-d",
                    "subnet_id": baz.id,
                },
            ],
            cloud_storage={
                "enabled": False,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        baz = yandex.VpcSubnet("baz",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB Sharded Clickhouse Cluster.
        #
        my_cluster = yandex.MdbClickhouseCluster("my_cluster",
            name="sharded",
            environment="PRODUCTION",
            network_id=foo.id,
            clickhouse={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            zookeeper={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 10,
                },
            },
            databases=[{
                "name": "db_name",
            }],
            users=[{
                "name": "user",
                "password": "password",
                "permissions": [{
                    "database_name": "db_name",
                }],
                "settings": {
                    "max_memory_usage_for_user": 1000000000,
                    "read_overflow_mode": "throw",
                    "output_format_json_quote64bit_integers": True,
                },
                "quotas": [
                    {
                        "interval_duration": 3600000,
                        "queries": 10000,
                        "errors": 1000,
                    },
                    {
                        "interval_duration": 79800000,
                        "queries": 50000,
                        "errors": 5000,
                    },
                ],
            }],
            shards=[
                {
                    "name": "shard1",
                    "weight": 110,
                },
                {
                    "name": "shard2",
                    "weight": 300,
                },
            ],
            hosts=[
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                    "shard_name": "shard1",
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                    "shard_name": "shard1",
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                    "shard_name": "shard2",
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-d",
                    "subnet_id": baz.id,
                    "shard_name": "shard2",
                },
            ],
            shard_groups=[{
                "name": "single_shard_group",
                "description": "Cluster configuration that contain only shard1",
                "shard_names": ["shard1"],
            }],
            cloud_storage={
                "enabled": False,
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbClickhouseCluster:MdbClickhouseCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbClickhouseCluster:MdbClickhouseCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbClickhouseClusterAccessArgs', 'MdbClickhouseClusterAccessArgsDict']] access: Access policy to the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] admin_password: A password used to authorize as user `admin` when `sql_user_management` enabled.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input[Union['MdbClickhouseClusterBackupWindowStartArgs', 'MdbClickhouseClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input[Union['MdbClickhouseClusterClickhouseArgs', 'MdbClickhouseClusterClickhouseArgsDict']] clickhouse: Configuration of the ClickHouse subcluster.
        :param pulumi.Input[Union['MdbClickhouseClusterCloudStorageArgs', 'MdbClickhouseClusterCloudStorageArgsDict']] cloud_storage: Cloud Storage settings.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster identifier.
        :param pulumi.Input[_builtins.bool] copy_schema_on_new_hosts: Whether to copy schema on new ClickHouse hosts.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterDatabaseArgs', 'MdbClickhouseClusterDatabaseArgsDict']]]] databases: A database of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[_builtins.bool] embedded_keeper: Whether to use ClickHouse Keeper as a coordination system and place it on the same hosts with ClickHouse. If not, it's used ZooKeeper with placement on separate hosts.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the ClickHouse cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterFormatSchemaArgs', 'MdbClickhouseClusterFormatSchemaArgsDict']]]] format_schemas: A set of `protobuf` or `capnproto` format schemas.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterHostArgs', 'MdbClickhouseClusterHostArgsDict']]]] hosts: A host of the ClickHouse cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterMlModelArgs', 'MdbClickhouseClusterMlModelArgsDict']]]] ml_models: A group of machine learning models.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardGroupArgs', 'MdbClickhouseClusterShardGroupArgsDict']]]] shard_groups: A group of clickhouse shards.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardArgs', 'MdbClickhouseClusterShardArgsDict']]]] shards: A shard of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] sql_database_management: Grants `admin` user database management permission.
        :param pulumi.Input[_builtins.bool] sql_user_management: Enables `admin` user with user management permission.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterUserArgs', 'MdbClickhouseClusterUserArgsDict']]]] users: A user of the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] version: Version of the ClickHouse server software.
        :param pulumi.Input[Union['MdbClickhouseClusterZookeeperArgs', 'MdbClickhouseClusterZookeeperArgsDict']] zookeeper: Configuration of the ZooKeeper subcluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbClickhouseClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a ClickHouse cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-clickhouse/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB Clickhouse Cluster.
        #
        my_cluster = yandex.MdbClickhouseCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            clickhouse={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 32,
                },
                "config": {
                    "log_level": "TRACE",
                    "max_connections": 100,
                    "max_concurrent_queries": 50,
                    "keep_alive_timeout": 3000,
                    "uncompressed_cache_size": 8589934592,
                    "mark_cache_size": 5368709120,
                    "max_table_size_to_drop": 53687091200,
                    "max_partition_size_to_drop": 53687091200,
                    "timezone": "UTC",
                    "geobase_uri": "",
                    "query_log_retention_size": 1073741824,
                    "query_log_retention_time": 2592000,
                    "query_thread_log_enabled": True,
                    "query_thread_log_retention_size": 536870912,
                    "query_thread_log_retention_time": 2592000,
                    "part_log_retention_size": 536870912,
                    "part_log_retention_time": 2592000,
                    "metric_log_enabled": True,
                    "metric_log_retention_size": 536870912,
                    "metric_log_retention_time": 2592000,
                    "trace_log_enabled": True,
                    "trace_log_retention_size": 536870912,
                    "trace_log_retention_time": 2592000,
                    "text_log_enabled": True,
                    "text_log_retention_size": 536870912,
                    "text_log_retention_time": 2592000,
                    "text_log_level": "TRACE",
                    "background_pool_size": 16,
                    "background_schedule_pool_size": 16,
                    "merge_tree": {
                        "replicated_deduplication_window": 100,
                        "replicated_deduplication_window_seconds": 604800,
                        "parts_to_delay_insert": 150,
                        "parts_to_throw_insert": 300,
                        "max_replicated_merges_in_queue": 16,
                        "number_of_free_entries_in_pool_to_lower_max_size_of_merge": 8,
                        "max_bytes_to_merge_at_min_space_in_pool": 1048576,
                        "max_bytes_to_merge_at_max_space_in_pool": 161061273600,
                    },
                    "kafka": {
                        "security_protocol": "SECURITY_PROTOCOL_PLAINTEXT",
                        "sasl_mechanism": "SASL_MECHANISM_GSSAPI",
                        "sasl_username": "user1",
                        "sasl_password": "pass1",
                    },
                    "kafka_topics": [
                        {
                            "name": "topic1",
                            "settings": {
                                "security_protocol": "SECURITY_PROTOCOL_SSL",
                                "sasl_mechanism": "SASL_MECHANISM_SCRAM_SHA_256",
                                "sasl_username": "user2",
                                "sasl_password": "pass2",
                            },
                        },
                        {
                            "name": "topic2",
                            "settings": {
                                "security_protocol": "SECURITY_PROTOCOL_SASL_PLAINTEXT",
                                "sasl_mechanism": "SASL_MECHANISM_PLAIN",
                            },
                        },
                    ],
                    "rabbitmq": {
                        "username": "rabbit_user",
                        "password": "rabbit_pass",
                    },
                    "compressions": [
                        {
                            "method": "LZ4",
                            "min_part_size": 1024,
                            "min_part_size_ratio": 0.5,
                        },
                        {
                            "method": "ZSTD",
                            "min_part_size": 2048,
                            "min_part_size_ratio": 0.7,
                        },
                    ],
                    "graphite_rollups": [
                        {
                            "name": "rollup1",
                            "patterns": [{
                                "regexp": "abc",
                                "function": "func1",
                                "retentions": [{
                                    "age": 1000,
                                    "precision": 3,
                                }],
                            }],
                        },
                        {
                            "name": "rollup2",
                            "patterns": [{
                                "function": "func2",
                                "retentions": [{
                                    "age": 2000,
                                    "precision": 5,
                                }],
                            }],
                        },
                    ],
                },
            },
            databases=[{
                "name": "db_name",
            }],
            users=[{
                "name": "user",
                "password": "your_password",
                "permissions": [{
                    "database_name": "db_name",
                }],
                "settings": {
                    "max_memory_usage_for_user": 1000000000,
                    "read_overflow_mode": "throw",
                    "output_format_json_quote64bit_integers": True,
                },
                "quotas": [
                    {
                        "interval_duration": 3600000,
                        "queries": 10000,
                        "errors": 1000,
                    },
                    {
                        "interval_duration": 79800000,
                        "queries": 50000,
                        "errors": 5000,
                    },
                ],
            }],
            hosts=[{
                "type": "CLICKHOUSE",
                "zone": "ru-central1-a",
                "subnet_id": foo_vpc_subnet.id,
            }],
            format_schemas=[{
                "name": "test_schema",
                "type": "FORMAT_SCHEMA_TYPE_CAPNPROTO",
                "uri": "https://storage.yandexcloud.net/ch-data/schema.proto",
            }],
            ml_models=[{
                "name": "test_model",
                "type": "ML_MODEL_TYPE_CATBOOST",
                "uri": "https://storage.yandexcloud.net/ch-data/train.csv",
            }],
            service_account_id="your_service_account_id",
            cloud_storage={
                "enabled": False,
            },
            maintenance_window={
                "type": "ANYTIME",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        baz = yandex.VpcSubnet("baz",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB High Availability Clickhouse Cluster.
        #
        my_cluster = yandex.MdbClickhouseCluster("my_cluster",
            name="ha",
            environment="PRESTABLE",
            network_id=foo.id,
            clickhouse={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            zookeeper={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 10,
                },
            },
            databases=[{
                "name": "db_name",
            }],
            users=[{
                "name": "user",
                "password": "password",
                "permissions": [{
                    "database_name": "db_name",
                }],
                "settings": {
                    "max_memory_usage_for_user": 1000000000,
                    "read_overflow_mode": "throw",
                    "output_format_json_quote64bit_integers": True,
                },
                "quotas": [
                    {
                        "interval_duration": 3600000,
                        "queries": 10000,
                        "errors": 1000,
                    },
                    {
                        "interval_duration": 79800000,
                        "queries": 50000,
                        "errors": 5000,
                    },
                ],
            }],
            hosts=[
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                },
                {
                    "type": "ZOOKEEPER",
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                },
                {
                    "type": "ZOOKEEPER",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                },
                {
                    "type": "ZOOKEEPER",
                    "zone": "ru-central1-d",
                    "subnet_id": baz.id,
                },
            ],
            cloud_storage={
                "enabled": False,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-b",
            network_id=foo.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        baz = yandex.VpcSubnet("baz",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB Sharded Clickhouse Cluster.
        #
        my_cluster = yandex.MdbClickhouseCluster("my_cluster",
            name="sharded",
            environment="PRODUCTION",
            network_id=foo.id,
            clickhouse={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            zookeeper={
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 10,
                },
            },
            databases=[{
                "name": "db_name",
            }],
            users=[{
                "name": "user",
                "password": "password",
                "permissions": [{
                    "database_name": "db_name",
                }],
                "settings": {
                    "max_memory_usage_for_user": 1000000000,
                    "read_overflow_mode": "throw",
                    "output_format_json_quote64bit_integers": True,
                },
                "quotas": [
                    {
                        "interval_duration": 3600000,
                        "queries": 10000,
                        "errors": 1000,
                    },
                    {
                        "interval_duration": 79800000,
                        "queries": 50000,
                        "errors": 5000,
                    },
                ],
            }],
            shards=[
                {
                    "name": "shard1",
                    "weight": 110,
                },
                {
                    "name": "shard2",
                    "weight": 300,
                },
            ],
            hosts=[
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                    "shard_name": "shard1",
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                    "shard_name": "shard1",
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                    "shard_name": "shard2",
                },
                {
                    "type": "CLICKHOUSE",
                    "zone": "ru-central1-d",
                    "subnet_id": baz.id,
                    "shard_name": "shard2",
                },
            ],
            shard_groups=[{
                "name": "single_shard_group",
                "description": "Cluster configuration that contain only shard1",
                "shard_names": ["shard1"],
            }],
            cloud_storage={
                "enabled": False,
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbClickhouseCluster:MdbClickhouseCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbClickhouseCluster:MdbClickhouseCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbClickhouseClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbClickhouseClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbClickhouseClusterAccessArgs', 'MdbClickhouseClusterAccessArgsDict']]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbClickhouseClusterBackupWindowStartArgs', 'MdbClickhouseClusterBackupWindowStartArgsDict']]] = None,
                 clickhouse: Optional[pulumi.Input[Union['MdbClickhouseClusterClickhouseArgs', 'MdbClickhouseClusterClickhouseArgsDict']]] = None,
                 cloud_storage: Optional[pulumi.Input[Union['MdbClickhouseClusterCloudStorageArgs', 'MdbClickhouseClusterCloudStorageArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_schema_on_new_hosts: Optional[pulumi.Input[_builtins.bool]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterDatabaseArgs', 'MdbClickhouseClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 embedded_keeper: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 format_schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterFormatSchemaArgs', 'MdbClickhouseClusterFormatSchemaArgsDict']]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterHostArgs', 'MdbClickhouseClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbClickhouseClusterMaintenanceWindowArgs', 'MdbClickhouseClusterMaintenanceWindowArgsDict']]] = None,
                 ml_models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterMlModelArgs', 'MdbClickhouseClusterMlModelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 shard_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardGroupArgs', 'MdbClickhouseClusterShardGroupArgsDict']]]]] = None,
                 shards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardArgs', 'MdbClickhouseClusterShardArgsDict']]]]] = None,
                 sql_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 sql_user_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterUserArgs', 'MdbClickhouseClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zookeeper: Optional[pulumi.Input[Union['MdbClickhouseClusterZookeeperArgs', 'MdbClickhouseClusterZookeeperArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbClickhouseClusterArgs.__new__(MdbClickhouseClusterArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["backup_retain_period_days"] = backup_retain_period_days
            __props__.__dict__["backup_window_start"] = backup_window_start
            __props__.__dict__["clickhouse"] = clickhouse
            __props__.__dict__["cloud_storage"] = cloud_storage
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["copy_schema_on_new_hosts"] = copy_schema_on_new_hosts
            __props__.__dict__["databases"] = databases
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
            __props__.__dict__["embedded_keeper"] = embedded_keeper
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["format_schemas"] = format_schemas
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["ml_models"] = ml_models
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["shard_groups"] = shard_groups
            __props__.__dict__["shards"] = shards
            __props__.__dict__["sql_database_management"] = sql_database_management
            __props__.__dict__["sql_user_management"] = sql_user_management
            __props__.__dict__["users"] = users
            __props__.__dict__["version"] = version
            __props__.__dict__["zookeeper"] = zookeeper
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MdbClickhouseCluster, __self__).__init__(
            'yandex:index/mdbClickhouseCluster:MdbClickhouseCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[Union['MdbClickhouseClusterAccessArgs', 'MdbClickhouseClusterAccessArgsDict']]] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            backup_retain_period_days: Optional[pulumi.Input[_builtins.int]] = None,
            backup_window_start: Optional[pulumi.Input[Union['MdbClickhouseClusterBackupWindowStartArgs', 'MdbClickhouseClusterBackupWindowStartArgsDict']]] = None,
            clickhouse: Optional[pulumi.Input[Union['MdbClickhouseClusterClickhouseArgs', 'MdbClickhouseClusterClickhouseArgsDict']]] = None,
            cloud_storage: Optional[pulumi.Input[Union['MdbClickhouseClusterCloudStorageArgs', 'MdbClickhouseClusterCloudStorageArgsDict']]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            copy_schema_on_new_hosts: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterDatabaseArgs', 'MdbClickhouseClusterDatabaseArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            embedded_keeper: Optional[pulumi.Input[_builtins.bool]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            format_schemas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterFormatSchemaArgs', 'MdbClickhouseClusterFormatSchemaArgsDict']]]]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterHostArgs', 'MdbClickhouseClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbClickhouseClusterMaintenanceWindowArgs', 'MdbClickhouseClusterMaintenanceWindowArgsDict']]] = None,
            ml_models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterMlModelArgs', 'MdbClickhouseClusterMlModelArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            shard_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardGroupArgs', 'MdbClickhouseClusterShardGroupArgsDict']]]]] = None,
            shards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardArgs', 'MdbClickhouseClusterShardArgsDict']]]]] = None,
            sql_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
            sql_user_management: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterUserArgs', 'MdbClickhouseClusterUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            zookeeper: Optional[pulumi.Input[Union['MdbClickhouseClusterZookeeperArgs', 'MdbClickhouseClusterZookeeperArgsDict']]] = None) -> 'MdbClickhouseCluster':
        """
        Get an existing MdbClickhouseCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbClickhouseClusterAccessArgs', 'MdbClickhouseClusterAccessArgsDict']] access: Access policy to the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] admin_password: A password used to authorize as user `admin` when `sql_user_management` enabled.
        :param pulumi.Input[_builtins.int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input[Union['MdbClickhouseClusterBackupWindowStartArgs', 'MdbClickhouseClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC timezone.
        :param pulumi.Input[Union['MdbClickhouseClusterClickhouseArgs', 'MdbClickhouseClusterClickhouseArgsDict']] clickhouse: Configuration of the ClickHouse subcluster.
        :param pulumi.Input[Union['MdbClickhouseClusterCloudStorageArgs', 'MdbClickhouseClusterCloudStorageArgsDict']] cloud_storage: Cloud Storage settings.
        :param pulumi.Input[_builtins.str] cluster_id: The cluster identifier.
        :param pulumi.Input[_builtins.bool] copy_schema_on_new_hosts: Whether to copy schema on new ClickHouse hosts.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterDatabaseArgs', 'MdbClickhouseClusterDatabaseArgsDict']]]] databases: A database of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[_builtins.bool] embedded_keeper: Whether to use ClickHouse Keeper as a coordination system and place it on the same hosts with ClickHouse. If not, it's used ZooKeeper with placement on separate hosts.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the ClickHouse cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterFormatSchemaArgs', 'MdbClickhouseClusterFormatSchemaArgsDict']]]] format_schemas: A set of `protobuf` or `capnproto` format schemas.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster. Can be `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterHostArgs', 'MdbClickhouseClusterHostArgsDict']]]] hosts: A host of the ClickHouse cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterMlModelArgs', 'MdbClickhouseClusterMlModelArgsDict']]]] ml_models: A group of machine learning models.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardGroupArgs', 'MdbClickhouseClusterShardGroupArgsDict']]]] shard_groups: A group of clickhouse shards.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterShardArgs', 'MdbClickhouseClusterShardArgsDict']]]] shards: A shard of the ClickHouse cluster.
        :param pulumi.Input[_builtins.bool] sql_database_management: Grants `admin` user database management permission.
        :param pulumi.Input[_builtins.bool] sql_user_management: Enables `admin` user with user management permission.
        :param pulumi.Input[_builtins.str] status: Status of the cluster. Can be `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbClickhouseClusterUserArgs', 'MdbClickhouseClusterUserArgsDict']]]] users: A user of the ClickHouse cluster.
        :param pulumi.Input[_builtins.str] version: Version of the ClickHouse server software.
        :param pulumi.Input[Union['MdbClickhouseClusterZookeeperArgs', 'MdbClickhouseClusterZookeeperArgsDict']] zookeeper: Configuration of the ZooKeeper subcluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbClickhouseClusterState.__new__(_MdbClickhouseClusterState)

        __props__.__dict__["access"] = access
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["backup_retain_period_days"] = backup_retain_period_days
        __props__.__dict__["backup_window_start"] = backup_window_start
        __props__.__dict__["clickhouse"] = clickhouse
        __props__.__dict__["cloud_storage"] = cloud_storage
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["copy_schema_on_new_hosts"] = copy_schema_on_new_hosts
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["databases"] = databases
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
        __props__.__dict__["embedded_keeper"] = embedded_keeper
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["format_schemas"] = format_schemas
        __props__.__dict__["health"] = health
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["ml_models"] = ml_models
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["shard_groups"] = shard_groups
        __props__.__dict__["shards"] = shards
        __props__.__dict__["sql_database_management"] = sql_database_management
        __props__.__dict__["sql_user_management"] = sql_user_management
        __props__.__dict__["status"] = status
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        __props__.__dict__["zookeeper"] = zookeeper
        return MdbClickhouseCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def access(self) -> pulumi.Output['outputs.MdbClickhouseClusterAccess']:
        """
        Access policy to the ClickHouse cluster.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A password used to authorize as user `admin` when `sql_user_management` enabled.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @_builtins.property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> pulumi.Output['outputs.MdbClickhouseClusterBackupWindowStart']:
        """
        Time to start the daily backup, in the UTC timezone.
        """
        return pulumi.get(self, "backup_window_start")

    @_builtins.property
    @pulumi.getter
    def clickhouse(self) -> pulumi.Output['outputs.MdbClickhouseClusterClickhouse']:
        """
        Configuration of the ClickHouse subcluster.
        """
        return pulumi.get(self, "clickhouse")

    @_builtins.property
    @pulumi.getter(name="cloudStorage")
    def cloud_storage(self) -> pulumi.Output['outputs.MdbClickhouseClusterCloudStorage']:
        """
        Cloud Storage settings.
        """
        return pulumi.get(self, "cloud_storage")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster identifier.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="copySchemaOnNewHosts")
    def copy_schema_on_new_hosts(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to copy schema on new ClickHouse hosts.
        """
        return pulumi.get(self, "copy_schema_on_new_hosts")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_clickhouse_database""")
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.MdbClickhouseClusterDatabase']]]:
        """
        A database of the ClickHouse cluster.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @_builtins.property
    @pulumi.getter(name="embeddedKeeper")
    def embedded_keeper(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to use ClickHouse Keeper as a coordination system and place it on the same hosts with ClickHouse. If not, it's used ZooKeeper with placement on separate hosts.
        """
        return pulumi.get(self, "embedded_keeper")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment environment of the ClickHouse cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="formatSchemas")
    def format_schemas(self) -> pulumi.Output[Optional[Sequence['outputs.MdbClickhouseClusterFormatSchema']]]:
        """
        A set of `protobuf` or `capnproto` format schemas.
        """
        return pulumi.get(self, "format_schemas")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregated health of the cluster. Can be `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbClickhouseClusterHost']]:
        """
        A host of the ClickHouse cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbClickhouseClusterMaintenanceWindow']:
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="mlModels")
    def ml_models(self) -> pulumi.Output[Optional[Sequence['outputs.MdbClickhouseClusterMlModel']]]:
        """
        A group of machine learning models.
        """
        return pulumi.get(self, "ml_models")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="shardGroups")
    def shard_groups(self) -> pulumi.Output[Optional[Sequence['outputs.MdbClickhouseClusterShardGroup']]]:
        """
        A group of clickhouse shards.
        """
        return pulumi.get(self, "shard_groups")

    @_builtins.property
    @pulumi.getter
    def shards(self) -> pulumi.Output[Sequence['outputs.MdbClickhouseClusterShard']]:
        """
        A shard of the ClickHouse cluster.
        """
        return pulumi.get(self, "shards")

    @_builtins.property
    @pulumi.getter(name="sqlDatabaseManagement")
    def sql_database_management(self) -> pulumi.Output[_builtins.bool]:
        """
        Grants `admin` user database management permission.
        """
        return pulumi.get(self, "sql_database_management")

    @_builtins.property
    @pulumi.getter(name="sqlUserManagement")
    def sql_user_management(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables `admin` user with user management permission.
        """
        return pulumi.get(self, "sql_user_management")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the cluster. Can be `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-clickhouse/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_clickhouse_user""")
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.MdbClickhouseClusterUser']]]:
        """
        A user of the ClickHouse cluster.
        """
        return pulumi.get(self, "users")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the ClickHouse server software.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def zookeeper(self) -> pulumi.Output['outputs.MdbClickhouseClusterZookeeper']:
        """
        Configuration of the ZooKeeper subcluster.
        """
        return pulumi.get(self, "zookeeper")

