# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbKafkaConnectorArgs', 'MdbKafkaConnector']

@pulumi.input_type
class MdbKafkaConnectorArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tasks_max: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a MdbKafkaConnector resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]] connector_config_mirrormakers: Settings for MirrorMaker2 connector.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]] connector_config_s3_sinks: Settings for S3 Sink connector.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Additional properties for connector.
        :param pulumi.Input[_builtins.int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if connector_config_mirrormakers is not None:
            pulumi.set(__self__, "connector_config_mirrormakers", connector_config_mirrormakers)
        if connector_config_s3_sinks is not None:
            pulumi.set(__self__, "connector_config_s3_sinks", connector_config_s3_sinks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tasks_max is not None:
            pulumi.set(__self__, "tasks_max", tasks_max)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="connectorConfigMirrormakers")
    def connector_config_mirrormakers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]:
        """
        Settings for MirrorMaker2 connector.
        """
        return pulumi.get(self, "connector_config_mirrormakers")

    @connector_config_mirrormakers.setter
    def connector_config_mirrormakers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]):
        pulumi.set(self, "connector_config_mirrormakers", value)

    @_builtins.property
    @pulumi.getter(name="connectorConfigS3Sinks")
    def connector_config_s3_sinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]:
        """
        Settings for S3 Sink connector.
        """
        return pulumi.get(self, "connector_config_s3_sinks")

    @connector_config_s3_sinks.setter
    def connector_config_s3_sinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]):
        pulumi.set(self, "connector_config_s3_sinks", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional properties for connector.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="tasksMax")
    def tasks_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the connector's parallel working tasks. Default is the number of brokers.
        """
        return pulumi.get(self, "tasks_max")

    @tasks_max.setter
    def tasks_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tasks_max", value)


@pulumi.input_type
class _MdbKafkaConnectorState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tasks_max: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering MdbKafkaConnector resources.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]] connector_config_mirrormakers: Settings for MirrorMaker2 connector.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]] connector_config_s3_sinks: Settings for S3 Sink connector.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Additional properties for connector.
        :param pulumi.Input[_builtins.int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if connector_config_mirrormakers is not None:
            pulumi.set(__self__, "connector_config_mirrormakers", connector_config_mirrormakers)
        if connector_config_s3_sinks is not None:
            pulumi.set(__self__, "connector_config_s3_sinks", connector_config_s3_sinks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tasks_max is not None:
            pulumi.set(__self__, "tasks_max", tasks_max)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="connectorConfigMirrormakers")
    def connector_config_mirrormakers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]:
        """
        Settings for MirrorMaker2 connector.
        """
        return pulumi.get(self, "connector_config_mirrormakers")

    @connector_config_mirrormakers.setter
    def connector_config_mirrormakers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]):
        pulumi.set(self, "connector_config_mirrormakers", value)

    @_builtins.property
    @pulumi.getter(name="connectorConfigS3Sinks")
    def connector_config_s3_sinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]:
        """
        Settings for S3 Sink connector.
        """
        return pulumi.get(self, "connector_config_s3_sinks")

    @connector_config_s3_sinks.setter
    def connector_config_s3_sinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]):
        pulumi.set(self, "connector_config_s3_sinks", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional properties for connector.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="tasksMax")
    def tasks_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the connector's parallel working tasks. Default is the number of brokers.
        """
        return pulumi.get(self, "tasks_max")

    @tasks_max.setter
    def tasks_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tasks_max", value)


@pulumi.type_token("yandex:index/mdbKafkaConnector:MdbKafkaConnector")
class MdbKafkaConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tasks_max: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a connector of a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        my_cluster = yandex.MdbKafkaCluster("my_cluster",
            name="foo",
            network_id="c64vs98keiqc7f24pvkd",
            config={
                "version": "2.8",
                "zones": ["ru-central1-a"],
                "kafka": {
                    "resources": {
                        "resource_preset_id": "s2.micro",
                        "disk_type_id": "network-hdd",
                        "disk_size": 16,
                    },
                },
            })
        #
        # Create a new MDB Kafka Connector.
        #
        my_conn = yandex.MdbKafkaConnector("my_conn",
            cluster_id=my_cluster.id,
            name="replication",
            tasks_max=3,
            properties={
                topics["enabled"]: "true",
            },
            connector_config_mirrormakers=[{
                "topics": "data.*",
                "replication_factor": 1,
                "source_cluster": {
                    "alias": "source",
                    "external_clusters": [{
                        "bootstrap_servers": "somebroker1:9091,somebroker2:9091",
                        "sasl_username": "someuser",
                        "sasl_password": "somepassword",
                        "sasl_mechanism": "SCRAM-SHA-512",
                        "security_protocol": "SASL_SSL",
                    }],
                },
                "target_cluster": {
                    "this_clusters": [{}],
                    "alias": "target",
                },
            }])
        connector = yandex.MdbKafkaConnector("connector",
            cluster_id=my_cluster.id,
            name="s3-sink",
            tasks_max=3,
            properties={
                "key.converter": "org.apache.kafka.connect.storage.StringConverter",
                "value.converter": "org.apache.kafka.connect.json.JsonConverter",
                "value.converter.schemas.enable": "false",
                "format.output.type": "jsonl",
                "file.name.template": "dir1/dir2/{{topic}}-{{partition:padding=true}}-{{start_offset:padding=true}}.gz",
                "timestamp.timezone": "Europe/Moscow",
            },
            connector_config_s3_sinks=[{
                "topics": "data.*",
                "file_compression_type": "gzip",
                "file_max_records": 100,
                "s3_connection": {
                    "bucket_name": "somebucket",
                    "external_s3s": [{
                        "endpoint": "storage.yandexcloud.net",
                        "access_key_id": "some_access_key_id",
                        "secret_access_key": "some_secret_access_key",
                    }],
                },
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbKafkaConnector:MdbKafkaConnector <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbKafkaConnector:MdbKafkaConnector my_conn ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]] connector_config_mirrormakers: Settings for MirrorMaker2 connector.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]] connector_config_s3_sinks: Settings for S3 Sink connector.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Additional properties for connector.
        :param pulumi.Input[_builtins.int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbKafkaConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a connector of a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        my_cluster = yandex.MdbKafkaCluster("my_cluster",
            name="foo",
            network_id="c64vs98keiqc7f24pvkd",
            config={
                "version": "2.8",
                "zones": ["ru-central1-a"],
                "kafka": {
                    "resources": {
                        "resource_preset_id": "s2.micro",
                        "disk_type_id": "network-hdd",
                        "disk_size": 16,
                    },
                },
            })
        #
        # Create a new MDB Kafka Connector.
        #
        my_conn = yandex.MdbKafkaConnector("my_conn",
            cluster_id=my_cluster.id,
            name="replication",
            tasks_max=3,
            properties={
                topics["enabled"]: "true",
            },
            connector_config_mirrormakers=[{
                "topics": "data.*",
                "replication_factor": 1,
                "source_cluster": {
                    "alias": "source",
                    "external_clusters": [{
                        "bootstrap_servers": "somebroker1:9091,somebroker2:9091",
                        "sasl_username": "someuser",
                        "sasl_password": "somepassword",
                        "sasl_mechanism": "SCRAM-SHA-512",
                        "security_protocol": "SASL_SSL",
                    }],
                },
                "target_cluster": {
                    "this_clusters": [{}],
                    "alias": "target",
                },
            }])
        connector = yandex.MdbKafkaConnector("connector",
            cluster_id=my_cluster.id,
            name="s3-sink",
            tasks_max=3,
            properties={
                "key.converter": "org.apache.kafka.connect.storage.StringConverter",
                "value.converter": "org.apache.kafka.connect.json.JsonConverter",
                "value.converter.schemas.enable": "false",
                "format.output.type": "jsonl",
                "file.name.template": "dir1/dir2/{{topic}}-{{partition:padding=true}}-{{start_offset:padding=true}}.gz",
                "timestamp.timezone": "Europe/Moscow",
            },
            connector_config_s3_sinks=[{
                "topics": "data.*",
                "file_compression_type": "gzip",
                "file_max_records": 100,
                "s3_connection": {
                    "bucket_name": "somebucket",
                    "external_s3s": [{
                        "endpoint": "storage.yandexcloud.net",
                        "access_key_id": "some_access_key_id",
                        "secret_access_key": "some_secret_access_key",
                    }],
                },
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbKafkaConnector:MdbKafkaConnector <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbKafkaConnector:MdbKafkaConnector my_conn ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbKafkaConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbKafkaConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tasks_max: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbKafkaConnectorArgs.__new__(MdbKafkaConnectorArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["connector_config_mirrormakers"] = connector_config_mirrormakers
            __props__.__dict__["connector_config_s3_sinks"] = connector_config_s3_sinks
            __props__.__dict__["name"] = name
            __props__.__dict__["properties"] = properties
            __props__.__dict__["tasks_max"] = tasks_max
        super(MdbKafkaConnector, __self__).__init__(
            'yandex:index/mdbKafkaConnector:MdbKafkaConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]]] = None,
            connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tasks_max: Optional[pulumi.Input[_builtins.int]] = None) -> 'MdbKafkaConnector':
        """
        Get an existing MdbKafkaConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]] connector_config_mirrormakers: Settings for MirrorMaker2 connector.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]] connector_config_s3_sinks: Settings for S3 Sink connector.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: Additional properties for connector.
        :param pulumi.Input[_builtins.int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbKafkaConnectorState.__new__(_MdbKafkaConnectorState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["connector_config_mirrormakers"] = connector_config_mirrormakers
        __props__.__dict__["connector_config_s3_sinks"] = connector_config_s3_sinks
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["tasks_max"] = tasks_max
        return MdbKafkaConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="connectorConfigMirrormakers")
    def connector_config_mirrormakers(self) -> pulumi.Output[Optional[Sequence['outputs.MdbKafkaConnectorConnectorConfigMirrormaker']]]:
        """
        Settings for MirrorMaker2 connector.
        """
        return pulumi.get(self, "connector_config_mirrormakers")

    @_builtins.property
    @pulumi.getter(name="connectorConfigS3Sinks")
    def connector_config_s3_sinks(self) -> pulumi.Output[Optional[Sequence['outputs.MdbKafkaConnectorConnectorConfigS3Sink']]]:
        """
        Settings for S3 Sink connector.
        """
        return pulumi.get(self, "connector_config_s3_sinks")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Additional properties for connector.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="tasksMax")
    def tasks_max(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of the connector's parallel working tasks. Default is the number of brokers.
        """
        return pulumi.get(self, "tasks_max")

