# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbKafkaUserArgs', 'MdbKafkaUser']

@pulumi.input_type
class MdbKafkaUserArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]]] = None):
        """
        The set of arguments for constructing a MdbKafkaUser resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]] permissions: Set of permissions granted to the user.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "password", password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class _MdbKafkaUserState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]]] = None):
        """
        Input properties used for looking up and filtering MdbKafkaUser resources.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]] permissions: Set of permissions granted to the user.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


@pulumi.type_token("yandex:index/mdbKafkaUser:MdbKafkaUser")
class MdbKafkaUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaUserPermissionArgs', 'MdbKafkaUserPermissionArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a user of a Kafka User within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new MDB Kafka User.
        #
        user_events = yandex.MdbKafkaUser("user_events",
            cluster_id=foo["id"],
            name="user-events",
            password="pass1231232332",
            permissions=[
                {
                    "topic_name": "events",
                    "role": "ACCESS_ROLE_CONSUMER",
                    "allow_hosts": [
                        "host1.db.yandex.net",
                        "host2.db.yandex.net",
                    ],
                },
                {
                    "topic_name": "events",
                    "role": "ACCESS_ROLE_PRODUCER",
                },
            ])
        my_cluster = yandex.MdbKafkaCluster("my_cluster",
            name="foo",
            network_id="c64vs98keiqc7f24pvkd",
            config={
                "version": "2.8",
                "zones": ["ru-central1-a"],
                "kafka": {
                    "resources": {
                        "resource_preset_id": "s2.micro",
                        "disk_type_id": "network-hdd",
                        "disk_size": 16,
                    },
                },
            })
        # Auxiliary resources
        events = yandex.MdbKafkaTopic("events",
            cluster_id=my_cluster.id,
            name="events",
            partitions=4,
            replication_factor=1)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbKafkaUser:MdbKafkaUser <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbKafkaUser:MdbKafkaUser user_events ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaUserPermissionArgs', 'MdbKafkaUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbKafkaUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a user of a Kafka User within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-kafka/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new MDB Kafka User.
        #
        user_events = yandex.MdbKafkaUser("user_events",
            cluster_id=foo["id"],
            name="user-events",
            password="pass1231232332",
            permissions=[
                {
                    "topic_name": "events",
                    "role": "ACCESS_ROLE_CONSUMER",
                    "allow_hosts": [
                        "host1.db.yandex.net",
                        "host2.db.yandex.net",
                    ],
                },
                {
                    "topic_name": "events",
                    "role": "ACCESS_ROLE_PRODUCER",
                },
            ])
        my_cluster = yandex.MdbKafkaCluster("my_cluster",
            name="foo",
            network_id="c64vs98keiqc7f24pvkd",
            config={
                "version": "2.8",
                "zones": ["ru-central1-a"],
                "kafka": {
                    "resources": {
                        "resource_preset_id": "s2.micro",
                        "disk_type_id": "network-hdd",
                        "disk_size": 16,
                    },
                },
            })
        # Auxiliary resources
        events = yandex.MdbKafkaTopic("events",
            cluster_id=my_cluster.id,
            name="events",
            partitions=4,
            replication_factor=1)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbKafkaUser:MdbKafkaUser <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbKafkaUser:MdbKafkaUser user_events ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbKafkaUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbKafkaUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaUserPermissionArgs', 'MdbKafkaUserPermissionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbKafkaUserArgs.__new__(MdbKafkaUserArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["permissions"] = permissions
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MdbKafkaUser, __self__).__init__(
            'yandex:index/mdbKafkaUser:MdbKafkaUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaUserPermissionArgs', 'MdbKafkaUserPermissionArgsDict']]]]] = None) -> 'MdbKafkaUser':
        """
        Get an existing MdbKafkaUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the Kafka cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaUserPermissionArgs', 'MdbKafkaUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbKafkaUserState.__new__(_MdbKafkaUserState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["permissions"] = permissions
        return MdbKafkaUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence['outputs.MdbKafkaUserPermission']]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

