# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbMongodbClusterArgs', 'MdbMongodbCluster']

@pulumi.input_type
class MdbMongodbClusterArgs:
    def __init__(__self__, *,
                 cluster_config: pulumi.Input['MdbMongodbClusterClusterConfigArgs'],
                 environment: pulumi.Input[_builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]],
                 network_id: pulumi.Input[_builtins.str],
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling_mongocfg: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs']] = None,
                 disk_size_autoscaling_mongod: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs']] = None,
                 disk_size_autoscaling_mongoinfra: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs']] = None,
                 disk_size_autoscaling_mongos: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input['MdbMongodbClusterResourcesArgs']] = None,
                 resources_mongocfg: Optional[pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs']] = None,
                 resources_mongod: Optional[pulumi.Input['MdbMongodbClusterResourcesMongodArgs']] = None,
                 resources_mongoinfra: Optional[pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs']] = None,
                 resources_mongos: Optional[pulumi.Input['MdbMongodbClusterResourcesMongosArgs']] = None,
                 restore: Optional[pulumi.Input['MdbMongodbClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]]] = None):
        """
        The set of arguments for constructing a MdbMongodbCluster resource.
        :param pulumi.Input['MdbMongodbClusterClusterConfigArgs'] cluster_config: Configuration of the MongoDB subcluster.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MongoDB cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]] hosts: A host of the MongoDB cluster.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]] databases: A database of the MongoDB cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs'] disk_size_autoscaling_mongocfg: Disk size autoscaling settings for mongocfg.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs'] disk_size_autoscaling_mongod: Disk size autoscaling settings for mongod.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs'] disk_size_autoscaling_mongoinfra: Disk size autoscaling settings for mongoinfra.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs'] disk_size_autoscaling_mongos: Disk size autoscaling settings for mongos.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs'] maintenance_window: Maintenance window settings of the MongoDB cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['MdbMongodbClusterResourcesArgs'] resources: (**DEPRECATED**, use `resources_*` instead) Resources allocated to hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs'] resources_mongocfg: Resources allocated to `mongocfg` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongodArgs'] resources_mongod: Resources allocated to `mongod` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs'] resources_mongoinfra: Resources allocated to `mongoinfra` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongosArgs'] resources_mongos: Resources allocated to `mongos` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterRestoreArgs'] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]] users: A user of the MongoDB cluster.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_mongodb_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_mongodb_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if disk_size_autoscaling_mongocfg is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongocfg", disk_size_autoscaling_mongocfg)
        if disk_size_autoscaling_mongod is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongod", disk_size_autoscaling_mongod)
        if disk_size_autoscaling_mongoinfra is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongoinfra", disk_size_autoscaling_mongoinfra)
        if disk_size_autoscaling_mongos is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongos", disk_size_autoscaling_mongos)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            warnings.warn("""to manage `resources`s, please switch to using a separate resource type `resources_mongo*`""", DeprecationWarning)
            pulumi.log.warn("""resources is deprecated: to manage `resources`s, please switch to using a separate resource type `resources_mongo*`""")
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if resources_mongocfg is not None:
            pulumi.set(__self__, "resources_mongocfg", resources_mongocfg)
        if resources_mongod is not None:
            pulumi.set(__self__, "resources_mongod", resources_mongod)
        if resources_mongoinfra is not None:
            pulumi.set(__self__, "resources_mongoinfra", resources_mongoinfra)
        if resources_mongos is not None:
            pulumi.set(__self__, "resources_mongos", resources_mongos)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_mongodb_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_mongodb_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Input['MdbMongodbClusterClusterConfigArgs']:
        """
        Configuration of the MongoDB subcluster.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: pulumi.Input['MdbMongodbClusterClusterConfigArgs']):
        pulumi.set(self, "cluster_config", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment environment of the MongoDB cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]]:
        """
        A host of the MongoDB cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mongodb_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]]]:
        """
        A database of the MongoDB cluster.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongocfg")
    def disk_size_autoscaling_mongocfg(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs']]:
        """
        Disk size autoscaling settings for mongocfg.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongocfg")

    @disk_size_autoscaling_mongocfg.setter
    def disk_size_autoscaling_mongocfg(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongocfg", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongod")
    def disk_size_autoscaling_mongod(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs']]:
        """
        Disk size autoscaling settings for mongod.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongod")

    @disk_size_autoscaling_mongod.setter
    def disk_size_autoscaling_mongod(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongod", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongoinfra")
    def disk_size_autoscaling_mongoinfra(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs']]:
        """
        Disk size autoscaling settings for mongoinfra.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongoinfra")

    @disk_size_autoscaling_mongoinfra.setter
    def disk_size_autoscaling_mongoinfra(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongoinfra", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongos")
    def disk_size_autoscaling_mongos(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs']]:
        """
        Disk size autoscaling settings for mongos.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongos")

    @disk_size_autoscaling_mongos.setter
    def disk_size_autoscaling_mongos(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongos", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs']]:
        """
        Maintenance window settings of the MongoDB cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage `resources`s, please switch to using a separate resource type `resources_mongo*`""")
    def resources(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesArgs']]:
        """
        (**DEPRECATED**, use `resources_*` instead) Resources allocated to hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongocfg")
    def resources_mongocfg(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs']]:
        """
        Resources allocated to `mongocfg` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongocfg")

    @resources_mongocfg.setter
    def resources_mongocfg(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs']]):
        pulumi.set(self, "resources_mongocfg", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongod")
    def resources_mongod(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongodArgs']]:
        """
        Resources allocated to `mongod` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongod")

    @resources_mongod.setter
    def resources_mongod(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongodArgs']]):
        pulumi.set(self, "resources_mongod", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongoinfra")
    def resources_mongoinfra(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs']]:
        """
        Resources allocated to `mongoinfra` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongoinfra")

    @resources_mongoinfra.setter
    def resources_mongoinfra(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs']]):
        pulumi.set(self, "resources_mongoinfra", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongos")
    def resources_mongos(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongosArgs']]:
        """
        Resources allocated to `mongos` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongos")

    @resources_mongos.setter
    def resources_mongos(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongosArgs']]):
        pulumi.set(self, "resources_mongos", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbMongodbClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbMongodbClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mongodb_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]]]:
        """
        A user of the MongoDB cluster.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _MdbMongodbClusterState:
    def __init__(__self__, *,
                 cluster_config: Optional[pulumi.Input['MdbMongodbClusterClusterConfigArgs']] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling_mongocfg: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs']] = None,
                 disk_size_autoscaling_mongod: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs']] = None,
                 disk_size_autoscaling_mongoinfra: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs']] = None,
                 disk_size_autoscaling_mongos: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs']] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input['MdbMongodbClusterResourcesArgs']] = None,
                 resources_mongocfg: Optional[pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs']] = None,
                 resources_mongod: Optional[pulumi.Input['MdbMongodbClusterResourcesMongodArgs']] = None,
                 resources_mongoinfra: Optional[pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs']] = None,
                 resources_mongos: Optional[pulumi.Input['MdbMongodbClusterResourcesMongosArgs']] = None,
                 restore: Optional[pulumi.Input['MdbMongodbClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sharded: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering MdbMongodbCluster resources.
        :param pulumi.Input['MdbMongodbClusterClusterConfigArgs'] cluster_config: Configuration of the MongoDB subcluster.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]] databases: A database of the MongoDB cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs'] disk_size_autoscaling_mongocfg: Disk size autoscaling settings for mongocfg.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs'] disk_size_autoscaling_mongod: Disk size autoscaling settings for mongod.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs'] disk_size_autoscaling_mongoinfra: Disk size autoscaling settings for mongoinfra.
        :param pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs'] disk_size_autoscaling_mongos: Disk size autoscaling settings for mongos.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MongoDB cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]] hosts: A host of the MongoDB cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs'] maintenance_window: Maintenance window settings of the MongoDB cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbMongodbClusterResourcesArgs'] resources: (**DEPRECATED**, use `resources_*` instead) Resources allocated to hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs'] resources_mongocfg: Resources allocated to `mongocfg` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongodArgs'] resources_mongod: Resources allocated to `mongod` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs'] resources_mongoinfra: Resources allocated to `mongoinfra` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterResourcesMongosArgs'] resources_mongos: Resources allocated to `mongos` hosts of the MongoDB cluster.
        :param pulumi.Input['MdbMongodbClusterRestoreArgs'] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.bool] sharded: MongoDB Cluster mode enabled/disabled.
        :param pulumi.Input[_builtins.str] status: Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]] users: A user of the MongoDB cluster.
        """
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_mongodb_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_mongodb_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if disk_size_autoscaling_mongocfg is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongocfg", disk_size_autoscaling_mongocfg)
        if disk_size_autoscaling_mongod is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongod", disk_size_autoscaling_mongod)
        if disk_size_autoscaling_mongoinfra is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongoinfra", disk_size_autoscaling_mongoinfra)
        if disk_size_autoscaling_mongos is not None:
            pulumi.set(__self__, "disk_size_autoscaling_mongos", disk_size_autoscaling_mongos)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if resources is not None:
            warnings.warn("""to manage `resources`s, please switch to using a separate resource type `resources_mongo*`""", DeprecationWarning)
            pulumi.log.warn("""resources is deprecated: to manage `resources`s, please switch to using a separate resource type `resources_mongo*`""")
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if resources_mongocfg is not None:
            pulumi.set(__self__, "resources_mongocfg", resources_mongocfg)
        if resources_mongod is not None:
            pulumi.set(__self__, "resources_mongod", resources_mongod)
        if resources_mongoinfra is not None:
            pulumi.set(__self__, "resources_mongoinfra", resources_mongoinfra)
        if resources_mongos is not None:
            pulumi.set(__self__, "resources_mongos", resources_mongos)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sharded is not None:
            pulumi.set(__self__, "sharded", sharded)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_mongodb_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_mongodb_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['MdbMongodbClusterClusterConfigArgs']]:
        """
        Configuration of the MongoDB subcluster.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['MdbMongodbClusterClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mongodb_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]]]:
        """
        A database of the MongoDB cluster.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongocfg")
    def disk_size_autoscaling_mongocfg(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs']]:
        """
        Disk size autoscaling settings for mongocfg.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongocfg")

    @disk_size_autoscaling_mongocfg.setter
    def disk_size_autoscaling_mongocfg(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongocfg", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongod")
    def disk_size_autoscaling_mongod(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs']]:
        """
        Disk size autoscaling settings for mongod.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongod")

    @disk_size_autoscaling_mongod.setter
    def disk_size_autoscaling_mongod(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongodArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongod", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongoinfra")
    def disk_size_autoscaling_mongoinfra(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs']]:
        """
        Disk size autoscaling settings for mongoinfra.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongoinfra")

    @disk_size_autoscaling_mongoinfra.setter
    def disk_size_autoscaling_mongoinfra(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongoinfra", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongos")
    def disk_size_autoscaling_mongos(self) -> Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs']]:
        """
        Disk size autoscaling settings for mongos.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongos")

    @disk_size_autoscaling_mongos.setter
    def disk_size_autoscaling_mongos(self, value: Optional[pulumi.Input['MdbMongodbClusterDiskSizeAutoscalingMongosArgs']]):
        pulumi.set(self, "disk_size_autoscaling_mongos", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the MongoDB cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]]]:
        """
        A host of the MongoDB cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs']]:
        """
        Maintenance window settings of the MongoDB cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbMongodbClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage `resources`s, please switch to using a separate resource type `resources_mongo*`""")
    def resources(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesArgs']]:
        """
        (**DEPRECATED**, use `resources_*` instead) Resources allocated to hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongocfg")
    def resources_mongocfg(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs']]:
        """
        Resources allocated to `mongocfg` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongocfg")

    @resources_mongocfg.setter
    def resources_mongocfg(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongocfgArgs']]):
        pulumi.set(self, "resources_mongocfg", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongod")
    def resources_mongod(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongodArgs']]:
        """
        Resources allocated to `mongod` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongod")

    @resources_mongod.setter
    def resources_mongod(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongodArgs']]):
        pulumi.set(self, "resources_mongod", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongoinfra")
    def resources_mongoinfra(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs']]:
        """
        Resources allocated to `mongoinfra` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongoinfra")

    @resources_mongoinfra.setter
    def resources_mongoinfra(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongoinfraArgs']]):
        pulumi.set(self, "resources_mongoinfra", value)

    @_builtins.property
    @pulumi.getter(name="resourcesMongos")
    def resources_mongos(self) -> Optional[pulumi.Input['MdbMongodbClusterResourcesMongosArgs']]:
        """
        Resources allocated to `mongos` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongos")

    @resources_mongos.setter
    def resources_mongos(self, value: Optional[pulumi.Input['MdbMongodbClusterResourcesMongosArgs']]):
        pulumi.set(self, "resources_mongos", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbMongodbClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbMongodbClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def sharded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        MongoDB Cluster mode enabled/disabled.
        """
        return pulumi.get(self, "sharded")

    @sharded.setter
    def sharded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sharded", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mongodb_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]]]:
        """
        A user of the MongoDB cluster.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMongodbClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("yandex:index/mdbMongodbCluster:MdbMongodbCluster")
class MdbMongodbCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_config: Optional[pulumi.Input[Union['MdbMongodbClusterClusterConfigArgs', 'MdbMongodbClusterClusterConfigArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterDatabaseArgs', 'MdbMongodbClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling_mongocfg: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongocfgArgsDict']]] = None,
                 disk_size_autoscaling_mongod: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongodArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongodArgsDict']]] = None,
                 disk_size_autoscaling_mongoinfra: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgsDict']]] = None,
                 disk_size_autoscaling_mongos: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongosArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongosArgsDict']]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterHostArgs', 'MdbMongodbClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbMongodbClusterMaintenanceWindowArgs', 'MdbMongodbClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesArgs', 'MdbMongodbClusterResourcesArgsDict']]] = None,
                 resources_mongocfg: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongocfgArgs', 'MdbMongodbClusterResourcesMongocfgArgsDict']]] = None,
                 resources_mongod: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongodArgs', 'MdbMongodbClusterResourcesMongodArgsDict']]] = None,
                 resources_mongoinfra: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongoinfraArgs', 'MdbMongodbClusterResourcesMongoinfraArgsDict']]] = None,
                 resources_mongos: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongosArgs', 'MdbMongodbClusterResourcesMongosArgsDict']]] = None,
                 restore: Optional[pulumi.Input[Union['MdbMongodbClusterRestoreArgs', 'MdbMongodbClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterUserArgs', 'MdbMongodbClusterUserArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a MongoDB cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mongodb/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        #
        # Create a new MDB MongoDB Cluster.
        #
        my_cluster = yandex.MdbMongodbCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            cluster_config={
                "version": "4.2",
            },
            labels={
                "test_key": "test_value",
            },
            databases=[{
                "name": "testdb",
            }],
            users=[{
                "name": "john",
                "password": "password",
                "permissions": [{
                    "database_name": "testdb",
                }],
            }],
            resources_mongod={
                "resource_preset_id": "s2.small",
                "disk_size": 16,
                "disk_type_id": "network-hdd",
            },
            resources_mongos={
                "resource_preset_id": "s2.small",
                "disk_size": 14,
                "disk_type_id": "network-hdd",
            },
            resources_mongocfg={
                "resource_preset_id": "s2.small",
                "disk_size": 14,
                "disk_type_id": "network-hdd",
            },
            hosts=[{
                "zone_id": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }],
            maintenance_window={
                "type": "ANYTIME",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMongodbCluster:MdbMongodbCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbMongodbCluster:MdbMongodbCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbMongodbClusterClusterConfigArgs', 'MdbMongodbClusterClusterConfigArgsDict']] cluster_config: Configuration of the MongoDB subcluster.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterDatabaseArgs', 'MdbMongodbClusterDatabaseArgsDict']]]] databases: A database of the MongoDB cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongocfgArgsDict']] disk_size_autoscaling_mongocfg: Disk size autoscaling settings for mongocfg.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongodArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongodArgsDict']] disk_size_autoscaling_mongod: Disk size autoscaling settings for mongod.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgsDict']] disk_size_autoscaling_mongoinfra: Disk size autoscaling settings for mongoinfra.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongosArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongosArgsDict']] disk_size_autoscaling_mongos: Disk size autoscaling settings for mongos.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MongoDB cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterHostArgs', 'MdbMongodbClusterHostArgsDict']]]] hosts: A host of the MongoDB cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbMongodbClusterMaintenanceWindowArgs', 'MdbMongodbClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance window settings of the MongoDB cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesArgs', 'MdbMongodbClusterResourcesArgsDict']] resources: (**DEPRECATED**, use `resources_*` instead) Resources allocated to hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongocfgArgs', 'MdbMongodbClusterResourcesMongocfgArgsDict']] resources_mongocfg: Resources allocated to `mongocfg` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongodArgs', 'MdbMongodbClusterResourcesMongodArgsDict']] resources_mongod: Resources allocated to `mongod` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongoinfraArgs', 'MdbMongodbClusterResourcesMongoinfraArgsDict']] resources_mongoinfra: Resources allocated to `mongoinfra` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongosArgs', 'MdbMongodbClusterResourcesMongosArgsDict']] resources_mongos: Resources allocated to `mongos` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterRestoreArgs', 'MdbMongodbClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterUserArgs', 'MdbMongodbClusterUserArgsDict']]]] users: A user of the MongoDB cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbMongodbClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MongoDB cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mongodb/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        #
        # Create a new MDB MongoDB Cluster.
        #
        my_cluster = yandex.MdbMongodbCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            cluster_config={
                "version": "4.2",
            },
            labels={
                "test_key": "test_value",
            },
            databases=[{
                "name": "testdb",
            }],
            users=[{
                "name": "john",
                "password": "password",
                "permissions": [{
                    "database_name": "testdb",
                }],
            }],
            resources_mongod={
                "resource_preset_id": "s2.small",
                "disk_size": 16,
                "disk_type_id": "network-hdd",
            },
            resources_mongos={
                "resource_preset_id": "s2.small",
                "disk_size": 14,
                "disk_type_id": "network-hdd",
            },
            resources_mongocfg={
                "resource_preset_id": "s2.small",
                "disk_size": 14,
                "disk_type_id": "network-hdd",
            },
            hosts=[{
                "zone_id": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }],
            maintenance_window={
                "type": "ANYTIME",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMongodbCluster:MdbMongodbCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbMongodbCluster:MdbMongodbCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbMongodbClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbMongodbClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_config: Optional[pulumi.Input[Union['MdbMongodbClusterClusterConfigArgs', 'MdbMongodbClusterClusterConfigArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterDatabaseArgs', 'MdbMongodbClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling_mongocfg: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongocfgArgsDict']]] = None,
                 disk_size_autoscaling_mongod: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongodArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongodArgsDict']]] = None,
                 disk_size_autoscaling_mongoinfra: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgsDict']]] = None,
                 disk_size_autoscaling_mongos: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongosArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongosArgsDict']]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterHostArgs', 'MdbMongodbClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbMongodbClusterMaintenanceWindowArgs', 'MdbMongodbClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesArgs', 'MdbMongodbClusterResourcesArgsDict']]] = None,
                 resources_mongocfg: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongocfgArgs', 'MdbMongodbClusterResourcesMongocfgArgsDict']]] = None,
                 resources_mongod: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongodArgs', 'MdbMongodbClusterResourcesMongodArgsDict']]] = None,
                 resources_mongoinfra: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongoinfraArgs', 'MdbMongodbClusterResourcesMongoinfraArgsDict']]] = None,
                 resources_mongos: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongosArgs', 'MdbMongodbClusterResourcesMongosArgsDict']]] = None,
                 restore: Optional[pulumi.Input[Union['MdbMongodbClusterRestoreArgs', 'MdbMongodbClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterUserArgs', 'MdbMongodbClusterUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbMongodbClusterArgs.__new__(MdbMongodbClusterArgs)

            if cluster_config is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_config'")
            __props__.__dict__["cluster_config"] = cluster_config
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["databases"] = databases
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
            __props__.__dict__["disk_size_autoscaling_mongocfg"] = disk_size_autoscaling_mongocfg
            __props__.__dict__["disk_size_autoscaling_mongod"] = disk_size_autoscaling_mongod
            __props__.__dict__["disk_size_autoscaling_mongoinfra"] = disk_size_autoscaling_mongoinfra
            __props__.__dict__["disk_size_autoscaling_mongos"] = disk_size_autoscaling_mongos
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["resources"] = resources
            __props__.__dict__["resources_mongocfg"] = resources_mongocfg
            __props__.__dict__["resources_mongod"] = resources_mongod
            __props__.__dict__["resources_mongoinfra"] = resources_mongoinfra
            __props__.__dict__["resources_mongos"] = resources_mongos
            __props__.__dict__["restore"] = restore
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["users"] = users
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["sharded"] = None
            __props__.__dict__["status"] = None
        super(MdbMongodbCluster, __self__).__init__(
            'yandex:index/mdbMongodbCluster:MdbMongodbCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_config: Optional[pulumi.Input[Union['MdbMongodbClusterClusterConfigArgs', 'MdbMongodbClusterClusterConfigArgsDict']]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterDatabaseArgs', 'MdbMongodbClusterDatabaseArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size_autoscaling_mongocfg: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongocfgArgsDict']]] = None,
            disk_size_autoscaling_mongod: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongodArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongodArgsDict']]] = None,
            disk_size_autoscaling_mongoinfra: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgsDict']]] = None,
            disk_size_autoscaling_mongos: Optional[pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongosArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongosArgsDict']]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterHostArgs', 'MdbMongodbClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbMongodbClusterMaintenanceWindowArgs', 'MdbMongodbClusterMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesArgs', 'MdbMongodbClusterResourcesArgsDict']]] = None,
            resources_mongocfg: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongocfgArgs', 'MdbMongodbClusterResourcesMongocfgArgsDict']]] = None,
            resources_mongod: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongodArgs', 'MdbMongodbClusterResourcesMongodArgsDict']]] = None,
            resources_mongoinfra: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongoinfraArgs', 'MdbMongodbClusterResourcesMongoinfraArgsDict']]] = None,
            resources_mongos: Optional[pulumi.Input[Union['MdbMongodbClusterResourcesMongosArgs', 'MdbMongodbClusterResourcesMongosArgsDict']]] = None,
            restore: Optional[pulumi.Input[Union['MdbMongodbClusterRestoreArgs', 'MdbMongodbClusterRestoreArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sharded: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterUserArgs', 'MdbMongodbClusterUserArgsDict']]]]] = None) -> 'MdbMongodbCluster':
        """
        Get an existing MdbMongodbCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbMongodbClusterClusterConfigArgs', 'MdbMongodbClusterClusterConfigArgsDict']] cluster_config: Configuration of the MongoDB subcluster.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterDatabaseArgs', 'MdbMongodbClusterDatabaseArgsDict']]]] databases: A database of the MongoDB cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongocfgArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongocfgArgsDict']] disk_size_autoscaling_mongocfg: Disk size autoscaling settings for mongocfg.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongodArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongodArgsDict']] disk_size_autoscaling_mongod: Disk size autoscaling settings for mongod.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongoinfraArgsDict']] disk_size_autoscaling_mongoinfra: Disk size autoscaling settings for mongoinfra.
        :param pulumi.Input[Union['MdbMongodbClusterDiskSizeAutoscalingMongosArgs', 'MdbMongodbClusterDiskSizeAutoscalingMongosArgsDict']] disk_size_autoscaling_mongos: Disk size autoscaling settings for mongos.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the MongoDB cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterHostArgs', 'MdbMongodbClusterHostArgsDict']]]] hosts: A host of the MongoDB cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbMongodbClusterMaintenanceWindowArgs', 'MdbMongodbClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance window settings of the MongoDB cluster.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesArgs', 'MdbMongodbClusterResourcesArgsDict']] resources: (**DEPRECATED**, use `resources_*` instead) Resources allocated to hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongocfgArgs', 'MdbMongodbClusterResourcesMongocfgArgsDict']] resources_mongocfg: Resources allocated to `mongocfg` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongodArgs', 'MdbMongodbClusterResourcesMongodArgsDict']] resources_mongod: Resources allocated to `mongod` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongoinfraArgs', 'MdbMongodbClusterResourcesMongoinfraArgsDict']] resources_mongoinfra: Resources allocated to `mongoinfra` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterResourcesMongosArgs', 'MdbMongodbClusterResourcesMongosArgsDict']] resources_mongos: Resources allocated to `mongos` hosts of the MongoDB cluster.
        :param pulumi.Input[Union['MdbMongodbClusterRestoreArgs', 'MdbMongodbClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.bool] sharded: MongoDB Cluster mode enabled/disabled.
        :param pulumi.Input[_builtins.str] status: Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMongodbClusterUserArgs', 'MdbMongodbClusterUserArgsDict']]]] users: A user of the MongoDB cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbMongodbClusterState.__new__(_MdbMongodbClusterState)

        __props__.__dict__["cluster_config"] = cluster_config
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["databases"] = databases
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
        __props__.__dict__["disk_size_autoscaling_mongocfg"] = disk_size_autoscaling_mongocfg
        __props__.__dict__["disk_size_autoscaling_mongod"] = disk_size_autoscaling_mongod
        __props__.__dict__["disk_size_autoscaling_mongoinfra"] = disk_size_autoscaling_mongoinfra
        __props__.__dict__["disk_size_autoscaling_mongos"] = disk_size_autoscaling_mongos
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["resources"] = resources
        __props__.__dict__["resources_mongocfg"] = resources_mongocfg
        __props__.__dict__["resources_mongod"] = resources_mongod
        __props__.__dict__["resources_mongoinfra"] = resources_mongoinfra
        __props__.__dict__["resources_mongos"] = resources_mongos
        __props__.__dict__["restore"] = restore
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["sharded"] = sharded
        __props__.__dict__["status"] = status
        __props__.__dict__["users"] = users
        return MdbMongodbCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Output['outputs.MdbMongodbClusterClusterConfig']:
        """
        Configuration of the MongoDB subcluster.
        """
        return pulumi.get(self, "cluster_config")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mongodb_database""")
    def databases(self) -> pulumi.Output[Sequence['outputs.MdbMongodbClusterDatabase']]:
        """
        A database of the MongoDB cluster.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongocfg")
    def disk_size_autoscaling_mongocfg(self) -> pulumi.Output['outputs.MdbMongodbClusterDiskSizeAutoscalingMongocfg']:
        """
        Disk size autoscaling settings for mongocfg.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongocfg")

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongod")
    def disk_size_autoscaling_mongod(self) -> pulumi.Output['outputs.MdbMongodbClusterDiskSizeAutoscalingMongod']:
        """
        Disk size autoscaling settings for mongod.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongod")

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongoinfra")
    def disk_size_autoscaling_mongoinfra(self) -> pulumi.Output['outputs.MdbMongodbClusterDiskSizeAutoscalingMongoinfra']:
        """
        Disk size autoscaling settings for mongoinfra.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongoinfra")

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscalingMongos")
    def disk_size_autoscaling_mongos(self) -> pulumi.Output['outputs.MdbMongodbClusterDiskSizeAutoscalingMongos']:
        """
        Disk size autoscaling settings for mongos.
        """
        return pulumi.get(self, "disk_size_autoscaling_mongos")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment environment of the MongoDB cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbMongodbClusterHost']]:
        """
        A host of the MongoDB cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbMongodbClusterMaintenanceWindow']:
        """
        Maintenance window settings of the MongoDB cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage `resources`s, please switch to using a separate resource type `resources_mongo*`""")
    def resources(self) -> pulumi.Output[Optional['outputs.MdbMongodbClusterResources']]:
        """
        (**DEPRECATED**, use `resources_*` instead) Resources allocated to hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="resourcesMongocfg")
    def resources_mongocfg(self) -> pulumi.Output[Optional['outputs.MdbMongodbClusterResourcesMongocfg']]:
        """
        Resources allocated to `mongocfg` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongocfg")

    @_builtins.property
    @pulumi.getter(name="resourcesMongod")
    def resources_mongod(self) -> pulumi.Output[Optional['outputs.MdbMongodbClusterResourcesMongod']]:
        """
        Resources allocated to `mongod` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongod")

    @_builtins.property
    @pulumi.getter(name="resourcesMongoinfra")
    def resources_mongoinfra(self) -> pulumi.Output[Optional['outputs.MdbMongodbClusterResourcesMongoinfra']]:
        """
        Resources allocated to `mongoinfra` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongoinfra")

    @_builtins.property
    @pulumi.getter(name="resourcesMongos")
    def resources_mongos(self) -> pulumi.Output[Optional['outputs.MdbMongodbClusterResourcesMongos']]:
        """
        Resources allocated to `mongos` hosts of the MongoDB cluster.
        """
        return pulumi.get(self, "resources_mongos")

    @_builtins.property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.MdbMongodbClusterRestore']]:
        """
        The cluster will be created from the specified backup.
        """
        return pulumi.get(self, "restore")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def sharded(self) -> pulumi.Output[_builtins.bool]:
        """
        MongoDB Cluster mode enabled/disabled.
        """
        return pulumi.get(self, "sharded")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-mongodb/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mongodb_user""")
    def users(self) -> pulumi.Output[Sequence['outputs.MdbMongodbClusterUser']]:
        """
        A user of the MongoDB cluster.
        """
        return pulumi.get(self, "users")

