# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MdbMysqlDatabaseArgs', 'MdbMysqlDatabase']

@pulumi.input_type
class MdbMysqlDatabaseArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MdbMysqlDatabase resource.
        :param pulumi.Input[_builtins.str] cluster_id: The MySQL cluster ID.
        :param pulumi.Input[_builtins.str] name: The name of the database.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The MySQL cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MdbMysqlDatabaseState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MdbMysqlDatabase resources.
        :param pulumi.Input[_builtins.str] cluster_id: The MySQL cluster ID.
        :param pulumi.Input[_builtins.str] name: The name of the database.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MySQL cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("yandex:index/mdbMysqlDatabase:MdbMysqlDatabase")
class MdbMysqlDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a MySQL database within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        #
        # Create a new MDB MySQL Database.
        #
        my_db = yandex.MdbMysqlDatabase("my_db",
            cluster_id=my_cluster.id,
            name="testdb")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMysqlDatabase:MdbMysqlDatabase <resource Name> "<cluster Id>:<database Name>"
        ```

        ```sh
        $ pulumi import yandex:index/mdbMysqlDatabase:MdbMysqlDatabase my_db ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The MySQL cluster ID.
        :param pulumi.Input[_builtins.str] name: The name of the database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbMysqlDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MySQL database within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        my_cluster = yandex.MdbMysqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            version="8.0",
            resources={
                "resource_preset_id": "s2.micro",
                "disk_type_id": "network-ssd",
                "disk_size": 16,
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        #
        # Create a new MDB MySQL Database.
        #
        my_db = yandex.MdbMysqlDatabase("my_db",
            cluster_id=my_cluster.id,
            name="testdb")
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMysqlDatabase:MdbMysqlDatabase <resource Name> "<cluster Id>:<database Name>"
        ```

        ```sh
        $ pulumi import yandex:index/mdbMysqlDatabase:MdbMysqlDatabase my_db ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbMysqlDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbMysqlDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbMysqlDatabaseArgs.__new__(MdbMysqlDatabaseArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
        super(MdbMysqlDatabase, __self__).__init__(
            'yandex:index/mdbMysqlDatabase:MdbMysqlDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'MdbMysqlDatabase':
        """
        Get an existing MdbMysqlDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The MySQL cluster ID.
        :param pulumi.Input[_builtins.str] name: The name of the database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbMysqlDatabaseState.__new__(_MdbMysqlDatabaseState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["name"] = name
        return MdbMysqlDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The MySQL cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database.
        """
        return pulumi.get(self, "name")

