# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbMysqlUserArgs', 'MdbMysqlUser']

@pulumi.input_type
class MdbMysqlUserArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 authentication_plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limits: Optional[pulumi.Input['MdbMysqlUserConnectionLimitsArgs']] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]]] = None):
        """
        The set of arguments for constructing a MdbMysqlUser resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the MySQL cluster.
        :param pulumi.Input[_builtins.str] authentication_plugin: Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        :param pulumi.Input['MdbMysqlUserConnectionLimitsArgs'] connection_limits: User's connection limits. If the attribute is not specified there will be no changes. Default value is `-1`. When these parameters are set to `-1`, backend default values will be actually used.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: `true` or `false`. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] global_permissions: List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]] permissions: Set of permissions granted to the user.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if authentication_plugin is not None:
            pulumi.set(__self__, "authentication_plugin", authentication_plugin)
        if connection_limits is not None:
            pulumi.set(__self__, "connection_limits", connection_limits)
        if generate_password is not None:
            pulumi.set(__self__, "generate_password", generate_password)
        if global_permissions is not None:
            pulumi.set(__self__, "global_permissions", global_permissions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="authenticationPlugin")
    def authentication_plugin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        """
        return pulumi.get(self, "authentication_plugin")

    @authentication_plugin.setter
    def authentication_plugin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_plugin", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimits")
    def connection_limits(self) -> Optional[pulumi.Input['MdbMysqlUserConnectionLimitsArgs']]:
        """
        User's connection limits. If the attribute is not specified there will be no changes. Default value is `-1`. When these parameters are set to `-1`, backend default values will be actually used.
        """
        return pulumi.get(self, "connection_limits")

    @connection_limits.setter
    def connection_limits(self, value: Optional[pulumi.Input['MdbMysqlUserConnectionLimitsArgs']]):
        pulumi.set(self, "connection_limits", value)

    @_builtins.property
    @pulumi.getter(name="generatePassword")
    def generate_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generate password using Connection Manager. Allowed values: `true` or `false`. It's used only during user creation and is ignored during updating.
        """
        return pulumi.get(self, "generate_password")

    @generate_password.setter
    def generate_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_password", value)

    @_builtins.property
    @pulumi.getter(name="globalPermissions")
    def global_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        """
        return pulumi.get(self, "global_permissions")

    @global_permissions.setter
    def global_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "global_permissions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class _MdbMysqlUserState:
    def __init__(__self__, *,
                 authentication_plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limits: Optional[pulumi.Input['MdbMysqlUserConnectionLimitsArgs']] = None,
                 connection_manager: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]]] = None):
        """
        Input properties used for looking up and filtering MdbMysqlUser resources.
        :param pulumi.Input[_builtins.str] authentication_plugin: Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the MySQL cluster.
        :param pulumi.Input['MdbMysqlUserConnectionLimitsArgs'] connection_limits: User's connection limits. If the attribute is not specified there will be no changes. Default value is `-1`. When these parameters are set to `-1`, backend default values will be actually used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connection_manager: Connection Manager connection configuration. Filled in by the server automatically.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: `true` or `false`. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] global_permissions: List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]] permissions: Set of permissions granted to the user.
        """
        if authentication_plugin is not None:
            pulumi.set(__self__, "authentication_plugin", authentication_plugin)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if connection_limits is not None:
            pulumi.set(__self__, "connection_limits", connection_limits)
        if connection_manager is not None:
            pulumi.set(__self__, "connection_manager", connection_manager)
        if generate_password is not None:
            pulumi.set(__self__, "generate_password", generate_password)
        if global_permissions is not None:
            pulumi.set(__self__, "global_permissions", global_permissions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="authenticationPlugin")
    def authentication_plugin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        """
        return pulumi.get(self, "authentication_plugin")

    @authentication_plugin.setter
    def authentication_plugin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_plugin", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionLimits")
    def connection_limits(self) -> Optional[pulumi.Input['MdbMysqlUserConnectionLimitsArgs']]:
        """
        User's connection limits. If the attribute is not specified there will be no changes. Default value is `-1`. When these parameters are set to `-1`, backend default values will be actually used.
        """
        return pulumi.get(self, "connection_limits")

    @connection_limits.setter
    def connection_limits(self, value: Optional[pulumi.Input['MdbMysqlUserConnectionLimitsArgs']]):
        pulumi.set(self, "connection_limits", value)

    @_builtins.property
    @pulumi.getter(name="connectionManager")
    def connection_manager(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Connection Manager connection configuration. Filled in by the server automatically.
        """
        return pulumi.get(self, "connection_manager")

    @connection_manager.setter
    def connection_manager(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connection_manager", value)

    @_builtins.property
    @pulumi.getter(name="generatePassword")
    def generate_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generate password using Connection Manager. Allowed values: `true` or `false`. It's used only during user creation and is ignored during updating.
        """
        return pulumi.get(self, "generate_password")

    @generate_password.setter
    def generate_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_password", value)

    @_builtins.property
    @pulumi.getter(name="globalPermissions")
    def global_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        """
        return pulumi.get(self, "global_permissions")

    @global_permissions.setter
    def global_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "global_permissions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)


@pulumi.type_token("yandex:index/mdbMysqlUser:MdbMysqlUser")
class MdbMysqlUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limits: Optional[pulumi.Input[Union['MdbMysqlUserConnectionLimitsArgs', 'MdbMysqlUserConnectionLimitsArgsDict']]] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlUserPermissionArgs', 'MdbMysqlUserPermissionArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a MySQL user within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMysqlUser:MdbMysqlUser <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbMysqlUser:MdbMysqlUser my_user ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_plugin: Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the MySQL cluster.
        :param pulumi.Input[Union['MdbMysqlUserConnectionLimitsArgs', 'MdbMysqlUserConnectionLimitsArgsDict']] connection_limits: User's connection limits. If the attribute is not specified there will be no changes. Default value is `-1`. When these parameters are set to `-1`, backend default values will be actually used.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: `true` or `false`. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] global_permissions: List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlUserPermissionArgs', 'MdbMysqlUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbMysqlUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MySQL user within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-mysql/).

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbMysqlUser:MdbMysqlUser <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbMysqlUser:MdbMysqlUser my_user ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbMysqlUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbMysqlUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_plugin: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_limits: Optional[pulumi.Input[Union['MdbMysqlUserConnectionLimitsArgs', 'MdbMysqlUserConnectionLimitsArgsDict']]] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlUserPermissionArgs', 'MdbMysqlUserPermissionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbMysqlUserArgs.__new__(MdbMysqlUserArgs)

            __props__.__dict__["authentication_plugin"] = authentication_plugin
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["connection_limits"] = connection_limits
            __props__.__dict__["generate_password"] = generate_password
            __props__.__dict__["global_permissions"] = global_permissions
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["connection_manager"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MdbMysqlUser, __self__).__init__(
            'yandex:index/mdbMysqlUser:MdbMysqlUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_plugin: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_limits: Optional[pulumi.Input[Union['MdbMysqlUserConnectionLimitsArgs', 'MdbMysqlUserConnectionLimitsArgsDict']]] = None,
            connection_manager: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
            global_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlUserPermissionArgs', 'MdbMysqlUserPermissionArgsDict']]]]] = None) -> 'MdbMysqlUser':
        """
        Get an existing MdbMysqlUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_plugin: Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the MySQL cluster.
        :param pulumi.Input[Union['MdbMysqlUserConnectionLimitsArgs', 'MdbMysqlUserConnectionLimitsArgsDict']] connection_limits: User's connection limits. If the attribute is not specified there will be no changes. Default value is `-1`. When these parameters are set to `-1`, backend default values will be actually used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connection_manager: Connection Manager connection configuration. Filled in by the server automatically.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: `true` or `false`. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] global_permissions: List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlUserPermissionArgs', 'MdbMysqlUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbMysqlUserState.__new__(_MdbMysqlUserState)

        __props__.__dict__["authentication_plugin"] = authentication_plugin
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["connection_limits"] = connection_limits
        __props__.__dict__["connection_manager"] = connection_manager
        __props__.__dict__["generate_password"] = generate_password
        __props__.__dict__["global_permissions"] = global_permissions
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["permissions"] = permissions
        return MdbMysqlUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationPlugin")
    def authentication_plugin(self) -> pulumi.Output[_builtins.str]:
        """
        Authentication plugin. Allowed values: `MYSQL_NATIVE_PASSWORD`, `CACHING_SHA2_PASSWORD`, `SHA256_PASSWORD` (for version 5.7 `MYSQL_NATIVE_PASSWORD`, `SHA256_PASSWORD`)
        """
        return pulumi.get(self, "authentication_plugin")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the MySQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="connectionLimits")
    def connection_limits(self) -> pulumi.Output['outputs.MdbMysqlUserConnectionLimits']:
        """
        User's connection limits. If the attribute is not specified there will be no changes. Default value is `-1`. When these parameters are set to `-1`, backend default values will be actually used.
        """
        return pulumi.get(self, "connection_limits")

    @_builtins.property
    @pulumi.getter(name="connectionManager")
    def connection_manager(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Connection Manager connection configuration. Filled in by the server automatically.
        """
        return pulumi.get(self, "connection_manager")

    @_builtins.property
    @pulumi.getter(name="generatePassword")
    def generate_password(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Generate password using Connection Manager. Allowed values: `true` or `false`. It's used only during user creation and is ignored during updating.
        """
        return pulumi.get(self, "generate_password")

    @_builtins.property
    @pulumi.getter(name="globalPermissions")
    def global_permissions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List user's global permissions. Allowed permissions: `REPLICATION_CLIENT`, `REPLICATION_SLAVE`, `PROCESS`, `FLUSH_OPTIMIZER_COSTS`, `SHOW_ROUTINE`, `MDB_ADMIN` for clear list use empty list. If the attribute is not specified there will be no changes.
        """
        return pulumi.get(self, "global_permissions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence['outputs.MdbMysqlUserPermission']]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

