# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbPostgresqlUserArgs', 'MdbPostgresqlUser']

@pulumi.input_type
class MdbPostgresqlUserArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 conn_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a MdbPostgresqlUser resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.int] conn_limit: The maximum number of connections per user. (Default 50).
        :param pulumi.Input[_builtins.str] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: true or false. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grants: List of the user's grants.
        :param pulumi.Input[_builtins.bool] login: User's ability to login.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]] permissions: Set of permissions granted to the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of user settings. [Full description](https://yandex.cloud/docs/managed-postgresql/api-ref/grpc/Cluster/create#yandex.cloud.mdb.postgresql.v1.UserSettings).
               
               * `default_transaction_isolation` - defines the default isolation level to be set for all new SQL transactions. One of:  - 0: `unspecified`
                 - 1: `read uncommitted`
                 - 2: `read committed`
                 - 3: `repeatable read`
                 - 4: `serializable`
               
               * `lock_timeout` - The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object (default 0)
               
               * `log_min_duration_statement` - This setting controls logging of the duration of statements. (default -1 disables logging of the duration of statements.)
               
               * `synchronous_commit` - This setting defines whether DBMS will commit transaction in a synchronous way. One of:
                 - 0: `unspecified`
                 - 1: `on`
                 - 2: `off`
                 - 3: `local`
                 - 4: `remote write`
                 - 5: `remote apply`
               
               * `temp_file_limit` - The maximum storage space size (in kilobytes) that a single process can use to create temporary files.
               
               * `log_statement` - This setting specifies which SQL statements should be logged (on the user level). One of:
                 - 0: `unspecified`
                 - 1: `none`
                 - 2: `ddl`
                 - 3: `mod`
                 - 4: `all`
               
               * `pool_mode` - Mode that the connection pooler is working in with specified user. One of:
                 - 1: `session`
                 - 2: `transaction`
                 - 3: `statement`
               
               * `prepared_statements_pooling` - This setting allows user to use prepared statements with transaction pooling. Boolean.
               
               * `catchup_timeout` - The connection pooler setting. It determines the maximum allowed replication lag (in seconds). Pooler will reject connections to the replica with a lag above this threshold. Default value is 0, which disables this feature. Integer.
               
               * `wal_sender_timeout` - The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+). Terminate replication connections that are inactive for longer than this amount of time. Integer.
               
               * `idle_in_transaction_session_timeout` - Sets the maximum allowed idle time (in milliseconds) between queries, when in a transaction. Value of 0 (default) disables the timeout. Integer.
               
               * `statement_timeout` - The maximum time (in milliseconds) to wait for statement. Value of 0 (default) disables the timeout. Integer
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if conn_limit is not None:
            pulumi.set(__self__, "conn_limit", conn_limit)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if generate_password is not None:
            pulumi.set(__self__, "generate_password", generate_password)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="connLimit")
    def conn_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections per user. (Default 50).
        """
        return pulumi.get(self, "conn_limit")

    @conn_limit.setter
    def conn_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "conn_limit", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="generatePassword")
    def generate_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generate password using Connection Manager. Allowed values: true or false. It's used only during user creation and is ignored during updating.
        """
        return pulumi.get(self, "generate_password")

    @generate_password.setter
    def generate_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_password", value)

    @_builtins.property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the user's grants.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "grants", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        User's ability to login.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of user settings. [Full description](https://yandex.cloud/docs/managed-postgresql/api-ref/grpc/Cluster/create#yandex.cloud.mdb.postgresql.v1.UserSettings).

        * `default_transaction_isolation` - defines the default isolation level to be set for all new SQL transactions. One of:  - 0: `unspecified`
          - 1: `read uncommitted`
          - 2: `read committed`
          - 3: `repeatable read`
          - 4: `serializable`

        * `lock_timeout` - The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object (default 0)

        * `log_min_duration_statement` - This setting controls logging of the duration of statements. (default -1 disables logging of the duration of statements.)

        * `synchronous_commit` - This setting defines whether DBMS will commit transaction in a synchronous way. One of:
          - 0: `unspecified`
          - 1: `on`
          - 2: `off`
          - 3: `local`
          - 4: `remote write`
          - 5: `remote apply`

        * `temp_file_limit` - The maximum storage space size (in kilobytes) that a single process can use to create temporary files.

        * `log_statement` - This setting specifies which SQL statements should be logged (on the user level). One of:
          - 0: `unspecified`
          - 1: `none`
          - 2: `ddl`
          - 3: `mod`
          - 4: `all`

        * `pool_mode` - Mode that the connection pooler is working in with specified user. One of:
          - 1: `session`
          - 2: `transaction`
          - 3: `statement`

        * `prepared_statements_pooling` - This setting allows user to use prepared statements with transaction pooling. Boolean.

        * `catchup_timeout` - The connection pooler setting. It determines the maximum allowed replication lag (in seconds). Pooler will reject connections to the replica with a lag above this threshold. Default value is 0, which disables this feature. Integer.

        * `wal_sender_timeout` - The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+). Terminate replication connections that are inactive for longer than this amount of time. Integer.

        * `idle_in_transaction_session_timeout` - Sets the maximum allowed idle time (in milliseconds) between queries, when in a transaction. Value of 0 (default) disables the timeout. Integer.

        * `statement_timeout` - The maximum time (in milliseconds) to wait for statement. Value of 0 (default) disables the timeout. Integer
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _MdbPostgresqlUserState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conn_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_manager: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering MdbPostgresqlUser resources.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.int] conn_limit: The maximum number of connections per user. (Default 50).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connection_manager: Connection Manager connection configuration. Filled in by the server automatically.
        :param pulumi.Input[_builtins.str] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: true or false. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grants: List of the user's grants.
        :param pulumi.Input[_builtins.bool] login: User's ability to login.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]] permissions: Set of permissions granted to the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of user settings. [Full description](https://yandex.cloud/docs/managed-postgresql/api-ref/grpc/Cluster/create#yandex.cloud.mdb.postgresql.v1.UserSettings).
               
               * `default_transaction_isolation` - defines the default isolation level to be set for all new SQL transactions. One of:  - 0: `unspecified`
                 - 1: `read uncommitted`
                 - 2: `read committed`
                 - 3: `repeatable read`
                 - 4: `serializable`
               
               * `lock_timeout` - The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object (default 0)
               
               * `log_min_duration_statement` - This setting controls logging of the duration of statements. (default -1 disables logging of the duration of statements.)
               
               * `synchronous_commit` - This setting defines whether DBMS will commit transaction in a synchronous way. One of:
                 - 0: `unspecified`
                 - 1: `on`
                 - 2: `off`
                 - 3: `local`
                 - 4: `remote write`
                 - 5: `remote apply`
               
               * `temp_file_limit` - The maximum storage space size (in kilobytes) that a single process can use to create temporary files.
               
               * `log_statement` - This setting specifies which SQL statements should be logged (on the user level). One of:
                 - 0: `unspecified`
                 - 1: `none`
                 - 2: `ddl`
                 - 3: `mod`
                 - 4: `all`
               
               * `pool_mode` - Mode that the connection pooler is working in with specified user. One of:
                 - 1: `session`
                 - 2: `transaction`
                 - 3: `statement`
               
               * `prepared_statements_pooling` - This setting allows user to use prepared statements with transaction pooling. Boolean.
               
               * `catchup_timeout` - The connection pooler setting. It determines the maximum allowed replication lag (in seconds). Pooler will reject connections to the replica with a lag above this threshold. Default value is 0, which disables this feature. Integer.
               
               * `wal_sender_timeout` - The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+). Terminate replication connections that are inactive for longer than this amount of time. Integer.
               
               * `idle_in_transaction_session_timeout` - Sets the maximum allowed idle time (in milliseconds) between queries, when in a transaction. Value of 0 (default) disables the timeout. Integer.
               
               * `statement_timeout` - The maximum time (in milliseconds) to wait for statement. Value of 0 (default) disables the timeout. Integer
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if conn_limit is not None:
            pulumi.set(__self__, "conn_limit", conn_limit)
        if connection_manager is not None:
            pulumi.set(__self__, "connection_manager", connection_manager)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if generate_password is not None:
            pulumi.set(__self__, "generate_password", generate_password)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="connLimit")
    def conn_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of connections per user. (Default 50).
        """
        return pulumi.get(self, "conn_limit")

    @conn_limit.setter
    def conn_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "conn_limit", value)

    @_builtins.property
    @pulumi.getter(name="connectionManager")
    def connection_manager(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Connection Manager connection configuration. Filled in by the server automatically.
        """
        return pulumi.get(self, "connection_manager")

    @connection_manager.setter
    def connection_manager(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connection_manager", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="generatePassword")
    def generate_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generate password using Connection Manager. Allowed values: true or false. It's used only during user creation and is ignored during updating.
        """
        return pulumi.get(self, "generate_password")

    @generate_password.setter
    def generate_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate_password", value)

    @_builtins.property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of the user's grants.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "grants", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        User's ability to login.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of user settings. [Full description](https://yandex.cloud/docs/managed-postgresql/api-ref/grpc/Cluster/create#yandex.cloud.mdb.postgresql.v1.UserSettings).

        * `default_transaction_isolation` - defines the default isolation level to be set for all new SQL transactions. One of:  - 0: `unspecified`
          - 1: `read uncommitted`
          - 2: `read committed`
          - 3: `repeatable read`
          - 4: `serializable`

        * `lock_timeout` - The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object (default 0)

        * `log_min_duration_statement` - This setting controls logging of the duration of statements. (default -1 disables logging of the duration of statements.)

        * `synchronous_commit` - This setting defines whether DBMS will commit transaction in a synchronous way. One of:
          - 0: `unspecified`
          - 1: `on`
          - 2: `off`
          - 3: `local`
          - 4: `remote write`
          - 5: `remote apply`

        * `temp_file_limit` - The maximum storage space size (in kilobytes) that a single process can use to create temporary files.

        * `log_statement` - This setting specifies which SQL statements should be logged (on the user level). One of:
          - 0: `unspecified`
          - 1: `none`
          - 2: `ddl`
          - 3: `mod`
          - 4: `all`

        * `pool_mode` - Mode that the connection pooler is working in with specified user. One of:
          - 1: `session`
          - 2: `transaction`
          - 3: `statement`

        * `prepared_statements_pooling` - This setting allows user to use prepared statements with transaction pooling. Boolean.

        * `catchup_timeout` - The connection pooler setting. It determines the maximum allowed replication lag (in seconds). Pooler will reject connections to the replica with a lag above this threshold. Default value is 0, which disables this feature. Integer.

        * `wal_sender_timeout` - The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+). Terminate replication connections that are inactive for longer than this amount of time. Integer.

        * `idle_in_transaction_session_timeout` - Sets the maximum allowed idle time (in milliseconds) between queries, when in a transaction. Value of 0 (default) disables the timeout. Integer.

        * `statement_timeout` - The maximum time (in milliseconds) to wait for statement. Value of 0 (default) disables the timeout. Integer
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "settings", value)


@pulumi.type_token("yandex:index/mdbPostgresqlUser:MdbPostgresqlUser")
class MdbPostgresqlUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conn_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a PostgreSQL user within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-postgresql/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        #
        # Create a new MDB PostgreSQL database User.
        #
        my_user = yandex.MdbPostgresqlUser("my_user",
            cluster_id=my_cluster.id,
            name="alice",
            password="password",
            conn_limit=50,
            settings={
                "default_transaction_isolation": "read committed",
                "log_min_duration_statement": "5000",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlUser:MdbPostgresqlUser <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlUser:MdbPostgresqlUser my_user ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.int] conn_limit: The maximum number of connections per user. (Default 50).
        :param pulumi.Input[_builtins.str] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: true or false. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grants: List of the user's grants.
        :param pulumi.Input[_builtins.bool] login: User's ability to login.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of user settings. [Full description](https://yandex.cloud/docs/managed-postgresql/api-ref/grpc/Cluster/create#yandex.cloud.mdb.postgresql.v1.UserSettings).
               
               * `default_transaction_isolation` - defines the default isolation level to be set for all new SQL transactions. One of:  - 0: `unspecified`
                 - 1: `read uncommitted`
                 - 2: `read committed`
                 - 3: `repeatable read`
                 - 4: `serializable`
               
               * `lock_timeout` - The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object (default 0)
               
               * `log_min_duration_statement` - This setting controls logging of the duration of statements. (default -1 disables logging of the duration of statements.)
               
               * `synchronous_commit` - This setting defines whether DBMS will commit transaction in a synchronous way. One of:
                 - 0: `unspecified`
                 - 1: `on`
                 - 2: `off`
                 - 3: `local`
                 - 4: `remote write`
                 - 5: `remote apply`
               
               * `temp_file_limit` - The maximum storage space size (in kilobytes) that a single process can use to create temporary files.
               
               * `log_statement` - This setting specifies which SQL statements should be logged (on the user level). One of:
                 - 0: `unspecified`
                 - 1: `none`
                 - 2: `ddl`
                 - 3: `mod`
                 - 4: `all`
               
               * `pool_mode` - Mode that the connection pooler is working in with specified user. One of:
                 - 1: `session`
                 - 2: `transaction`
                 - 3: `statement`
               
               * `prepared_statements_pooling` - This setting allows user to use prepared statements with transaction pooling. Boolean.
               
               * `catchup_timeout` - The connection pooler setting. It determines the maximum allowed replication lag (in seconds). Pooler will reject connections to the replica with a lag above this threshold. Default value is 0, which disables this feature. Integer.
               
               * `wal_sender_timeout` - The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+). Terminate replication connections that are inactive for longer than this amount of time. Integer.
               
               * `idle_in_transaction_session_timeout` - Sets the maximum allowed idle time (in milliseconds) between queries, when in a transaction. Value of 0 (default) disables the timeout. Integer.
               
               * `statement_timeout` - The maximum time (in milliseconds) to wait for statement. Value of 0 (default) disables the timeout. Integer
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbPostgresqlUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a PostgreSQL user within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-postgresql/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        my_cluster = yandex.MdbPostgresqlCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "version": "15",
                "resources": {
                    "resource_preset_id": "s2.micro",
                    "disk_type_id": "network-ssd",
                    "disk_size": 16,
                },
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }])
        #
        # Create a new MDB PostgreSQL database User.
        #
        my_user = yandex.MdbPostgresqlUser("my_user",
            cluster_id=my_cluster.id,
            name="alice",
            password="password",
            conn_limit=50,
            settings={
                "default_transaction_isolation": "read committed",
                "log_min_duration_statement": "5000",
            })
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlUser:MdbPostgresqlUser <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlUser:MdbPostgresqlUser my_user ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbPostgresqlUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbPostgresqlUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conn_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbPostgresqlUserArgs.__new__(MdbPostgresqlUserArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["conn_limit"] = conn_limit
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["generate_password"] = generate_password
            __props__.__dict__["grants"] = grants
            __props__.__dict__["login"] = login
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["settings"] = settings
            __props__.__dict__["connection_manager"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MdbPostgresqlUser, __self__).__init__(
            'yandex:index/mdbPostgresqlUser:MdbPostgresqlUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            conn_limit: Optional[pulumi.Input[_builtins.int]] = None,
            connection_manager: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.str]] = None,
            generate_password: Optional[pulumi.Input[_builtins.bool]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            login: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'MdbPostgresqlUser':
        """
        Get an existing MdbPostgresqlUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the PostgreSQL cluster.
        :param pulumi.Input[_builtins.int] conn_limit: The maximum number of connections per user. (Default 50).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connection_manager: Connection Manager connection configuration. Filled in by the server automatically.
        :param pulumi.Input[_builtins.str] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.bool] generate_password: Generate password using Connection Manager. Allowed values: true or false. It's used only during user creation and is ignored during updating.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grants: List of the user's grants.
        :param pulumi.Input[_builtins.bool] login: User's ability to login.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        :param pulumi.Input[_builtins.str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] settings: Map of user settings. [Full description](https://yandex.cloud/docs/managed-postgresql/api-ref/grpc/Cluster/create#yandex.cloud.mdb.postgresql.v1.UserSettings).
               
               * `default_transaction_isolation` - defines the default isolation level to be set for all new SQL transactions. One of:  - 0: `unspecified`
                 - 1: `read uncommitted`
                 - 2: `read committed`
                 - 3: `repeatable read`
                 - 4: `serializable`
               
               * `lock_timeout` - The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object (default 0)
               
               * `log_min_duration_statement` - This setting controls logging of the duration of statements. (default -1 disables logging of the duration of statements.)
               
               * `synchronous_commit` - This setting defines whether DBMS will commit transaction in a synchronous way. One of:
                 - 0: `unspecified`
                 - 1: `on`
                 - 2: `off`
                 - 3: `local`
                 - 4: `remote write`
                 - 5: `remote apply`
               
               * `temp_file_limit` - The maximum storage space size (in kilobytes) that a single process can use to create temporary files.
               
               * `log_statement` - This setting specifies which SQL statements should be logged (on the user level). One of:
                 - 0: `unspecified`
                 - 1: `none`
                 - 2: `ddl`
                 - 3: `mod`
                 - 4: `all`
               
               * `pool_mode` - Mode that the connection pooler is working in with specified user. One of:
                 - 1: `session`
                 - 2: `transaction`
                 - 3: `statement`
               
               * `prepared_statements_pooling` - This setting allows user to use prepared statements with transaction pooling. Boolean.
               
               * `catchup_timeout` - The connection pooler setting. It determines the maximum allowed replication lag (in seconds). Pooler will reject connections to the replica with a lag above this threshold. Default value is 0, which disables this feature. Integer.
               
               * `wal_sender_timeout` - The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+). Terminate replication connections that are inactive for longer than this amount of time. Integer.
               
               * `idle_in_transaction_session_timeout` - Sets the maximum allowed idle time (in milliseconds) between queries, when in a transaction. Value of 0 (default) disables the timeout. Integer.
               
               * `statement_timeout` - The maximum time (in milliseconds) to wait for statement. Value of 0 (default) disables the timeout. Integer
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbPostgresqlUserState.__new__(_MdbPostgresqlUserState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["conn_limit"] = conn_limit
        __props__.__dict__["connection_manager"] = connection_manager
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["generate_password"] = generate_password
        __props__.__dict__["grants"] = grants
        __props__.__dict__["login"] = login
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["settings"] = settings
        return MdbPostgresqlUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the PostgreSQL cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="connLimit")
    def conn_limit(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of connections per user. (Default 50).
        """
        return pulumi.get(self, "conn_limit")

    @_builtins.property
    @pulumi.getter(name="connectionManager")
    def connection_manager(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Connection Manager connection configuration. Filled in by the server automatically.
        """
        return pulumi.get(self, "connection_manager")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="generatePassword")
    def generate_password(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Generate password using Connection Manager. Allowed values: true or false. It's used only during user creation and is ignored during updating.
        """
        return pulumi.get(self, "generate_password")

    @_builtins.property
    @pulumi.getter
    def grants(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of the user's grants.
        """
        return pulumi.get(self, "grants")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        User's ability to login.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence['outputs.MdbPostgresqlUserPermission']]]:
        """
        Set of permissions granted to the user.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of user settings. [Full description](https://yandex.cloud/docs/managed-postgresql/api-ref/grpc/Cluster/create#yandex.cloud.mdb.postgresql.v1.UserSettings).

        * `default_transaction_isolation` - defines the default isolation level to be set for all new SQL transactions. One of:  - 0: `unspecified`
          - 1: `read uncommitted`
          - 2: `read committed`
          - 3: `repeatable read`
          - 4: `serializable`

        * `lock_timeout` - The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object (default 0)

        * `log_min_duration_statement` - This setting controls logging of the duration of statements. (default -1 disables logging of the duration of statements.)

        * `synchronous_commit` - This setting defines whether DBMS will commit transaction in a synchronous way. One of:
          - 0: `unspecified`
          - 1: `on`
          - 2: `off`
          - 3: `local`
          - 4: `remote write`
          - 5: `remote apply`

        * `temp_file_limit` - The maximum storage space size (in kilobytes) that a single process can use to create temporary files.

        * `log_statement` - This setting specifies which SQL statements should be logged (on the user level). One of:
          - 0: `unspecified`
          - 1: `none`
          - 2: `ddl`
          - 3: `mod`
          - 4: `all`

        * `pool_mode` - Mode that the connection pooler is working in with specified user. One of:
          - 1: `session`
          - 2: `transaction`
          - 3: `statement`

        * `prepared_statements_pooling` - This setting allows user to use prepared statements with transaction pooling. Boolean.

        * `catchup_timeout` - The connection pooler setting. It determines the maximum allowed replication lag (in seconds). Pooler will reject connections to the replica with a lag above this threshold. Default value is 0, which disables this feature. Integer.

        * `wal_sender_timeout` - The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+). Terminate replication connections that are inactive for longer than this amount of time. Integer.

        * `idle_in_transaction_session_timeout` - Sets the maximum allowed idle time (in milliseconds) between queries, when in a transaction. Value of 0 (default) disables the timeout. Integer.

        * `statement_timeout` - The maximum time (in milliseconds) to wait for statement. Value of 0 (default) disables the timeout. Integer
        """
        return pulumi.get(self, "settings")

