# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbRedisClusterArgs', 'MdbRedisCluster']

@pulumi.input_type
class MdbRedisClusterArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['MdbRedisClusterConfigArgs'],
                 environment: pulumi.Input[_builtins.str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]],
                 network_id: pulumi.Input[_builtins.str],
                 resources: pulumi.Input['MdbRedisClusterResourcesArgs'],
                 access: Optional[pulumi.Input['MdbRedisClusterAccessArgs']] = None,
                 announce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_sentinel: Optional[pulumi.Input[_builtins.bool]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs']] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbRedisClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sharded: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a MdbRedisCluster resource.
        :param pulumi.Input['MdbRedisClusterConfigArgs'] config: Configuration of the Redis cluster.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Redis cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]] hosts: A host of the Redis cluster.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input['MdbRedisClusterResourcesArgs'] resources: Resources allocated to hosts of the Redis cluster.
        :param pulumi.Input['MdbRedisClusterAccessArgs'] access: Access policy to the Redis cluster.
        :param pulumi.Input[_builtins.bool] announce_hostnames: Announce fqdn instead of ip address.
        :param pulumi.Input[_builtins.bool] auth_sentinel: Allows to use ACL users to auth in sentinel
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs'] disk_size_autoscaling: Disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbRedisClusterMaintenanceWindowArgs'] maintenance_window: Maintenance window settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] persistence_mode: Persistence mode. Possible values: `ON`, `OFF`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.bool] sharded: Redis Cluster mode enabled/disabled. Enables sharding when cluster non-sharded. If cluster is sharded - disabling is not allowed.
        :param pulumi.Input[_builtins.bool] tls_enabled: TLS support mode enabled/disabled.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "resources", resources)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if announce_hostnames is not None:
            pulumi.set(__self__, "announce_hostnames", announce_hostnames)
        if auth_sentinel is not None:
            pulumi.set(__self__, "auth_sentinel", auth_sentinel)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if disk_size_autoscaling is not None:
            pulumi.set(__self__, "disk_size_autoscaling", disk_size_autoscaling)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistence_mode is not None:
            pulumi.set(__self__, "persistence_mode", persistence_mode)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sharded is not None:
            pulumi.set(__self__, "sharded", sharded)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Input['MdbRedisClusterConfigArgs']:
        """
        Configuration of the Redis cluster.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['MdbRedisClusterConfigArgs']):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input[_builtins.str]:
        """
        Deployment environment of the Redis cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]]:
        """
        A host of the Redis cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Input['MdbRedisClusterResourcesArgs']:
        """
        Resources allocated to hosts of the Redis cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input['MdbRedisClusterResourcesArgs']):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbRedisClusterAccessArgs']]:
        """
        Access policy to the Redis cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbRedisClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="announceHostnames")
    def announce_hostnames(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Announce fqdn instead of ip address.
        """
        return pulumi.get(self, "announce_hostnames")

    @announce_hostnames.setter
    def announce_hostnames(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "announce_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="authSentinel")
    def auth_sentinel(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows to use ACL users to auth in sentinel
        """
        return pulumi.get(self, "auth_sentinel")

    @auth_sentinel.setter
    def auth_sentinel(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auth_sentinel", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscaling")
    def disk_size_autoscaling(self) -> Optional[pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs']]:
        """
        Disk size autoscaling settings.
        """
        return pulumi.get(self, "disk_size_autoscaling")

    @disk_size_autoscaling.setter
    def disk_size_autoscaling(self, value: Optional[pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs']]):
        pulumi.set(self, "disk_size_autoscaling", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbRedisClusterMaintenanceWindowArgs']]:
        """
        Maintenance window settings.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbRedisClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="persistenceMode")
    def persistence_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Persistence mode. Possible values: `ON`, `OFF`.
        """
        return pulumi.get(self, "persistence_mode")

    @persistence_mode.setter
    def persistence_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistence_mode", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def sharded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Redis Cluster mode enabled/disabled. Enables sharding when cluster non-sharded. If cluster is sharded - disabling is not allowed.
        """
        return pulumi.get(self, "sharded")

    @sharded.setter
    def sharded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sharded", value)

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        TLS support mode enabled/disabled.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)


@pulumi.input_type
class _MdbRedisClusterState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input['MdbRedisClusterAccessArgs']] = None,
                 announce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_sentinel: Optional[pulumi.Input[_builtins.bool]] = None,
                 config: Optional[pulumi.Input['MdbRedisClusterConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs']] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 health: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbRedisClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input['MdbRedisClusterResourcesArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sharded: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering MdbRedisCluster resources.
        :param pulumi.Input['MdbRedisClusterAccessArgs'] access: Access policy to the Redis cluster.
        :param pulumi.Input[_builtins.bool] announce_hostnames: Announce fqdn instead of ip address.
        :param pulumi.Input[_builtins.bool] auth_sentinel: Allows to use ACL users to auth in sentinel
        :param pulumi.Input['MdbRedisClusterConfigArgs'] config: Configuration of the Redis cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs'] disk_size_autoscaling: Disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Redis cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]] hosts: A host of the Redis cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['MdbRedisClusterMaintenanceWindowArgs'] maintenance_window: Maintenance window settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] persistence_mode: Persistence mode. Possible values: `ON`, `OFF`.
        :param pulumi.Input['MdbRedisClusterResourcesArgs'] resources: Resources allocated to hosts of the Redis cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.bool] sharded: Redis Cluster mode enabled/disabled. Enables sharding when cluster non-sharded. If cluster is sharded - disabling is not allowed.
        :param pulumi.Input[_builtins.str] status: Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        :param pulumi.Input[_builtins.bool] tls_enabled: TLS support mode enabled/disabled.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if announce_hostnames is not None:
            pulumi.set(__self__, "announce_hostnames", announce_hostnames)
        if auth_sentinel is not None:
            pulumi.set(__self__, "auth_sentinel", auth_sentinel)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key_id is not None:
            pulumi.set(__self__, "disk_encryption_key_id", disk_encryption_key_id)
        if disk_size_autoscaling is not None:
            pulumi.set(__self__, "disk_size_autoscaling", disk_size_autoscaling)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if persistence_mode is not None:
            pulumi.set(__self__, "persistence_mode", persistence_mode)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if sharded is not None:
            pulumi.set(__self__, "sharded", sharded)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbRedisClusterAccessArgs']]:
        """
        Access policy to the Redis cluster.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbRedisClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter(name="announceHostnames")
    def announce_hostnames(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Announce fqdn instead of ip address.
        """
        return pulumi.get(self, "announce_hostnames")

    @announce_hostnames.setter
    def announce_hostnames(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "announce_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="authSentinel")
    def auth_sentinel(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows to use ACL users to auth in sentinel
        """
        return pulumi.get(self, "auth_sentinel")

    @auth_sentinel.setter
    def auth_sentinel(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auth_sentinel", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['MdbRedisClusterConfigArgs']]:
        """
        Configuration of the Redis cluster.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['MdbRedisClusterConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @disk_encryption_key_id.setter
    def disk_encryption_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_key_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscaling")
    def disk_size_autoscaling(self) -> Optional[pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs']]:
        """
        Disk size autoscaling settings.
        """
        return pulumi.get(self, "disk_size_autoscaling")

    @disk_size_autoscaling.setter
    def disk_size_autoscaling(self, value: Optional[pulumi.Input['MdbRedisClusterDiskSizeAutoscalingArgs']]):
        pulumi.set(self, "disk_size_autoscaling", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment environment of the Redis cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]]]:
        """
        A host of the Redis cluster.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbRedisClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbRedisClusterMaintenanceWindowArgs']]:
        """
        Maintenance window settings.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbRedisClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="persistenceMode")
    def persistence_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Persistence mode. Possible values: `ON`, `OFF`.
        """
        return pulumi.get(self, "persistence_mode")

    @persistence_mode.setter
    def persistence_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistence_mode", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['MdbRedisClusterResourcesArgs']]:
        """
        Resources allocated to hosts of the Redis cluster.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['MdbRedisClusterResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter
    def sharded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Redis Cluster mode enabled/disabled. Enables sharding when cluster non-sharded. If cluster is sharded - disabling is not allowed.
        """
        return pulumi.get(self, "sharded")

    @sharded.setter
    def sharded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sharded", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        TLS support mode enabled/disabled.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)


@pulumi.type_token("yandex:index/mdbRedisCluster:MdbRedisCluster")
class MdbRedisCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbRedisClusterAccessArgs', 'MdbRedisClusterAccessArgsDict']]] = None,
                 announce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_sentinel: Optional[pulumi.Input[_builtins.bool]] = None,
                 config: Optional[pulumi.Input[Union['MdbRedisClusterConfigArgs', 'MdbRedisClusterConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input[Union['MdbRedisClusterDiskSizeAutoscalingArgs', 'MdbRedisClusterDiskSizeAutoscalingArgsDict']]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbRedisClusterHostArgs', 'MdbRedisClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbRedisClusterMaintenanceWindowArgs', 'MdbRedisClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['MdbRedisClusterResourcesArgs', 'MdbRedisClusterResourcesArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sharded: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Redis cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-redis/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB Redis Cluster.
        #
        my_cluster = yandex.MdbRedisCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "password": "your_password",
                "version": "6.2",
            },
            resources={
                "resource_preset_id": "hm1.nano",
                "disk_size": 16,
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }],
            maintenance_window={
                "type": "ANYTIME",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo_vpc_network = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo_vpc_network.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-b",
            network_id=foo_vpc_network.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        baz = yandex.VpcSubnet("baz",
            zone="ru-central1-d",
            network_id=foo_vpc_network.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB Sharded Redis Cluster.
        #
        foo = yandex.MdbRedisCluster("foo",
            name="test",
            environment="PRESTABLE",
            network_id=foo_vpc_network.id,
            sharded=True,
            config={
                "version": "6.2",
                "password": "your_password",
            },
            resources={
                "resource_preset_id": "hm1.nano",
                "disk_size": 16,
            },
            hosts=[
                {
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                    "shard_name": "first",
                },
                {
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                    "shard_name": "second",
                },
                {
                    "zone": "ru-central1-d",
                    "subnet_id": baz.id,
                    "shard_name": "third",
                },
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbRedisCluster:MdbRedisCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbRedisCluster:MdbRedisCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbRedisClusterAccessArgs', 'MdbRedisClusterAccessArgsDict']] access: Access policy to the Redis cluster.
        :param pulumi.Input[_builtins.bool] announce_hostnames: Announce fqdn instead of ip address.
        :param pulumi.Input[_builtins.bool] auth_sentinel: Allows to use ACL users to auth in sentinel
        :param pulumi.Input[Union['MdbRedisClusterConfigArgs', 'MdbRedisClusterConfigArgsDict']] config: Configuration of the Redis cluster.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[Union['MdbRedisClusterDiskSizeAutoscalingArgs', 'MdbRedisClusterDiskSizeAutoscalingArgsDict']] disk_size_autoscaling: Disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Redis cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbRedisClusterHostArgs', 'MdbRedisClusterHostArgsDict']]]] hosts: A host of the Redis cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbRedisClusterMaintenanceWindowArgs', 'MdbRedisClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance window settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] persistence_mode: Persistence mode. Possible values: `ON`, `OFF`.
        :param pulumi.Input[Union['MdbRedisClusterResourcesArgs', 'MdbRedisClusterResourcesArgsDict']] resources: Resources allocated to hosts of the Redis cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.bool] sharded: Redis Cluster mode enabled/disabled. Enables sharding when cluster non-sharded. If cluster is sharded - disabling is not allowed.
        :param pulumi.Input[_builtins.bool] tls_enabled: TLS support mode enabled/disabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbRedisClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Redis cluster within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/managed-redis/concepts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        foo = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-d",
            network_id=foo.id,
            v4_cidr_blocks=["10.5.0.0/24"])
        #
        # Create a new MDB Redis Cluster.
        #
        my_cluster = yandex.MdbRedisCluster("my_cluster",
            name="test",
            environment="PRESTABLE",
            network_id=foo.id,
            config={
                "password": "your_password",
                "version": "6.2",
            },
            resources={
                "resource_preset_id": "hm1.nano",
                "disk_size": 16,
            },
            hosts=[{
                "zone": "ru-central1-d",
                "subnet_id": foo_vpc_subnet.id,
            }],
            maintenance_window={
                "type": "ANYTIME",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        # Auxiliary resources
        foo_vpc_network = yandex.VpcNetwork("foo")
        foo_vpc_subnet = yandex.VpcSubnet("foo",
            zone="ru-central1-a",
            network_id=foo_vpc_network.id,
            v4_cidr_blocks=["10.1.0.0/24"])
        bar = yandex.VpcSubnet("bar",
            zone="ru-central1-b",
            network_id=foo_vpc_network.id,
            v4_cidr_blocks=["10.2.0.0/24"])
        baz = yandex.VpcSubnet("baz",
            zone="ru-central1-d",
            network_id=foo_vpc_network.id,
            v4_cidr_blocks=["10.3.0.0/24"])
        #
        # Create a new MDB Sharded Redis Cluster.
        #
        foo = yandex.MdbRedisCluster("foo",
            name="test",
            environment="PRESTABLE",
            network_id=foo_vpc_network.id,
            sharded=True,
            config={
                "version": "6.2",
                "password": "your_password",
            },
            resources={
                "resource_preset_id": "hm1.nano",
                "disk_size": 16,
            },
            hosts=[
                {
                    "zone": "ru-central1-a",
                    "subnet_id": foo_vpc_subnet.id,
                    "shard_name": "first",
                },
                {
                    "zone": "ru-central1-b",
                    "subnet_id": bar.id,
                    "shard_name": "second",
                },
                {
                    "zone": "ru-central1-d",
                    "subnet_id": baz.id,
                    "shard_name": "third",
                },
            ])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/mdbRedisCluster:MdbRedisCluster <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/mdbRedisCluster:MdbRedisCluster my_cluster ...
        ```

        :param str resource_name: The name of the resource.
        :param MdbRedisClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbRedisClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbRedisClusterAccessArgs', 'MdbRedisClusterAccessArgsDict']]] = None,
                 announce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_sentinel: Optional[pulumi.Input[_builtins.bool]] = None,
                 config: Optional[pulumi.Input[Union['MdbRedisClusterConfigArgs', 'MdbRedisClusterConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_autoscaling: Optional[pulumi.Input[Union['MdbRedisClusterDiskSizeAutoscalingArgs', 'MdbRedisClusterDiskSizeAutoscalingArgsDict']]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbRedisClusterHostArgs', 'MdbRedisClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbRedisClusterMaintenanceWindowArgs', 'MdbRedisClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resources: Optional[pulumi.Input[Union['MdbRedisClusterResourcesArgs', 'MdbRedisClusterResourcesArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sharded: Optional[pulumi.Input[_builtins.bool]] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbRedisClusterArgs.__new__(MdbRedisClusterArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["announce_hostnames"] = announce_hostnames
            __props__.__dict__["auth_sentinel"] = auth_sentinel
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
            __props__.__dict__["disk_size_autoscaling"] = disk_size_autoscaling
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["persistence_mode"] = persistence_mode
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["sharded"] = sharded
            __props__.__dict__["tls_enabled"] = tls_enabled
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["status"] = None
        super(MdbRedisCluster, __self__).__init__(
            'yandex:index/mdbRedisCluster:MdbRedisCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[Union['MdbRedisClusterAccessArgs', 'MdbRedisClusterAccessArgsDict']]] = None,
            announce_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
            auth_sentinel: Optional[pulumi.Input[_builtins.bool]] = None,
            config: Optional[pulumi.Input[Union['MdbRedisClusterConfigArgs', 'MdbRedisClusterConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size_autoscaling: Optional[pulumi.Input[Union['MdbRedisClusterDiskSizeAutoscalingArgs', 'MdbRedisClusterDiskSizeAutoscalingArgsDict']]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            health: Optional[pulumi.Input[_builtins.str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbRedisClusterHostArgs', 'MdbRedisClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbRedisClusterMaintenanceWindowArgs', 'MdbRedisClusterMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            persistence_mode: Optional[pulumi.Input[_builtins.str]] = None,
            resources: Optional[pulumi.Input[Union['MdbRedisClusterResourcesArgs', 'MdbRedisClusterResourcesArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sharded: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'MdbRedisCluster':
        """
        Get an existing MdbRedisCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbRedisClusterAccessArgs', 'MdbRedisClusterAccessArgsDict']] access: Access policy to the Redis cluster.
        :param pulumi.Input[_builtins.bool] announce_hostnames: Announce fqdn instead of ip address.
        :param pulumi.Input[_builtins.bool] auth_sentinel: Allows to use ACL users to auth in sentinel
        :param pulumi.Input[Union['MdbRedisClusterConfigArgs', 'MdbRedisClusterConfigArgsDict']] config: Configuration of the Redis cluster.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.bool] deletion_protection: The `true` value means that resource is protected from accidental deletion.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] disk_encryption_key_id: ID of the KMS key for cluster disk encryption.
        :param pulumi.Input[Union['MdbRedisClusterDiskSizeAutoscalingArgs', 'MdbRedisClusterDiskSizeAutoscalingArgsDict']] disk_size_autoscaling: Disk size autoscaling settings.
        :param pulumi.Input[_builtins.str] environment: Deployment environment of the Redis cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[_builtins.str] health: Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbRedisClusterHostArgs', 'MdbRedisClusterHostArgsDict']]]] hosts: A host of the Redis cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['MdbRedisClusterMaintenanceWindowArgs', 'MdbRedisClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance window settings.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[_builtins.str] network_id: The `VPC Network ID` of subnets which resource attached to.
        :param pulumi.Input[_builtins.str] persistence_mode: Persistence mode. Possible values: `ON`, `OFF`.
        :param pulumi.Input[Union['MdbRedisClusterResourcesArgs', 'MdbRedisClusterResourcesArgsDict']] resources: Resources allocated to hosts of the Redis cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The list of security groups applied to resource or their components.
        :param pulumi.Input[_builtins.bool] sharded: Redis Cluster mode enabled/disabled. Enables sharding when cluster non-sharded. If cluster is sharded - disabling is not allowed.
        :param pulumi.Input[_builtins.str] status: Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        :param pulumi.Input[_builtins.bool] tls_enabled: TLS support mode enabled/disabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbRedisClusterState.__new__(_MdbRedisClusterState)

        __props__.__dict__["access"] = access
        __props__.__dict__["announce_hostnames"] = announce_hostnames
        __props__.__dict__["auth_sentinel"] = auth_sentinel
        __props__.__dict__["config"] = config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_key_id"] = disk_encryption_key_id
        __props__.__dict__["disk_size_autoscaling"] = disk_size_autoscaling
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["persistence_mode"] = persistence_mode
        __props__.__dict__["resources"] = resources
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["sharded"] = sharded
        __props__.__dict__["status"] = status
        __props__.__dict__["tls_enabled"] = tls_enabled
        return MdbRedisCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def access(self) -> pulumi.Output['outputs.MdbRedisClusterAccess']:
        """
        Access policy to the Redis cluster.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter(name="announceHostnames")
    def announce_hostnames(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Announce fqdn instead of ip address.
        """
        return pulumi.get(self, "announce_hostnames")

    @_builtins.property
    @pulumi.getter(name="authSentinel")
    def auth_sentinel(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allows to use ACL users to auth in sentinel
        """
        return pulumi.get(self, "auth_sentinel")

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.MdbRedisClusterConfig']:
        """
        Configuration of the Redis cluster.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        The `true` value means that resource is protected from accidental deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeyId")
    def disk_encryption_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the KMS key for cluster disk encryption.
        """
        return pulumi.get(self, "disk_encryption_key_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeAutoscaling")
    def disk_size_autoscaling(self) -> pulumi.Output['outputs.MdbRedisClusterDiskSizeAutoscaling']:
        """
        Disk size autoscaling settings.
        """
        return pulumi.get(self, "disk_size_autoscaling")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment environment of the Redis cluster. Can be either `PRESTABLE` or `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[_builtins.str]:
        """
        Aggregated health of the cluster. Can be either `ALIVE`, `DEGRADED`, `DEAD` or `HEALTH_UNKNOWN`. For more information see `health` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbRedisClusterHost']]:
        """
        A host of the Redis cluster.
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbRedisClusterMaintenanceWindow']:
        """
        Maintenance window settings.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `VPC Network ID` of subnets which resource attached to.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="persistenceMode")
    def persistence_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Persistence mode. Possible values: `ON`, `OFF`.
        """
        return pulumi.get(self, "persistence_mode")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Output['outputs.MdbRedisClusterResources']:
        """
        Resources allocated to hosts of the Redis cluster.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of security groups applied to resource or their components.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def sharded(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Redis Cluster mode enabled/disabled. Enables sharding when cluster non-sharded. If cluster is sharded - disabling is not allowed.
        """
        return pulumi.get(self, "sharded")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://yandex.cloud/docs/managed-redis/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        TLS support mode enabled/disabled.
        """
        return pulumi.get(self, "tls_enabled")

