# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationmanagerGroupMembershipArgs', 'OrganizationmanagerGroupMembership']

@pulumi.input_type
class OrganizationmanagerGroupMembershipArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 members: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        The set of arguments for constructing a OrganizationmanagerGroupMembership resource.
        :param pulumi.Input[_builtins.str] group_id: The Group to add/remove members to/from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members of the Group. Each member is represented by an id.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "members", members)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Group to add/remove members to/from.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A set of members of the Group. Each member is represented by an id.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "members", value)


@pulumi.input_type
class _OrganizationmanagerGroupMembershipState:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OrganizationmanagerGroupMembership resources.
        :param pulumi.Input[_builtins.str] group_id: The Group to add/remove members to/from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members of the Group. Each member is represented by an id.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if members is not None:
            pulumi.set(__self__, "members", members)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Group to add/remove members to/from.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of members of the Group. Each member is represented by an id.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)


@pulumi.type_token("yandex:index/organizationmanagerGroupMembership:OrganizationmanagerGroupMembership")
class OrganizationmanagerGroupMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Allows members management of a single Yandex Cloud Organization Manager Group. For more information, see [the official documentation](https://yandex.cloud/docs/organization/manage-groups#add-member).

        > Multiple `yandex_organizationmanager_group_iam_binding` resources with the same group id will produce inconsistent behavior!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager Group Membership.
        #
        group = yandex.OrganizationmanagerGroupMembership("group",
            group_id="sdf4*********3fr",
            members=["xdf********123"])
        ```

        ## Import

        ~> Import for this resource is not implemented yet.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: The Group to add/remove members to/from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members of the Group. Each member is represented by an id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationmanagerGroupMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows members management of a single Yandex Cloud Organization Manager Group. For more information, see [the official documentation](https://yandex.cloud/docs/organization/manage-groups#add-member).

        > Multiple `yandex_organizationmanager_group_iam_binding` resources with the same group id will produce inconsistent behavior!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new OrganizationManager Group Membership.
        #
        group = yandex.OrganizationmanagerGroupMembership("group",
            group_id="sdf4*********3fr",
            members=["xdf********123"])
        ```

        ## Import

        ~> Import for this resource is not implemented yet.

        :param str resource_name: The name of the resource.
        :param OrganizationmanagerGroupMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationmanagerGroupMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationmanagerGroupMembershipArgs.__new__(OrganizationmanagerGroupMembershipArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
        super(OrganizationmanagerGroupMembership, __self__).__init__(
            'yandex:index/organizationmanagerGroupMembership:OrganizationmanagerGroupMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'OrganizationmanagerGroupMembership':
        """
        Get an existing OrganizationmanagerGroupMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: The Group to add/remove members to/from.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members of the Group. Each member is represented by an id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationmanagerGroupMembershipState.__new__(_OrganizationmanagerGroupMembershipState)

        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["members"] = members
        return OrganizationmanagerGroupMembership(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Group to add/remove members to/from.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of members of the Group. Each member is represented by an id.
        """
        return pulumi.get(self, "members")

