# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext: Optional[pulumi.Input[_builtins.bool]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 yq_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] cloud_id: The ID of the [Cloud](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#cloud) to apply any resources to.
               This can also be specified using environment variable `YC_CLOUD_ID`.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint for API calls, default value is **api.cloud.yandex.net:443**.
               This can also be defined by environment variable `YC_ENDPOINT`.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the [Folder](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#folder) to operate under, if not specified by a given resource.
               This can also be specified using environment variable `YC_FOLDER_ID`.
        :param pulumi.Input[_builtins.bool] insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`.
        :param pulumi.Input[_builtins.int] max_retries: This is the maximum number of times an API call is retried, in the case where requests are being throttled or experiencing transient failures. The delay between the subsequent API calls increases exponentially.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the [Cloud Organization](https://yandex.cloud/docs/organization/quickstart) to operate under.
        :param pulumi.Input[_builtins.bool] plaintext: Disable use of TLS. Default value is `false`.
        :param pulumi.Input[_builtins.str] profile: Profile name to use in the shared credentials file. Default value is `default`.
        :param pulumi.Input[_builtins.str] region_id: [The region](https://yandex.cloud/docs/overview/concepts/region) where operations will take place. For example `ru-central1`.
        :param pulumi.Input[_builtins.str] service_account_key_file: Contains either a path to or the contents of the [Service Account file](https://yandex.cloud/docs/iam/concepts/authorization/key) in JSON format.
               This can also be specified using environment variable `YC_SERVICE_ACCOUNT_KEY_FILE`. You can read how to create service account key file [here](https://yandex.cloud/docs/iam/operations/iam-token/create-for-sa#keys-create).
               
               > Only one of `token` or `service_account_key_file` must be specified.
               
               > One can authenticate via instance service account from inside a compute instance. In order to use this method, omit both `token`/`service_account_key_file` and attach service account to the instance. [Working with Yandex Cloud from inside an instance](https://yandex.cloud/docs/compute/operations/vm-connect/auth-inside-vm).
        :param pulumi.Input[_builtins.str] shared_credentials_file: Shared credentials file path.
               Supported keys: `storage_access_key` and `storage_secret_key`.
               
               > The `storage_access_key` and `storage_secret_key` attributes from the shared credentials file are used only when the provider and a storage data/resource do not have an access/secret keys explicitly specified.
        :param pulumi.Input[_builtins.str] storage_access_key: Yandex Cloud Object Storage access key, which is used when a storage data/resource doesn't have an access key explicitly specified. 
               This can also be specified using environment variable `YC_STORAGE_ACCESS_KEY`.
        :param pulumi.Input[_builtins.str] storage_endpoint: Yandex Cloud [Object Storage Endpoint](https://yandex.cloud/docs/storage/s3/#request-url), which is used to connect to `S3 API`. Default value is **storage.yandexcloud.net**.
        :param pulumi.Input[_builtins.str] storage_secret_key: Yandex Cloud Object Storage secret key, which is used when a storage data/resource doesn't have a secret key explicitly specified.
               This can also be specified using environment variable `YC_STORAGE_SECRET_KEY`.
        :param pulumi.Input[_builtins.str] token: Security token or IAM token used for authentication in Yandex Cloud.
               Check [documentation](https://yandex.cloud/docs/iam/operations/iam-token/create) about how to create IAM token. This can also be specified using environment variable `YC_TOKEN`.
        :param pulumi.Input[_builtins.str] ymq_access_key: Yandex Cloud Message Queue service access key, which is used when a YMQ queue resource doesn't have an access key explicitly specified.
                 This can also be specified using environment variable `YC_MESSAGE_QUEUE_ACCESS_KEY`.
        :param pulumi.Input[_builtins.str] ymq_endpoint: Yandex Cloud Message Queue service endpoint. Default value is **message-queue.api.cloud.yandex.net**.
        :param pulumi.Input[_builtins.str] ymq_secret_key: Yandex Cloud Message Queue service secret key, which is used when a YMQ queue resource doesn't have a secret key explicitly specified.
               This can also be specified using environment variable `YC_MESSAGE_QUEUE_SECRET_KEY`.
        :param pulumi.Input[_builtins.str] yq_endpoint: The Yandex Query API endpoint, default value is **grpc.yandex-query.cloud.yandex.net:2135**.
               This can also be defined by environment variable `YC_YQ_ENDPOINT`.
        :param pulumi.Input[_builtins.str] zone: The default [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) to operate under, if not specified by a given resource.
               This can also be specified using environment variable `YC_ZONE`.
        """
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if plaintext is not None:
            pulumi.set(__self__, "plaintext", plaintext)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if service_account_key_file is not None:
            pulumi.set(__self__, "service_account_key_file", service_account_key_file)
        if shared_credentials_file is not None:
            pulumi.set(__self__, "shared_credentials_file", shared_credentials_file)
        if storage_access_key is not None:
            pulumi.set(__self__, "storage_access_key", storage_access_key)
        if storage_endpoint is not None:
            pulumi.set(__self__, "storage_endpoint", storage_endpoint)
        if storage_secret_key is not None:
            pulumi.set(__self__, "storage_secret_key", storage_secret_key)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if ymq_access_key is not None:
            pulumi.set(__self__, "ymq_access_key", ymq_access_key)
        if ymq_endpoint is not None:
            pulumi.set(__self__, "ymq_endpoint", ymq_endpoint)
        if ymq_secret_key is not None:
            pulumi.set(__self__, "ymq_secret_key", ymq_secret_key)
        if yq_endpoint is not None:
            pulumi.set(__self__, "yq_endpoint", yq_endpoint)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the [Cloud](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#cloud) to apply any resources to.
        This can also be specified using environment variable `YC_CLOUD_ID`.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint for API calls, default value is **api.cloud.yandex.net:443**.
        This can also be defined by environment variable `YC_ENDPOINT`.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the [Folder](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#folder) to operate under, if not specified by a given resource.
        This can also be specified using environment variable `YC_FOLDER_ID`.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`.
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This is the maximum number of times an API call is retried, in the case where requests are being throttled or experiencing transient failures. The delay between the subsequent API calls increases exponentially.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the [Cloud Organization](https://yandex.cloud/docs/organization/quickstart) to operate under.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def plaintext(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable use of TLS. Default value is `false`.
        """
        return pulumi.get(self, "plaintext")

    @plaintext.setter
    def plaintext(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "plaintext", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Profile name to use in the shared credentials file. Default value is `default`.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [The region](https://yandex.cloud/docs/overview/concepts/region) where operations will take place. For example `ru-central1`.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountKeyFile")
    def service_account_key_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contains either a path to or the contents of the [Service Account file](https://yandex.cloud/docs/iam/concepts/authorization/key) in JSON format.
        This can also be specified using environment variable `YC_SERVICE_ACCOUNT_KEY_FILE`. You can read how to create service account key file [here](https://yandex.cloud/docs/iam/operations/iam-token/create-for-sa#keys-create).

        > Only one of `token` or `service_account_key_file` must be specified.

        > One can authenticate via instance service account from inside a compute instance. In order to use this method, omit both `token`/`service_account_key_file` and attach service account to the instance. [Working with Yandex Cloud from inside an instance](https://yandex.cloud/docs/compute/operations/vm-connect/auth-inside-vm).
        """
        return pulumi.get(self, "service_account_key_file")

    @service_account_key_file.setter
    def service_account_key_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_key_file", value)

    @_builtins.property
    @pulumi.getter(name="sharedCredentialsFile")
    def shared_credentials_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared credentials file path.
        Supported keys: `storage_access_key` and `storage_secret_key`.

        > The `storage_access_key` and `storage_secret_key` attributes from the shared credentials file are used only when the provider and a storage data/resource do not have an access/secret keys explicitly specified.
        """
        return pulumi.get(self, "shared_credentials_file")

    @shared_credentials_file.setter
    def shared_credentials_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_credentials_file", value)

    @_builtins.property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yandex Cloud Object Storage access key, which is used when a storage data/resource doesn't have an access key explicitly specified. 
        This can also be specified using environment variable `YC_STORAGE_ACCESS_KEY`.
        """
        return pulumi.get(self, "storage_access_key")

    @storage_access_key.setter
    def storage_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yandex Cloud [Object Storage Endpoint](https://yandex.cloud/docs/storage/s3/#request-url), which is used to connect to `S3 API`. Default value is **storage.yandexcloud.net**.
        """
        return pulumi.get(self, "storage_endpoint")

    @storage_endpoint.setter
    def storage_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="storageSecretKey")
    def storage_secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yandex Cloud Object Storage secret key, which is used when a storage data/resource doesn't have a secret key explicitly specified.
        This can also be specified using environment variable `YC_STORAGE_SECRET_KEY`.
        """
        return pulumi.get(self, "storage_secret_key")

    @storage_secret_key.setter
    def storage_secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_secret_key", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security token or IAM token used for authentication in Yandex Cloud.
        Check [documentation](https://yandex.cloud/docs/iam/operations/iam-token/create) about how to create IAM token. This can also be specified using environment variable `YC_TOKEN`.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="ymqAccessKey")
    def ymq_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yandex Cloud Message Queue service access key, which is used when a YMQ queue resource doesn't have an access key explicitly specified.
          This can also be specified using environment variable `YC_MESSAGE_QUEUE_ACCESS_KEY`.
        """
        return pulumi.get(self, "ymq_access_key")

    @ymq_access_key.setter
    def ymq_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ymq_access_key", value)

    @_builtins.property
    @pulumi.getter(name="ymqEndpoint")
    def ymq_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yandex Cloud Message Queue service endpoint. Default value is **message-queue.api.cloud.yandex.net**.
        """
        return pulumi.get(self, "ymq_endpoint")

    @ymq_endpoint.setter
    def ymq_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ymq_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="ymqSecretKey")
    def ymq_secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Yandex Cloud Message Queue service secret key, which is used when a YMQ queue resource doesn't have a secret key explicitly specified.
        This can also be specified using environment variable `YC_MESSAGE_QUEUE_SECRET_KEY`.
        """
        return pulumi.get(self, "ymq_secret_key")

    @ymq_secret_key.setter
    def ymq_secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ymq_secret_key", value)

    @_builtins.property
    @pulumi.getter(name="yqEndpoint")
    def yq_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Yandex Query API endpoint, default value is **grpc.yandex-query.cloud.yandex.net:2135**.
        This can also be defined by environment variable `YC_YQ_ENDPOINT`.
        """
        return pulumi.get(self, "yq_endpoint")

    @yq_endpoint.setter
    def yq_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "yq_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) to operate under, if not specified by a given resource.
        This can also be specified using environment variable `YC_ZONE`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("pulumi:providers:yandex")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext: Optional[pulumi.Input[_builtins.bool]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 yq_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the yandex package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_id: The ID of the [Cloud](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#cloud) to apply any resources to.
               This can also be specified using environment variable `YC_CLOUD_ID`.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint for API calls, default value is **api.cloud.yandex.net:443**.
               This can also be defined by environment variable `YC_ENDPOINT`.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the [Folder](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#folder) to operate under, if not specified by a given resource.
               This can also be specified using environment variable `YC_FOLDER_ID`.
        :param pulumi.Input[_builtins.bool] insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`.
        :param pulumi.Input[_builtins.int] max_retries: This is the maximum number of times an API call is retried, in the case where requests are being throttled or experiencing transient failures. The delay between the subsequent API calls increases exponentially.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the [Cloud Organization](https://yandex.cloud/docs/organization/quickstart) to operate under.
        :param pulumi.Input[_builtins.bool] plaintext: Disable use of TLS. Default value is `false`.
        :param pulumi.Input[_builtins.str] profile: Profile name to use in the shared credentials file. Default value is `default`.
        :param pulumi.Input[_builtins.str] region_id: [The region](https://yandex.cloud/docs/overview/concepts/region) where operations will take place. For example `ru-central1`.
        :param pulumi.Input[_builtins.str] service_account_key_file: Contains either a path to or the contents of the [Service Account file](https://yandex.cloud/docs/iam/concepts/authorization/key) in JSON format.
               This can also be specified using environment variable `YC_SERVICE_ACCOUNT_KEY_FILE`. You can read how to create service account key file [here](https://yandex.cloud/docs/iam/operations/iam-token/create-for-sa#keys-create).
               
               > Only one of `token` or `service_account_key_file` must be specified.
               
               > One can authenticate via instance service account from inside a compute instance. In order to use this method, omit both `token`/`service_account_key_file` and attach service account to the instance. [Working with Yandex Cloud from inside an instance](https://yandex.cloud/docs/compute/operations/vm-connect/auth-inside-vm).
        :param pulumi.Input[_builtins.str] shared_credentials_file: Shared credentials file path.
               Supported keys: `storage_access_key` and `storage_secret_key`.
               
               > The `storage_access_key` and `storage_secret_key` attributes from the shared credentials file are used only when the provider and a storage data/resource do not have an access/secret keys explicitly specified.
        :param pulumi.Input[_builtins.str] storage_access_key: Yandex Cloud Object Storage access key, which is used when a storage data/resource doesn't have an access key explicitly specified. 
               This can also be specified using environment variable `YC_STORAGE_ACCESS_KEY`.
        :param pulumi.Input[_builtins.str] storage_endpoint: Yandex Cloud [Object Storage Endpoint](https://yandex.cloud/docs/storage/s3/#request-url), which is used to connect to `S3 API`. Default value is **storage.yandexcloud.net**.
        :param pulumi.Input[_builtins.str] storage_secret_key: Yandex Cloud Object Storage secret key, which is used when a storage data/resource doesn't have a secret key explicitly specified.
               This can also be specified using environment variable `YC_STORAGE_SECRET_KEY`.
        :param pulumi.Input[_builtins.str] token: Security token or IAM token used for authentication in Yandex Cloud.
               Check [documentation](https://yandex.cloud/docs/iam/operations/iam-token/create) about how to create IAM token. This can also be specified using environment variable `YC_TOKEN`.
        :param pulumi.Input[_builtins.str] ymq_access_key: Yandex Cloud Message Queue service access key, which is used when a YMQ queue resource doesn't have an access key explicitly specified.
                 This can also be specified using environment variable `YC_MESSAGE_QUEUE_ACCESS_KEY`.
        :param pulumi.Input[_builtins.str] ymq_endpoint: Yandex Cloud Message Queue service endpoint. Default value is **message-queue.api.cloud.yandex.net**.
        :param pulumi.Input[_builtins.str] ymq_secret_key: Yandex Cloud Message Queue service secret key, which is used when a YMQ queue resource doesn't have a secret key explicitly specified.
               This can also be specified using environment variable `YC_MESSAGE_QUEUE_SECRET_KEY`.
        :param pulumi.Input[_builtins.str] yq_endpoint: The Yandex Query API endpoint, default value is **grpc.yandex-query.cloud.yandex.net:2135**.
               This can also be defined by environment variable `YC_YQ_ENDPOINT`.
        :param pulumi.Input[_builtins.str] zone: The default [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) to operate under, if not specified by a given resource.
               This can also be specified using environment variable `YC_ZONE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the yandex package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plaintext: Optional[pulumi.Input[_builtins.bool]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_credentials_file: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ymq_secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 yq_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["plaintext"] = pulumi.Output.from_input(plaintext).apply(pulumi.runtime.to_json) if plaintext is not None else None
            __props__.__dict__["profile"] = profile
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["service_account_key_file"] = service_account_key_file
            __props__.__dict__["shared_credentials_file"] = shared_credentials_file
            __props__.__dict__["storage_access_key"] = storage_access_key
            __props__.__dict__["storage_endpoint"] = storage_endpoint
            __props__.__dict__["storage_secret_key"] = None if storage_secret_key is None else pulumi.Output.secret(storage_secret_key)
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["ymq_access_key"] = ymq_access_key
            __props__.__dict__["ymq_endpoint"] = ymq_endpoint
            __props__.__dict__["ymq_secret_key"] = None if ymq_secret_key is None else pulumi.Output.secret(ymq_secret_key)
            __props__.__dict__["yq_endpoint"] = yq_endpoint
            __props__.__dict__["zone"] = zone
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageSecretKey", "token", "ymqSecretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'yandex',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the [Cloud](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#cloud) to apply any resources to.
        This can also be specified using environment variable `YC_CLOUD_ID`.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The endpoint for API calls, default value is **api.cloud.yandex.net:443**.
        This can also be defined by environment variable `YC_ENDPOINT`.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the [Folder](https://yandex.cloud/docs/resource-manager/concepts/resources-hierarchy#folder) to operate under, if not specified by a given resource.
        This can also be specified using environment variable `YC_FOLDER_ID`.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the [Cloud Organization](https://yandex.cloud/docs/organization/quickstart) to operate under.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Profile name to use in the shared credentials file. Default value is `default`.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [The region](https://yandex.cloud/docs/overview/concepts/region) where operations will take place. For example `ru-central1`.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccountKeyFile")
    def service_account_key_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Contains either a path to or the contents of the [Service Account file](https://yandex.cloud/docs/iam/concepts/authorization/key) in JSON format.
        This can also be specified using environment variable `YC_SERVICE_ACCOUNT_KEY_FILE`. You can read how to create service account key file [here](https://yandex.cloud/docs/iam/operations/iam-token/create-for-sa#keys-create).

        > Only one of `token` or `service_account_key_file` must be specified.

        > One can authenticate via instance service account from inside a compute instance. In order to use this method, omit both `token`/`service_account_key_file` and attach service account to the instance. [Working with Yandex Cloud from inside an instance](https://yandex.cloud/docs/compute/operations/vm-connect/auth-inside-vm).
        """
        return pulumi.get(self, "service_account_key_file")

    @_builtins.property
    @pulumi.getter(name="sharedCredentialsFile")
    def shared_credentials_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Shared credentials file path.
        Supported keys: `storage_access_key` and `storage_secret_key`.

        > The `storage_access_key` and `storage_secret_key` attributes from the shared credentials file are used only when the provider and a storage data/resource do not have an access/secret keys explicitly specified.
        """
        return pulumi.get(self, "shared_credentials_file")

    @_builtins.property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Yandex Cloud Object Storage access key, which is used when a storage data/resource doesn't have an access key explicitly specified. 
        This can also be specified using environment variable `YC_STORAGE_ACCESS_KEY`.
        """
        return pulumi.get(self, "storage_access_key")

    @_builtins.property
    @pulumi.getter(name="storageEndpoint")
    def storage_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Yandex Cloud [Object Storage Endpoint](https://yandex.cloud/docs/storage/s3/#request-url), which is used to connect to `S3 API`. Default value is **storage.yandexcloud.net**.
        """
        return pulumi.get(self, "storage_endpoint")

    @_builtins.property
    @pulumi.getter(name="storageSecretKey")
    def storage_secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Yandex Cloud Object Storage secret key, which is used when a storage data/resource doesn't have a secret key explicitly specified.
        This can also be specified using environment variable `YC_STORAGE_SECRET_KEY`.
        """
        return pulumi.get(self, "storage_secret_key")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Security token or IAM token used for authentication in Yandex Cloud.
        Check [documentation](https://yandex.cloud/docs/iam/operations/iam-token/create) about how to create IAM token. This can also be specified using environment variable `YC_TOKEN`.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="ymqAccessKey")
    def ymq_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Yandex Cloud Message Queue service access key, which is used when a YMQ queue resource doesn't have an access key explicitly specified.
          This can also be specified using environment variable `YC_MESSAGE_QUEUE_ACCESS_KEY`.
        """
        return pulumi.get(self, "ymq_access_key")

    @_builtins.property
    @pulumi.getter(name="ymqEndpoint")
    def ymq_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Yandex Cloud Message Queue service endpoint. Default value is **message-queue.api.cloud.yandex.net**.
        """
        return pulumi.get(self, "ymq_endpoint")

    @_builtins.property
    @pulumi.getter(name="ymqSecretKey")
    def ymq_secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Yandex Cloud Message Queue service secret key, which is used when a YMQ queue resource doesn't have a secret key explicitly specified.
        This can also be specified using environment variable `YC_MESSAGE_QUEUE_SECRET_KEY`.
        """
        return pulumi.get(self, "ymq_secret_key")

    @_builtins.property
    @pulumi.getter(name="yqEndpoint")
    def yq_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Yandex Query API endpoint, default value is **grpc.yandex-query.cloud.yandex.net:2135**.
        This can also be defined by environment variable `YC_YQ_ENDPOINT`.
        """
        return pulumi.get(self, "yq_endpoint")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default [availability zone](https://yandex.cloud/docs/overview/concepts/geo-scope) to operate under, if not specified by a given resource.
        This can also be specified using environment variable `YC_ZONE`.
        """
        return pulumi.get(self, "zone")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:yandex/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

