# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ResourcemanagerFolderIamPolicyArgs', 'ResourcemanagerFolderIamPolicy']

@pulumi.input_type
class ResourcemanagerFolderIamPolicyArgs:
    def __init__(__self__, *,
                 folder_id: pulumi.Input[_builtins.str],
                 policy_data: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ResourcemanagerFolderIamPolicy resource.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the folder to attach a policy to.
        :param pulumi.Input[_builtins.str] policy_data: Required only by `IamServiceAccountIamPolicy`. The policy data generated by a `get_iam_policy` data source.
        """
        pulumi.set(__self__, "folder_id", folder_id)
        pulumi.set(__self__, "policy_data", policy_data)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the folder to attach a policy to.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Input[_builtins.str]:
        """
        Required only by `IamServiceAccountIamPolicy`. The policy data generated by a `get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_data", value)


@pulumi.input_type
class _ResourcemanagerFolderIamPolicyState:
    def __init__(__self__, *,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourcemanagerFolderIamPolicy resources.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the folder to attach a policy to.
        :param pulumi.Input[_builtins.str] policy_data: Required only by `IamServiceAccountIamPolicy`. The policy data generated by a `get_iam_policy` data source.
        """
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if policy_data is not None:
            pulumi.set(__self__, "policy_data", policy_data)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the folder to attach a policy to.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required only by `IamServiceAccountIamPolicy`. The policy data generated by a `get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_data", value)


@pulumi.type_token("yandex:index/resourcemanagerFolderIamPolicy:ResourcemanagerFolderIamPolicy")
class ResourcemanagerFolderIamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows creation and management of the IAM policy for an existing Yandex Resource Manager folder.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new IAM Policy for existing Folder.
        #
        project1 = yandex.get_resourcemanager_folder(folder_id="my_folder_id")
        admin = yandex.get_iam_policy(bindings=[{
            "role": "editor",
            "members": ["userAccount:some_user_id"],
        }])
        folder_admin_policy = yandex.ResourcemanagerFolderIamPolicy("folder_admin_policy",
            folder_id=project1_yandex_folder["id"],
            policy_data=admin.policy_data)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/resourcemanagerFolderIamPolicy:ResourcemanagerFolderIamPolicy <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/resourcemanagerFolderIamPolicy:ResourcemanagerFolderIamPolicy folder_admin_policy ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the folder to attach a policy to.
        :param pulumi.Input[_builtins.str] policy_data: Required only by `IamServiceAccountIamPolicy`. The policy data generated by a `get_iam_policy` data source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourcemanagerFolderIamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows creation and management of the IAM policy for an existing Yandex Resource Manager folder.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new IAM Policy for existing Folder.
        #
        project1 = yandex.get_resourcemanager_folder(folder_id="my_folder_id")
        admin = yandex.get_iam_policy(bindings=[{
            "role": "editor",
            "members": ["userAccount:some_user_id"],
        }])
        folder_admin_policy = yandex.ResourcemanagerFolderIamPolicy("folder_admin_policy",
            folder_id=project1_yandex_folder["id"],
            policy_data=admin.policy_data)
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/resourcemanagerFolderIamPolicy:ResourcemanagerFolderIamPolicy <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/resourcemanagerFolderIamPolicy:ResourcemanagerFolderIamPolicy folder_admin_policy ...
        ```

        :param str resource_name: The name of the resource.
        :param ResourcemanagerFolderIamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourcemanagerFolderIamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourcemanagerFolderIamPolicyArgs.__new__(ResourcemanagerFolderIamPolicyArgs)

            if folder_id is None and not opts.urn:
                raise TypeError("Missing required property 'folder_id'")
            __props__.__dict__["folder_id"] = folder_id
            if policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'policy_data'")
            __props__.__dict__["policy_data"] = policy_data
        super(ResourcemanagerFolderIamPolicy, __self__).__init__(
            'yandex:index/resourcemanagerFolderIamPolicy:ResourcemanagerFolderIamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_data: Optional[pulumi.Input[_builtins.str]] = None) -> 'ResourcemanagerFolderIamPolicy':
        """
        Get an existing ResourcemanagerFolderIamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] folder_id: The ID of the folder to attach a policy to.
        :param pulumi.Input[_builtins.str] policy_data: Required only by `IamServiceAccountIamPolicy`. The policy data generated by a `get_iam_policy` data source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourcemanagerFolderIamPolicyState.__new__(_ResourcemanagerFolderIamPolicyState)

        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["policy_data"] = policy_data
        return ResourcemanagerFolderIamPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the folder to attach a policy to.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Output[_builtins.str]:
        """
        Required only by `IamServiceAccountIamPolicy`. The policy data generated by a `get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

