# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerlessContainerArgs', 'ServerlessContainer']

@pulumi.input_type
class ServerlessContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input['ServerlessContainerImageArgs'],
                 memory: pulumi.Input[_builtins.int],
                 async_invocation: Optional[pulumi.Input['ServerlessContainerAsyncInvocationArgs']] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input['ServerlessContainerConnectivityArgs']] = None,
                 core_fraction: Optional[pulumi.Input[_builtins.int]] = None,
                 cores: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input['ServerlessContainerLogOptionsArgs']] = None,
                 metadata_options: Optional[pulumi.Input['ServerlessContainerMetadataOptionsArgs']] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_policy: Optional[pulumi.Input['ServerlessContainerProvisionPolicyArgs']] = None,
                 runtime: Optional[pulumi.Input['ServerlessContainerRuntimeArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]]] = None):
        """
        The set of arguments for constructing a ServerlessContainer resource.
        :param pulumi.Input['ServerlessContainerImageArgs'] image: Revision deployment image for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128 MB**).
        :param pulumi.Input['ServerlessContainerAsyncInvocationArgs'] async_invocation: Config for asynchronous invocations of Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] concurrency: Concurrency of Yandex Cloud Serverless Container.
        :param pulumi.Input['ServerlessContainerConnectivityArgs'] connectivity: Network access. If specified the revision will be attached to specified network.
        :param pulumi.Input[_builtins.int] core_fraction: Core fraction (**0...100**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] cores: Cores (**1+**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds (**duration format**) for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['ServerlessContainerLogOptionsArgs'] log_options: Options for logging from Yandex Cloud Serverless Container.
        :param pulumi.Input['ServerlessContainerMetadataOptionsArgs'] metadata_options: Options set the access mode to revision's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]] mounts: Mounts for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['ServerlessContainerProvisionPolicyArgs'] provision_policy: Provision policy. If specified the revision will have prepared instances.
        :param pulumi.Input['ServerlessContainerRuntimeArgs'] runtime: Runtime for Yandex Cloud Serverless Container.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]] secrets: Secrets for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]] storage_mounts: (**DEPRECATED**, use `mounts.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "memory", memory)
        if async_invocation is not None:
            pulumi.set(__self__, "async_invocation", async_invocation)
        if concurrency is not None:
            pulumi.set(__self__, "concurrency", concurrency)
        if connectivity is not None:
            pulumi.set(__self__, "connectivity", connectivity)
        if core_fraction is not None:
            pulumi.set(__self__, "core_fraction", core_fraction)
        if cores is not None:
            pulumi.set(__self__, "cores", cores)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provision_policy is not None:
            pulumi.set(__self__, "provision_policy", provision_policy)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if storage_mounts is not None:
            warnings.warn("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""", DeprecationWarning)
            pulumi.log.warn("""storage_mounts is deprecated: The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
        if storage_mounts is not None:
            pulumi.set(__self__, "storage_mounts", storage_mounts)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input['ServerlessContainerImageArgs']:
        """
        Revision deployment image for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input['ServerlessContainerImageArgs']):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Input[_builtins.int]:
        """
        Memory in megabytes (**aligned to 128 MB**).
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="asyncInvocation")
    def async_invocation(self) -> Optional[pulumi.Input['ServerlessContainerAsyncInvocationArgs']]:
        """
        Config for asynchronous invocations of Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "async_invocation")

    @async_invocation.setter
    def async_invocation(self, value: Optional[pulumi.Input['ServerlessContainerAsyncInvocationArgs']]):
        pulumi.set(self, "async_invocation", value)

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Concurrency of Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency", value)

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> Optional[pulumi.Input['ServerlessContainerConnectivityArgs']]:
        """
        Network access. If specified the revision will be attached to specified network.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: Optional[pulumi.Input['ServerlessContainerConnectivityArgs']]):
        pulumi.set(self, "connectivity", value)

    @_builtins.property
    @pulumi.getter(name="coreFraction")
    def core_fraction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Core fraction (**0...100**) of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "core_fraction")

    @core_fraction.setter
    def core_fraction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "core_fraction", value)

    @_builtins.property
    @pulumi.getter
    def cores(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cores (**1+**) of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "cores")

    @cores.setter
    def cores(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cores", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution timeout in seconds (**duration format**) for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_timeout", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['ServerlessContainerLogOptionsArgs']]:
        """
        Options for logging from Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['ServerlessContainerLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['ServerlessContainerMetadataOptionsArgs']]:
        """
        Options set the access mode to revision's metadata endpoints.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['ServerlessContainerMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]]]:
        """
        Mounts for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="provisionPolicy")
    def provision_policy(self) -> Optional[pulumi.Input['ServerlessContainerProvisionPolicyArgs']]:
        """
        Provision policy. If specified the revision will have prepared instances.
        """
        return pulumi.get(self, "provision_policy")

    @provision_policy.setter
    def provision_policy(self, value: Optional[pulumi.Input['ServerlessContainerProvisionPolicyArgs']]):
        pulumi.set(self, "provision_policy", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['ServerlessContainerRuntimeArgs']]:
        """
        Runtime for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['ServerlessContainerRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]]]:
        """
        Secrets for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageMounts")
    @_utilities.deprecated("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
    def storage_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]]]:
        """
        (**DEPRECATED**, use `mounts.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "storage_mounts")

    @storage_mounts.setter
    def storage_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]]]):
        pulumi.set(self, "storage_mounts", value)


@pulumi.input_type
class _ServerlessContainerState:
    def __init__(__self__, *,
                 async_invocation: Optional[pulumi.Input['ServerlessContainerAsyncInvocationArgs']] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input['ServerlessContainerConnectivityArgs']] = None,
                 core_fraction: Optional[pulumi.Input[_builtins.int]] = None,
                 cores: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input['ServerlessContainerImageArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input['ServerlessContainerLogOptionsArgs']] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata_options: Optional[pulumi.Input['ServerlessContainerMetadataOptionsArgs']] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_policy: Optional[pulumi.Input['ServerlessContainerProvisionPolicyArgs']] = None,
                 revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 runtime: Optional[pulumi.Input['ServerlessContainerRuntimeArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerlessContainer resources.
        :param pulumi.Input['ServerlessContainerAsyncInvocationArgs'] async_invocation: Config for asynchronous invocations of Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] concurrency: Concurrency of Yandex Cloud Serverless Container.
        :param pulumi.Input['ServerlessContainerConnectivityArgs'] connectivity: Network access. If specified the revision will be attached to specified network.
        :param pulumi.Input[_builtins.int] core_fraction: Core fraction (**0...100**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] cores: Cores (**1+**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds (**duration format**) for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input['ServerlessContainerImageArgs'] image: Revision deployment image for Yandex Cloud Serverless Container.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input['ServerlessContainerLogOptionsArgs'] log_options: Options for logging from Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128 MB**).
        :param pulumi.Input['ServerlessContainerMetadataOptionsArgs'] metadata_options: Options set the access mode to revision's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]] mounts: Mounts for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input['ServerlessContainerProvisionPolicyArgs'] provision_policy: Provision policy. If specified the revision will have prepared instances.
        :param pulumi.Input[_builtins.str] revision_id: Last revision ID of the Yandex Cloud Serverless Container.
        :param pulumi.Input['ServerlessContainerRuntimeArgs'] runtime: Runtime for Yandex Cloud Serverless Container.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]] secrets: Secrets for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]] storage_mounts: (**DEPRECATED**, use `mounts.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] url: Invoke URL for the Yandex Cloud Serverless Container.
        """
        if async_invocation is not None:
            pulumi.set(__self__, "async_invocation", async_invocation)
        if concurrency is not None:
            pulumi.set(__self__, "concurrency", concurrency)
        if connectivity is not None:
            pulumi.set(__self__, "connectivity", connectivity)
        if core_fraction is not None:
            pulumi.set(__self__, "core_fraction", core_fraction)
        if cores is not None:
            pulumi.set(__self__, "cores", cores)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_options is not None:
            pulumi.set(__self__, "log_options", log_options)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provision_policy is not None:
            pulumi.set(__self__, "provision_policy", provision_policy)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if storage_mounts is not None:
            warnings.warn("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""", DeprecationWarning)
            pulumi.log.warn("""storage_mounts is deprecated: The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
        if storage_mounts is not None:
            pulumi.set(__self__, "storage_mounts", storage_mounts)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="asyncInvocation")
    def async_invocation(self) -> Optional[pulumi.Input['ServerlessContainerAsyncInvocationArgs']]:
        """
        Config for asynchronous invocations of Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "async_invocation")

    @async_invocation.setter
    def async_invocation(self, value: Optional[pulumi.Input['ServerlessContainerAsyncInvocationArgs']]):
        pulumi.set(self, "async_invocation", value)

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Concurrency of Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "concurrency")

    @concurrency.setter
    def concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrency", value)

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> Optional[pulumi.Input['ServerlessContainerConnectivityArgs']]:
        """
        Network access. If specified the revision will be attached to specified network.
        """
        return pulumi.get(self, "connectivity")

    @connectivity.setter
    def connectivity(self, value: Optional[pulumi.Input['ServerlessContainerConnectivityArgs']]):
        pulumi.set(self, "connectivity", value)

    @_builtins.property
    @pulumi.getter(name="coreFraction")
    def core_fraction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Core fraction (**0...100**) of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "core_fraction")

    @core_fraction.setter
    def core_fraction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "core_fraction", value)

    @_builtins.property
    @pulumi.getter
    def cores(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cores (**1+**) of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "cores")

    @cores.setter
    def cores(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cores", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Execution timeout in seconds (**duration format**) for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_timeout", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['ServerlessContainerImageArgs']]:
        """
        Revision deployment image for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['ServerlessContainerImageArgs']]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Optional[pulumi.Input['ServerlessContainerLogOptionsArgs']]:
        """
        Options for logging from Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "log_options")

    @log_options.setter
    def log_options(self, value: Optional[pulumi.Input['ServerlessContainerLogOptionsArgs']]):
        pulumi.set(self, "log_options", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Memory in megabytes (**aligned to 128 MB**).
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional[pulumi.Input['ServerlessContainerMetadataOptionsArgs']]:
        """
        Options set the access mode to revision's metadata endpoints.
        """
        return pulumi.get(self, "metadata_options")

    @metadata_options.setter
    def metadata_options(self, value: Optional[pulumi.Input['ServerlessContainerMetadataOptionsArgs']]):
        pulumi.set(self, "metadata_options", value)

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]]]:
        """
        Mounts for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="provisionPolicy")
    def provision_policy(self) -> Optional[pulumi.Input['ServerlessContainerProvisionPolicyArgs']]:
        """
        Provision policy. If specified the revision will have prepared instances.
        """
        return pulumi.get(self, "provision_policy")

    @provision_policy.setter
    def provision_policy(self, value: Optional[pulumi.Input['ServerlessContainerProvisionPolicyArgs']]):
        pulumi.set(self, "provision_policy", value)

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last revision ID of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_id", value)

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['ServerlessContainerRuntimeArgs']]:
        """
        Runtime for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['ServerlessContainerRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]]]:
        """
        Secrets for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageMounts")
    @_utilities.deprecated("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
    def storage_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]]]:
        """
        (**DEPRECATED**, use `mounts.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "storage_mounts")

    @storage_mounts.setter
    def storage_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerlessContainerStorageMountArgs']]]]):
        pulumi.set(self, "storage_mounts", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Invoke URL for the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("yandex:index/serverlessContainer:ServerlessContainer")
class ServerlessContainer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 async_invocation: Optional[pulumi.Input[Union['ServerlessContainerAsyncInvocationArgs', 'ServerlessContainerAsyncInvocationArgsDict']]] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input[Union['ServerlessContainerConnectivityArgs', 'ServerlessContainerConnectivityArgsDict']]] = None,
                 core_fraction: Optional[pulumi.Input[_builtins.int]] = None,
                 cores: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input[Union['ServerlessContainerImageArgs', 'ServerlessContainerImageArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input[Union['ServerlessContainerLogOptionsArgs', 'ServerlessContainerLogOptionsArgsDict']]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata_options: Optional[pulumi.Input[Union['ServerlessContainerMetadataOptionsArgs', 'ServerlessContainerMetadataOptionsArgsDict']]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerMountArgs', 'ServerlessContainerMountArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_policy: Optional[pulumi.Input[Union['ServerlessContainerProvisionPolicyArgs', 'ServerlessContainerProvisionPolicyArgsDict']]] = None,
                 runtime: Optional[pulumi.Input[Union['ServerlessContainerRuntimeArgs', 'ServerlessContainerRuntimeArgsDict']]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerSecretArgs', 'ServerlessContainerSecretArgsDict']]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerStorageMountArgs', 'ServerlessContainerStorageMountArgsDict']]]]] = None,
                 __props__=None):
        """
        Allows management of a Yandex Cloud Serverless Container.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Serverless Container.
        #
        test_container = yandex.ServerlessContainer("test-container",
            name="some_name",
            description="any description",
            memory=256,
            execution_timeout="15s",
            cores=1,
            core_fraction=100,
            service_account_id="are1service2account3id",
            runtime={
                "type": "task",
            },
            secrets=[{
                "id": secret["id"],
                "version_id": secret_version["id"],
                "key": "secret-key",
                "environment_variable": "ENV_VARIABLE",
            }],
            mounts=[{
                "mount_point_path": "/mount/point",
                "ephemeral_disk": {
                    "size_gb": 5,
                },
            }],
            image={
                "url": "cr.yandex/yc/test-image:v1",
            },
            log_options={
                "log_group_id": "e2392vo6d1bne2aeq9fr",
                "min_level": "ERROR",
            },
            provision_policy={
                "min_instances": 1,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Serverless Container with Image digest.
        #
        test_container_with_digest = yandex.ServerlessContainer("test-container-with-digest",
            name="some_name",
            memory=128,
            image={
                "url": "cr.yandex/yc/test-image:v1",
                "digest": "sha256:e1d772fa8795adac847a2420c87d0d2e3d38fb02f168cab8c0b5fe2fb95c47f4",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        folder_id = "folder_id"
        # Auxiliary resources
        sa = yandex.IamServiceAccount("sa",
            folder_id=folder_id,
            name="test-sa")
        sa_static_key = yandex.IamServiceAccountStaticAccessKey("sa-static-key",
            service_account_id=sa.id,
            description="static access key for object storage")
        my_bucket = yandex.StorageBucket("my-bucket",
            access_key=sa_static_key.access_key,
            secret_key=sa_static_key.secret_key,
            bucket="bucket")
        test_container_object_storage_mount = yandex.ServerlessContainer("test-container-object-storage-mount",
            name="some_name",
            memory=128,
            service_account_id=sa.id,
            image={
                "url": "cr.yandex/yc/test-image:v1",
            },
            mounts=[{
                "mount_point_path": "/mount/point",
                "mode": "ro",
                "object_storage": {
                    "bucket": my_bucket.bucket,
                },
            }])
        sa_editor = yandex.index.ResourcemanagerFolderIamMember("sa-editor",
            folder_id=folder_id,
            role=storage.editor,
            member=fserviceAccount:{sa.id})
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/serverlessContainer:ServerlessContainer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/serverlessContainer:ServerlessContainer test-container ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerlessContainerAsyncInvocationArgs', 'ServerlessContainerAsyncInvocationArgsDict']] async_invocation: Config for asynchronous invocations of Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] concurrency: Concurrency of Yandex Cloud Serverless Container.
        :param pulumi.Input[Union['ServerlessContainerConnectivityArgs', 'ServerlessContainerConnectivityArgsDict']] connectivity: Network access. If specified the revision will be attached to specified network.
        :param pulumi.Input[_builtins.int] core_fraction: Core fraction (**0...100**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] cores: Cores (**1+**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds (**duration format**) for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['ServerlessContainerImageArgs', 'ServerlessContainerImageArgsDict']] image: Revision deployment image for Yandex Cloud Serverless Container.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['ServerlessContainerLogOptionsArgs', 'ServerlessContainerLogOptionsArgsDict']] log_options: Options for logging from Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128 MB**).
        :param pulumi.Input[Union['ServerlessContainerMetadataOptionsArgs', 'ServerlessContainerMetadataOptionsArgsDict']] metadata_options: Options set the access mode to revision's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerMountArgs', 'ServerlessContainerMountArgsDict']]]] mounts: Mounts for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['ServerlessContainerProvisionPolicyArgs', 'ServerlessContainerProvisionPolicyArgsDict']] provision_policy: Provision policy. If specified the revision will have prepared instances.
        :param pulumi.Input[Union['ServerlessContainerRuntimeArgs', 'ServerlessContainerRuntimeArgsDict']] runtime: Runtime for Yandex Cloud Serverless Container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerSecretArgs', 'ServerlessContainerSecretArgsDict']]]] secrets: Secrets for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerStorageMountArgs', 'ServerlessContainerStorageMountArgsDict']]]] storage_mounts: (**DEPRECATED**, use `mounts.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerlessContainerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of a Yandex Cloud Serverless Container.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Serverless Container.
        #
        test_container = yandex.ServerlessContainer("test-container",
            name="some_name",
            description="any description",
            memory=256,
            execution_timeout="15s",
            cores=1,
            core_fraction=100,
            service_account_id="are1service2account3id",
            runtime={
                "type": "task",
            },
            secrets=[{
                "id": secret["id"],
                "version_id": secret_version["id"],
                "key": "secret-key",
                "environment_variable": "ENV_VARIABLE",
            }],
            mounts=[{
                "mount_point_path": "/mount/point",
                "ephemeral_disk": {
                    "size_gb": 5,
                },
            }],
            image={
                "url": "cr.yandex/yc/test-image:v1",
            },
            log_options={
                "log_group_id": "e2392vo6d1bne2aeq9fr",
                "min_level": "ERROR",
            },
            provision_policy={
                "min_instances": 1,
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Serverless Container with Image digest.
        #
        test_container_with_digest = yandex.ServerlessContainer("test-container-with-digest",
            name="some_name",
            memory=128,
            image={
                "url": "cr.yandex/yc/test-image:v1",
                "digest": "sha256:e1d772fa8795adac847a2420c87d0d2e3d38fb02f168cab8c0b5fe2fb95c47f4",
            })
        ```

        ```python
        import pulumi
        import pulumi_yandex as yandex
        import pulumi_yandex_marketmaker as yandex

        folder_id = "folder_id"
        # Auxiliary resources
        sa = yandex.IamServiceAccount("sa",
            folder_id=folder_id,
            name="test-sa")
        sa_static_key = yandex.IamServiceAccountStaticAccessKey("sa-static-key",
            service_account_id=sa.id,
            description="static access key for object storage")
        my_bucket = yandex.StorageBucket("my-bucket",
            access_key=sa_static_key.access_key,
            secret_key=sa_static_key.secret_key,
            bucket="bucket")
        test_container_object_storage_mount = yandex.ServerlessContainer("test-container-object-storage-mount",
            name="some_name",
            memory=128,
            service_account_id=sa.id,
            image={
                "url": "cr.yandex/yc/test-image:v1",
            },
            mounts=[{
                "mount_point_path": "/mount/point",
                "mode": "ro",
                "object_storage": {
                    "bucket": my_bucket.bucket,
                },
            }])
        sa_editor = yandex.index.ResourcemanagerFolderIamMember("sa-editor",
            folder_id=folder_id,
            role=storage.editor,
            member=fserviceAccount:{sa.id})
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/serverlessContainer:ServerlessContainer <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/serverlessContainer:ServerlessContainer test-container ...
        ```

        :param str resource_name: The name of the resource.
        :param ServerlessContainerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerlessContainerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 async_invocation: Optional[pulumi.Input[Union['ServerlessContainerAsyncInvocationArgs', 'ServerlessContainerAsyncInvocationArgsDict']]] = None,
                 concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 connectivity: Optional[pulumi.Input[Union['ServerlessContainerConnectivityArgs', 'ServerlessContainerConnectivityArgsDict']]] = None,
                 core_fraction: Optional[pulumi.Input[_builtins.int]] = None,
                 cores: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image: Optional[pulumi.Input[Union['ServerlessContainerImageArgs', 'ServerlessContainerImageArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 log_options: Optional[pulumi.Input[Union['ServerlessContainerLogOptionsArgs', 'ServerlessContainerLogOptionsArgsDict']]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata_options: Optional[pulumi.Input[Union['ServerlessContainerMetadataOptionsArgs', 'ServerlessContainerMetadataOptionsArgsDict']]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerMountArgs', 'ServerlessContainerMountArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 provision_policy: Optional[pulumi.Input[Union['ServerlessContainerProvisionPolicyArgs', 'ServerlessContainerProvisionPolicyArgsDict']]] = None,
                 runtime: Optional[pulumi.Input[Union['ServerlessContainerRuntimeArgs', 'ServerlessContainerRuntimeArgsDict']]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerSecretArgs', 'ServerlessContainerSecretArgsDict']]]]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerStorageMountArgs', 'ServerlessContainerStorageMountArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerlessContainerArgs.__new__(ServerlessContainerArgs)

            __props__.__dict__["async_invocation"] = async_invocation
            __props__.__dict__["concurrency"] = concurrency
            __props__.__dict__["connectivity"] = connectivity
            __props__.__dict__["core_fraction"] = core_fraction
            __props__.__dict__["cores"] = cores
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_timeout"] = execution_timeout
            __props__.__dict__["folder_id"] = folder_id
            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_options"] = log_options
            if memory is None and not opts.urn:
                raise TypeError("Missing required property 'memory'")
            __props__.__dict__["memory"] = memory
            __props__.__dict__["metadata_options"] = metadata_options
            __props__.__dict__["mounts"] = mounts
            __props__.__dict__["name"] = name
            __props__.__dict__["provision_policy"] = provision_policy
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["storage_mounts"] = storage_mounts
            __props__.__dict__["created_at"] = None
            __props__.__dict__["revision_id"] = None
            __props__.__dict__["url"] = None
        super(ServerlessContainer, __self__).__init__(
            'yandex:index/serverlessContainer:ServerlessContainer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            async_invocation: Optional[pulumi.Input[Union['ServerlessContainerAsyncInvocationArgs', 'ServerlessContainerAsyncInvocationArgsDict']]] = None,
            concurrency: Optional[pulumi.Input[_builtins.int]] = None,
            connectivity: Optional[pulumi.Input[Union['ServerlessContainerConnectivityArgs', 'ServerlessContainerConnectivityArgsDict']]] = None,
            core_fraction: Optional[pulumi.Input[_builtins.int]] = None,
            cores: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execution_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            image: Optional[pulumi.Input[Union['ServerlessContainerImageArgs', 'ServerlessContainerImageArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            log_options: Optional[pulumi.Input[Union['ServerlessContainerLogOptionsArgs', 'ServerlessContainerLogOptionsArgsDict']]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            metadata_options: Optional[pulumi.Input[Union['ServerlessContainerMetadataOptionsArgs', 'ServerlessContainerMetadataOptionsArgsDict']]] = None,
            mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerMountArgs', 'ServerlessContainerMountArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            provision_policy: Optional[pulumi.Input[Union['ServerlessContainerProvisionPolicyArgs', 'ServerlessContainerProvisionPolicyArgsDict']]] = None,
            revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            runtime: Optional[pulumi.Input[Union['ServerlessContainerRuntimeArgs', 'ServerlessContainerRuntimeArgsDict']]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerSecretArgs', 'ServerlessContainerSecretArgsDict']]]]] = None,
            service_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerStorageMountArgs', 'ServerlessContainerStorageMountArgsDict']]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerlessContainer':
        """
        Get an existing ServerlessContainer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerlessContainerAsyncInvocationArgs', 'ServerlessContainerAsyncInvocationArgsDict']] async_invocation: Config for asynchronous invocations of Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] concurrency: Concurrency of Yandex Cloud Serverless Container.
        :param pulumi.Input[Union['ServerlessContainerConnectivityArgs', 'ServerlessContainerConnectivityArgsDict']] connectivity: Network access. If specified the revision will be attached to specified network.
        :param pulumi.Input[_builtins.int] core_fraction: Core fraction (**0...100**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] cores: Cores (**1+**) of the Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] execution_timeout: Execution timeout in seconds (**duration format**) for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Union['ServerlessContainerImageArgs', 'ServerlessContainerImageArgsDict']] image: Revision deployment image for Yandex Cloud Serverless Container.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[Union['ServerlessContainerLogOptionsArgs', 'ServerlessContainerLogOptionsArgsDict']] log_options: Options for logging from Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.int] memory: Memory in megabytes (**aligned to 128 MB**).
        :param pulumi.Input[Union['ServerlessContainerMetadataOptionsArgs', 'ServerlessContainerMetadataOptionsArgsDict']] metadata_options: Options set the access mode to revision's metadata endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerMountArgs', 'ServerlessContainerMountArgsDict']]]] mounts: Mounts for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] name: The resource name.
        :param pulumi.Input[Union['ServerlessContainerProvisionPolicyArgs', 'ServerlessContainerProvisionPolicyArgsDict']] provision_policy: Provision policy. If specified the revision will have prepared instances.
        :param pulumi.Input[_builtins.str] revision_id: Last revision ID of the Yandex Cloud Serverless Container.
        :param pulumi.Input[Union['ServerlessContainerRuntimeArgs', 'ServerlessContainerRuntimeArgsDict']] runtime: Runtime for Yandex Cloud Serverless Container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerSecretArgs', 'ServerlessContainerSecretArgsDict']]]] secrets: Secrets for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] service_account_id: [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerlessContainerStorageMountArgs', 'ServerlessContainerStorageMountArgsDict']]]] storage_mounts: (**DEPRECATED**, use `mounts.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container.
        :param pulumi.Input[_builtins.str] url: Invoke URL for the Yandex Cloud Serverless Container.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerlessContainerState.__new__(_ServerlessContainerState)

        __props__.__dict__["async_invocation"] = async_invocation
        __props__.__dict__["concurrency"] = concurrency
        __props__.__dict__["connectivity"] = connectivity
        __props__.__dict__["core_fraction"] = core_fraction
        __props__.__dict__["cores"] = cores
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["execution_timeout"] = execution_timeout
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["image"] = image
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_options"] = log_options
        __props__.__dict__["memory"] = memory
        __props__.__dict__["metadata_options"] = metadata_options
        __props__.__dict__["mounts"] = mounts
        __props__.__dict__["name"] = name
        __props__.__dict__["provision_policy"] = provision_policy
        __props__.__dict__["revision_id"] = revision_id
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["storage_mounts"] = storage_mounts
        __props__.__dict__["url"] = url
        return ServerlessContainer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="asyncInvocation")
    def async_invocation(self) -> pulumi.Output[Optional['outputs.ServerlessContainerAsyncInvocation']]:
        """
        Config for asynchronous invocations of Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "async_invocation")

    @_builtins.property
    @pulumi.getter
    def concurrency(self) -> pulumi.Output[_builtins.int]:
        """
        Concurrency of Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "concurrency")

    @_builtins.property
    @pulumi.getter
    def connectivity(self) -> pulumi.Output[Optional['outputs.ServerlessContainerConnectivity']]:
        """
        Network access. If specified the revision will be attached to specified network.
        """
        return pulumi.get(self, "connectivity")

    @_builtins.property
    @pulumi.getter(name="coreFraction")
    def core_fraction(self) -> pulumi.Output[_builtins.int]:
        """
        Core fraction (**0...100**) of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "core_fraction")

    @_builtins.property
    @pulumi.getter
    def cores(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Cores (**1+**) of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "cores")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        Execution timeout in seconds (**duration format**) for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "execution_timeout")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output['outputs.ServerlessContainerImage']:
        """
        Revision deployment image for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> pulumi.Output[Optional['outputs.ServerlessContainerLogOptions']]:
        """
        Options for logging from Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "log_options")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[_builtins.int]:
        """
        Memory in megabytes (**aligned to 128 MB**).
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> pulumi.Output['outputs.ServerlessContainerMetadataOptions']:
        """
        Options set the access mode to revision's metadata endpoints.
        """
        return pulumi.get(self, "metadata_options")

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> pulumi.Output[Sequence['outputs.ServerlessContainerMount']]:
        """
        Mounts for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "mounts")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="provisionPolicy")
    def provision_policy(self) -> pulumi.Output[Optional['outputs.ServerlessContainerProvisionPolicy']]:
        """
        Provision policy. If specified the revision will have prepared instances.
        """
        return pulumi.get(self, "provision_policy")

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        Last revision ID of the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "revision_id")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> pulumi.Output['outputs.ServerlessContainerRuntime']:
        """
        Runtime for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "runtime")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Sequence['outputs.ServerlessContainerSecret']]:
        """
        Secrets for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Service account](https://yandex.cloud/docs/iam/concepts/users/service-accounts) which linked to the resource.
        """
        return pulumi.get(self, "service_account_id")

    @_builtins.property
    @pulumi.getter(name="storageMounts")
    @_utilities.deprecated("""The 'storage_mounts' field has been deprecated. Please use 'mounts' instead.""")
    def storage_mounts(self) -> pulumi.Output[Sequence['outputs.ServerlessContainerStorageMount']]:
        """
        (**DEPRECATED**, use `mounts.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "storage_mounts")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Invoke URL for the Yandex Cloud Serverless Container.
        """
        return pulumi.get(self, "url")

