# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StorageObjectArgs', 'StorageObject']

@pulumi.input_type
class StorageObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a StorageObject resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the containing bucket.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `source` and `content_base64`.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file. Conflicts with `source` and `content`.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: Specifies a [legal hold status](https://yandex.cloud/docs/storage/concepts/object-lock#types) of an object. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_mode: Specifies a type of object lock. One of `["GOVERNANCE", "COMPLIANCE"]`. It must be set simultaneously with `object_lock_retain_until_date`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Specifies date and time in RTC3339 format until which an object is to be locked. It must be set simultaneously with `object_lock_mode`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. Conflicts with `content` and `content_base64`.
        :param pulumi.Input[_builtins.str] source_hash: Used to trigger object update when the source content changes. So the only meaningful value is `filemd5("path/to/source"). The value is only stored in state and not saved by Yandex Storage.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if object_lock_legal_hold_status is not None:
            pulumi.set(__self__, "object_lock_legal_hold_status", object_lock_legal_hold_status)
        if object_lock_mode is not None:
            pulumi.set(__self__, "object_lock_mode", object_lock_mode)
        if object_lock_retain_until_date is not None:
            pulumi.set(__self__, "object_lock_retain_until_date", object_lock_retain_until_date)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the containing bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `source` and `content_base64`.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file. Conflicts with `source` and `content`.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. `application/octet-stream`. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a [legal hold status](https://yandex.cloud/docs/storage/concepts/object-lock#types) of an object. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @object_lock_legal_hold_status.setter
    def object_lock_legal_hold_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_legal_hold_status", value)

    @_builtins.property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a type of object lock. One of `["GOVERNANCE", "COMPLIANCE"]`. It must be set simultaneously with `object_lock_retain_until_date`. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_mode")

    @object_lock_mode.setter
    def object_lock_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_mode", value)

    @_builtins.property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies date and time in RTC3339 format until which an object is to be locked. It must be set simultaneously with `object_lock_mode`. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @object_lock_retain_until_date.setter
    def object_lock_retain_until_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_retain_until_date", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to a file that will be read and uploaded as raw bytes for the object content. Conflicts with `content` and `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to trigger object update when the source content changes. So the only meaningful value is `filemd5("path/to/source"). The value is only stored in state and not saved by Yandex Storage.
        """
        return pulumi.get(self, "source_hash")

    @source_hash.setter
    def source_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_hash", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _StorageObjectState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering StorageObject resources.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] bucket: The name of the containing bucket.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `source` and `content_base64`.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file. Conflicts with `source` and `content`.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: Specifies a [legal hold status](https://yandex.cloud/docs/storage/concepts/object-lock#types) of an object. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_mode: Specifies a type of object lock. One of `["GOVERNANCE", "COMPLIANCE"]`. It must be set simultaneously with `object_lock_retain_until_date`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Specifies date and time in RTC3339 format until which an object is to be locked. It must be set simultaneously with `object_lock_mode`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. Conflicts with `content` and `content_base64`.
        :param pulumi.Input[_builtins.str] source_hash: Used to trigger object update when the source content changes. So the only meaningful value is `filemd5("path/to/source"). The value is only stored in state and not saved by Yandex Storage.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if object_lock_legal_hold_status is not None:
            pulumi.set(__self__, "object_lock_legal_hold_status", object_lock_legal_hold_status)
        if object_lock_mode is not None:
            pulumi.set(__self__, "object_lock_mode", object_lock_mode)
        if object_lock_retain_until_date is not None:
            pulumi.set(__self__, "object_lock_retain_until_date", object_lock_retain_until_date)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the containing bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `source` and `content_base64`.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file. Conflicts with `source` and `content`.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_base64", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A standard MIME type describing the format of the object data, e.g. `application/octet-stream`. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a [legal hold status](https://yandex.cloud/docs/storage/concepts/object-lock#types) of an object. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @object_lock_legal_hold_status.setter
    def object_lock_legal_hold_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_legal_hold_status", value)

    @_builtins.property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a type of object lock. One of `["GOVERNANCE", "COMPLIANCE"]`. It must be set simultaneously with `object_lock_retain_until_date`. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_mode")

    @object_lock_mode.setter
    def object_lock_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_mode", value)

    @_builtins.property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies date and time in RTC3339 format until which an object is to be locked. It must be set simultaneously with `object_lock_mode`. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @object_lock_retain_until_date.setter
    def object_lock_retain_until_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_lock_retain_until_date", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to a file that will be read and uploaded as raw bytes for the object content. Conflicts with `content` and `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to trigger object update when the source content changes. So the only meaningful value is `filemd5("path/to/source"). The value is only stored in state and not saved by Yandex Storage.
        """
        return pulumi.get(self, "source_hash")

    @source_hash.setter
    def source_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_hash", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("yandex:index/storageObject:StorageObject")
class StorageObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Storage Object](https://yandex.cloud/docs/storage/concepts/object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Storage Object in Bucket.
        #
        cute_cat_picture = yandex.StorageObject("cute-cat-picture",
            bucket="cat-pictures",
            key="cute-cat",
            source="/images/cats/cute-cat.jpg",
            tags={
                "test": "value",
            })
        ```

        ## Import

        ~> Import for this resource is not implemented yet.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] bucket: The name of the containing bucket.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `source` and `content_base64`.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file. Conflicts with `source` and `content`.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: Specifies a [legal hold status](https://yandex.cloud/docs/storage/concepts/object-lock#types) of an object. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_mode: Specifies a type of object lock. One of `["GOVERNANCE", "COMPLIANCE"]`. It must be set simultaneously with `object_lock_retain_until_date`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Specifies date and time in RTC3339 format until which an object is to be locked. It must be set simultaneously with `object_lock_mode`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. Conflicts with `content` and `content_base64`.
        :param pulumi.Input[_builtins.str] source_hash: Used to trigger object update when the source content changes. So the only meaningful value is `filemd5("path/to/source"). The value is only stored in state and not saved by Yandex Storage.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Storage Object](https://yandex.cloud/docs/storage/concepts/object).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new Storage Object in Bucket.
        #
        cute_cat_picture = yandex.StorageObject("cute-cat-picture",
            bucket="cat-pictures",
            key="cute-cat",
            source="/images/cats/cute-cat.jpg",
            tags={
                "test": "value",
            })
        ```

        ## Import

        ~> Import for this resource is not implemented yet.

        :param str resource_name: The name of the resource.
        :param StorageObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageObjectArgs.__new__(StorageObjectArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["content"] = content
            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["content_type"] = content_type
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["object_lock_legal_hold_status"] = object_lock_legal_hold_status
            __props__.__dict__["object_lock_mode"] = object_lock_mode
            __props__.__dict__["object_lock_retain_until_date"] = object_lock_retain_until_date
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["source"] = source
            __props__.__dict__["source_hash"] = source_hash
            __props__.__dict__["tags"] = tags
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StorageObject, __self__).__init__(
            'yandex:index/storageObject:StorageObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            acl: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            content_base64: Optional[pulumi.Input[_builtins.str]] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            object_lock_legal_hold_status: Optional[pulumi.Input[_builtins.str]] = None,
            object_lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
            object_lock_retain_until_date: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            source_hash: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'StorageObject':
        """
        Get an existing StorageObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] acl: The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`.
        :param pulumi.Input[_builtins.str] bucket: The name of the containing bucket.
        :param pulumi.Input[_builtins.str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `source` and `content_base64`.
        :param pulumi.Input[_builtins.str] content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file. Conflicts with `source` and `content`.
        :param pulumi.Input[_builtins.str] content_type: A standard MIME type describing the format of the object data, e.g. `application/octet-stream`. All Valid MIME Types are valid for this input.
        :param pulumi.Input[_builtins.str] key: The name of the object once it is in the bucket.
        :param pulumi.Input[_builtins.str] object_lock_legal_hold_status: Specifies a [legal hold status](https://yandex.cloud/docs/storage/concepts/object-lock#types) of an object. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_mode: Specifies a type of object lock. One of `["GOVERNANCE", "COMPLIANCE"]`. It must be set simultaneously with `object_lock_retain_until_date`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] object_lock_retain_until_date: Specifies date and time in RTC3339 format until which an object is to be locked. It must be set simultaneously with `object_lock_mode`. Requires `object_lock_configuration` to be enabled on a bucket.
        :param pulumi.Input[_builtins.str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[_builtins.str] source: The path to a file that will be read and uploaded as raw bytes for the object content. Conflicts with `content` and `content_base64`.
        :param pulumi.Input[_builtins.str] source_hash: Used to trigger object update when the source content changes. So the only meaningful value is `filemd5("path/to/source"). The value is only stored in state and not saved by Yandex Storage.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageObjectState.__new__(_StorageObjectState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["content"] = content
        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["key"] = key
        __props__.__dict__["object_lock_legal_hold_status"] = object_lock_legal_hold_status
        __props__.__dict__["object_lock_mode"] = object_lock_mode
        __props__.__dict__["object_lock_retain_until_date"] = object_lock_retain_until_date
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["source"] = source
        __props__.__dict__["source_hash"] = source_hash
        __props__.__dict__["tags"] = tags
        return StorageObject(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [predefined ACL](https://yandex.cloud/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the containing bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `source` and `content_base64`.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for small content such as the result of the `gzipbase64` function with small text strings. For larger objects, use `source` to stream the content from a disk file. Conflicts with `source` and `content`.
        """
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[_builtins.str]:
        """
        A standard MIME type describing the format of the object data, e.g. `application/octet-stream`. All Valid MIME Types are valid for this input.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the object once it is in the bucket.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="objectLockLegalHoldStatus")
    def object_lock_legal_hold_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a [legal hold status](https://yandex.cloud/docs/storage/concepts/object-lock#types) of an object. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_legal_hold_status")

    @_builtins.property
    @pulumi.getter(name="objectLockMode")
    def object_lock_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a type of object lock. One of `["GOVERNANCE", "COMPLIANCE"]`. It must be set simultaneously with `object_lock_retain_until_date`. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_mode")

    @_builtins.property
    @pulumi.getter(name="objectLockRetainUntilDate")
    def object_lock_retain_until_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies date and time in RTC3339 format until which an object is to be locked. It must be set simultaneously with `object_lock_mode`. Requires `object_lock_configuration` to be enabled on a bucket.
        """
        return pulumi.get(self, "object_lock_retain_until_date")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path to a file that will be read and uploaded as raw bytes for the object content. Conflicts with `content` and `content_base64`.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Used to trigger object update when the source content changes. So the only meaningful value is `filemd5("path/to/source"). The value is only stored in state and not saved by Yandex Storage.
        """
        return pulumi.get(self, "source_hash")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The `tags` object for setting tags (or labels) for bucket. See [Tags](https://yandex.cloud/docs/storage/concepts/tags) for more information.
        """
        return pulumi.get(self, "tags")

