# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwsAdvancedRateLimiterProfileArgs', 'SwsAdvancedRateLimiterProfile']

@pulumi.input_type
class SwsAdvancedRateLimiterProfileArgs:
    def __init__(__self__, *,
                 advanced_rate_limiter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SwsAdvancedRateLimiterProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]] advanced_rate_limiter_rules: List of rules.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        if advanced_rate_limiter_rules is not None:
            pulumi.set(__self__, "advanced_rate_limiter_rules", advanced_rate_limiter_rules)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterRules")
    def advanced_rate_limiter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]]]:
        """
        List of rules.
        """
        return pulumi.get(self, "advanced_rate_limiter_rules")

    @advanced_rate_limiter_rules.setter
    def advanced_rate_limiter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]]]):
        pulumi.set(self, "advanced_rate_limiter_rules", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SwsAdvancedRateLimiterProfileState:
    def __init__(__self__, *,
                 advanced_rate_limiter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SwsAdvancedRateLimiterProfile resources.
        :param pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]] advanced_rate_limiter_rules: List of rules.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        if advanced_rate_limiter_rules is not None:
            pulumi.set(__self__, "advanced_rate_limiter_rules", advanced_rate_limiter_rules)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterRules")
    def advanced_rate_limiter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]]]:
        """
        List of rules.
        """
        return pulumi.get(self, "advanced_rate_limiter_rules")

    @advanced_rate_limiter_rules.setter
    def advanced_rate_limiter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs']]]]):
        pulumi.set(self, "advanced_rate_limiter_rules", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("yandex:index/swsAdvancedRateLimiterProfile:SwsAdvancedRateLimiterProfile")
class SwsAdvancedRateLimiterProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_rate_limiter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs', 'SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgsDict']]]]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an SWS Advanced Rate Limiter (ARL) profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#arl).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS Advanced Rate Limiter Profile.
        #
        demo_profile = yandex.SwsAdvancedRateLimiterProfile("demo-profile",
            name="demo-profile",
            advanced_rate_limiter_rules=[{
                "name": "rule1",
                "priority": 10,
                "description": "First test rule",
                "dry_run": True,
                "static_quota": {
                    "action": "DENY",
                    "limit": 10000000,
                    "period": 1,
                    "condition": {
                        "request_uri": {
                            "path": {
                                "exact_match": "/api",
                            },
                        },
                    },
                },
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/swsAdvancedRateLimiterProfile:SwsAdvancedRateLimiterProfile <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/swsAdvancedRateLimiterProfile:SwsAdvancedRateLimiterProfile demo-profile ...
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs', 'SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgsDict']]]] advanced_rate_limiter_rules: List of rules.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SwsAdvancedRateLimiterProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an SWS Advanced Rate Limiter (ARL) profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#arl).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_yandex_marketmaker as yandex

        #
        # Create a new SWS Advanced Rate Limiter Profile.
        #
        demo_profile = yandex.SwsAdvancedRateLimiterProfile("demo-profile",
            name="demo-profile",
            advanced_rate_limiter_rules=[{
                "name": "rule1",
                "priority": 10,
                "description": "First test rule",
                "dry_run": True,
                "static_quota": {
                    "action": "DENY",
                    "limit": 10000000,
                    "period": 1,
                    "condition": {
                        "request_uri": {
                            "path": {
                                "exact_match": "/api",
                            },
                        },
                    },
                },
            }])
        ```

        ## Import

        The resource can be imported by using their `resource ID`. For getting the resource ID you can use Yandex Cloud [Web Console](https://console.yandex.cloud) or [YC CLI](https://yandex.cloud/docs/cli/quickstart).

        ```sh
        $ pulumi import yandex:index/swsAdvancedRateLimiterProfile:SwsAdvancedRateLimiterProfile <resource Name> <resource Id>
        ```

        ```sh
        $ pulumi import yandex:index/swsAdvancedRateLimiterProfile:SwsAdvancedRateLimiterProfile demo-profile ...
        ```

        :param str resource_name: The name of the resource.
        :param SwsAdvancedRateLimiterProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwsAdvancedRateLimiterProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_rate_limiter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs', 'SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgsDict']]]]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwsAdvancedRateLimiterProfileArgs.__new__(SwsAdvancedRateLimiterProfileArgs)

            __props__.__dict__["advanced_rate_limiter_rules"] = advanced_rate_limiter_rules
            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["created_at"] = None
        super(SwsAdvancedRateLimiterProfile, __self__).__init__(
            'yandex:index/swsAdvancedRateLimiterProfile:SwsAdvancedRateLimiterProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_rate_limiter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs', 'SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgsDict']]]]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SwsAdvancedRateLimiterProfile':
        """
        Get an existing SwsAdvancedRateLimiterProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgs', 'SwsAdvancedRateLimiterProfileAdvancedRateLimiterRuleArgsDict']]]] advanced_rate_limiter_rules: List of rules.
        :param pulumi.Input[_builtins.str] cloud_id: The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of the resource.
        :param pulumi.Input[_builtins.str] description: The resource description.
        :param pulumi.Input[_builtins.str] folder_id: The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs which assigned to resource.
        :param pulumi.Input[_builtins.str] name: The resource name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwsAdvancedRateLimiterProfileState.__new__(_SwsAdvancedRateLimiterProfileState)

        __props__.__dict__["advanced_rate_limiter_rules"] = advanced_rate_limiter_rules
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        return SwsAdvancedRateLimiterProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedRateLimiterRules")
    def advanced_rate_limiter_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SwsAdvancedRateLimiterProfileAdvancedRateLimiterRule']]]:
        """
        List of rules.
        """
        return pulumi.get(self, "advanced_rate_limiter_rules")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The `Cloud ID` which resource belongs to. If it is not provided, the default provider `cloud-id` is used.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the resource.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        """
        The folder identifier that resource belongs to. If it is not provided, the default provider `folder-id` is used.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs which assigned to resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

