"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
exports.StorageClass = StorageClass;
_a = JSII_RTTI_SYMBOL_1;
StorageClass[_a] = { fqn: "@aws-cdk/aws-s3.StorageClass", version: "1.158.0" };
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Storage class for long-term archival that can be accessed in a few milliseconds.
 *
 * It is ideal for data that is accessed once or twice per quarter, and
 * that requires immediate access. Data stored in the GLACIER_IR storage class
 * has a minimum storage duration period of 90 days and can be accessed in
 * as milliseconds. If you delete an object before the 90-day minimum,
 * you are charged for 90 days.
 */
StorageClass.GLACIER_INSTANT_RETRIEVAL = new StorageClass('GLACIER_IR');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
//# sourceMappingURL=data:application/json;base64,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