"""off_chain_bids_1

Revision ID: bd913c5bfdfb
Revises: 85982c1f3b95
Create Date: 2023-06-16 15:36:14.972841

"""
import alembic
import sqlalchemy as sa  # type: ignore
import sqlalchemy.dialects  # type: ignore

# revision identifiers, used by Alembic.
revision = 'bd913c5bfdfb'
down_revision = '85982c1f3b95'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    connection = alembic.op.get_bind()
    metadata = sa.MetaData()
    alembic.op.add_column(
        'transfers',
        sa.Column('fee', sa.Numeric(precision=78, scale=0), nullable=True))
    BidTable = sa.Table('bids', metadata, autoload_with=connection)
    TransferTable = sa.Table('transfers', metadata, autoload_with=connection)
    transfer_fee_subquery = sa.select(BidTable.columns.fee).where(
        TransferTable.columns.bid_id == BidTable.columns.id).as_scalar()
    transfer_fee_update_statement = sa.update(TransferTable).where(
        TransferTable.columns.fee == sqlalchemy.null()).values(
            fee=transfer_fee_subquery)
    connection.execute(transfer_fee_update_statement)
    alembic.op.alter_column('transfers', 'fee',
                            existing_type=sa.NUMERIC(precision=78,
                                                     scale=0), nullable=False)
    alembic.op.drop_constraint('transfers_bid_id_fkey', 'transfers',
                               type_='foreignkey')
    alembic.op.drop_column('transfers', 'bid_id')
    delete_bids_table_statement = sa.delete(BidTable)
    connection.execute(delete_bids_table_statement)
    alembic.op.add_column(
        'bids', sa.Column('valid_until', sa.Integer(), nullable=False))
    alembic.op.add_column(
        'bids', sa.Column('source_blockchain_id', sa.Integer(),
                          nullable=False))
    alembic.op.drop_index('ux_bids_hub_contract_id_on_chain_bid_id',
                          table_name='bids')
    alembic.op.drop_constraint('bids_hub_contract_id_fkey', 'bids',
                               type_='foreignkey')
    alembic.op.create_foreign_key('bids_source_blockchain_id', 'bids',
                                  'blockchains', ['source_blockchain_id'],
                                  ['id'])
    alembic.op.drop_column('bids', 'unregistered')
    alembic.op.drop_column('bids', 'on_chain_bid_id')
    alembic.op.drop_column('bids', 'registered')
    alembic.op.drop_column('bids', 'hub_contract_id')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    alembic.op.add_column(
        'bids',
        sa.Column('hub_contract_id', sa.INTEGER(), autoincrement=False,
                  nullable=False))
    alembic.op.add_column('transfers',
                          sa.Column('bid_id', sa.Integer(), nullable=False))
    alembic.op.create_foreign_key('bids_hub_contract_id_fkey', 'bids',
                                  'hub_contracts', ['hub_contract_id'], ['id'])
    alembic.op.create_foreign_key('transfers_bid_id_fkey', 'transfers', 'bids',
                                  ['bid_id'], ['id'])
    alembic.op.add_column(
        'bids',
        sa.Column('registered', sqlalchemy.dialects.postgresql.TIMESTAMP(),
                  autoincrement=False, nullable=True))
    alembic.op.add_column(
        'bids',
        sa.Column('on_chain_bid_id', sa.BIGINT(), autoincrement=False,
                  nullable=True))
    alembic.op.add_column(
        'bids',
        sa.Column('unregistered', sqlalchemy.dialects.postgresql.TIMESTAMP(),
                  autoincrement=False, nullable=True))
    alembic.op.create_index('ux_bids_hub_contract_id_on_chain_bid_id', 'bids',
                            ['hub_contract_id', 'on_chain_bid_id'],
                            unique=False)
    alembic.op.drop_constraint('bids_source_blockchain_id', 'bids',
                               type_='foreignkey')
    alembic.op.drop_column('transfers', 'fee')
    alembic.op.drop_column('bids', 'valid_until')
    alembic.op.drop_column('bids', 'source_blockchain_id')
    # ### end Alembic commands ###
