import subprocess
import os


class DependencyManager:
    """依赖管理工具"""

    @staticmethod
    def generate_requirements(output_file='requirements.txt'):
        """自动生成requirements.txt"""
        # 获取当前导入的第三方库
        installed_packages = subprocess.check_output(
            ['pip', 'freeze']
        ).decode('utf-8').splitlines()

        with open(output_file, 'w') as f:
            f.write("# Auto-generated by Bruce_li_tc\n")
            for package in installed_packages:
                f.write(f"{package}\n")
        return f"Generated {output_file}"

    @staticmethod
    def generate_pyproject(output_file='pyproject.toml'):
        """自动生成pyproject.toml模板"""
        content = """[build-system]
requires = ["setuptools", "wheel"]
build-backend = "setuptools.build_meta"

[project]
name = "your_project_name"
version = "0.1.0"
description = "Your project description"
authors = [
    { name = "Your Name", email = "your.email@example.com" }
]
dependencies = []
"""
        with open(output_file, 'w') as f:
            f.write(content)
        return f"Generated {output_file}"