# Generated by Django 4.0.6 on 2022-08-15 00:43

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import workos_login.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='UserLogin',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mfa_factor', models.CharField(blank=True, max_length=255)),
                ('mfa_type', models.CharField(blank=True, choices=[('sms', 'SMS'), ('totp', 'Authenticator App')], max_length=10)),
                ('sso_id', models.CharField(blank=True, max_length=255)),
                ('idp_id', models.CharField(blank=True, max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='LoginRule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name for this config', max_length=255, unique=True)),
                ('lookup_attributes', models.JSONField(blank=True, null=True)),
                ('totp_organization_name', models.CharField(blank=True, help_text='The name of organization which shows in authenticator apps.', max_length=255)),
                ('method', models.CharField(choices=[('mfa', 'MFA'), ('magic', 'Passwordless Email'), ('GoogleOAuth', 'Google SSO'), ('MicrosoftOAuth', 'Microsoft SSO'), ('sso', 'SAML SSO'), ('username', 'Username/Password')], max_length=15)),
                ('jit_creation', models.BooleanField(default=False, help_text='If enabled a user account will be automatically created if one does not exist.', verbose_name='Just in time account creation')),
                ('priority', models.IntegerField(default=100, help_text='Priority of this rule. Lower numbers are checked first', unique=True)),
                ('email_regex', workos_login.models.EmailRegexField(blank=True, help_text='Regex to test on email. Ex. ^.+@(domain|domain2)\\.com$', verbose_name='Email Regular Expression Pattern')),
                ('connection_id', models.CharField(blank=True, help_text='WorkOS connection ID', max_length=255)),
                ('organization_id', models.CharField(blank=True, help_text='WorkOS organization ID', max_length=255)),
                ('jit_attributes', models.JSONField(blank=True, default=dict, help_text='Attributes to set on user instance when creating user')),
                ('jit_groups', models.ManyToManyField(blank=True, help_text='Groups a user should be added to if user is being created.', to='auth.group')),
            ],
            options={
                'ordering': ['priority'],
            },
        ),
    ]
