from enum import Enum


class PayrollValueType(str, Enum):
    BASICPAY = "BasicPay"
    GROSS = "Gross"
    GROSSFORTAX = "GrossForTax"
    GROSSFORNI = "GrossForNi"
    EMPLOYERNI = "EmployerNi"
    EMPLOYEENI = "EmployeeNi"
    EMPLOYERNIOFFPAYROLL = "EmployerNiOffPayroll"
    REALTIMECLASS1ANI = "RealTimeClass1ANi"
    TAX = "Tax"
    NETPAY = "NetPay"
    ADJUSTMENTS = "Adjustments"
    TAKEHOMEPAY = "TakeHomePay"
    NONTAXORNICPMT = "NonTaxOrNICPmt"
    ITEMSSUBJECTTOCLASS1NIC = "ItemsSubjectToClass1NIC"
    DEDNSFROMNETPAY = "DednsFromNetPay"
    TCP_TCLS = "Tcp_Tcls"
    TCP_PP = "Tcp_Pp"
    TCP_OP = "Tcp_Op"
    FLEXIDD_DEATH = "FlexiDd_Death"
    FLEXIDD_DEATH_NONTAX = "FlexiDd_Death_NonTax"
    FLEXIDD_PENSION = "FlexiDd_Pension"
    FLEXIDD_PENSION_NONTAX = "FlexiDd_Pension_NonTax"
    SMP = "Smp"
    SPP = "Spp"
    SAP = "Sap"
    SHPP = "Shpp"
    SPBP = "Spbp"
    STUDENTLOANRECOVERED = "StudentLoanRecovered"
    POSTGRADLOANRECOVERED = "PostgradLoanRecovered"
    PENSIONABLEPAY = "PensionablePay"
    NONTIERABLEPAY = "NonTierablePay"
    EMPLOYEEPENSIONCONTRIBUTION = "EmployeePensionContribution"
    EMPLOYERPENSIONCONTRIBUTION = "EmployerPensionContribution"
    EMPEEPENCONTRIBNSNOTPAID = "EmpeePenContribnsNotPaid"
    EMPEEPENCONTRIBNSPAID = "EmpeePenContribnsPaid"
    ATTACHMENTORDERDEDUCTIONS = "AttachmentOrderDeductions"
    CISDEDUCTION = "CisDeduction"
    CISVAT = "CisVat"
    CISUMBRELLAFEE = "CisUmbrellaFee"
    CISUMBRELLAFEEPOSTTAX = "CisUmbrellaFeePostTax"
    PBIK = "Pbik"
    MAPSMILES = "MapsMiles"
    UMBRELLAFEE = "UmbrellaFee"
    APPLEVYDEDUCTION = "AppLevyDeduction"
    PAYMENTAFTERLEAVING = "PaymentAfterLeaving"
    TAXONPAYMENTAFTERLEAVING = "TaxOnPaymentAfterLeaving"
    SSP = "Ssp"
    ATTACHMENTORDERADMINFEE = "AttachmentOrderAdminFee"
    EMPLOYEEPENSIONNETPAY = "EmployeePensionNetPay"
    EMPLOYEEPENSIONRAS = "EmployeePensionRas"
    EMPLOYEEPENSIONSALSAC = "EmployeePensionSalSac"
    EMPLOYEEPENSIONCONTRIBUTIONAVC = "EmployeePensionContributionAvc"
    DEDUCTIONS = "Deductions"
    ADDITIONS = "Additions"
    PENSIONABLEEARNINGS = "PensionableEarnings"

    def __str__(self) -> str:
        return str(self.value)
