# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApikeyArgs', 'Apikey']

@pulumi.input_type
class ApikeyArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 expiry_time: pulumi.Input[str],
                 owner_id: pulumi.Input[str],
                 owner_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 timeouts: Optional[pulumi.Input['ApikeyTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Apikey resource.
        :param pulumi.Input[str] display_name: The display name for the API key.
        :param pulumi.Input[str] expiry_time: The expiry time for the API key in ISO 8601 format.
        :param pulumi.Input[str] owner_id: The ID of the owner to create the API key for.
        :param pulumi.Input[str] owner_type: The type of the owner to create the API key.
        :param pulumi.Input[str] description: The description for the API key.
        :param pulumi.Input[bool] disabled: Whether the API key is disabled.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "expiry_time", expiry_time)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "owner_type", owner_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name for the API key.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> pulumi.Input[str]:
        """
        The expiry time for the API key in ISO 8601 format.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "expiry_time", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Input[str]:
        """
        The ID of the owner to create the API key for.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="ownerType")
    def owner_type(self) -> pulumi.Input[str]:
        """
        The type of the owner to create the API key.
        """
        return pulumi.get(self, "owner_type")

    @owner_type.setter
    def owner_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the API key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the API key is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ApikeyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ApikeyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ApikeyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 owner_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['ApikeyTimeoutsArgs']] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Apikey resources.
        :param pulumi.Input[str] description: The description for the API key.
        :param pulumi.Input[bool] disabled: Whether the API key is disabled.
        :param pulumi.Input[str] display_name: The display name for the API key.
        :param pulumi.Input[str] expiry_time: The expiry time for the API key in ISO 8601 format.
        :param pulumi.Input[str] owner_id: The ID of the owner to create the API key for.
        :param pulumi.Input[str] owner_type: The type of the owner to create the API key.
        :param pulumi.Input[str] state: The current state of the API key.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if owner_type is not None:
            pulumi.set(__self__, "owner_type", owner_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the API key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the API key is disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name for the API key.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry time for the API key in ISO 8601 format.
        """
        return pulumi.get(self, "expiry_time")

    @expiry_time.setter
    def expiry_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry_time", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the owner to create the API key for.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="ownerType")
    def owner_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the owner to create the API key.
        """
        return pulumi.get(self, "owner_type")

    @owner_type.setter
    def owner_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the API key.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ApikeyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ApikeyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class Apikey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 owner_type: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ApikeyTimeoutsArgs', 'ApikeyTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provisions a Temporal Cloud API key.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_temporalcloud as temporalcloud

        global_service_account = temporalcloud.ServiceAccount("global_service_account",
            name="admin",
            account_access="Admin")
        global_apikey = temporalcloud.Apikey("global_apikey",
            display_name="admin",
            owner_type="service-account",
            owner_id=global_service_account.id,
            expiry_time="2024-11-01T00:00:00Z",
            disabled=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description for the API key.
        :param pulumi.Input[bool] disabled: Whether the API key is disabled.
        :param pulumi.Input[str] display_name: The display name for the API key.
        :param pulumi.Input[str] expiry_time: The expiry time for the API key in ISO 8601 format.
        :param pulumi.Input[str] owner_id: The ID of the owner to create the API key for.
        :param pulumi.Input[str] owner_type: The type of the owner to create the API key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApikeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provisions a Temporal Cloud API key.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_temporalcloud as temporalcloud

        global_service_account = temporalcloud.ServiceAccount("global_service_account",
            name="admin",
            account_access="Admin")
        global_apikey = temporalcloud.Apikey("global_apikey",
            display_name="admin",
            owner_type="service-account",
            owner_id=global_service_account.id,
            expiry_time="2024-11-01T00:00:00Z",
            disabled=False)
        ```

        :param str resource_name: The name of the resource.
        :param ApikeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApikeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiry_time: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 owner_type: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ApikeyTimeoutsArgs', 'ApikeyTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApikeyArgs.__new__(ApikeyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if expiry_time is None and not opts.urn:
                raise TypeError("Missing required property 'expiry_time'")
            __props__.__dict__["expiry_time"] = expiry_time
            if owner_id is None and not opts.urn:
                raise TypeError("Missing required property 'owner_id'")
            __props__.__dict__["owner_id"] = owner_id
            if owner_type is None and not opts.urn:
                raise TypeError("Missing required property 'owner_type'")
            __props__.__dict__["owner_type"] = owner_type
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["state"] = None
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Apikey, __self__).__init__(
            'temporalcloud:index/apikey:Apikey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            expiry_time: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            owner_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['ApikeyTimeoutsArgs', 'ApikeyTimeoutsArgsDict']]] = None,
            token: Optional[pulumi.Input[str]] = None) -> 'Apikey':
        """
        Get an existing Apikey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description for the API key.
        :param pulumi.Input[bool] disabled: Whether the API key is disabled.
        :param pulumi.Input[str] display_name: The display name for the API key.
        :param pulumi.Input[str] expiry_time: The expiry time for the API key in ISO 8601 format.
        :param pulumi.Input[str] owner_id: The ID of the owner to create the API key for.
        :param pulumi.Input[str] owner_type: The type of the owner to create the API key.
        :param pulumi.Input[str] state: The current state of the API key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApikeyState.__new__(_ApikeyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expiry_time"] = expiry_time
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["owner_type"] = owner_type
        __props__.__dict__["state"] = state
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["token"] = token
        return Apikey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description for the API key.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Whether the API key is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name for the API key.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> pulumi.Output[str]:
        """
        The expiry time for the API key in ISO 8601 format.
        """
        return pulumi.get(self, "expiry_time")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        The ID of the owner to create the API key for.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="ownerType")
    def owner_type(self) -> pulumi.Output[str]:
        """
        The type of the owner to create the API key.
        """
        return pulumi.get(self, "owner_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the API key.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ApikeyTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        return pulumi.get(self, "token")

