# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NexusEndpointArgs', 'NexusEndpoint']

@pulumi.input_type
class NexusEndpointArgs:
    def __init__(__self__, *,
                 allowed_caller_namespaces: pulumi.Input[Sequence[pulumi.Input[str]]],
                 worker_target: pulumi.Input['NexusEndpointWorkerTargetArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['NexusEndpointTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a NexusEndpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_caller_namespaces: Namespace Id(s) that are allowed to call this Endpoint.
        :param pulumi.Input['NexusEndpointWorkerTargetArgs'] worker_target: A target spec for routing nexus requests to a specific cloud namespace worker.
        :param pulumi.Input[str] description: The description for the Nexus endpoint.
        :param pulumi.Input[str] name: The name of the endpoint. Must be unique within an account and match `^[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9]$`
        """
        pulumi.set(__self__, "allowed_caller_namespaces", allowed_caller_namespaces)
        pulumi.set(__self__, "worker_target", worker_target)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="allowedCallerNamespaces")
    def allowed_caller_namespaces(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Namespace Id(s) that are allowed to call this Endpoint.
        """
        return pulumi.get(self, "allowed_caller_namespaces")

    @allowed_caller_namespaces.setter
    def allowed_caller_namespaces(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_caller_namespaces", value)

    @property
    @pulumi.getter(name="workerTarget")
    def worker_target(self) -> pulumi.Input['NexusEndpointWorkerTargetArgs']:
        """
        A target spec for routing nexus requests to a specific cloud namespace worker.
        """
        return pulumi.get(self, "worker_target")

    @worker_target.setter
    def worker_target(self, value: pulumi.Input['NexusEndpointWorkerTargetArgs']):
        pulumi.set(self, "worker_target", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the Nexus endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint. Must be unique within an account and match `^[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9]$`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NexusEndpointTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NexusEndpointTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _NexusEndpointState:
    def __init__(__self__, *,
                 allowed_caller_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['NexusEndpointTimeoutsArgs']] = None,
                 worker_target: Optional[pulumi.Input['NexusEndpointWorkerTargetArgs']] = None):
        """
        Input properties used for looking up and filtering NexusEndpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_caller_namespaces: Namespace Id(s) that are allowed to call this Endpoint.
        :param pulumi.Input[str] description: The description for the Nexus endpoint.
        :param pulumi.Input[str] name: The name of the endpoint. Must be unique within an account and match `^[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9]$`
        :param pulumi.Input['NexusEndpointWorkerTargetArgs'] worker_target: A target spec for routing nexus requests to a specific cloud namespace worker.
        """
        if allowed_caller_namespaces is not None:
            pulumi.set(__self__, "allowed_caller_namespaces", allowed_caller_namespaces)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if worker_target is not None:
            pulumi.set(__self__, "worker_target", worker_target)

    @property
    @pulumi.getter(name="allowedCallerNamespaces")
    def allowed_caller_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Namespace Id(s) that are allowed to call this Endpoint.
        """
        return pulumi.get(self, "allowed_caller_namespaces")

    @allowed_caller_namespaces.setter
    def allowed_caller_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_caller_namespaces", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the Nexus endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint. Must be unique within an account and match `^[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9]$`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NexusEndpointTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NexusEndpointTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="workerTarget")
    def worker_target(self) -> Optional[pulumi.Input['NexusEndpointWorkerTargetArgs']]:
        """
        A target spec for routing nexus requests to a specific cloud namespace worker.
        """
        return pulumi.get(self, "worker_target")

    @worker_target.setter
    def worker_target(self, value: Optional[pulumi.Input['NexusEndpointWorkerTargetArgs']]):
        pulumi.set(self, "worker_target", value)


class NexusEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_caller_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['NexusEndpointTimeoutsArgs', 'NexusEndpointTimeoutsArgsDict']]] = None,
                 worker_target: Optional[pulumi.Input[Union['NexusEndpointWorkerTargetArgs', 'NexusEndpointWorkerTargetArgsDict']]] = None,
                 __props__=None):
        """
        Provisions a Temporal Cloud Nexus endpoint.

        ## Import

        Nexus Endpoints can be imported to incorporate existing Nexus Endpoints into your Terraform pipeline.

        To import a Nexus Endpoint, you need

        - a resource configuration in your Terraform configuration file/module to accept the imported Nexus Endpoint. In the example below, the placeholder is "temporalcloud_nexus_endpoint" "nexus_endpoint"

        - the Nexus Endpoint's ID, which is found using the Temporal Cloud CLI tcld nexus endpoint list. In the example below, this is 405f7da4224a43d99c211904ed9b3819

        ```sh
        $ pulumi import temporalcloud:index/nexusEndpoint:NexusEndpoint nexus_endpoint 405f7da4224a43d99c211904ed9b3819
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_caller_namespaces: Namespace Id(s) that are allowed to call this Endpoint.
        :param pulumi.Input[str] description: The description for the Nexus endpoint.
        :param pulumi.Input[str] name: The name of the endpoint. Must be unique within an account and match `^[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9]$`
        :param pulumi.Input[Union['NexusEndpointWorkerTargetArgs', 'NexusEndpointWorkerTargetArgsDict']] worker_target: A target spec for routing nexus requests to a specific cloud namespace worker.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NexusEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provisions a Temporal Cloud Nexus endpoint.

        ## Import

        Nexus Endpoints can be imported to incorporate existing Nexus Endpoints into your Terraform pipeline.

        To import a Nexus Endpoint, you need

        - a resource configuration in your Terraform configuration file/module to accept the imported Nexus Endpoint. In the example below, the placeholder is "temporalcloud_nexus_endpoint" "nexus_endpoint"

        - the Nexus Endpoint's ID, which is found using the Temporal Cloud CLI tcld nexus endpoint list. In the example below, this is 405f7da4224a43d99c211904ed9b3819

        ```sh
        $ pulumi import temporalcloud:index/nexusEndpoint:NexusEndpoint nexus_endpoint 405f7da4224a43d99c211904ed9b3819
        ```

        :param str resource_name: The name of the resource.
        :param NexusEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NexusEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_caller_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['NexusEndpointTimeoutsArgs', 'NexusEndpointTimeoutsArgsDict']]] = None,
                 worker_target: Optional[pulumi.Input[Union['NexusEndpointWorkerTargetArgs', 'NexusEndpointWorkerTargetArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NexusEndpointArgs.__new__(NexusEndpointArgs)

            if allowed_caller_namespaces is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_caller_namespaces'")
            __props__.__dict__["allowed_caller_namespaces"] = allowed_caller_namespaces
            __props__.__dict__["description"] = None if description is None else pulumi.Output.secret(description)
            __props__.__dict__["name"] = name
            __props__.__dict__["timeouts"] = timeouts
            if worker_target is None and not opts.urn:
                raise TypeError("Missing required property 'worker_target'")
            __props__.__dict__["worker_target"] = worker_target
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["description"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NexusEndpoint, __self__).__init__(
            'temporalcloud:index/nexusEndpoint:NexusEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_caller_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['NexusEndpointTimeoutsArgs', 'NexusEndpointTimeoutsArgsDict']]] = None,
            worker_target: Optional[pulumi.Input[Union['NexusEndpointWorkerTargetArgs', 'NexusEndpointWorkerTargetArgsDict']]] = None) -> 'NexusEndpoint':
        """
        Get an existing NexusEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_caller_namespaces: Namespace Id(s) that are allowed to call this Endpoint.
        :param pulumi.Input[str] description: The description for the Nexus endpoint.
        :param pulumi.Input[str] name: The name of the endpoint. Must be unique within an account and match `^[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9]$`
        :param pulumi.Input[Union['NexusEndpointWorkerTargetArgs', 'NexusEndpointWorkerTargetArgsDict']] worker_target: A target spec for routing nexus requests to a specific cloud namespace worker.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NexusEndpointState.__new__(_NexusEndpointState)

        __props__.__dict__["allowed_caller_namespaces"] = allowed_caller_namespaces
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["worker_target"] = worker_target
        return NexusEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedCallerNamespaces")
    def allowed_caller_namespaces(self) -> pulumi.Output[Sequence[str]]:
        """
        Namespace Id(s) that are allowed to call this Endpoint.
        """
        return pulumi.get(self, "allowed_caller_namespaces")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description for the Nexus endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the endpoint. Must be unique within an account and match `^[a-zA-Z][a-zA-Z0-9\\-]*[a-zA-Z0-9]$`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.NexusEndpointTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="workerTarget")
    def worker_target(self) -> pulumi.Output['outputs.NexusEndpointWorkerTarget']:
        """
        A target spec for routing nexus requests to a specific cloud namespace worker.
        """
        return pulumi.get(self, "worker_target")

