# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'ApikeyTimeouts',
    'MetricsEndpointTimeouts',
    'NamespaceCertificateFilter',
    'NamespaceCodecServer',
    'NamespaceEndpoints',
    'NamespaceTimeouts',
    'NexusEndpointTimeouts',
    'NexusEndpointWorkerTarget',
    'ServiceAccountNamespaceAccess',
    'ServiceAccountTimeouts',
    'UserNamespaceAccess',
    'UserTimeouts',
    'GetNamespacesNamespaceResult',
    'GetNamespacesNamespaceCertificateFilterResult',
    'GetNamespacesNamespaceCodecServerResult',
    'GetNamespacesNamespaceEndpointsResult',
    'GetNamespacesNamespaceLimitsResult',
    'GetNamespacesNamespacePrivateConnectivityResult',
    'GetNamespacesNamespacePrivateConnectivityAwsPrivateLinkInfoResult',
    'GetRegionsRegionResult',
    'GetServiceAccountsServiceAccountResult',
    'GetServiceAccountsServiceAccountNamespaceAccessResult',
]

@pulumi.output_type
class ApikeyTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class MetricsEndpointTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class NamespaceCertificateFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "subjectAlternativeName":
            suggest = "subject_alternative_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceCertificateFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceCertificateFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceCertificateFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[str] = None,
                 organization: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 subject_alternative_name: Optional[str] = None):
        """
        :param str common_name: The certificate's common name.
        :param str organization: The certificate's organization.
        :param str organizational_unit: The certificate's organizational unit.
        :param str subject_alternative_name: The certificate's subject alternative name (or SAN).
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if subject_alternative_name is not None:
            pulumi.set(__self__, "subject_alternative_name", subject_alternative_name)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        """
        The certificate's common name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        """
        The certificate's organization.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        """
        The certificate's organizational unit.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="subjectAlternativeName")
    def subject_alternative_name(self) -> Optional[str]:
        """
        The certificate's subject alternative name (or SAN).
        """
        return pulumi.get(self, "subject_alternative_name")


@pulumi.output_type
class NamespaceCodecServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeCrossOriginCredentials":
            suggest = "include_cross_origin_credentials"
        elif key == "passAccessToken":
            suggest = "pass_access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceCodecServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceCodecServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceCodecServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 include_cross_origin_credentials: Optional[bool] = None,
                 pass_access_token: Optional[bool] = None):
        """
        :param str endpoint: The endpoint of the codec server. Must begin with "https".
        :param bool include_cross_origin_credentials: If true, Temporal Cloud will include cross-origin credentials in requests to the codec server.
        :param bool pass_access_token: If true, Temporal Cloud will pass the access token to the codec server upon each request.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if include_cross_origin_credentials is not None:
            pulumi.set(__self__, "include_cross_origin_credentials", include_cross_origin_credentials)
        if pass_access_token is not None:
            pulumi.set(__self__, "pass_access_token", pass_access_token)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint of the codec server. Must begin with "https".
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="includeCrossOriginCredentials")
    def include_cross_origin_credentials(self) -> Optional[bool]:
        """
        If true, Temporal Cloud will include cross-origin credentials in requests to the codec server.
        """
        return pulumi.get(self, "include_cross_origin_credentials")

    @property
    @pulumi.getter(name="passAccessToken")
    def pass_access_token(self) -> Optional[bool]:
        """
        If true, Temporal Cloud will pass the access token to the codec server upon each request.
        """
        return pulumi.get(self, "pass_access_token")


@pulumi.output_type
class NamespaceEndpoints(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "grpcAddress":
            suggest = "grpc_address"
        elif key == "mtlsGrpcAddress":
            suggest = "mtls_grpc_address"
        elif key == "webAddress":
            suggest = "web_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceEndpoints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceEndpoints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceEndpoints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 grpc_address: Optional[str] = None,
                 mtls_grpc_address: Optional[str] = None,
                 web_address: Optional[str] = None):
        """
        :param str grpc_address: The gRPC address for API key client connections (may be empty if API keys are disabled).
        :param str mtls_grpc_address: The gRPC address for mTLS client connections (may be empty if mTLS is disabled).
        :param str web_address: The address in the Temporal Cloud Web UI for the namespace
        """
        if grpc_address is not None:
            pulumi.set(__self__, "grpc_address", grpc_address)
        if mtls_grpc_address is not None:
            pulumi.set(__self__, "mtls_grpc_address", mtls_grpc_address)
        if web_address is not None:
            pulumi.set(__self__, "web_address", web_address)

    @property
    @pulumi.getter(name="grpcAddress")
    def grpc_address(self) -> Optional[str]:
        """
        The gRPC address for API key client connections (may be empty if API keys are disabled).
        """
        return pulumi.get(self, "grpc_address")

    @property
    @pulumi.getter(name="mtlsGrpcAddress")
    def mtls_grpc_address(self) -> Optional[str]:
        """
        The gRPC address for mTLS client connections (may be empty if mTLS is disabled).
        """
        return pulumi.get(self, "mtls_grpc_address")

    @property
    @pulumi.getter(name="webAddress")
    def web_address(self) -> Optional[str]:
        """
        The address in the Temporal Cloud Web UI for the namespace
        """
        return pulumi.get(self, "web_address")


@pulumi.output_type
class NamespaceTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class NexusEndpointTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class NexusEndpointWorkerTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"
        elif key == "taskQueue":
            suggest = "task_queue"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NexusEndpointWorkerTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NexusEndpointWorkerTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NexusEndpointWorkerTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace_id: str,
                 task_queue: str):
        """
        :param str namespace_id: The target cloud namespace to route requests to. Namespace must be in same account as the endpoint.
        :param str task_queue: The task queue on the cloud namespace to route requests to.
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "task_queue", task_queue)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> str:
        """
        The target cloud namespace to route requests to. Namespace must be in same account as the endpoint.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="taskQueue")
    def task_queue(self) -> str:
        """
        The task queue on the cloud namespace to route requests to.
        """
        return pulumi.get(self, "task_queue")


@pulumi.output_type
class ServiceAccountNamespaceAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAccountNamespaceAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAccountNamespaceAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAccountNamespaceAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace_id: str,
                 permission: str):
        """
        :param str namespace_id: The namespace to assign permissions to.
        :param str permission: The permission to assign. Must be one of admin, write, or read (case-insensitive)
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> str:
        """
        The namespace to assign permissions to.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The permission to assign. Must be one of admin, write, or read (case-insensitive)
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class ServiceAccountTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class UserNamespaceAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserNamespaceAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserNamespaceAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserNamespaceAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace_id: str,
                 permission: str):
        """
        :param str namespace_id: The namespace to assign permissions to.
        :param str permission: The permission to assign. Must be one of admin, write, or read (case-insensitive)
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> str:
        """
        The namespace to assign permissions to.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The permission to assign. Must be one of admin, write, or read (case-insensitive)
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class UserTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class GetNamespacesNamespaceResult(dict):
    def __init__(__self__, *,
                 accepted_client_ca: str,
                 active_region: str,
                 certificate_filters: Sequence['outputs.GetNamespacesNamespaceCertificateFilterResult'],
                 codec_server: 'outputs.GetNamespacesNamespaceCodecServerResult',
                 created_time: str,
                 custom_search_attributes: Mapping[str, str],
                 endpoints: 'outputs.GetNamespacesNamespaceEndpointsResult',
                 id: str,
                 last_modified_time: str,
                 limits: 'outputs.GetNamespacesNamespaceLimitsResult',
                 name: str,
                 private_connectivities: Sequence['outputs.GetNamespacesNamespacePrivateConnectivityResult'],
                 regions: Sequence[str],
                 retention_days: int,
                 state: str,
                 api_key_auth: Optional[bool] = None):
        """
        :param str accepted_client_ca: The Base64-encoded CA cert in PEM format that clients use when authenticating with Temporal Cloud.
        :param str active_region: The currently active region for the namespace.
        :param Sequence['GetNamespacesNamespaceCertificateFilterArgs'] certificate_filters: A list of filters to apply to client certificates when initiating a connection Temporal Cloud. If present, connections will only be allowed from client certificates whose distinguished name properties match at least one of the filters.
        :param 'GetNamespacesNamespaceCodecServerArgs' codec_server: A codec server is used by the Temporal Cloud UI to decode payloads for all users interacting with this namespace, even if the workflow history itself is encrypted.
        :param str created_time: The date and time when the namespace was created.
        :param Mapping[str, str] custom_search_attributes: The custom search attributes to use for the namespace.
        :param 'GetNamespacesNamespaceEndpointsArgs' endpoints: The endpoints for the namespace.
        :param str id: The unique identifier of the namespace across all Temporal Cloud tenants.
        :param str last_modified_time: The date and time when the namespace was last modified. Will not be set if the namespace has never been modified.
        :param 'GetNamespacesNamespaceLimitsArgs' limits: The limits set on the namespace currently.
        :param str name: The name of the namespace.
        :param Sequence['GetNamespacesNamespacePrivateConnectivityArgs'] private_connectivities: The private connectivities for the namespace, if any.
        :param int retention_days: The number of days to retain workflow history. Any changes to the retention period will be applied to all new running workflows.
        :param str state: The current state of the namespace.
        :param bool api_key_auth: If true, Temporal Cloud will use API key authentication for this namespace. If false, mutual TLS (mTLS) authentication will be used.
        """
        pulumi.set(__self__, "accepted_client_ca", accepted_client_ca)
        pulumi.set(__self__, "active_region", active_region)
        pulumi.set(__self__, "certificate_filters", certificate_filters)
        pulumi.set(__self__, "codec_server", codec_server)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "custom_search_attributes", custom_search_attributes)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_connectivities", private_connectivities)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "state", state)
        if api_key_auth is not None:
            pulumi.set(__self__, "api_key_auth", api_key_auth)

    @property
    @pulumi.getter(name="acceptedClientCa")
    def accepted_client_ca(self) -> str:
        """
        The Base64-encoded CA cert in PEM format that clients use when authenticating with Temporal Cloud.
        """
        return pulumi.get(self, "accepted_client_ca")

    @property
    @pulumi.getter(name="activeRegion")
    def active_region(self) -> str:
        """
        The currently active region for the namespace.
        """
        return pulumi.get(self, "active_region")

    @property
    @pulumi.getter(name="certificateFilters")
    def certificate_filters(self) -> Sequence['outputs.GetNamespacesNamespaceCertificateFilterResult']:
        """
        A list of filters to apply to client certificates when initiating a connection Temporal Cloud. If present, connections will only be allowed from client certificates whose distinguished name properties match at least one of the filters.
        """
        return pulumi.get(self, "certificate_filters")

    @property
    @pulumi.getter(name="codecServer")
    def codec_server(self) -> 'outputs.GetNamespacesNamespaceCodecServerResult':
        """
        A codec server is used by the Temporal Cloud UI to decode payloads for all users interacting with this namespace, even if the workflow history itself is encrypted.
        """
        return pulumi.get(self, "codec_server")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The date and time when the namespace was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="customSearchAttributes")
    def custom_search_attributes(self) -> Mapping[str, str]:
        """
        The custom search attributes to use for the namespace.
        """
        return pulumi.get(self, "custom_search_attributes")

    @property
    @pulumi.getter
    def endpoints(self) -> 'outputs.GetNamespacesNamespaceEndpointsResult':
        """
        The endpoints for the namespace.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier of the namespace across all Temporal Cloud tenants.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        The date and time when the namespace was last modified. Will not be set if the namespace has never been modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def limits(self) -> 'outputs.GetNamespacesNamespaceLimitsResult':
        """
        The limits set on the namespace currently.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateConnectivities")
    def private_connectivities(self) -> Sequence['outputs.GetNamespacesNamespacePrivateConnectivityResult']:
        """
        The private connectivities for the namespace, if any.
        """
        return pulumi.get(self, "private_connectivities")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> int:
        """
        The number of days to retain workflow history. Any changes to the retention period will be applied to all new running workflows.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the namespace.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="apiKeyAuth")
    def api_key_auth(self) -> Optional[bool]:
        """
        If true, Temporal Cloud will use API key authentication for this namespace. If false, mutual TLS (mTLS) authentication will be used.
        """
        return pulumi.get(self, "api_key_auth")


@pulumi.output_type
class GetNamespacesNamespaceCertificateFilterResult(dict):
    def __init__(__self__, *,
                 common_name: str,
                 organization: str,
                 organizational_unit: str,
                 subject_alternative_name: str):
        """
        :param str common_name: The certificate's common name.
        :param str organization: The certificate's organization.
        :param str organizational_unit: The certificate's organizational unit.
        :param str subject_alternative_name: The certificate's subject alternative name (or SAN).
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "organizational_unit", organizational_unit)
        pulumi.set(__self__, "subject_alternative_name", subject_alternative_name)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The certificate's common name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        The certificate's organization.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> str:
        """
        The certificate's organizational unit.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="subjectAlternativeName")
    def subject_alternative_name(self) -> str:
        """
        The certificate's subject alternative name (or SAN).
        """
        return pulumi.get(self, "subject_alternative_name")


@pulumi.output_type
class GetNamespacesNamespaceCodecServerResult(dict):
    def __init__(__self__, *,
                 endpoint: str,
                 include_cross_origin_credentials: bool,
                 pass_access_token: bool):
        """
        :param str endpoint: The endpoint of the codec server.
        :param bool include_cross_origin_credentials: If true, Temporal Cloud will include cross-origin credentials in requests to the codec server.
        :param bool pass_access_token: If true, Temporal Cloud will pass the access token to the codec server upon each request.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "include_cross_origin_credentials", include_cross_origin_credentials)
        pulumi.set(__self__, "pass_access_token", pass_access_token)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint of the codec server.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="includeCrossOriginCredentials")
    def include_cross_origin_credentials(self) -> bool:
        """
        If true, Temporal Cloud will include cross-origin credentials in requests to the codec server.
        """
        return pulumi.get(self, "include_cross_origin_credentials")

    @property
    @pulumi.getter(name="passAccessToken")
    def pass_access_token(self) -> bool:
        """
        If true, Temporal Cloud will pass the access token to the codec server upon each request.
        """
        return pulumi.get(self, "pass_access_token")


@pulumi.output_type
class GetNamespacesNamespaceEndpointsResult(dict):
    def __init__(__self__, *,
                 grpc_address: str,
                 web_address: str):
        """
        :param str grpc_address: The gRPC hostport address that the temporal workers, clients and tctl connect to.
        :param str web_address: The web UI address.
        """
        pulumi.set(__self__, "grpc_address", grpc_address)
        pulumi.set(__self__, "web_address", web_address)

    @property
    @pulumi.getter(name="grpcAddress")
    def grpc_address(self) -> str:
        """
        The gRPC hostport address that the temporal workers, clients and tctl connect to.
        """
        return pulumi.get(self, "grpc_address")

    @property
    @pulumi.getter(name="webAddress")
    def web_address(self) -> str:
        """
        The web UI address.
        """
        return pulumi.get(self, "web_address")


@pulumi.output_type
class GetNamespacesNamespaceLimitsResult(dict):
    def __init__(__self__, *,
                 actions_per_second_limit: int):
        """
        :param int actions_per_second_limit: The number of actions per second (APS) that is currently allowed for the namespace. The namespace may be throttled if its APS exceeds the limit.
        """
        pulumi.set(__self__, "actions_per_second_limit", actions_per_second_limit)

    @property
    @pulumi.getter(name="actionsPerSecondLimit")
    def actions_per_second_limit(self) -> int:
        """
        The number of actions per second (APS) that is currently allowed for the namespace. The namespace may be throttled if its APS exceeds the limit.
        """
        return pulumi.get(self, "actions_per_second_limit")


@pulumi.output_type
class GetNamespacesNamespacePrivateConnectivityResult(dict):
    def __init__(__self__, *,
                 aws_private_link_info: 'outputs.GetNamespacesNamespacePrivateConnectivityAwsPrivateLinkInfoResult',
                 region: str):
        """
        :param 'GetNamespacesNamespacePrivateConnectivityAwsPrivateLinkInfoArgs' aws_private_link_info: The AWS PrivateLink info. This will only be set for namespaces whose cloud provider is AWS.
        :param str region: The id of the region where the private connectivity applies.
        """
        pulumi.set(__self__, "aws_private_link_info", aws_private_link_info)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="awsPrivateLinkInfo")
    def aws_private_link_info(self) -> 'outputs.GetNamespacesNamespacePrivateConnectivityAwsPrivateLinkInfoResult':
        """
        The AWS PrivateLink info. This will only be set for namespaces whose cloud provider is AWS.
        """
        return pulumi.get(self, "aws_private_link_info")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The id of the region where the private connectivity applies.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetNamespacesNamespacePrivateConnectivityAwsPrivateLinkInfoResult(dict):
    def __init__(__self__, *,
                 allowed_principal_arns: Sequence[str],
                 vpc_endpoint_service_names: Sequence[str]):
        """
        :param Sequence[str] allowed_principal_arns: The list of principal arns that are allowed to access the namespace on the private link.
        :param Sequence[str] vpc_endpoint_service_names: The list of vpc endpoint service names that are associated with the namespace.
        """
        pulumi.set(__self__, "allowed_principal_arns", allowed_principal_arns)
        pulumi.set(__self__, "vpc_endpoint_service_names", vpc_endpoint_service_names)

    @property
    @pulumi.getter(name="allowedPrincipalArns")
    def allowed_principal_arns(self) -> Sequence[str]:
        """
        The list of principal arns that are allowed to access the namespace on the private link.
        """
        return pulumi.get(self, "allowed_principal_arns")

    @property
    @pulumi.getter(name="vpcEndpointServiceNames")
    def vpc_endpoint_service_names(self) -> Sequence[str]:
        """
        The list of vpc endpoint service names that are associated with the namespace.
        """
        return pulumi.get(self, "vpc_endpoint_service_names")


@pulumi.output_type
class GetRegionsRegionResult(dict):
    def __init__(__self__, *,
                 cloud_provider: str,
                 cloud_provider_region: str,
                 id: str,
                 location: str):
        """
        :param str cloud_provider: The name of the Cloud provider for this region, e.g. `aws`.
        :param str cloud_provider_region: The name of the region within the Cloud provider, e.g. `us-east-1`.
        :param str id: The unique identifier for the region, e.g. `aws-us-east-1`.
        :param str location: The physical location of the region, e.g. "US East (N. Virginia)".
        """
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "cloud_provider_region", cloud_provider_region)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> str:
        """
        The name of the Cloud provider for this region, e.g. `aws`.
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter(name="cloudProviderRegion")
    def cloud_provider_region(self) -> str:
        """
        The name of the region within the Cloud provider, e.g. `us-east-1`.
        """
        return pulumi.get(self, "cloud_provider_region")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier for the region, e.g. `aws-us-east-1`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The physical location of the region, e.g. "US East (N. Virginia)".
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class GetServiceAccountsServiceAccountResult(dict):
    def __init__(__self__, *,
                 account_access: str,
                 created_at: str,
                 description: str,
                 id: str,
                 name: str,
                 namespace_accesses: Sequence['outputs.GetServiceAccountsServiceAccountNamespaceAccessResult'],
                 state: str,
                 updated_at: str):
        """
        :param str account_access: The role on the account. Must be one of admin, developer, or read (case-insensitive).
        :param str created_at: The creation time of the Service Account.
        :param str description: The description of the Service Account.
        :param str id: The unique identifier of the Service Account.
        :param str name: The name associated with the service account.
        :param Sequence['GetServiceAccountsServiceAccountNamespaceAccessArgs'] namespace_accesses: The set of namespace permissions for this service account, including each namespace and its role.
        :param str state: The current state of the Service Account.
        :param str updated_at: The last update time of the Service Account.
        """
        pulumi.set(__self__, "account_access", account_access)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace_accesses", namespace_accesses)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="accountAccess")
    def account_access(self) -> str:
        """
        The role on the account. Must be one of admin, developer, or read (case-insensitive).
        """
        return pulumi.get(self, "account_access")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The creation time of the Service Account.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Service Account.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier of the Service Account.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name associated with the service account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceAccesses")
    def namespace_accesses(self) -> Sequence['outputs.GetServiceAccountsServiceAccountNamespaceAccessResult']:
        """
        The set of namespace permissions for this service account, including each namespace and its role.
        """
        return pulumi.get(self, "namespace_accesses")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Service Account.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The last update time of the Service Account.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetServiceAccountsServiceAccountNamespaceAccessResult(dict):
    def __init__(__self__, *,
                 namespace_id: str,
                 permission: str):
        """
        :param str namespace_id: The namespace to assign permissions to.
        :param str permission: The permission to assign. Must be one of admin, write, or read (case-insensitive)
        """
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> str:
        """
        The namespace to assign permissions to.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The permission to assign. Must be one of admin, write, or read (case-insensitive)
        """
        return pulumi.get(self, "permission")


