# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 allowed_account_id: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[bool] allow_insecure: If set to True, it allows for an insecure connection to the Temporal Cloud API. This should never be set to 'true' in
               production and defaults to false.
        :param pulumi.Input[str] allowed_account_id: The ID of the account to operate on. Prevents accidental mutation of accounts other than that provided.
        :param pulumi.Input[str] api_key: The API key for Temporal Cloud. See [this documentation](https://docs.temporal.io/cloud/api-keys) for information on how
               to obtain an API key.
        :param pulumi.Input[str] endpoint: The endpoint for the Temporal Cloud API. Defaults to `saas-api.tmprl.cloud:443`.
        """
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if allowed_account_id is not None:
            pulumi.set(__self__, "allowed_account_id", allowed_account_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to True, it allows for an insecure connection to the Temporal Cloud API. This should never be set to 'true' in
        production and defaults to false.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="allowedAccountId")
    def allowed_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the account to operate on. Prevents accidental mutation of accounts other than that provided.
        """
        return pulumi.get(self, "allowed_account_id")

    @allowed_account_id.setter
    def allowed_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_account_id", value)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[str]]:
        """
        The API key for Temporal Cloud. See [this documentation](https://docs.temporal.io/cloud/api-keys) for information on how
        to obtain an API key.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint for the Temporal Cloud API. Defaults to `saas-api.tmprl.cloud:443`.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 allowed_account_id: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the temporalcloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_insecure: If set to True, it allows for an insecure connection to the Temporal Cloud API. This should never be set to 'true' in
               production and defaults to false.
        :param pulumi.Input[str] allowed_account_id: The ID of the account to operate on. Prevents accidental mutation of accounts other than that provided.
        :param pulumi.Input[str] api_key: The API key for Temporal Cloud. See [this documentation](https://docs.temporal.io/cloud/api-keys) for information on how
               to obtain an API key.
        :param pulumi.Input[str] endpoint: The endpoint for the Temporal Cloud API. Defaults to `saas-api.tmprl.cloud:443`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the temporalcloud package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 allowed_account_id: Optional[pulumi.Input[str]] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["allow_insecure"] = pulumi.Output.from_input(allow_insecure).apply(pulumi.runtime.to_json) if allow_insecure is not None else None
            __props__.__dict__["allowed_account_id"] = allowed_account_id
            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["endpoint"] = endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'temporalcloud',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="allowedAccountId")
    def allowed_account_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the account to operate on. Prevents accidental mutation of accounts other than that provided.
        """
        return pulumi.get(self, "allowed_account_id")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[str]]:
        """
        The API key for Temporal Cloud. See [this documentation](https://docs.temporal.io/cloud/api-keys) for information on how
        to obtain an API key.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The endpoint for the Temporal Cloud API. Defaults to `saas-api.tmprl.cloud:443`.
        """
        return pulumi.get(self, "endpoint")

