# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 account_access: pulumi.Input[str],
                 email: pulumi.Input[str],
                 namespace_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['UserTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] account_access: The role on the account. Must be one of owner, admin, developer, or read (case-insensitive). owner is only valid for import and cannot be created, updated or deleted without Temporal support.
        :param pulumi.Input[str] email: The email address for the user.
        :param pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]] namespace_accesses: The set of namespace accesses. Empty sets are not allowed, omit the attribute instead. Users with account*access roles of owner or admin cannot be assigned explicit permissions to namespaces. They implicitly receive access to all Namespaces.
        """
        pulumi.set(__self__, "account_access", account_access)
        pulumi.set(__self__, "email", email)
        if namespace_accesses is not None:
            pulumi.set(__self__, "namespace_accesses", namespace_accesses)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="accountAccess")
    def account_access(self) -> pulumi.Input[str]:
        """
        The role on the account. Must be one of owner, admin, developer, or read (case-insensitive). owner is only valid for import and cannot be created, updated or deleted without Temporal support.
        """
        return pulumi.get(self, "account_access")

    @account_access.setter
    def account_access(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_access", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The email address for the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="namespaceAccesses")
    def namespace_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]]]:
        """
        The set of namespace accesses. Empty sets are not allowed, omit the attribute instead. Users with account*access roles of owner or admin cannot be assigned explicit permissions to namespaces. They implicitly receive access to all Namespaces.
        """
        return pulumi.get(self, "namespace_accesses")

    @namespace_accesses.setter
    def namespace_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]]]):
        pulumi.set(self, "namespace_accesses", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['UserTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['UserTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 account_access: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 namespace_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['UserTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] account_access: The role on the account. Must be one of owner, admin, developer, or read (case-insensitive). owner is only valid for import and cannot be created, updated or deleted without Temporal support.
        :param pulumi.Input[str] email: The email address for the user.
        :param pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]] namespace_accesses: The set of namespace accesses. Empty sets are not allowed, omit the attribute instead. Users with account*access roles of owner or admin cannot be assigned explicit permissions to namespaces. They implicitly receive access to all Namespaces.
        :param pulumi.Input[str] state: The current state of the user.
        """
        if account_access is not None:
            pulumi.set(__self__, "account_access", account_access)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if namespace_accesses is not None:
            pulumi.set(__self__, "namespace_accesses", namespace_accesses)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="accountAccess")
    def account_access(self) -> Optional[pulumi.Input[str]]:
        """
        The role on the account. Must be one of owner, admin, developer, or read (case-insensitive). owner is only valid for import and cannot be created, updated or deleted without Temporal support.
        """
        return pulumi.get(self, "account_access")

    @account_access.setter
    def account_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_access", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address for the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="namespaceAccesses")
    def namespace_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]]]:
        """
        The set of namespace accesses. Empty sets are not allowed, omit the attribute instead. Users with account*access roles of owner or admin cannot be assigned explicit permissions to namespaces. They implicitly receive access to all Namespaces.
        """
        return pulumi.get(self, "namespace_accesses")

    @namespace_accesses.setter
    def namespace_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserNamespaceAccessArgs']]]]):
        pulumi.set(self, "namespace_accesses", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the user.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['UserTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['UserTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_access: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 namespace_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserNamespaceAccessArgs', 'UserNamespaceAccessArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['UserTimeoutsArgs', 'UserTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Provisions a Temporal Cloud user.

        ## Import

        Users can be imported to incorporate existing Users into your Terraform pipeline.

        To import a User, you need

        - a resource configuration in your Terraform configuration file/module to accept the imported User. In the example below, the placeholder is "temporalcloud_user" "user"

        - the User's ID, which is found using the Temporal Cloud CLI tcld u l. In the example below, this is 72360058153949edb2f1d47019c1e85f

        ```sh
        $ pulumi import temporalcloud:index/user:User user 72360058153949edb2f1d47019c1e85f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_access: The role on the account. Must be one of owner, admin, developer, or read (case-insensitive). owner is only valid for import and cannot be created, updated or deleted without Temporal support.
        :param pulumi.Input[str] email: The email address for the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserNamespaceAccessArgs', 'UserNamespaceAccessArgsDict']]]] namespace_accesses: The set of namespace accesses. Empty sets are not allowed, omit the attribute instead. Users with account*access roles of owner or admin cannot be assigned explicit permissions to namespaces. They implicitly receive access to all Namespaces.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provisions a Temporal Cloud user.

        ## Import

        Users can be imported to incorporate existing Users into your Terraform pipeline.

        To import a User, you need

        - a resource configuration in your Terraform configuration file/module to accept the imported User. In the example below, the placeholder is "temporalcloud_user" "user"

        - the User's ID, which is found using the Temporal Cloud CLI tcld u l. In the example below, this is 72360058153949edb2f1d47019c1e85f

        ```sh
        $ pulumi import temporalcloud:index/user:User user 72360058153949edb2f1d47019c1e85f
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_access: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 namespace_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserNamespaceAccessArgs', 'UserNamespaceAccessArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['UserTimeoutsArgs', 'UserTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if account_access is None and not opts.urn:
                raise TypeError("Missing required property 'account_access'")
            __props__.__dict__["account_access"] = account_access
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["namespace_accesses"] = namespace_accesses
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["state"] = None
        super(User, __self__).__init__(
            'temporalcloud:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_access: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            namespace_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserNamespaceAccessArgs', 'UserNamespaceAccessArgsDict']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['UserTimeoutsArgs', 'UserTimeoutsArgsDict']]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_access: The role on the account. Must be one of owner, admin, developer, or read (case-insensitive). owner is only valid for import and cannot be created, updated or deleted without Temporal support.
        :param pulumi.Input[str] email: The email address for the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserNamespaceAccessArgs', 'UserNamespaceAccessArgsDict']]]] namespace_accesses: The set of namespace accesses. Empty sets are not allowed, omit the attribute instead. Users with account*access roles of owner or admin cannot be assigned explicit permissions to namespaces. They implicitly receive access to all Namespaces.
        :param pulumi.Input[str] state: The current state of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["account_access"] = account_access
        __props__.__dict__["email"] = email
        __props__.__dict__["namespace_accesses"] = namespace_accesses
        __props__.__dict__["state"] = state
        __props__.__dict__["timeouts"] = timeouts
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountAccess")
    def account_access(self) -> pulumi.Output[str]:
        """
        The role on the account. Must be one of owner, admin, developer, or read (case-insensitive). owner is only valid for import and cannot be created, updated or deleted without Temporal support.
        """
        return pulumi.get(self, "account_access")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The email address for the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="namespaceAccesses")
    def namespace_accesses(self) -> pulumi.Output[Optional[Sequence['outputs.UserNamespaceAccess']]]:
        """
        The set of namespace accesses. Empty sets are not allowed, omit the attribute instead. Users with account*access roles of owner or admin cannot be assigned explicit permissions to namespaces. They implicitly receive access to all Namespaces.
        """
        return pulumi.get(self, "namespace_accesses")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the user.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.UserTimeouts']]:
        return pulumi.get(self, "timeouts")

