import numpy as np
from scipy.linalg import solve_triangular, cholesky


class GP:
    def __init__(self, X, Y, kernel):
        sigon = 1
        self.X = X
        n, dx = X.shape
        self.kernel = kernel
        K = kernel(X, X)
        self.L = cholesky(K + (sigon ** 2) * np.eye(n))
        self.alpha = solve_triangular(self.L,
                                      solve_triangular(self.L, Y, trans=1))

    def predict(self, Xt):
        Kxxt = self.kernel(self.X, Xt)
        mu = np.dot(self.alpha.reshape(-1), Kxxt)
        v = solve_triangular(self.L, Kxxt, trans=1)
        s2 = self.kernel(Xt) - np.sum(v ** 2, axis=0)  # np.diag(np.dot(v.T,v))#
        return mu.reshape(-1, 1), s2.reshape(-1, 1)

    def optimize(self, **kwargs):
        raise NotImplementedError
