/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiOperationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#api_management_name ApiManagementApiOperation#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#api_name ApiManagementApiOperation#api_name}
    */
    readonly apiName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#display_name ApiManagementApiOperation#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#id ApiManagementApiOperation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#method ApiManagementApiOperation#method}
    */
    readonly method: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#operation_id ApiManagementApiOperation#operation_id}
    */
    readonly operationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#resource_group_name ApiManagementApiOperation#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#url_template ApiManagementApiOperation#url_template}
    */
    readonly urlTemplate: string;
    /**
    * request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#request ApiManagementApiOperation#request}
    */
    readonly request?: ApiManagementApiOperationRequest;
    /**
    * response block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#response ApiManagementApiOperation#response}
    */
    readonly response?: ApiManagementApiOperationResponse[] | cdktf.IResolvable;
    /**
    * template_parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#template_parameter ApiManagementApiOperation#template_parameter}
    */
    readonly templateParameter?: ApiManagementApiOperationTemplateParameter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#timeouts ApiManagementApiOperation#timeouts}
    */
    readonly timeouts?: ApiManagementApiOperationTimeouts;
}
export interface ApiManagementApiOperationRequestHeaderExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationRequestHeaderExampleToTerraform(struct?: ApiManagementApiOperationRequestHeaderExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestHeaderExampleToHclTerraform(struct?: ApiManagementApiOperationRequestHeaderExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestHeaderExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestHeaderExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestHeaderExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationRequestHeaderExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestHeaderExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestHeaderExampleOutputReference;
}
export interface ApiManagementApiOperationRequestHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#default_value ApiManagementApiOperation#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#required ApiManagementApiOperation#required}
    */
    readonly required: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type ApiManagementApiOperation#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#values ApiManagementApiOperation#values}
    */
    readonly values?: string[];
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationRequestHeaderExample[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationRequestHeaderToTerraform(struct?: ApiManagementApiOperationRequestHeader | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestHeaderToHclTerraform(struct?: ApiManagementApiOperationRequestHeader | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestHeader | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _example;
    get example(): ApiManagementApiOperationRequestHeaderExampleList;
    putExample(value: ApiManagementApiOperationRequestHeaderExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationRequestHeaderExample[] | undefined;
}
export declare class ApiManagementApiOperationRequestHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestHeaderOutputReference;
}
export interface ApiManagementApiOperationRequestQueryParameterExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationRequestQueryParameterExampleToTerraform(struct?: ApiManagementApiOperationRequestQueryParameterExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestQueryParameterExampleToHclTerraform(struct?: ApiManagementApiOperationRequestQueryParameterExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestQueryParameterExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestQueryParameterExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestQueryParameterExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationRequestQueryParameterExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestQueryParameterExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestQueryParameterExampleOutputReference;
}
export interface ApiManagementApiOperationRequestQueryParameter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#default_value ApiManagementApiOperation#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#required ApiManagementApiOperation#required}
    */
    readonly required: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type ApiManagementApiOperation#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#values ApiManagementApiOperation#values}
    */
    readonly values?: string[];
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationRequestQueryParameterExample[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationRequestQueryParameterToTerraform(struct?: ApiManagementApiOperationRequestQueryParameter | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestQueryParameterToHclTerraform(struct?: ApiManagementApiOperationRequestQueryParameter | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestQueryParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestQueryParameter | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestQueryParameter | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _example;
    get example(): ApiManagementApiOperationRequestQueryParameterExampleList;
    putExample(value: ApiManagementApiOperationRequestQueryParameterExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationRequestQueryParameterExample[] | undefined;
}
export declare class ApiManagementApiOperationRequestQueryParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestQueryParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestQueryParameterOutputReference;
}
export interface ApiManagementApiOperationRequestRepresentationExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationRequestRepresentationExampleToTerraform(struct?: ApiManagementApiOperationRequestRepresentationExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestRepresentationExampleToHclTerraform(struct?: ApiManagementApiOperationRequestRepresentationExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestRepresentationExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestRepresentationExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestRepresentationExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationRequestRepresentationExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestRepresentationExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestRepresentationExampleOutputReference;
}
export interface ApiManagementApiOperationRequestRepresentationFormParameterExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationRequestRepresentationFormParameterExampleToTerraform(struct?: ApiManagementApiOperationRequestRepresentationFormParameterExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestRepresentationFormParameterExampleToHclTerraform(struct?: ApiManagementApiOperationRequestRepresentationFormParameterExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestRepresentationFormParameterExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestRepresentationFormParameterExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestRepresentationFormParameterExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationRequestRepresentationFormParameterExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestRepresentationFormParameterExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestRepresentationFormParameterExampleOutputReference;
}
export interface ApiManagementApiOperationRequestRepresentationFormParameter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#default_value ApiManagementApiOperation#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#required ApiManagementApiOperation#required}
    */
    readonly required: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type ApiManagementApiOperation#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#values ApiManagementApiOperation#values}
    */
    readonly values?: string[];
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationRequestRepresentationFormParameterExample[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationRequestRepresentationFormParameterToTerraform(struct?: ApiManagementApiOperationRequestRepresentationFormParameter | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestRepresentationFormParameterToHclTerraform(struct?: ApiManagementApiOperationRequestRepresentationFormParameter | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestRepresentationFormParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestRepresentationFormParameter | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestRepresentationFormParameter | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _example;
    get example(): ApiManagementApiOperationRequestRepresentationFormParameterExampleList;
    putExample(value: ApiManagementApiOperationRequestRepresentationFormParameterExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationRequestRepresentationFormParameterExample[] | undefined;
}
export declare class ApiManagementApiOperationRequestRepresentationFormParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestRepresentationFormParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestRepresentationFormParameterOutputReference;
}
export interface ApiManagementApiOperationRequestRepresentation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#content_type ApiManagementApiOperation#content_type}
    */
    readonly contentType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationRequestRepresentationExample[] | cdktf.IResolvable;
    /**
    * form_parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#form_parameter ApiManagementApiOperation#form_parameter}
    */
    readonly formParameter?: ApiManagementApiOperationRequestRepresentationFormParameter[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationRequestRepresentationToTerraform(struct?: ApiManagementApiOperationRequestRepresentation | cdktf.IResolvable): any;
export declare function apiManagementApiOperationRequestRepresentationToHclTerraform(struct?: ApiManagementApiOperationRequestRepresentation | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationRequestRepresentationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationRequestRepresentation | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationRequestRepresentation | cdktf.IResolvable | undefined);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    get contentTypeInput(): string | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _example;
    get example(): ApiManagementApiOperationRequestRepresentationExampleList;
    putExample(value: ApiManagementApiOperationRequestRepresentationExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationRequestRepresentationExample[] | undefined;
    private _formParameter;
    get formParameter(): ApiManagementApiOperationRequestRepresentationFormParameterList;
    putFormParameter(value: ApiManagementApiOperationRequestRepresentationFormParameter[] | cdktf.IResolvable): void;
    resetFormParameter(): void;
    get formParameterInput(): cdktf.IResolvable | ApiManagementApiOperationRequestRepresentationFormParameter[] | undefined;
}
export declare class ApiManagementApiOperationRequestRepresentationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationRequestRepresentation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationRequestRepresentationOutputReference;
}
export interface ApiManagementApiOperationRequest {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#header ApiManagementApiOperation#header}
    */
    readonly header?: ApiManagementApiOperationRequestHeader[] | cdktf.IResolvable;
    /**
    * query_parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#query_parameter ApiManagementApiOperation#query_parameter}
    */
    readonly queryParameter?: ApiManagementApiOperationRequestQueryParameter[] | cdktf.IResolvable;
    /**
    * representation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#representation ApiManagementApiOperation#representation}
    */
    readonly representation?: ApiManagementApiOperationRequestRepresentation[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationRequestToTerraform(struct?: ApiManagementApiOperationRequestOutputReference | ApiManagementApiOperationRequest): any;
export declare function apiManagementApiOperationRequestToHclTerraform(struct?: ApiManagementApiOperationRequestOutputReference | ApiManagementApiOperationRequest): any;
export declare class ApiManagementApiOperationRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiOperationRequest | undefined;
    set internalValue(value: ApiManagementApiOperationRequest | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _header;
    get header(): ApiManagementApiOperationRequestHeaderList;
    putHeader(value: ApiManagementApiOperationRequestHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ApiManagementApiOperationRequestHeader[] | undefined;
    private _queryParameter;
    get queryParameter(): ApiManagementApiOperationRequestQueryParameterList;
    putQueryParameter(value: ApiManagementApiOperationRequestQueryParameter[] | cdktf.IResolvable): void;
    resetQueryParameter(): void;
    get queryParameterInput(): cdktf.IResolvable | ApiManagementApiOperationRequestQueryParameter[] | undefined;
    private _representation;
    get representation(): ApiManagementApiOperationRequestRepresentationList;
    putRepresentation(value: ApiManagementApiOperationRequestRepresentation[] | cdktf.IResolvable): void;
    resetRepresentation(): void;
    get representationInput(): cdktf.IResolvable | ApiManagementApiOperationRequestRepresentation[] | undefined;
}
export interface ApiManagementApiOperationResponseHeaderExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationResponseHeaderExampleToTerraform(struct?: ApiManagementApiOperationResponseHeaderExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationResponseHeaderExampleToHclTerraform(struct?: ApiManagementApiOperationResponseHeaderExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationResponseHeaderExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationResponseHeaderExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationResponseHeaderExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationResponseHeaderExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationResponseHeaderExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationResponseHeaderExampleOutputReference;
}
export interface ApiManagementApiOperationResponseHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#default_value ApiManagementApiOperation#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#required ApiManagementApiOperation#required}
    */
    readonly required: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type ApiManagementApiOperation#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#values ApiManagementApiOperation#values}
    */
    readonly values?: string[];
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationResponseHeaderExample[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationResponseHeaderToTerraform(struct?: ApiManagementApiOperationResponseHeader | cdktf.IResolvable): any;
export declare function apiManagementApiOperationResponseHeaderToHclTerraform(struct?: ApiManagementApiOperationResponseHeader | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationResponseHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationResponseHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationResponseHeader | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _example;
    get example(): ApiManagementApiOperationResponseHeaderExampleList;
    putExample(value: ApiManagementApiOperationResponseHeaderExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationResponseHeaderExample[] | undefined;
}
export declare class ApiManagementApiOperationResponseHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationResponseHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationResponseHeaderOutputReference;
}
export interface ApiManagementApiOperationResponseRepresentationExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationResponseRepresentationExampleToTerraform(struct?: ApiManagementApiOperationResponseRepresentationExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationResponseRepresentationExampleToHclTerraform(struct?: ApiManagementApiOperationResponseRepresentationExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationResponseRepresentationExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationResponseRepresentationExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationResponseRepresentationExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationResponseRepresentationExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationResponseRepresentationExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationResponseRepresentationExampleOutputReference;
}
export interface ApiManagementApiOperationResponseRepresentationFormParameterExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationResponseRepresentationFormParameterExampleToTerraform(struct?: ApiManagementApiOperationResponseRepresentationFormParameterExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationResponseRepresentationFormParameterExampleToHclTerraform(struct?: ApiManagementApiOperationResponseRepresentationFormParameterExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationResponseRepresentationFormParameterExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationResponseRepresentationFormParameterExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationResponseRepresentationFormParameterExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationResponseRepresentationFormParameterExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationResponseRepresentationFormParameterExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationResponseRepresentationFormParameterExampleOutputReference;
}
export interface ApiManagementApiOperationResponseRepresentationFormParameter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#default_value ApiManagementApiOperation#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#required ApiManagementApiOperation#required}
    */
    readonly required: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type ApiManagementApiOperation#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#values ApiManagementApiOperation#values}
    */
    readonly values?: string[];
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationResponseRepresentationFormParameterExample[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationResponseRepresentationFormParameterToTerraform(struct?: ApiManagementApiOperationResponseRepresentationFormParameter | cdktf.IResolvable): any;
export declare function apiManagementApiOperationResponseRepresentationFormParameterToHclTerraform(struct?: ApiManagementApiOperationResponseRepresentationFormParameter | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationResponseRepresentationFormParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationResponseRepresentationFormParameter | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationResponseRepresentationFormParameter | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _example;
    get example(): ApiManagementApiOperationResponseRepresentationFormParameterExampleList;
    putExample(value: ApiManagementApiOperationResponseRepresentationFormParameterExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationResponseRepresentationFormParameterExample[] | undefined;
}
export declare class ApiManagementApiOperationResponseRepresentationFormParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationResponseRepresentationFormParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationResponseRepresentationFormParameterOutputReference;
}
export interface ApiManagementApiOperationResponseRepresentation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#content_type ApiManagementApiOperation#content_type}
    */
    readonly contentType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationResponseRepresentationExample[] | cdktf.IResolvable;
    /**
    * form_parameter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#form_parameter ApiManagementApiOperation#form_parameter}
    */
    readonly formParameter?: ApiManagementApiOperationResponseRepresentationFormParameter[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationResponseRepresentationToTerraform(struct?: ApiManagementApiOperationResponseRepresentation | cdktf.IResolvable): any;
export declare function apiManagementApiOperationResponseRepresentationToHclTerraform(struct?: ApiManagementApiOperationResponseRepresentation | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationResponseRepresentationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationResponseRepresentation | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationResponseRepresentation | cdktf.IResolvable | undefined);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    get contentTypeInput(): string | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _example;
    get example(): ApiManagementApiOperationResponseRepresentationExampleList;
    putExample(value: ApiManagementApiOperationResponseRepresentationExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationResponseRepresentationExample[] | undefined;
    private _formParameter;
    get formParameter(): ApiManagementApiOperationResponseRepresentationFormParameterList;
    putFormParameter(value: ApiManagementApiOperationResponseRepresentationFormParameter[] | cdktf.IResolvable): void;
    resetFormParameter(): void;
    get formParameterInput(): cdktf.IResolvable | ApiManagementApiOperationResponseRepresentationFormParameter[] | undefined;
}
export declare class ApiManagementApiOperationResponseRepresentationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationResponseRepresentation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationResponseRepresentationOutputReference;
}
export interface ApiManagementApiOperationResponse {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#status_code ApiManagementApiOperation#status_code}
    */
    readonly statusCode: number;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#header ApiManagementApiOperation#header}
    */
    readonly header?: ApiManagementApiOperationResponseHeader[] | cdktf.IResolvable;
    /**
    * representation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#representation ApiManagementApiOperation#representation}
    */
    readonly representation?: ApiManagementApiOperationResponseRepresentation[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationResponseToTerraform(struct?: ApiManagementApiOperationResponse | cdktf.IResolvable): any;
export declare function apiManagementApiOperationResponseToHclTerraform(struct?: ApiManagementApiOperationResponse | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationResponseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationResponse | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationResponse | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _statusCode?;
    get statusCode(): number;
    set statusCode(value: number);
    get statusCodeInput(): number | undefined;
    private _header;
    get header(): ApiManagementApiOperationResponseHeaderList;
    putHeader(value: ApiManagementApiOperationResponseHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ApiManagementApiOperationResponseHeader[] | undefined;
    private _representation;
    get representation(): ApiManagementApiOperationResponseRepresentationList;
    putRepresentation(value: ApiManagementApiOperationResponseRepresentation[] | cdktf.IResolvable): void;
    resetRepresentation(): void;
    get representationInput(): cdktf.IResolvable | ApiManagementApiOperationResponseRepresentation[] | undefined;
}
export declare class ApiManagementApiOperationResponseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationResponse[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationResponseOutputReference;
}
export interface ApiManagementApiOperationTemplateParameterExample {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#external_value ApiManagementApiOperation#external_value}
    */
    readonly externalValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#summary ApiManagementApiOperation#summary}
    */
    readonly summary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#value ApiManagementApiOperation#value}
    */
    readonly value?: string;
}
export declare function apiManagementApiOperationTemplateParameterExampleToTerraform(struct?: ApiManagementApiOperationTemplateParameterExample | cdktf.IResolvable): any;
export declare function apiManagementApiOperationTemplateParameterExampleToHclTerraform(struct?: ApiManagementApiOperationTemplateParameterExample | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationTemplateParameterExampleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationTemplateParameterExample | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationTemplateParameterExample | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalValue?;
    get externalValue(): string;
    set externalValue(value: string);
    resetExternalValue(): void;
    get externalValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _summary?;
    get summary(): string;
    set summary(value: string);
    resetSummary(): void;
    get summaryInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApiManagementApiOperationTemplateParameterExampleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationTemplateParameterExample[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationTemplateParameterExampleOutputReference;
}
export interface ApiManagementApiOperationTemplateParameter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#default_value ApiManagementApiOperation#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#description ApiManagementApiOperation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#name ApiManagementApiOperation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#required ApiManagementApiOperation#required}
    */
    readonly required: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#schema_id ApiManagementApiOperation#schema_id}
    */
    readonly schemaId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type ApiManagementApiOperation#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#type_name ApiManagementApiOperation#type_name}
    */
    readonly typeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#values ApiManagementApiOperation#values}
    */
    readonly values?: string[];
    /**
    * example block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#example ApiManagementApiOperation#example}
    */
    readonly example?: ApiManagementApiOperationTemplateParameterExample[] | cdktf.IResolvable;
}
export declare function apiManagementApiOperationTemplateParameterToTerraform(struct?: ApiManagementApiOperationTemplateParameter | cdktf.IResolvable): any;
export declare function apiManagementApiOperationTemplateParameterToHclTerraform(struct?: ApiManagementApiOperationTemplateParameter | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationTemplateParameterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementApiOperationTemplateParameter | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationTemplateParameter | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _schemaId?;
    get schemaId(): string;
    set schemaId(value: string);
    resetSchemaId(): void;
    get schemaIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeName?;
    get typeName(): string;
    set typeName(value: string);
    resetTypeName(): void;
    get typeNameInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
    private _example;
    get example(): ApiManagementApiOperationTemplateParameterExampleList;
    putExample(value: ApiManagementApiOperationTemplateParameterExample[] | cdktf.IResolvable): void;
    resetExample(): void;
    get exampleInput(): cdktf.IResolvable | ApiManagementApiOperationTemplateParameterExample[] | undefined;
}
export declare class ApiManagementApiOperationTemplateParameterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementApiOperationTemplateParameter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementApiOperationTemplateParameterOutputReference;
}
export interface ApiManagementApiOperationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#create ApiManagementApiOperation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#delete ApiManagementApiOperation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#read ApiManagementApiOperation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#update ApiManagementApiOperation#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiOperationTimeoutsToTerraform(struct?: ApiManagementApiOperationTimeouts | cdktf.IResolvable): any;
export declare function apiManagementApiOperationTimeoutsToHclTerraform(struct?: ApiManagementApiOperationTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiOperationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiOperationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation azurerm_api_management_api_operation}
*/
export declare class ApiManagementApiOperation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_api_operation";
    /**
    * Generates CDKTF code for importing a ApiManagementApiOperation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementApiOperation to import
    * @param importFromId The id of the existing ApiManagementApiOperation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementApiOperation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.95.0/docs/resources/api_management_api_operation azurerm_api_management_api_operation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiOperationConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiOperationConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _apiName?;
    get apiName(): string;
    set apiName(value: string);
    get apiNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    get methodInput(): string | undefined;
    private _operationId?;
    get operationId(): string;
    set operationId(value: string);
    get operationIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _urlTemplate?;
    get urlTemplate(): string;
    set urlTemplate(value: string);
    get urlTemplateInput(): string | undefined;
    private _request;
    get request(): ApiManagementApiOperationRequestOutputReference;
    putRequest(value: ApiManagementApiOperationRequest): void;
    resetRequest(): void;
    get requestInput(): ApiManagementApiOperationRequest | undefined;
    private _response;
    get response(): ApiManagementApiOperationResponseList;
    putResponse(value: ApiManagementApiOperationResponse[] | cdktf.IResolvable): void;
    resetResponse(): void;
    get responseInput(): cdktf.IResolvable | ApiManagementApiOperationResponse[] | undefined;
    private _templateParameter;
    get templateParameter(): ApiManagementApiOperationTemplateParameterList;
    putTemplateParameter(value: ApiManagementApiOperationTemplateParameter[] | cdktf.IResolvable): void;
    resetTemplateParameter(): void;
    get templateParameterInput(): cdktf.IResolvable | ApiManagementApiOperationTemplateParameter[] | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiOperationTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiOperationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementApiOperationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
